<?php
//set_time_limit();

//set headers


//browsers collect first 1024 bytes
//and show page only if bytes collected
//so we will use space padding.
//if you cannot understand what it means
//check script with PADDING=0
define("PADDING", 16);
define("DEBUG", TRUE);


include_once("_dirinfo.php");
include_once(PATH_TO_ROOT . "_support/Curl/Curl.php");
include_once(PATH_TO_ROOT . "_support/Curl/CaseInsensitiveArray.php");
include_once(PATH_TO_ROOT . "init.php");

header('Transfer-Encoding: chunked');
header('Content-Type: text/html; charset=UTF-8');
header('X-Content-Type-Options', 'nosniff');

//caret return and new line characters as constant
define("RN", "\r\n");

for($i=0;$i<PADDING;$i++){
    //64 spaces (1 block)
    echo "                                                                ";
}
spl_autoload_register(function ($className)
{

    if(class_exists($className)) return;

    $parts = explode('\\', $className);
    $className = array_pop($parts);


    if(count($parts) > 0)
      $file = PATH_TO_ROOT . '_class/liveupdate/' . implode('/', $parts) . '/' . $className  . '.php';
    else
      $file = PATH_TO_ROOT . "_class/liveupdate/class." . $className . ".php";

    if(file_exists($file))
      include_once($file);
});

function app()
{
  global $db;

  $statusList   = new \DataContainers\StatusList();
  $actionData   = new \DataContainers\ActionData();
  $versions     = new \DataContainers\CurrentVersion($db);
  $projects     = new \DataContainers\CurrentProject();

  $clientStatus = new \DataContainers\ClientUpdateStatus($statusList);

  $statusList->attach(new OutputLogObserver($statusList));
  $statusList->attach(new UploadLogObserver($actionData, $versions,$statusList));
  $statusList->attach(new MemorySizeObserver($statusList));


  $lu = new LiveUpdate($versions, $projects);

  $lu->setActionData($actionData);

  StepFactory::setVersions($versions);
  StepFactory::setClientStatus($clientStatus);
  StepFactory::setProjects($projects);

  $lu->beforeDownloadEvent(StepFactory::createStep(\Steps\CheckInternetConnection::class, $actionData));
  //$lu->beforeDownloadEvent(StepFactory::createStep(\Steps\CheckRequirements::class));
  $lu->beforeDownloadEvent(StepFactory::createStep(\Steps\DownloadVersions::class));

  $lu->downloadEvent(StepFactory::createStep(\Steps\DownloadZip::class));
  $lu->downloadEvent(StepFactory::createStep(\Steps\ExtractZip::class));
  $lu->downloadEvent(StepFactory::createStep(\Steps\ParseXml::class, $actionData));
  $lu->downloadEvent(StepFactory::createStep(\Steps\CopyFiles::class, $actionData));
  $lu->downloadEvent(StepFactory::createStep(\Steps\ExecuteStatments::class, $actionData, $db));
  $lu->downloadEvent(StepFactory::createStep(\Steps\ExecuteScript::class, $actionData, $db));
  $lu->downloadEvent(StepFactory::createStep(\Steps\CleanTmpFiles::class));
  $lu->downloadEvent(StepFactory::createStep(\Steps\MajorVersionCheck::class));

  $lu->beforeUploadEvent(StepFactory::createStep(\Steps\SelectUserProjects::class, $db));

  $lu->uploadEvent(StepFactory::createStep(\Steps\PrepareLocalRecords::class, $actionData, $versions, $db));
  $lu->uploadEvent(StepFactory::createStep(\Steps\UploadRecords::class, $actionData));
  $lu->uploadEvent(StepFactory::createStep(\Steps\UpdateLocalRecords::class, $actionData, $db));

  $lu->afterUploadEvent(StepFactory::createStep(\Steps\AfterUpload::class, $actionData));
  $lu->afterUploadEvent(StepFactory::createStep(\Steps\FinishUpdate::class, $actionData));

  try
  {
    $lu->run();
  }
  catch(Exception $e)
  {
    //DisplayOutput::printOnScreen('Exception!');
  }
}

function config($key = null)
{

  //TODO Don't load it on every function call you idiot!!
    $capiConfig = configLoader::loadConfig('capi');
    $pathsConfig = configLoader::loadConfig('paths');

    $liveUpdateWWW = $pathsConfig['live_update_www'];

    $config['versionControlUrl'] = $liveUpdateWWW . $pathsConfig['live_update_version_script'];
    $config['reciveUrl'] =         $liveUpdateWWW . $pathsConfig['live_update_recieve_script'];
    $config['remoteContainer'] =   $pathsConfig['live_update_zip_files_remote'];
    $config['localContainer'] =    $pathsConfig['live_update_locale_container'];
    $config['actionFileName'] =    'file-action.xml';
    $config['checkConnectionUrl'] = $liveUpdateWWW . '_liveUpdate/Register.php';
    $config['upload_engine_log'] = $capiConfig['upload_engine_log'];

    $config['client_log_path']       = $config['localContainer'] . $capiConfig['client_log_path'];
    $config['client_log_date_format']= $capiConfig['client_log_date_format'];

    $config['temporaryFolderName'][\DataContainers\ActionData::FILETYPE_WARPIT] =      'Warpit';
    $config['temporaryFolderName'][\DataContainers\ActionData::FILETYPE_WEBPROJECTS] = 'WebProjects';

    $config['dbName']['table_warpit_webcati'] =      DB_WARPIT_WEBCATI;
    $config['dbName']['table_warpit_webcati_base'] = DB_WARPIT_WEBCATI_BASE;
    $config['dbName']['table_warpit_liveupdate'] =   DB_WARPIT_LIVEUPDATE;

    $config['client-machine-id']  = $capiConfig['client-machine-id'];
    $config['user_id']            = $_SESSION['UserInfo']['id'];
    $config['user_name']          = $_SESSION['UserInfo']['username'];
    $config['ssl_verify']         = $capiConfig['ssl_verify'];
    $config['max_log_size']       = $capiConfig['max_log_size'];
    $config['log_sqls']           = $capiConfig['log_sqls'];

    /*
      log_upload_level = 1 - upload only on update faild
      log_upload_level = 2 - upload log allways
    */
    $config['log_upload_level']   = $capiConfig['log_upload_level'];
//    $config['start_version']      = 5;//$this->getVersion();
    //20170510 Bojan Orter - we need two timeouts, first is for download zip (connection_timeout = 240s)
    //and secound is for checking internet connection(check_conection_timeout = 1s||2s||3s)
    //in config they are separated with >>,<<
    $timeoutConfig = explode(',', $capiConfig['connection_timeout']);
    if(count($timeoutConfig) == 1)
    {
        $config['connection_timeout'] = $timeoutConfig[0];
        $config['check_conection_timeout'] = $timeoutConfig[0];
    }
    else if(count($timeoutConfig) == 2)
    {
        $config['connection_timeout'] = $timeoutConfig[0];
        $config['check_conection_timeout'] = $timeoutConfig[1];
    }

    if(!is_null($key)) return $config[$key];
    return $config;
}

function isApache()
{
    return strpos($_SERVER['SERVER_SOFTWARE'], 'Apache') !== false;
}

$localContainer = config('localContainer');

if(!file_exists($localContainer))
{
    if(!mkdir($localContainer,0777,true))
        DisplayOutput::printOnScreen('Can\'t creat temporary folder please check you config!');
}

$lock = $localContainer . 'live-update.lock';

$fh = fopen($lock, 'a+');

register_shutdown_function(function() use($fh, $lock){

  flock($fh, LOCK_UN);
  fclose($fh);

  if(file_exists($lock))
    unlink($lock);

    if(isApache())
      DisplayOutput::terminate();
});

if(!flock($fh, LOCK_EX | LOCK_NB))
{
//  print "tu sem";
      DisplayOutput::printOnScreen('Already running in bacground.');

      if(isApache())
        DisplayOutput::terminate();

      exit;
}

/*
define("DEBUG_MODE", 1);
*/

$html = '<html>
<head>
    <script type="text/javascript" charset="utf8" src="' . PATH_TO_ROOT .'_js/tel/DataTables/js/jquery.js"></script>
    <link rel="stylesheet" href="' . PATH_TO_ROOT .'_js/tel/jqueryui1.11.4/jquery-ui.css">
    <script type="text/javascript" charset="utf8" src="' . PATH_TO_ROOT .'_js/tel/jqueryui1.11.4/jquery-ui.js"></script>
</head>
<body>
<style>
.ui-progressbar-value {
   background:#b3ffb3;
}

.ui-progressbar {
  width: 250px;
  height: 10px;
}
</style>
<script type="text/javascript">

    function sP(version, value)
    {
      $( "#progress_version_" + version ).progressbar({
            value: value
          });
    }

    function ShowBadIntenetWarning()
    {
    //  alert("tu sem");
      parent.window.ShowWarning();
    }

    function HideBadIntenetWarning()
    {
    //  alert("tu sem");
      parent.window.HideWarning();
    }

</script>

</body>
</html>';


DisplayOutput::printOnScreen($html);
app();
?>
