<?php

use Phinx\Migration\AbstractMigration;

class AddResponsiveSliderProperties extends AbstractMigration
{
    public function change()
    {
        $this->query("ALTER TABLE `" . DB_WARPIT_WEBCATI_BASE ."`.`_plugin_responsiveslider`
                            ADD COLUMN `scale_source` TINYINT UNSIGNED NOT NULL DEFAULT 2 COMMENT '1 answers/legend, 2 min/max/step parameters' AFTER `id_question`,
                            ADD COLUMN `scale_min` INT NOT NULL DEFAULT '1' AFTER `scale_source`,
                            ADD COLUMN `scale_max` INT NOT NULL DEFAULT '5' AFTER `scale_min`,
                            ADD COLUMN `scale_step` INT NOT NULL DEFAULT '1' AFTER `scale_max`,
                            ADD COLUMN `left_side_text` VARCHAR(255) NOT NULL DEFAULT '' AFTER `scale_step`,
                            ADD COLUMN `right_side_text` VARCHAR(255) NOT NULL DEFAULT '' AFTER `left_side_text`,
                            ADD COLUMN `space_before_slider` INT NOT NULL DEFAULT 50 AFTER `scale_source`,
                            ADD COLUMN `space_after_slider` INT NOT NULL DEFAULT 50 AFTER `scale_source`");

        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('scale_source', 'Scale source', '2', 'Scale settings', '106')");
        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('scale_min', 'Minimal value', '1', 'Scale settings', '106')");
        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('scale_max', 'Maximal value', '5', 'Scale settings', '106')");
        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('scale_step', 'Step', '1', 'Scale settings', '106')");


        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('left_side_text', 'Text on left side', '', 'Legend settings', '106')");
        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('right_side_text', 'Text on right side', '', 'Legend settings', '106')");

        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('space_before_slider', 'Space before slider', '50', 'Design settings', '106');");
        $this->query("INSERT INTO `" . DB_WARPIT_WEBCATI_BASE ."`.`_Plugin_label` (`name`, `label`, `default_value`, `group`, `id_plugin`) VALUES ('space_after_slider', 'Space after slider', '50', 'Design settings', '106')");
    }
}
