<?php
use \Curl\Curl;

class UploadLogObserver extends AbstractObserver
{
    public function __construct(\DataContainers\ActionData $actionData, \DataContainers\CurrentVersion $versions, \DataContainers\StatusList $statusList)
    {
        $this->actionData = $actionData;
        $this->versions = $versions;

        parent::__construct($statusList);
    }

    public function update()
    {
        $status = $this->statusList->getLatestStatus();
        $faild = $this->statusList->isFaild();

        if($status['entryType'] == 'restartStatusList')
            $this->updateLog($status['data']['restartCount']);

        if($status['entryType'] == 'liveUpdateFinished' || $faild)
            $this->finish();

        return true;
    }

    public function finish()
    {
        $data = [];
        $data['action'] = 'end';
        $data['end_version'] = $this->versions->getVersion();
        $data['id_log'] = $this->actionData->getLogId();

        if($this->statusList->isFaild() || config('log_upload_level') == 2)
        {
          $data['update_log'] = '###################### END_LOG #################################\n';
          $data['update_log'] .= $this->statusList->toString();
        }

        $this->upload($data);
    }

    public function updateLog($count)
    {
        $data = [];
        $data['action'] = 'update_log';
        $data['id_log'] = $this->actionData->getLogId();
        $data['update_log'] = '###################### LOG #' . $count . ' #################################\n';
        $data['update_log'] .= $this->statusList->toString();


        $this->upload($data);
    }

    public function upload($data)
    {
      $curl = new Curl();

      $curl->setDefaultJsonDecoder();

      $curl->setOpt(CURLOPT_SSL_VERIFYHOST, config('ssl_verify'));
      $curl->setOpt(CURLOPT_SSL_VERIFYPEER, config('ssl_verify'));

      $curl->post(config('checkConnectionUrl'), $data);
    }
}

 ?>
