<?php

class OutputLogObserver extends AbstractObserver
{
   private $displayedProjectName = array();

   public function update()
   {
      $status = $this->statusList->getLatestStatus();

      $lng = \DataContainers\LanguagePack::getTranslation();
      switch($status['entryType'])
      {
          case 'versionsDownloaded':
            if(count($status['data']['versionsToDownload']) <= 0) DisplayOutput::logHeader($lng['no_pending_update']);
            break;

          case 'versionsDownloadError':
            DisplayOutput::logError($lng['version_download_faild']);
            break;

          case 'zipFileDownloadStarted':
            //$this->outputLine('Downloding version:<b>' . $version . '</b><br />');
            DisplayOutput::logHeader(sprintf($lng['update_to_version'], '<b>' . $status['data']['version'] . '</b>'));
            $this->output('<div id="progress_version_' . $status['data']['version'] .'"></div>
                      <div id="bad_inernet_connection_'.$status['data']['version'].'" . style="display:none;color:red;" >Bad internet connction</div>');
            break;
          case 'badInternetShow':
            $this->output('<script>ShowBadIntenetWarning();</script>');
            break;

          case 'badInternetHide':
            $this->output('<script> HideBadIntenetWarning();</script>');
            break;
          case 'updateProgressbar':
            $this->output('<script> sP("' . $status['data']['version'] . '", ' . $status['data']['percent'] .');</script>');
            break;

          case 'downloadZipFaild':
            DisplayOutput::logError($lng['download_faild']);
            break;

          case 'wrongChecksum':
            DisplayOutput::logError($lng['download_file_broken']);
            break;

          case 'downloadZipSuccess':
			//DisplayOutput::logNotice('');
            break;

          case 'extractZipFaild':
            $this->outputLine($lng['download_file_broken']);
            break;

          case 'xmlParseFaild':
            $this->outputLine($lng['xml_broken']);
            break;

          case 'filesCopied':
              $text = sprintf($lng['copy_in_folder'], $status['data']['folderType'], count($status['data']['files']));
              DisplayOutput::logNotice($text);
              break;

          case 'filesFaildToCopy':
            $text = sprintf($lng['faild_to_copy_in_folder'], $status['data']['folderType']);
            DisplayOutput::logError($text);
            break;

          case 'faildToExecuteSQL':
            DisplayOutput::logError($lng['sql_exe_error']);
            break;

          case 'allSqlsDone':
            $text = sprintf($lng['sql_exe_success'], $status['data']['numOfSQLs']);
            DisplayOutput::logNotice($text);
            break;

          case 'scriptWrongExstension':
            DisplayOutput::logError($lng['no_php_script']);
            break;

          case 'scriptNotValid':
            DisplayOutput::logError($lng['script_name_not_valid']);
            //$this->outputLine('Script name not valid');
            break;

          case 'scriptNotFound':
            //$this->outputLine('Script not found');
            DisplayOutput::logError($lng['script_not_found']);
            break;

          case 'noTemporaryFolder':
            DisplayOutput::logError($lng['no_tmp_file']);
            break;

          case 'executedScript':
              DisplayOutput::logNotice($lng['script_exe_success']);
            //  DisplayOutput::printOnScreen($status['output']);
            break;

          case 'downloadProcStart':
            DisplayOutput::logTitle($lng['download_info']);
            break;

          case 'uploadStarted':
            DisplayOutput::logTitle("<br />" . $lng['upload_info']);
            break;
          case 'uploadDisabled':
            DisplayOutput::logHeader($lng['upload_disabled']);
            break;
          case 'dataExists':
           $text = sprintf($lng['data_exist'], $status['data']['projectName'], $status['data']['recordsCnt']);
            DisplayOutput::logHeader($text);
            break;

          case 'missingTable':
            DisplayOutput::logError($lng['missing_datatable']);
            break;
          case 'cantConnect':
            DisplayOutput::logError($lng['cant_connect']);
            break;
          case 'errorOnServer':
            DisplayOutput::logError($lng['unknown_error_on_server']);
            break;
          case 'recordsUploaded':
            $uploaded = $status['data']['uploaded'];
            $saved = $status['data']['saved'];
            $projectName = '<b>' . $status['data']['projectName'] . '</b>';

            $text = sprintf($lng['data_saved_on_server'], $saved, $uploaded, $projectName);
            DisplayOutput::logHeader($text);
            break;
          case 'notMarkedUploaded':
            if (strpos($status['data']['tableName'], '_structure') !== false)
              $text = sprintf($lng['structure_not_uploaded']);
            else
              $text = sprintf($lng['visits_not_uploaded']);

            DisplayOutput::logError($text);
            break;
          case 'clientNoPendingData':
            $text = sprintf($lng['no_pending_data'], "<b>" . $status['data']['username']. "</b>");
            DisplayOutput::logHeader($text);
            break;
          case 'uploadServerError':
            $text = $lng['error_on_server'];
            DisplayOutput::logError($text);
            break;
          case 'majorVersion':
              $text = $lng['major_version_warn'];
              DisplayOutput::logError($text);
              break;
          case 'noCurl':
              $text = $lng['missing_curl'];
              DisplayOutput::logError($text);
              break;
          case 'wrongUserType':
              $text = $lng['wrong_user_type'];
              DisplayOutput::logError($text);
              break;
          case 'startExtract':
              $text = $lng['start_extract'];
              DisplayOutput::logNotice($text);
              break;
          case 'sqlExecuting':
              $text = $lng['sql_executing'];
              DisplayOutput::logNotice($text);
              break;
          case 'xmlReading':
              $text = $lng['xml_reading'];
              DisplayOutput::logNotice($text);
              break;
          case 'copyingFiles':
              $text = $lng['copying_files'];
              DisplayOutput::logNotice($text);
              break;
          case 'noInternetConnection':
              $text = $lng['no_internet'];
              DisplayOutput::logError($text);
              break;
          case 'badInternetConnection':
              $text = $lng['no_internet'];
              DisplayOutput::logNotice($text);
              break;
      }

      return true;

   }

   public function output($string)
   {
      DisplayOutput::printOnScreen($string);
   }

   public function outputLine($string)
   {
        $this->output($string . "<br />");
   }
}

/*class FileLogObserver extends AbstractObserver
{
   public function update($data, $faild = null)
   {
       if($faild)
        $this->output($data);

      return true;

   }

   public function output($string)
   {
     $path = config('client_log_path') . date(config('client_log_date_format')) . '.log';
     $content = print_r($string, true);
     /* $cont = @file_put_contents($path,$content, FILE_APPEND);
      $p = $cont;*/

	/*  file_put_contents('/mnt/sdcard/htdocs/webProjects/LiveUpdate/_log/tanis.txt', $content, FILE_APPEND);
   }
}*/
