<?php
function isProcessRunning($pidFile) {
    if (!file_exists($pidFile) || !is_file($pidFile)) return false;
    $pid = file_get_contents($pidFile);
    return posix_kill($pid, 0);
}
//20160609 Bojan Orter - zamenjana je vsebina tega event_loger, da lahko spremljamo tudi pri watch modulo, stara vsebina je v datoteki event_loger.php_20160609
$config = ConfigLoader::loadConfig('live_watch');
$websocketsServerAddress = $config['websockets_server_address'];
$pidFilePath = $config['tmp_path'] . "pid";
$showLog =  ($config['show_log'] == 1) ? 1 : 0;

$useSocket = "true";
if(empty($websocketsServerAddress) || !isProcessRunning($pidFilePath))
{
    $useSocket = "false";
}

$username = '?';

$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
$sessionId = session_id();
$userId = $_SESSION['id_user'];
$userType = $_SESSION['user_type'];
$clientId = $userType . '_' . $userId; // user ids are not unique themselves, need to include user_type!

$startTimestamp = 'null';
if($_SESSION['nextQuestion'][0]['q_name'] == 'tStatus'){
    $startTimestamp = $db->get($_SESSION['proj_name']."_structure", $_SESSION['id_record'], 't_start');
}
// Retrieve username.
$sql = "SELECT sub.username
        FROM (SELECT id,username,Firstname,Surname,email,0 AS id_type FROM " . DB_WARPIT_WEBCATI_BASE . ".`_Interviewer`
              UNION SELECT id,username,Firstname,Surname,email,1 AS id_type FROM " . DB_WARPIT_MAIN . "._user) sub
        WHERE sub.id = $userId AND sub.id_type = $userType";
$res = $db->SQLexecute($sql);
if ($res) {

    $row = $db->fetchRow($res);
    $username = $row[0];
}
$db->ChangeDatabase(DB_WARPIT_WEBCATI);
//script for event logger!
echo "<script>
	clickEvents = new Array();

	timeStamp = Math.round(new Date().getTime() / 1000);

	// We prepare hidden variables with start date/time

	startTime = timeStamp;

	// we calculate correction time between client and server time
	var ClientServerCorrection = ".time()." - timeStamp;
	// we save client and server time in first item in array. We need this if their will be problems with different times on Clients....
	clickEvents.push('{ \"TimeSync\" : \"1\", \"ClientTime\" : \"' + timeStamp + '\", \"ServerTime\" : \"".time()."\" }');

    // Matej, 2015-07-15
    // Live (WebSocket) tracking
    var clientId = '$clientId';
    var websocketsServerAddress = '$websocketsServerAddress';
    var questionnaireId = '{$_SESSION['id_project']}';
    var sessionId = '$sessionId';
    //console.log('sessionId: ', sessionId);
    var ws = null;
    if ('WebSocket' in window && $useSocket) {

        ws = new WebSocket(websocketsServerAddress);
        ws.onopen = function(evt) {

            // Wait till DOM is complete, read the questionnaire HTML,
            // and send it to admins.
            // TODO: are there cases when this is too soon (HTML not built yet)?
            // TODO: compress html?
            $(document).ready(function() {
                // Text input boxes are not handled by recodeClickEvents,
                // we need to do it separately.
                //adding event for change in input (textbox)
                $('#mainForm input[type=\"text\"]').on('input', function(evt) {
                    var self = $(this);
                    sendEventToWebSocketServer('client_event', {
                        eventType: 'input',
                        id: self.attr('id'),
                        value: self.val()
                    });
                });

                //adding event for change in input (textarea)
                $('#mainForm textarea').on('input', function(evt) {
                    var self = $(this);
                    sendEventToWebSocketServer('client_event', {
                        eventType: 'textarea',
                        id: self.attr('id'),
                        value: self.val()
                    });
                });

                //for appointment we need to add handler for radio buttons
                $('input[name=\"' + 'appointmentStatusRec' + '\"]').on('click', function(evt){
                    var input = $(evt.target);
                    var objName = input.attr('name');
                    var objValue = input.attr('value');

                    sendEventToWebSocketServer('client_event', {
                        eventType: '1',
                        objType: 'radio',
                        objValue: objValue,
                        objName: objName
                    });
                });

                //first we need to add ids to textboxes, textareas so we can handle events
                $('input[name^=\"dogovor\"], textarea[name^=\"dogovor\"]').each(function(index, element){
                    $(element).attr('id', $(element).attr('name'));
                });

                $('input[name^=\"dogovor\"], textarea[name^=\"dogovor\"]').on('input', function(evt){
                    var self = $(this);
                    sendEventToWebSocketServer('client_event', {
                        eventType: 'input',
                        id: self.attr('id'),
                        value: self.val()
                    });
                });

                //for tstatus we need to add handler for radio buttons
                $('input[name=\"' + 'status_telnum' + '\"]').on('click', function(evt){
                    var input = $(evt.target);
                    var objName = input.attr('name');
                    var objValue = input.attr('value');

                    sendEventToWebSocketServer('client_event', {
                        eventType: '1',
                        objType: 'radio',
                        objValue: objValue,
                        objName: objName
                    });
                });


                // Clone mainForm and trim it before uploading the html.
                var mainForm = $('#mainForm').clone();
                mainForm.find('script, iframe').remove();
                mainForm.find('[onclick]').removeAttr('onclick');
                mainForm.find('tr[id], td[id]').removeAttr('id'); // TODO: are these ids referenced anywhere?
                sendEventToWebSocketServer('client_setup', undefined, mainForm.html());
            });
        };

        ws.onclose = ws.onerror = function(event) {
            event = event || {};
            if (event.code == 1000)
                reason = 'Normal closure, meaning that the purpose for which the connection was established has been fulfilled.';
            else if(event.code == 1001)
                reason = 'An endpoint is \"going away\", such as a server going down or a browser having navigated away from a page.';
            else if(event.code == 1002)
                reason = 'An endpoint is terminating the connection due to a protocol error';
            else if(event.code == 1003)
                reason = 'An endpoint is terminating the connection because it has received a type of data it cannot accept (e.g., an endpoint that understands only text data MAY send this if it receives a binary message).';
            else if(event.code == 1004)
                reason = 'Reserved. The specific meaning might be defined in the future.';
            else if(event.code == 1005)
                reason = 'No status code was actually present.';
            else if(event.code == 1006)
               reason = 'The connection was closed abnormally, e.g., without sending or receiving a Close control frame';
            else if(event.code == 1007)
                reason = 'An endpoint is terminating the connection because it has received data within a message that was not consistent with the type of the message (e.g., non-UTF-8 [http://tools.ietf.org/html/rfc3629] data within a text message).';
            else if(event.code == 1008)
                reason = 'An endpoint is terminating the connection because it has received a message that \"violates its policy\". This reason is given either if there is no other sutible reason, or if there is a need to hide specific details about the policy.';
            else if(event.code == 1009)
               reason = 'An endpoint is terminating the connection because it has received a message that is too big for it to process.';
            else if(event.code == 1010) // Note that this status code is not used by the server, because it can fail the WebSocket handshake instead.
                reason = 'An endpoint (client) is terminating the connection because it has expected the server to negotiate one or more extension, but the server didnt return them in the response message of the WebSocket handshake. <br /> Specifically, the extensions that are needed are: ' + event.reason;
            else if(event.code == 1011)
                reason = 'A server is terminating the connection because it encountered an unexpected condition that prevented it from fulfilling the request.';
            else if(event.code == 1015)
                reason = 'The connection was closed due to a failure to perform a TLS handshake (e.g., the server certificate cant be verified).';
            else
                reason = 'Unknown reason';

            if($showLog)
            {
                console.log('Connection closed: ' + reason);
            }
            ws = null;

        };

        ws.onsent = function() {
            if($showLog)
            {
                console.log('message sent');
            }
        };

        // Firefox annoys with 'The connection to ... was interrupted while the page was loading'
        // https://bugzilla.mozilla.org/show_bug.cgi?id=712329
        $(window).on('beforeunload', function() {
            if (ws)
                ws.close();
        });
    }

    // Matej, 2015-07-15
    function sendEventToWebSocketServer(type, event, html) {
        if (ws === null)
            return;

        if (typeof event === 'string')
            event = JSON.parse(event);

        var message = {
            type: type,
            client_id: clientId,
            session_id: sessionId,
            questionnaire_id: questionnaireId,
            client_username: '$username',
            client_ip: '" . $_SERVER['REMOTE_ADDR'] . "',
            survey_start: $startTimestamp,
            question_name: '" . $_SESSION['nextQuestion'][0]['q_name'] . "',
            event: event,
            html: html // Usually undefined, nothing sent (except on client_setup event)
        };
        ws.send(JSON.stringify(message));
    }

	function recodeClickEvents(aObj,eventType)
	{
		// calculating timestamp for each click
		var timeStamp = Math.round(new Date().getTime() / 1000) ;

		// prepare json object with all importend informations....
		var EventLog = '{ \"clickTime\" : \"' + ( timeStamp +  ClientServerCorrection ) + '\", \"clickTimeClient\"  : \"' + timeStamp + '\",  \"eventType\" : \"'+ eventType +'\", \"objName\" : \"' + aObj.name + '\", \"objValue\" : \"' + aObj.value.replace(/\"/g,\"Ë�\").replace(/'/g,\"Â´\") + '\", \"objType\" : \"' +  aObj.type + '\"';

		//console.log(EventLog);
		// adding information for different HTML objects
		if (aObj.type == 'checkbox') EventLog = EventLog + ', \"checked\" : \"' + aObj.checked + '\"';

		EventLog = EventLog + ' } ';
		// adding neew event into array
		clickEvents.push(EventLog);

        // Matej, 2015-07-15
        sendEventToWebSocketServer('client_event', EventLog);

		if(eventType == 3 ) {
			// we save timestamp for end of form
			document.forms['mainForm']['RMquestionDuration'].value = timeStamp - startTime;

			document.forms['mainForm']['RMclickLogger'].value='['+clickEvents.join()+']';
		}
	}

    function hideButton(name)
    {
        var button = $('#' + name); 
        var form = button.closest('form');
        
        //if we have back button we want to submit it even if it is not valid.
        //submit function in jquery doest validate form before submitting
        //additionali we have to add hiden field with questBack value so
        // form is correctly submited
        if(name == 'questBack'){
            var input = $('<input>')
               .attr('name', 'questBack')
               .attr('type', 'hidden')
               .val('<<<<');
            
            form.append(input);
            form.submit();
            button.hide();
            return;
        }
        
        if(form[0].checkValidity() == true){
            button.hide();
        }
    }

	function SingleResponseAutoSubmit(timeout) {
        //20170914 Bojan Orter - we add 100ms delay so that custom images renders and we see what we checked
        setTimeout(function(){
            $('[name=\"questSubmit\"]').click();
        }, timeout);
	}

function control_backspace(e) {
        var type    = '';
        var element = '';
        var keyCode = '';
        
        var allowedTypes = [
            'text', 
            'number', 
            'color', 
            'date', 
            'datetime-local',
            'email',
            'month',
            'number',
            'password',
            'range',
            'search',
            'tel',
            'time',
            'url',
            'week'
         ];
        
        if (typeof window.event == 'undefined'){
            type    = event.srcElement.getAttribute('type');
            element = event.srcElement.tagName.toLowerCase();
            keyCode = event.keyCode;
        } else {
            type    = e.target.getAttribute('type');
            element = e.target.nodeName.toLowerCase();
            keyCode = e.keyCode;
        }

        if(keyCode !== 8){
            return true;
        }
        
        if(element === 'textarea'){
            return true;
        }
        
        if(element !== 'input'){
            return false;
        }
        
        if(allowedTypes.indexOf(type) > -1){
            return true;
        }
        
        return false;
}
	document.onkeydown  = control_backspace;
    document.onkeypress = control_backspace;
	window.onload       = control_backspace;

</script>";

?>
