<?php

namespace Steps;

use \ActionData;

class ParseXml extends AbstractStep
{

    public function __construct(\DataContainers\ActionData $actionData)
    {
        $this->actionData = $actionData;
    }

    public function execute($data = null)
    {
        $version = $this->versions->current('version');

        $xmlFileName = config('localContainer') . $version . '/' . config('actionFileName');

        $sqlFilesContainer = config('localContainer') . $version . '/SQL_files/';

        try {
            $this->clientStatus->xmlReading(null);
            $xml = new \SimpleXMLElement(file_get_contents($xmlFileName));

            foreach ($xml->file as $file) {
                if ($file->type == 1) {
                    $this->actionData->addFile(array((string)$file->directory, (string)$file->filename), \DataContainers\ActionData::FILETYPE_WARPIT);
                } else if ($file->type == 2) {
                    $this->actionData->addFile(array((string)$file->directory, (string)$file->filename), \DataContainers\ActionData::FILETYPE_WEBPROJECTS);
                } else {
                    $pathToFile = $sqlFilesContainer . $file->filename;
                    if (file_exists($pathToFile)) {
                        $sql_statements = explode("<stat>", file_get_contents($pathToFile));
                        array_filter($sql_statements);
                        $this->actionData->addSQLStatment(strval($file->database), $sql_statements);
                    } else {
                        $this->xmlParseFaild(array(
                            'error' => 'Cant found SQL file.',
                            'pathToFile' => $pathToFile
                        ));
                    }
                }
            }
        } catch (Exception $e) {
            $this->clientUpdate->xmlParseFaild($e);
        }

    }
}
