<?php

/**
 * RIM sampler
 * Borut -> 2018.03.27
 */
class RIMsampler
{
    private $db;
    private $rimTotals;
	private $rimColumns;
	private $rimColumnValues;
	private $workingGroup;
	private $memoryTableName;
	private $nTotal;
	private $whereAdd;
	private $whereBasic;
	private $nIteration;
	private $sumAllColItems;
	private $cntPerColumn = 0;
	private $iterationStep = 0;
	private $totalIterationPercent = 0;
	private $iterationStepFactor = 0.72; //do not change, if you are not absolutely sure what are you doing

    public function __construct($db)
    {
        $this->db = $db;
		$this->memoryTableName = "memRIMsampler_".$_SESSION['UserInfo']['username']."_".$this->getTime();
    }

	public function setRims($rims,$nTotal,$nIteration = null) {
		$this->rimTotals = $rims;
		foreach($rims as $keyRims => $itemRims) {
			$arr_rimColumns[] = $keyRims;
			// prepare main condition for panelists
			$allPctKeys = array();
			foreach($itemRims['pct'] as $keyPct => $itemPct) {
				 $allPctKeys[] = $keyPct;
			}
			$mainWhereCondition[] = "AND $keyRims IN (".implode(",",$allPctKeys).")";
			$arr_rimColumnValues[$keyRims] = $allPctKeys;
		}
		$this->whereBasic = implode(" ",$mainWhereCondition);
		$this->rimColumns = implode(",",$arr_rimColumns);
		$this->rimColumnValues = $arr_rimColumnValues;

		$this->nTotal = $nTotal;
		if (isset($nIteration)) {
			if ($nIteration < 2) $nIteration = 2;
			if ($nIteration > 50) $nIteration = 50;
		}
		else {
			$nIteration = 30;
		}
		$this->nIteration = $nIteration;
	}

	public function setGroup($group) {
		$this->workingGroup = $group;
	}

	public function setWhere($where) {
		$this->whereAdd = $where;
	}

	private function setIterationStep() {
		$this->iterationStep++;
	}

	private function setTotalIterationPercent($pct) {
		$this->totalIterationPercent = $this->totalIterationPercent + $pct;
	}

	private function setCountPerColumn($count) {
		$this->cntPerColumn = $this->cntPerColumn + $count;
	}

	private function getTime() {
		$date = new DateTime();

		return $date->getTimestamp();
	}

	private function getWhere() {
		return $this->whereAdd;
	}

	private function getWhereBasic() {
		return $this->whereBasic;
	}

	private function getRimColumns() {
		return $this->rimColumns;
	}

	private function getRimColumnValues() {
		return $this->rimColumnValues;
	}

	private function getTableName() {
		return $this->memoryTableName;
	}

	private function getTotals() {
		return $this->rimTotals;
	}

	private function getStepFactor() {
		return $this->iterationStepFactor;
	}

	private function getIterationStep() {
		return $this->iterationStep;
	}

	private function getIterationStartPct() {
		return $this->nIteration;
	}

	private function getTotalIterationPercent() {
		return $this->totalIterationPercent;
	}

	private function getCountPerColumn() {
		return $this->cntPerColumn;
	}

	private function calculateIterationStepNum($sampleTotal,$iterationStartPct,$iterationStep,$varNumberOfValues,$numberOfVars) {
		$stepFactor = $this->getStepFactor();
		//echo "stepFactor: $stepFactor<br>";
		$calculatedStepFactor = pow($stepFactor, $iterationStep);
		if ($calculatedStepFactor == 0) $calculatedStepFactor = 1;
		//echo "calculatedStepFactor: $calculatedStepFactor<br>";

		// depend in which step i am, set new step factor
		$iterationPct = $iterationStartPct * $calculatedStepFactor;
		if ($iterationPct < 2) $iterationPct = 2;
		//echo "iterationPct: $iterationPct<br>";

		$stepNum = (($sampleTotal * $iterationPct) / 100) / $varNumberOfValues; // is it better to split non equal N through variables based on number of values inside variable ?
		//$stepNum = (($sampleTotal * $iterationPct) / 100) / $numberOfVars; // is it better to split equal N through all variables ?
		$this->setTotalIterationPercent($iterationPct);

		return $stepNum;
	}

	/**
	 * get order from variables with higher number of items to lower
	 */
	private function getOrder() {
		foreach($this->rimTotals as $keyTotals => $itemTotals) {
			$countColumn = count($itemTotals['pct']);
			$sumAllColumns[$keyTotals] = $countColumn;
			$orderTotals[$keyTotals] = $countColumn;
		}
		$this->sumAllColItems = $sumAllColumns;
		arsort($orderTotals);

		return $orderTotals;
	}

	private function clearTable() {
		$tableName = $this->getTableName();
		$sql = "DROP TABLE IF EXISTS ".$tableName;
		//echo "$sql<br>";
		//$res = $this->db->SQLexecute($sql);
	}

    private function createExcludeTempTable(){
        $usedIdsInSampleSql = " SELECT DISTINCT id FROM _samples_link as a WHERE id_sample IN (SELECT id FROM _SamplingTemplates WHERE id_group = {$this->workingGroup} AND is_leaf = 1)";
        $sql = "DROP TEMPORARY TABLE IF EXISTS tmpExclude";
        $this->db->SQLexecute($sql);

        $sql = "CREATE TEMPORARY TABLE tmpExclude (PRIMARY KEY prim_key (id)) $usedIdsInSampleSql";
		//echo "$sql<br>";
        $this->db->SQLexecute($sql);
    }

	private function createMemoryTable() {
		$tableName = $this->getTableName();
		$whereAdd = $this->getWhere();
		$whereBasic = $this->getWhereBasic();

		$rimColumns = $this->getRimColumns();
		$sql = "CREATE TABLE ".$tableName." (sflag tinyint NOT NULL DEFAULT '0', KEY(sflag)) ENGINE=MEMORY
			SELECT a.id,".$rimColumns." FROM `_Interviewer` a
			INNER JOIN `_group_link` b ON a.id = b.id
            LEFT JOIN _InterviewerStatuses as c ON a.id = c.interviewer_id
            LEFT JOIN tmpExclude as d ON a.id = d.id
			WHERE b.`id_group`=".$this->workingGroup." ".$whereAdd." ".$whereBasic;
		//echo "$sql<br>";
		$res = $this->db->SQLexecute($sql);
	}

	public function runRimSampling() {
        $this->createExcludeTempTable();
		$this->createMemoryTable();
		$rimOrder = $this->getOrder();
		$rimTotals = $this->getTotals();
		$sampleTotal = $this->nTotal;
		//echo "sampleTotal: $sampleTotal<br>";
		$iterationStep = $this->getIterationStep();
		//echo "iterationStep: $iterationStep<br>";
		$varNumberOfValues = array_sum($this->sumAllColItems);
		$numberOfVars = count(explode(",",$this->getRimColumns()));
		//echo "varNumberOfValues: $varNumberOfValues<br>";
		$iterationStartPct = $this->getIterationStartPct();
		//echo "iterationStartPct: $iterationStartPct<br>";

		$totalIterationPercent = $iterationStartPct;
		//echo "totalIterationPercent: $totalIterationPercent<br>";
		// iterationStep is only second fail safe
		while($totalIterationPercent < 100 && $iterationStep < 100) {
			// calculate for every iteration based on iteration step, iteration factor and start percent
			$needIterationN = $this->calculateIterationStepNum($sampleTotal,$iterationStartPct,$iterationStep,$varNumberOfValues,$numberOfVars);
			//echo "needIterationN: $needIterationN<br>";

			// execute for every iteration all selected columns
			foreach($rimOrder as $keyRimsVars => $itemRimsVars) {
				//echo "foreach rimOrder: $keyRimsVars => $itemRimsVars<br>";
				//echo $this->getTime()."<br>";
				// calculate needed N for column iteration
				$cntPerColumn = $needIterationN * $itemRimsVars; // is it better to split non equal N through variables based on number of values inside variable ?
				//$cntPerColumn = $needIterationN; // is it better to split equal N through all variables ?
				//echo "additional N which i need: $cntPerColumn<br>";
				$this->setCountPerColumn($cntPerColumn);
				$cntPerColumn = $this->getCountPerColumn();
				//echo "N which i need: $cntPerColumn<br>";
				// call random sampling for every value inside active column
				foreach($rimTotals[$keyRimsVars]['pct'] as $keyTotals => $itemTotals){
					$valueVar = $keyTotals;
					$neededPct = $itemTotals;
					//echo "value and pct: $valueVar | $neededPct<br>";
					$this->getSamplePerValue($cntPerColumn,$neededPct,$keyRimsVars,$valueVar);
				}

			}
			//echo $this->getTime()."<br>";

			$this->setIterationStep();
			$iterationStep = $this->getIterationStep();
			//echo "iterationStep: $iterationStep<br>";
			$totalIterationPercent = $this->getTotalIterationPercent();
			//echo "totalIterationPercent: $totalIterationPercent<br>";
		}
	}

	private function getSamplePerValue($cntPerColumn,$neededPct,$variableColumn,$valueVar) {
		$tableName = $this->getTableName();
		$requestedN = $this->calculateNforValue($cntPerColumn,$neededPct,$variableColumn,$valueVar);
		// run SQL count for all values to see which values i should already exclude from next iteration step
		$doNotIncludeRecords = $this->calculateNotInclude($cntPerColumn);
		$samplerCounter = 1;
		if ($requestedN > 0) {
			$sql = "UPDATE ".$tableName." dest,
						(SELECT * FROM ".$tableName." WHERE sflag = 0 AND ".$variableColumn."=".$valueVar." ".$doNotIncludeRecords." ORDER BY RAND() LIMIT ".$requestedN.") src
					SET dest.sflag=".$samplerCounter."
					WHERE dest.id=src.id";
			//echo "$sql<br>";
			$res = $this->db->SQLexecute($sql);
		}
	}

	private function calculateNotInclude($subTotalCount) {
		$rimColumnValues = $this->getRimColumnValues();
		$rimTotals = $this->getTotals();
		$tableName = $this->getTableName();

		foreach ($rimColumnValues as $keyColumn => $itemColumn) {
			$sql = "SELECT count(*) as N, ".$keyColumn." as val FROM ".$tableName." WHERE sflag>0 GROUP BY ".$keyColumn;
			//echo "$sql<br>";
			$res = $this->db->SQLexecute($sql);
			while ($row = $this->db->fetchAssoc($res)) {
				$calcHave[$keyColumn][$row['val']]['cnt'] = $row['N'];
			}
		}
		//echo "calcHave<br>";
		//print_r($calcHave);

		$excludeVal = array();
		foreach($rimTotals as $keyTotals => $itemTotals){
			$var = $keyTotals;

			foreach($itemTotals['pct'] as $keyVal => $itemVal) {
				$val = $keyVal;
				$pct = $itemVal;
				$count = $subTotalCount * $pct / 100;
				$calcMust[$var][$val]['pct'] = $pct;
				$calcMust[$var][$val]['cnt'] = $count;

				// get excluded values per variable
				//echo "check if N is bigger and i need to exclude values: $var | $val => ".$calcHave[$var][$val]['cnt']." >= $count<br>";
				if ($calcHave[$var][$val]['cnt'] >= $count) {
					$excludeVal[$var][] = $val;
				}
			}
		}
		//print_r($calcMust);
		//print_r($excludeVal);

		$strExclude = array();
		foreach($excludeVal as $varExclued => $valExcluded) {
			$strExclude[] = " AND ".$varExclued." NOT IN (".implode(",", $valExcluded).")";
		}
		$excludeValues = implode(" ",$strExclude);
		//echo "$excludeValues<br>";

		return $excludeValues;
	}

	private function calculateNforValue($countCol,$percentNeed,$variableColumn,$valueVar) {
		$partialSampleForValue = $this->calculatePartialSample($variableColumn,$valueVar);
		$cntPerColumn = $countCol;
		$neededPct = $percentNeed;
		$requestedN = round(($cntPerColumn * $neededPct / 100),0);
		$calculatedN = $requestedN - $partialSampleForValue;
		if ($calculatedN < 0) $calculatedN = 0; // if i already have more than i need, i will not add new record to the sample

		return $calculatedN;
	}

	private function calculatePartialSample($variableColumn,$valueVar) {
		$tableName = $this->getTableName();

		$sql = "SELECT count(*) as N,".$variableColumn." FROM ".$tableName." WHERE sflag>0 AND ".$variableColumn."=".$valueVar;
		//echo "$sql<br>";
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);
		$partialValue = $row['N'];
		//echo "count for variable: ".$row['N']."<br>";

		return $partialValue;
	}

	public function getRimSampleIds() {
		$tableName = $this->getTableName();
		$sampleTotal = $this->nTotal;

		$sql = "SELECT id FROM ".$tableName." WHERE sflag=1 ORDER BY RAND() LIMIT ".$sampleTotal;
		//echo "$sql<br>";
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			$exportIds[] = $row[id];
		}
		$this->clearTable();

		return implode(",",$exportIds);
	}



}

?>
=======
<?php

/**
 * RIM sampler
 * Borut -> 2018.03.27
 */
class RIMsampler
{
    private $db;
    private $rimTotals;
	private $rimColumns;
	private $rimColumnValues;
	private $workingGroup;
	private $memoryTableName;
	private $nTotal;
	private $whereAdd;
	private $whereBasic;
	private $nIteration;
	private $sumAllColItems;
	private $cntPerColumn = 0;
	private $iterationStep = 0;
	private $totalIterationPercent = 0;
	private $iterationStepFactor = 0.72; //do not change, if you are not absolutely sure what are you doing

    public function __construct($db)
    {
        $this->db = $db;
		$this->memoryTableName = "memRIMsampler_".$_SESSION['UserInfo']['username']."_".$this->getTime();
    }

	public function setRims($rims,$nTotal,$nIteration = null) {
		$this->rimTotals = $rims;
		foreach($rims as $keyRims => $itemRims) {
			$arr_rimColumns[] = $keyRims;
			// prepare main condition for panelists
			$allPctKeys = array();
			foreach($itemRims['pct'] as $keyPct => $itemPct) {
				 $allPctKeys[] = $keyPct;
			}
			$mainWhereCondition[] = "AND $keyRims IN (".implode(",",$allPctKeys).")";
			$arr_rimColumnValues[$keyRims] = $allPctKeys;
		}
		$this->whereBasic = implode(" ",$mainWhereCondition);
		$this->rimColumns = implode(",",$arr_rimColumns);
		$this->rimColumnValues = $arr_rimColumnValues;

		$this->nTotal = $nTotal;
		if (isset($nIteration)) {
			if ($nIteration < 2) $nIteration = 2;
			if ($nIteration > 50) $nIteration = 50;
		}
		else {
			$nIteration = 30;
		}
		$this->nIteration = $nIteration;
	}

	public function setGroup($group) {
		$this->workingGroup = $group;
	}

	public function setWhere($where) {
		$this->whereAdd = $where;
	}

	private function setIterationStep() {
		$this->iterationStep++;
	}

	private function setTotalIterationPercent($pct) {
		$this->totalIterationPercent = $this->totalIterationPercent + $pct;
	}

	private function setCountPerColumn($count) {
		$this->cntPerColumn = $this->cntPerColumn + $count;
	}

	private function getTime() {
		$date = new DateTime();

		return $date->getTimestamp();
	}

	private function getWhere() {
		return $this->whereAdd;
	}

	private function getWhereBasic() {
		return $this->whereBasic;
	}

	private function getRimColumns() {
		return $this->rimColumns;
	}

	private function getRimColumnValues() {
		return $this->rimColumnValues;
	}

	private function getTableName() {
		return $this->memoryTableName;
	}

	private function getTotals() {
		return $this->rimTotals;
	}

	private function getStepFactor() {
		return $this->iterationStepFactor;
	}

	private function getIterationStep() {
		return $this->iterationStep;
	}

	private function getIterationStartPct() {
		return $this->nIteration;
	}

	private function getTotalIterationPercent() {
		return $this->totalIterationPercent;
	}

	private function getCountPerColumn() {
		return $this->cntPerColumn;
	}

	private function calculateIterationStepNum($sampleTotal,$iterationStartPct,$iterationStep,$varNumberOfValues,$numberOfVars) {
		$stepFactor = $this->getStepFactor();
		//echo "stepFactor: $stepFactor<br>";
		$calculatedStepFactor = pow($stepFactor, $iterationStep);
		if ($calculatedStepFactor == 0) $calculatedStepFactor = 1;
		//echo "calculatedStepFactor: $calculatedStepFactor<br>";

		// depend in which step i am, set new step factor
		$iterationPct = $iterationStartPct * $calculatedStepFactor;
		if ($iterationPct < 2) $iterationPct = 2;
		//echo "iterationPct: $iterationPct<br>";

		$stepNum = (($sampleTotal * $iterationPct) / 100) / $varNumberOfValues; // is it better to split non equal N through variables based on number of values inside variable ?
		//$stepNum = (($sampleTotal * $iterationPct) / 100) / $numberOfVars; // is it better to split equal N through all variables ?
		$this->setTotalIterationPercent($iterationPct);

		return $stepNum;
	}

	/**
	 * get order from variables with higher number of items to lower
	 */
	private function getOrder() {
		foreach($this->rimTotals as $keyTotals => $itemTotals) {
			$countColumn = count($itemTotals['pct']);
			$sumAllColumns[$keyTotals] = $countColumn;
			$orderTotals[$keyTotals] = $countColumn;
		}
		$this->sumAllColItems = $sumAllColumns;
		arsort($orderTotals);

		return $orderTotals;
	}

	private function clearTable() {
		$tableName = $this->getTableName();
		$sql = "DROP TABLE IF EXISTS ".$tableName;
		//echo "$sql<br>";
		//$res = $this->db->SQLexecute($sql);
	}

    private function createExcludeTempTable(){
        $usedIdsInSampleSql = " SELECT DISTINCT id FROM _samples_link as a WHERE id_sample IN (SELECT id FROM _SamplingTemplates WHERE id_group = {$this->workingGroup} AND is_leaf = 1)";
        $sql = "DROP TEMPORARY TABLE IF EXISTS tmpExclude";
        $this->db->SQLexecute($sql);

        $sql = "CREATE TEMPORARY TABLE tmpExclude (PRIMARY KEY prim_key (id)) $usedIdsInSampleSql";
		//echo "$sql<br>";
        $this->db->SQLexecute($sql);
    }

	private function createMemoryTable() {
		$tableName = $this->getTableName();
		$whereAdd = $this->getWhere();
		$whereBasic = $this->getWhereBasic();

		$rimColumns = $this->getRimColumns();
		$sql = "CREATE TABLE ".$tableName." (sflag tinyint NOT NULL DEFAULT '0', KEY(sflag)) ENGINE=MEMORY
			SELECT a.id,".$rimColumns." FROM `_Interviewer` a
			INNER JOIN `_group_link` b ON a.id = b.id
            LEFT JOIN _InterviewerStatuses as c ON a.id = c.interviewer_id
            LEFT JOIN tmpExclude as d ON a.id = d.id
			WHERE b.`id_group`=".$this->workingGroup." ".$whereAdd." ".$whereBasic;
		//echo "$sql<br>";
		$res = $this->db->SQLexecute($sql);
	}

	public function runRimSampling() {
        $this->createExcludeTempTable();
		$this->createMemoryTable();
		$rimOrder = $this->getOrder();
		$rimTotals = $this->getTotals();
		$sampleTotal = $this->nTotal;
		//echo "sampleTotal: $sampleTotal<br>";
		$iterationStep = $this->getIterationStep();
		//echo "iterationStep: $iterationStep<br>";
		$varNumberOfValues = array_sum($this->sumAllColItems);
		$numberOfVars = count(explode(",",$this->getRimColumns()));
		//echo "varNumberOfValues: $varNumberOfValues<br>";
		$iterationStartPct = $this->getIterationStartPct();
		//echo "iterationStartPct: $iterationStartPct<br>";

		$totalIterationPercent = $iterationStartPct;
		//echo "totalIterationPercent: $totalIterationPercent<br>";
		// iterationStep is only second fail safe
		while($totalIterationPercent < 100 && $iterationStep < 100) {
			// calculate for every iteration based on iteration step, iteration factor and start percent
			$needIterationN = $this->calculateIterationStepNum($sampleTotal,$iterationStartPct,$iterationStep,$varNumberOfValues,$numberOfVars);
			//echo "needIterationN: $needIterationN<br>";

			// execute for every iteration all selected columns
			foreach($rimOrder as $keyRimsVars => $itemRimsVars) {
				//echo "foreach rimOrder: $keyRimsVars => $itemRimsVars<br>";
				//echo $this->getTime()."<br>";
				// calculate needed N for column iteration
				$cntPerColumn = $needIterationN * $itemRimsVars; // is it better to split non equal N through variables based on number of values inside variable ?
				//$cntPerColumn = $needIterationN; // is it better to split equal N through all variables ?
				//echo "additional N which i need: $cntPerColumn<br>";
				$this->setCountPerColumn($cntPerColumn);
				$cntPerColumn = $this->getCountPerColumn();
				//echo "N which i need: $cntPerColumn<br>";
				// call random sampling for every value inside active column
				foreach($rimTotals[$keyRimsVars]['pct'] as $keyTotals => $itemTotals){
					$valueVar = $keyTotals;
					$neededPct = $itemTotals;
					//echo "value and pct: $valueVar | $neededPct<br>";
					$this->getSamplePerValue($cntPerColumn,$neededPct,$keyRimsVars,$valueVar);
				}

			}
			//echo $this->getTime()."<br>";

			$this->setIterationStep();
			$iterationStep = $this->getIterationStep();
			//echo "iterationStep: $iterationStep<br>";
			$totalIterationPercent = $this->getTotalIterationPercent();
			//echo "totalIterationPercent: $totalIterationPercent<br>";
		}
	}

	private function getSamplePerValue($cntPerColumn,$neededPct,$variableColumn,$valueVar) {
		$tableName = $this->getTableName();
		$requestedN = $this->calculateNforValue($cntPerColumn,$neededPct,$variableColumn,$valueVar);
		// run SQL count for all values to see which values i should already exclude from next iteration step
		$doNotIncludeRecords = $this->calculateNotInclude($cntPerColumn);
		$samplerCounter = 1;
		if ($requestedN > 0) {
			$sql = "UPDATE ".$tableName." dest,
						(SELECT * FROM ".$tableName." WHERE sflag = 0 AND ".$variableColumn."=".$valueVar." ".$doNotIncludeRecords." ORDER BY RAND() LIMIT ".$requestedN.") src
					SET dest.sflag=".$samplerCounter."
					WHERE dest.id=src.id";
			//echo "$sql<br>";
			$res = $this->db->SQLexecute($sql);
		}
	}

	private function calculateNotInclude($subTotalCount) {
		$rimColumnValues = $this->getRimColumnValues();
		$rimTotals = $this->getTotals();
		$tableName = $this->getTableName();

		foreach ($rimColumnValues as $keyColumn => $itemColumn) {
			$sql = "SELECT count(*) as N, ".$keyColumn." as val FROM ".$tableName." WHERE sflag>0 GROUP BY ".$keyColumn;
			//echo "$sql<br>";
			$res = $this->db->SQLexecute($sql);
			while ($row = $this->db->fetchAssoc($res)) {
				$calcHave[$keyColumn][$row['val']]['cnt'] = $row['N'];
			}
		}
		//echo "calcHave<br>";
		//print_r($calcHave);

		$excludeVal = array();
		foreach($rimTotals as $keyTotals => $itemTotals){
			$var = $keyTotals;

			foreach($itemTotals['pct'] as $keyVal => $itemVal) {
				$val = $keyVal;
				$pct = $itemVal;
				$count = $subTotalCount * $pct / 100;
				$calcMust[$var][$val]['pct'] = $pct;
				$calcMust[$var][$val]['cnt'] = $count;

				// get excluded values per variable
				//echo "check if N is bigger and i need to exclude values: $var | $val => ".$calcHave[$var][$val]['cnt']." >= $count<br>";
				if ($calcHave[$var][$val]['cnt'] >= $count) {
					$excludeVal[$var][] = $val;
				}
			}
		}
		//print_r($calcMust);
		//print_r($excludeVal);

		$strExclude = array();
		foreach($excludeVal as $varExclued => $valExcluded) {
			$strExclude[] = " AND ".$varExclued." NOT IN (".implode(",", $valExcluded).")";
		}
		$excludeValues = implode(" ",$strExclude);
		//echo "$excludeValues<br>";

		return $excludeValues;
	}

	private function calculateNforValue($countCol,$percentNeed,$variableColumn,$valueVar) {
		$partialSampleForValue = $this->calculatePartialSample($variableColumn,$valueVar);
		$cntPerColumn = $countCol;
		$neededPct = $percentNeed;
		$requestedN = round(($cntPerColumn * $neededPct / 100),0);
		$calculatedN = $requestedN - $partialSampleForValue;
		if ($calculatedN < 0) $calculatedN = 0; // if i already have more than i need, i will not add new record to the sample

		return $calculatedN;
	}

	private function calculatePartialSample($variableColumn,$valueVar) {
		$tableName = $this->getTableName();

		$sql = "SELECT count(*) as N,".$variableColumn." FROM ".$tableName." WHERE sflag>0 AND ".$variableColumn."=".$valueVar;
		//echo "$sql<br>";
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);
		$partialValue = $row['N'];
		//echo "count for variable: ".$row['N']."<br>";

		return $partialValue;
	}

	public function getRimSampleIds() {
		$tableName = $this->getTableName();
		$sampleTotal = $this->nTotal;

		$sql = "SELECT id FROM ".$tableName." WHERE sflag=1 ORDER BY RAND() LIMIT ".$sampleTotal;
		//echo "$sql<br>";
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			$exportIds[] = $row[id];
		}
		$this->clearTable();

		return implode(",",$exportIds);
	}



}

?>
>>>>>>> 1eb1a17... Added files from meinungsraum production
