<?php
include_once ("_dirinfo.php");

include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.gridData.php");
include_once (PATH_TO_ROOT. "webuserspool/_class/class.RIMsampler.php");
include_once (PATH_TO_ROOT. "webuserspool/_class/class.sampleCalculator.php");

class DataRims extends GridDataManipulator{

    function selectAction(){
        if(isset($_POST['calculate']) && $_POST['calculate'] == 1){
            return $this->calculateSelect();
        }
        else{
            return $this->initialSelect();
        }
    }

    private function calculateSelect(){
        $sampleName = $_POST["sampleName"];
        $templateData = $this->db->get('_SamplingTemplates',$this->treeWhere,'id, id_sup, id_group, id_fields');
        //$fieldIds = $templateData[0]['id_fields'];
        $idGroup = $templateData[0]['id_group'];
        $idTemplate = ($templateData[0]['id_sup'] == -1) ? null : $templateData[0]['id'];


        $data = json_decode($_POST['data'], true);
        $variables = [];

        foreach ($data as $variable){
            if(!array_key_exists($variable['field_name'], $variables)){
                $variables[$variable['field_name']] = [
                    "pct" => [],
                    "values" => [],
                    "labels" => []
                ];
            }

            $nextIndex = count($variables[$variable['field_name']]["pct"]);

            $variables[$variable['field_name']]["field_id"] = $variable['field_id'];
            $variables[$variable['field_name']]["field_name"] = $variable['field_name'];
            $variables[$variable['field_name']]["field_text"] = $variable['field_text'];
            $variables[$variable['field_name']]["pct"][$nextIndex] = $variable["percent"];
            $variables[$variable['field_name']]["values"][] = $nextIndex;
            $variables[$variable['field_name']]["labels"][$nextIndex] = $variable["field_value"];
        }

        $this->db->ChangeDatabase(DB_WARPIT_USERSPOOL);

        // class input $db, $rimTotals, $rimColumns
        $RimSampler = new RIMsampler($this->db);


        // total sample needed
        $nTotal = intval($_POST['countN']);
        // percent for first iteration cycle, the next cycles are automaticaly calculated
        // number must be between 4 and 50, if not it is automaticaly adjusted
        // if not set, it is automaticaly set to 30
        $nIteration = 10;
        // end load example for totals ***********************************************************************

        //var_dump($variables);

        // Run sampling process on specific group for specific RIMs under specific condition(s)
        // set Rim totals, you can call it also with default iteration n -> setRims($rimTotals,$nTotal)
        $RimSampler->setRims($variables,$nTotal,$nIteration);
        // set working group (number 6 is for test only)
        $RimSampler->setGroup($idGroup);
        // set additional condition to group panelists, if necessary (you can leave this out, if not needed)
        // be sure to include only active panelist!!!
        $RimSampler->setWhere("AND (c.definedStatus IS NULL OR c.definedStatus = 1) AND d.id IS NULL");

        // execute sampling
        $RimSampler->runRimSampling();

        // get panelist IDs for created sample
        $IDs = $RimSampler->getRimSampleIds();

        $this->createSample($sampleName, $idTemplate, explode(',', $IDs));

        $this->arr = [];
        return json_encode(["success" => true, "results" => count($this->arr), "rows" => $this->arr]);
    }

    function createSampleFromTemporaryData($sampleName){
        $idUser = $_SESSION['UserInfo']['id'];
        $where = " id_user = $idUser AND id_sup = -1 ";

        $data = $this->db->get('_SamplingTemplates', $where, 'id_group, id_fields');
        $field = $data[0]['id_fields'];
        $idGroup = $data[0]['id_group'];

        $fields = $this->db->get("_InterviewerStructure","id IN ($field)", "id,field_name,data_type,field_text");
        $fieldIds = array_column($fields, 'id');
        sort($fieldIds);

        $templateData = $this->db->get('_SamplingTemplates', "id_fields = '" . implode(',', $fieldIds) . "' AND id_group = $idGroup AND id_sup != -1 AND is_leaf = 0", "id, id_group, id_fields");
        $templateData = $templateData[0];
        if($templateData != null) {
            $idTemplate = $templateData['id'];
            $fields = $this->db->get("_InterviewerStructure","id IN (" . $templateData['id_fields'] . ")", "id,field_name,data_type,field_text");

            $sql = "INSERT INTO _SamplingTemplates (id_sup, idLab, is_leaf, id_user, id_group, id_fields) VALUES ($idTemplate, '$sampleName', 1, $idUser, $idGroup, '" . implode(',', $fieldIds) . "')";
            $this->db->SQLexecute($sql);
            $idSample = $this->db->GetLastInsertId();

            //$sql = "UPDATE _SamplingTemplates SET idLab = 'Sample_$idSample' WHERE id = $idSample";
            //$this->db->SQLexecute($sql);
        } else {
            $sql = "INSERT INTO _SamplingTemplates (id_sup, idLab, is_leaf, id_user, id_group, id_fields) VALUES (0, '" . implode(' - ', array_column($fields, 'field_text')) . "', 0, $idUser, $idGroup, '" . implode(',', $fieldIds) . "')";
            $this->db->SQLexecute($sql);
            $idTemplate = $this->db->GetLastInsertId();

            $sql = "INSERT INTO _SamplingTemplates (id_sup, idLab, is_leaf, id_user, id_group, id_fields) VALUES ($idTemplate, '$sampleName', 1, $idUser, $idGroup, '" . implode(',', $fieldIds) . "')";
            $this->db->SQLexecute($sql);
            $idSample = $this->db->GetLastInsertId();

            //$sql = "UPDATE _SamplingTemplates SET idLab = 'Sample_$idSample' WHERE id = $idSample";
            //$this->db->SQLexecute($sql);

            $tempTableName = "samplingDataUser___$idUser";
            $tableName = "samplingDataTemplate___$idTemplate";

            $fieldNames = array_column($fields, 'field_name');

            $sql = $this->getCreateSampleTableSql($tableName, $fields);
            $this->db->SQLexecute($sql);

            $sql = "INSERT INTO $tableName (id, select_N, freq_N, percent, " . implode(',', $fieldNames) . ") SELECT id, select_N, freq_N, percent, " . implode(',', $fieldNames) . " FROM $tempTableName";
            $this->db->SQLexecute($sql);
        }
        return ['idTemplate' => $idTemplate, 'idSample' => $idSample];
    }

    function getCreateSampleTableSql($tableName, $fields){
		include (PATH_TO_ROOT.'config.php');
		$sql = "CREATE TABLE $tableName  (
		id INT NOT NULL AUTO_INCREMENT ,
		select_N INT NOT NULL,
		freq_N INT NOT NULL,
		percent FLOAT(10,2) NOT NULL";
		foreach ($fields as $data) {
			$sql .= ','.$data['field_name']." ".getDataType($data['data_type']);
		}

		$sql .= ", PRIMARY KEY (id)) ENGINE = MYISAM";

		return $sql;
	}

    function createSample($sampleName, $idTemplate, $ids){
        //$idTemplate = $idTemplate;
		//$sampleName = $sampleName;
        //var_dump($idTemplate);exit;
		if(!$idTemplate){
			$result = $this->createSampleFromTemporaryData($sampleName);
			$idTemplate = $result['idTemplate'];
			$idSample = $result['idSample'];

			$this->db->ChangeDatabase(DB_WARPIT_USERSPOOL);
			$data = $this->db->get('_SamplingTemplates',"id = $idTemplate",'id, id_group,id_fields');
			$fieldIds = $data[0]['id_fields'];
			$idGroup = $data[0]['id_group'];
			$idSup = $data[0]['id'];
		}else{
			$this->db->ChangeDatabase(DB_WARPIT_USERSPOOL);
			$data = $this->db->get('_SamplingTemplates',"id = $idTemplate",'id_group,id_fields');
			$fieldIds = $data[0]['id_fields'];
			$idGroup = $data[0]['id_group'];

			$sql = "INSERT INTO _SamplingTemplates (id_sup, idLab, is_leaf, id_user, id_group, id_fields) VALUES ($idTemplate, '$sampleName', 1," . $_SESSION['UserInfo']['id'] . ", $idGroup, '$fieldIds')";
			$this->db->SQLexecute($sql);
			$idSample = $this->db->GetLastInsertId();
			$idSup = $idTemplate;
		}

        $this->treeWhere = 'id = '.$idTemplate;
		$this->tableName = 'samplingDataTemplate___'.$idTemplate;

        $rows = [];
        foreach ($ids as $id) {
            $rows[] = "($idSample, $id)";
        }

        //var_dump($rows, $id);
        if(count($rows) > 0){
			$sql = "INSERT IGNORE INTO _samples_link (id_sample, id) VALUES " . implode(',', $rows);
			$this->db->SQLexecute($sql);
		}

		return "{success:true}";
	}




    private function resultsToDatabase($variables, $results){
        //echo "/*<pre><br>";
        $columnNames = array_column($variables, 'field_name');
        foreach ($results as $key => $count) {
            $data = [
                round($count),
                0,
                0
            ];

            $explodedKey = explode('-', $key);
            for($i = 0; $i < count($explodedKey); $i++) {
                $label = ($variables[$i]['valueLabels'][$explodedKey[$i]] == '') ? "''" : "'" . $variables[$i]['valueLabels'][$explodedKey[$i]] . "'";
                $data[] = $label;
            }

            $dataRows[] = "(" . implode(',', $data) . ")";
        }

        $sql = "DELETE FROM " . $this->tableName;
        $this->db->SQLexecute($sql);

        $sql = "ALTER TABLE " . $this->tableName . " AUTO_INCREMENT = 1";
        $this->db->SQLexecute($sql);

        $sql = "INSERT INTO " . $this->tableName . " (select_N, freq_N, percent," .implode(',', $columnNames). ") VALUES " . (implode(',', $dataRows));
        $this->db->SQLexecute($sql);

        $this->updateSamplingAction();
    }

    function updateSamplingAction()
	{
		$this->db->ChangeDatabase(DB_WARPIT_USERSPOOL);
		$tableName = $this->tableName;

		$data = $this->db->get('_SamplingTemplates',$this->treeWhere,'id_group,id_fields');
		$fieldIds = $data[0]['id_fields'];
		$idGroup = $data[0]['id_group'];

		$fields = $this->db->get('_InterviewerStructure','id IN ('.$fieldIds.')','field_name,data_type,field_text');

		if(!$fields)
			return "{success: false, error:'Fields not found!'}";
		foreach ($fields as $data) {
			$fldNames[] = $data['field_name'];
			$notNullWhere[] = 'a.' . $data['field_name'].' IS NOT NULL';

            if($data['data_type'] === "3"){
                $conWhere[] = $tableName.'.'.$data['field_name'].' = samplerUpdateTmp.'.$data['field_name'] . ' collate "utf8_general_ci"';
            } else {
                $conWhere[] = $tableName.'.'.$data['field_name'].' = samplerUpdateTmp.'.$data['field_name'];
            }
		}

		$usedIdsInSampleSql = " SELECT DISTINCT id FROM _samples_link as a WHERE id_sample IN (SELECT id FROM _SamplingTemplates WHERE id_group = $idGroup AND is_leaf = 1)";
		$sql = "DROP TEMPORARY TABLE IF EXISTS tmpExclude";
		$this->db->SQLexecute($sql);

		$sql = "CREATE TEMPORARY TABLE tmpExclude (PRIMARY KEY prim_key (id)) $usedIdsInSampleSql";
		$this->db->SQLexecute($sql);

		$selectValidSql = "SELECT DISTINCT a.id, CONCAT_WS('-'," . implode(",", $fldNames) . ") as cond FROM _Interviewer a INNER JOIN _group_link b ON a.id = b.id LEFT JOIN _InterviewerStatuses as c ON b.id = c.interviewer_id LEFT JOIN tmpExclude d ON a.id = d.id WHERE id_group = $idGroup AND (c.definedStatus IS NULL OR c.definedStatus = 1) AND d.id IS NULL ORDER BY RAND()";


		$sql = "SELECT count(DISTINCT a.id) FROM _Interviewer a INNER JOIN _group_link b ON a.id = b.id LEFT JOIN _InterviewerStatuses as c ON b.id = c.interviewer_id LEFT JOIN tmpExclude d ON a.id = d.id WHERE b.id_group = $idGroup AND (c.definedStatus IS NULL OR c.definedStatus = 1) AND d.id IS NULL";
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchRow($res);
		$count = $row[0];

		$fldNames = implode(',',$fldNames);
		$this->db->SQLexecute("DROP TEMPORARY TABLE IF EXISTS samplerUpdateTmp");
		//load the data from interviewer table
		$sql = "CREATE TEMPORARY TABLE samplerUpdateTmp SELECT 0 as recExists,count(DISTINCT a.id) as freq,count(DISTINCT a.id)/$count*100 as percent,".$fldNames." FROM _Interviewer a INNER JOIN _group_link b ON a.id = b.id LEFT JOIN _InterviewerStatuses as c ON b.id = c.interviewer_id LEFT JOIN tmpExclude d ON a.id = d.id WHERE b.id_group = $idGroup AND (c.definedStatus IS NULL OR c.definedStatus = 1) AND d.id IS NULL AND (" . implode(' AND ', $notNullWhere) . ") GROUP BY $fldNames";
		//echo "/*$sql*/";
		$this->db->SQLexecute($sql);

		//lets update existing
		$sql = "UPDATE $tableName INNER JOIN samplerUpdateTmp ON ".implode(' AND ',$conWhere)." SET freq_N = freq,$tableName.percent = samplerUpdateTmp.percent,samplerUpdateTmp.recExists = 1";
		//$sql .= (count($notNullWhere) > 0) ? " WHERE " . implode(' AND ', $notNullWhere) : "";
		$this->db->SQLexecute($sql);//exit;
		//insert if some new combinations are available
		$sql = "INSERT INTO $tableName (freq_N,percent,$fldNames) SELECT freq,percent,$fldNames FROM samplerUpdateTmp WHERE recExists = 0";
		$this->db->SQLexecute($sql);
		//delete combinations that are not anymore existant :)
		//$sql = "DELETE FROM $tableName WHERE NOT EXISTS (SELECT * FROM samplerUpdateTmp WHERE ".implode(' AND ',$conWhere).") ";
		//$this->db->SQLexecute($sql);
	}


    private function initialSelect(){
        $data = $this->db->get('_SamplingTemplates',$this->treeWhere,'id, id_group, id_fields');
		$fieldIds = $data[0]['id_fields'];
		$idGroup = $data[0]['id_group'];
        $idTemplate = $data[0]['id'];

		$fields = $this->db->get('_InterviewerStructure','id IN ('.$fieldIds.')','id,field_name,data_type,field_text');
        $tableName = $this->tableName;

        $this->arr = [];
        $insertRows = [];
        foreach($fields as &$field){
            $fieldName = $field['field_name'];
            $sql = "SELECT $fieldName FROM $tableName GROUP BY $fieldName";
            $res = $this->db->SQLexecute($sql);

            while($row = $this->db->fetchAssoc($res)){
                $row = [
                    "field_id"          => $field["id"],
                    "is_total"          => 0,
                    "percent"           => 0,
                    "sample"            => 0,
                    "sample_percent"    => 0,
                    "field_value"       => $row[$fieldName],
                    "field_text"        => $field['field_text'],
                    "field_name"        => $fieldName
                ];
                $this->arr[] = $row;
                $insertRows[] = "(" . implode(',', $row) . ")";
            }

            $this->arr[] = [
                "field_id" => $field["id"],
                "is_total" => 1,
                "percent" => 0,
                "sample"  => 0,
                "sample_percent" => 0,
                "field_text"        => $field['field_text'],
                "field_name"        => $fieldName
            ];
        }

        return json_encode(["success" => true, "results" => count($this->arr), "rows" => $this->arr]);
    }
}

$db->ChangeDatabase(DB_WARPIT_USERSPOOL);
$manipulator = new DataRims($db,$_POST['RMtable']);


$idTemplate = $_POST['id_template'];
if(!$idTemplate)
{
    $manipulator->treeWhere = 'id_user = '.$_SESSION['UserInfo']['id']. " AND id_sup = -1 ";
    $manipulator->tableName = 'samplingDataUser___'.$_SESSION['UserInfo']['id'];
}
else
{
    $manipulator->treeWhere = 'id = '.$idTemplate;
    $manipulator->tableName = 'samplingDataTemplate___'.$idTemplate;
}

$comm = $_POST['action'].'Action';
if(method_exists($manipulator,$comm))
    echo $manipulator->$comm();
else
{
    echo '{success:false,error:"Unknown action!"}';
}
