<?php

include_once("_dirinfo.php");

$sessionHandling = 1;
include_once(PATH_TO_ROOT . "init.php");
use GuzzleHttp\Client as Guzzle;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\ClientException;

ini_set('display_errors', 1);
/**
 * UNIQUE ID na user_phone_number + id_project  - anketa se lahko pošlje samo 1x na telefonsko.
 *
 *
 */
//( 1 - single response, 3 - Multi response, 4 - Open, 5- Instruction)

CONST MULTIPLE = 3;
CONST SINGLE = 1;
CONST OPEN = 4;
CONST INSTRUCTION = 5;
$action = null;
$body = null;
$from = null;

if (isset($_POST['action']) && !empty($_POST['action'])) {
    $action = $_POST['action'];
}
if (isset($_POST['data']) && !empty($_POST['data'])) {
    $data = json_decode($_POST['data']);
}
if (isset($_POST['project_Id']) && !empty($_POST['project_Id'])) {
    $projectId = $_POST['project_Id'];
}
if (isset($_POST['from']) && !empty($_POST['from'])) {
    $from = $_POST['from'];
}
if (isset($_POST['from']) && !empty($_POST['from'])) {
    $from = $_POST['from'];
}
if ($action != null) {
    switch ($action) {
        case 'sendSms' :
            if ($projectId) {
                sendSmsWithQuestions($data, $projectId);
            }
            break;
        case 'receive':
            receiveSms($_POST['from'], $_POST['body']);
            break;
        default;
            break;
    }
}
function normalizeNumber($number)
{
    $result = substr($number, 0, 1);
    $checkZeros = substr($number,0,2);


    if($result != '+' && $checkZeros != '00')
    {

        $number = '+386'. substr($number,1);
    }
    if($checkZeros == '00')
    {
        $number = '+'. substr($number,2);
    }

    return $number;
}
//sendSmsWithQuestions($data, 2);
//receiveSms('1:041943599', '041943599 041943599 1');
function sendSmsWithQuestions($phoneNumbers, $projectId)
{
    $projectName = getProjectName($projectId);
    $questions = getQuestions($projectName);

    $questionRotation = '/';
    foreach ($questions as $question) {
        if ($question['id'] != 2 && $question['id'] != 5) {
            $questionRotation .= $question['id'] . '/';
        }
    }

    /*add end txt to end of questionary path*/
    $questionRotation .= '2/';
    $startText = getQuestionTextByIdQuestion($questions[0]['id'], $projectName);

    $startText = $startText['lngText'];
    $answerInstructions = getAnswerInstructions($projectName, $questions[0]['id']);
    $startText = $startText . "\n" . $answerInstructions;
    foreach ($phoneNumbers as $phoneNumber) {
        if ($phoneNumber) {
            $structureId = saveToStructure($projectId, $projectName);
            $interviewerStatisticsId = saveToInterviewerStatistics($structureId, $projectName, $projectId, $phoneNumber);
            saveToEngineLog($structureId, $projectName, $questions[0]['id'], $questions[0]['q_name'], $questionRotation, $questions[0]['id']);

            //echo "SEND TO : {$phoneNumber} TEXT :  $startText <br>";
            saveToStatisticsTable($phoneNumber, $projectId);

            sendSms($phoneNumber, $startText);
        }
    }
}

function receiveSms($phoneNumber, $answer = null)
{


    $temp = explode('1:', $phoneNumber);
    $phoneNumber = $temp[1];



    $temp2 = explode(' ', $answer);
    //delete from anwser number from user and number from mvrata telekom

    $phoneNumber  = normalizeNumber($phoneNumber);

    if (isset($temp2[0])) {
        unset($temp2[0]);
    }
    if (isset($temp2[1])) {
        unset($temp2[1]);
    }

    $answer = implode(" ", $temp2);
    $answers = explode(', ', trim($answer));
    $interviewerData = getInterviewerData($phoneNumber);

    $projectId = $interviewerData['id_project'];
    $structureId = $interviewerData['id_structure'];
    $interviewerId = $interviewerData['id'];
    $projectName = getProjectName($projectId);


    $currentQuestion = getCurrentQuestion($structureId, $projectId, $projectName);

    $engineLogId = $currentQuestion['engineLogId'];

    if(checkTimeout($projectName,$structureId)){
        sendSms($phoneNumber, getNotAllowedText($projectName));
        return;
    }
    $success = getCurrentStep($answers, $projectName, $structureId, $currentQuestion);


    IF ($success) {
        updateEngineLog($engineLogId, $projectId, $projectName);
        $nextStepQuestionId = setNextStep($currentQuestion, $structureId, $projectId, $projectName, $interviewerId);
        $message = getQuestionText($projectName, $nextStepQuestionId);
        $answerInstructions = getAnswerInstructions($projectName, $nextStepQuestionId);
        $questionAnswers = getAnswerOptions($nextStepQuestionId, $projectName);
        $smsBody = $message . "\n";
        if ($questionAnswers) {

            $questionAnswers = explode('/', $questionAnswers['lngText']);
            foreach ($questionAnswers as $questionAnswer) {
                $smsBody .= $questionAnswer . "\n";
            }
        }
        if ($answerInstructions) {
            $smsBody .= "(" . $answerInstructions . ")";
        }
        //echo "SEND TO : {$phoneNumber} TEXT :  {$smsBody}";
        sendSms($phoneNumber, $smsBody);
    } else {
        //echo "ANSWER NOT VALID";
        sendSms($phoneNumber, "ANSWER NOT VALID");
    }
}

function getNextQuestionIdAndRotation($currentRotationString)
{
    $rotationString = explode('/', $currentRotationString);
    if (isset($rotationString[1])) {
        unset($rotationString[1]);
    }
    return ["newRotationString" => implode('/', $rotationString), "nextQuestionId" => $rotationString[2]];
}

function setNextStep($currentQuestion, $structureId, $projectId, $projectName, $interviewerId)
{
    $data = getNextQuestionIdAndRotation($currentQuestion['currentRotationString']);
    $nextQuestion = getQuestionById($data['nextQuestionId'], $projectName);
    $questionPath = $currentQuestion['questionnairePath'] . ';' . $nextQuestion['id'];
    saveToEngineLog($structureId, $projectName, $nextQuestion['id'], $nextQuestion['q_name'], $data['newRotationString'], $questionPath);
    if ($nextQuestion['q_name'] == '_End' || $nextQuestion['q_pos'] == '-5') {
        endSurvey($structureId, $projectName, $interviewerId);
    }

    return $nextQuestion['id'];
}

function getCurrentStep($answers, $projectName, $structureId, $currentQuestion)
{
    $result = false;

    $questionAnswers = getAnswerOptions($currentQuestion['id_question'], $projectName);

    switch ($currentQuestion['tip_sql']) {


        case OPEN:
            $rowName = $currentQuestion['q_name'] . '_1';
            $tmp = null;

            foreach ($answers as $answer) {
                $tmp .= $answer;
            }

            saveAnwser($tmp, $projectName, $structureId, $rowName);
            $result = true;
            break;
        case MULTIPLE:
            $optionalAnswers = explode('/', $questionAnswers['lngText']);
            $answers = explode(',', $answers[0]);

            $int = null;



            foreach ($optionalAnswers as $optionalAnswer) {
                $tmp = explode(' ',$optionalAnswer);

                $int[] =$tmp[0];


            }
            //check if options exist

            foreach ($answers as $answer)
            {
                if(!in_array($answer,$int))
                {

                    return false;
                }


            }
            foreach ($int as $answerNumber) {
                if (in_array($answerNumber, $answers)) {
                    $rowName = $currentQuestion['q_name'] . '_' . $answerNumber;
                    saveAnwser($answerNumber, $projectName, $structureId, $rowName);
                    $result = true;
                }else{
                    $rowName = $currentQuestion['q_name'] . '_' . $answerNumber;
                    saveAnwser('0', $projectName, $structureId, $rowName);
                    $result = true;
                }
            }
            break;
        case INSTRUCTION:
        foreach ($answers as $answer) {
            if (strtoupper($answer) == 'START') {
                $result = true;
                break;
            }
        }
        break;
        case SINGLE:
            $tmpAnwsers = explode('/', $questionAnswers['lngText']);

            foreach ($tmpAnwsers as $tmpAnwser) {
                $tmp = explode(' ', $tmpAnwser);
                $optionalAnswers[] = $tmp[0];
            }

            $rowName = $currentQuestion['q_name'];

            foreach ($answers as $answer) {
                if (in_array(trim($answer), $optionalAnswers)) {
                    saveAnwser($answer, $projectName, $structureId, $rowName);
                    $result = true;
                }
            }
            break;
        default:
            $result = false;
            break;
    }
    return $result;
}

function getAnswerOptions($questionId, $projectName)
{
    global $db;
    $sql = "SELECT lngText,id_question FROM " . DB_WARPIT_WEBCATI . ".{$projectName}_language
            where id_question = {$questionId}
            and id_text_type = 3";

    try {
        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);
        return $row;
    } catch (Exception $e) {
        //TODO LOG WARNINGS OR ERRORS
    }
}

function getQuestionById($questionId, $projectName)
{
    global $db;
    $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI . ".{$projectName} WHERE id={$questionId}";
    if (!$result = $db->SQLexecute($sql))
        echo "NAPAKA 01:" . $db->GetError(); //return false


    $row = $db->fetchAssoc($result);
    return $row;
}

function getInterviewerData($phoneNumber)
{
    global $db;
    $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics
            where user_phone_number = {$phoneNumber}
            ORDER BY id  desc
            limit 1";

    try {
        if (!$result = $db->SQLexecute($sql))
            echo "NAPAKA 01:" . $db->GetError(); //return false

        $row = $db->fetchAssoc($result);

        return $row;
    } catch (Exception $e) {
        error_log("getInterviewerData :". json_encode($e));

    }
}
function getQuestionText($projectName, $questionId)
{
    global $db;
    $sql = "SELECT lngText,id_question FROM " . DB_WARPIT_WEBCATI . ".{$projectName}_language
            where id_question = {$questionId}
            and id_text_type = 2";
    try {
        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);
        return $row['lngText'];
    } catch (Exception $e) {

        error_log("getQuestionText :". json_encode($e));
    }
}
function getNotAllowedText($projectName)
{
    global $db;
    $sql = "SELECT lngText FROM ".DB_WARPIT_WEBCATI.".{$projectName}
            left join ".DB_WARPIT_WEBCATI.".{$projectName}_language on {$projectName}_language.id_question = {$projectName}.id where q_pos = -15";
    try {
        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);
        return $row['lngText'];
    } catch (Exception $e) {
        error_log("getNotAllowedText :". json_encode($e));
    }
}
function getAnswerInstructions($projectName, $questionId)
{
    global $db;
    $sql = "SELECT lngText,id_question FROM " . DB_WARPIT_WEBCATI . ".{$projectName}_language
            where id_question = {$questionId}
            and id_text_type = 1";
    try {
        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);
        return $row['lngText'];
    } catch (Exception $e) {
        error_log("getAnswerInstructions :". json_encode($e));
    }

}

function saveAnwser($answer, $projectName, $structureId, $rowName)
{
    global $db;
    $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}_structure SET {$rowName} = '{$answer}'
            WHERE id = {$structureId}";
    $result = $db->SQLexecute($sql);
}

function saveToEngineLog($idStructure, $projectName, $questionId, $questionQName, $questionRotation, $questionnairePath)
{
    global $db;
    $startTime = strtotime(date("Y-m-d H:i:s"));
    $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}___EngineLog
                             (`id_structure`,`id_question`,`user_type`,`id_language`,`q_name`,`currentRotationString`,`questionnairePath`,`engineTime`,`questStart`)
                             VALUES ({$idStructure},{$questionId},3,46,'{$questionQName}','{$questionRotation}','{$questionnairePath}',0,{$startTime})";

    $db->SQLexecute($sql);
    $id = $db->GetLastInsertId();
    return $id;

}

function saveToInterviewerStatistics($structureId, $projectName, $projectId, $phoneNumber)
{
    global $db;
    $startTime = strtotime(date("Y-m-d H:i:s"));

    $phoneNumber = (string)$phoneNumber;
    $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics
                            (`id_user`, `user_type`, `id_project`, `id_structure`, `qStatus`,`user_phone_number`,`startDate`)
                             VALUES (0,3,{$projectId},{$structureId},99,'{$phoneNumber}',{$startTime})";
    //qstatus == 99 če je v izdelavi, 1 kadar je končana.


    $db->SQLexecute($sql);

    $id = $db->GetLastInsertId();
    return $id;
}

function saveToStructure($projectId, $projectName)
{
    global $db;
    $startTime = strtotime(date("Y-m-d H:i:s"));

    $db->SQLexecute("INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $projectName . "_structure
                            (user_id, user_type, id_loginSID, id_device, id_language, flag_bad, t_pause,d_start,t_start)
                             VALUES (0,3,9999,2,60,99,0,{$startTime},{$startTime})");
    $id = $db->GetLastInsertId();
    return $id;
}


function getProjectName($projectId)
{
    global $db;
    try {
    $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "._Projects WHERE id = {$projectId}";


    if (!$result = $db->SQLexecute($sql))
        echo "NAPAKA 01:" . $db->GetError(); //return false


        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);
        return $row['proj_name'];
    } catch (Exception $e) {
        error_log("ERROR getting project name :". json_encode($e));
    }
}

function getQuestionTextByIdQuestion($questionId, $projectName)
{
    global $db;
    $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI . ".{$projectName}_language WHERE  id_question = {$questionId} and id_text_type = 2";
    try {
        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);
        return $row;
    } catch (Exception $e) {
        error_log("getQuestionTextByIdQuestion :". json_encode($e));
    }
}

function getQuestions($projectName)
{
    global $db;
    $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI . ".{$projectName} WHERE q_pos != -15 AND q_pos != -16";
    try {
        $result = $db->SQLexecute($sql);
        while ($row = $db->fetchAssoc($result)) {
            $questions[] = $row;
        }
        return $questions;
    } catch (Exception $e) {
        error_log("getQuestions :". json_encode($e));
    }
}

function updateEngineLog($engineLogId, $projectId, $projectName)
{
    global $db;
    $currentTime   =strtotime(date("Y-m-d H:i:s"));

    $db->SQLexecute("UPDATE " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}___EngineLog
                    SET `questEnd` =  {$currentTime}
                    WHERE `id` = {$engineLogId}");
}

function getCurrentQuestion($structureId, $projectId, $projectName)
{
    //GROUP BY " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}__EngineLog.id";
    global $db;
    $sql = "SELECT *," . DB_WARPIT_WEBCATI_BASE . ".{$projectName}___EngineLog.id as engineLogId FROM " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}___EngineLog
            join " . DB_WARPIT_WEBCATI . ".{$projectName} on " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}___EngineLog.id_question  = " . DB_WARPIT_WEBCATI . ".{$projectName}.id
            where id_structure = {$structureId}
            and questEnd IS NULL";

    try {
        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);
        return $row;
    } catch (Exception $e) {
        error_log("getCurrentQuestion :". json_encode($e));
    }
}

function saveToStatisticsTable($phoneNumber, $projectId)
{
    global $db;

    $currentTime   =strtotime(date("Y-m-d H:i:s"));
    try {
        $sql = "INSERT INTO " . DB_WARPIT_USERSPOOL . "._smsStatistics (telephone,id_project,send_date) VALUES ('{$phoneNumber}','{$projectId}',{$currentTime})";
        $db->SQLexecute($sql);
    }catch (Exception $e){

        error_log("saveToStatisticsTable :". json_encode($e));

    }
}

function endSurvey($structureId, $projectName, $interviewerStatisticsId)
{
    global $db;
    $currentTime   =strtotime(date("Y-m-d H:i:s"));

    $db->SQLexecute("UPDATE " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics
                    SET `qStatus` =  '1'
                    WHERE `id` = {$interviewerStatisticsId}");

    $db->SQLexecute("UPDATE " . DB_WARPIT_WEBCATI_BASE . ".{$projectName}_structure
                    SET `status` =  '1',
                        `status_rec` = '1',
                        `flag_bad` = '1',
                        `d_stop` = {$currentTime},
                        `t_stop` ={$currentTime}
                    WHERE `id` = {$structureId}");
}

/**
 * @param $phoneNumber
 * @param $question
 */
function sendSms($phoneNumber, $question)
{
    $client = new Guzzle;
    $smsApi = configLoader::loadConfig('sms_api');

    try {
        $options = [
            'auth' => [$smsApi['user'], $smsApi['token']],
            'form_params' => [
                'to' => $phoneNumber,
                'body' => trim($question)
            ],
        ];
        $response = $client->request('POST', $smsApi['url'], $options);
        $body = json_decode($response->getBody());
        if($body->statusCode == 200)
        {
            updateSmsStatistics($phoneNumber);
        }

    } catch (ClientException $e) {
        //echo '<pre>' . print_r($e) . '</pre>';
    } catch (RequestException $e) {
        //echo '<pre>' . print_r($e) . '</pre>';
    } catch (Exception $e) {
        //echo '<pre>' . print_r($e) . '</pre>';
    }
}
function checkTimeout($projectName,$structureId)
{
    $config =  configLoader::loadConfig('sms_api');
    $timeOut = $config['sms_timeout'];
    $sendDate = getLatestSendSms($projectName,$structureId);
    $receiveDate =strtotime(date("Y-m-d H:i:s"));
    $diference = $receiveDate - $sendDate;


    if($diference >= $timeOut)
    {
        return true;
    }else
    {
        return false;
    }
}
function getLatestSendSms($projectName,$idStructure)
{
    global $db;

    $sql ="SELECT * FROM ".DB_WARPIT_WEBCATI_BASE.".{$projectName}___EngineLog
            left join ".DB_WARPIT_WEBCATI_BASE.".{$projectName}_structure on ".DB_WARPIT_WEBCATI_BASE.".{$projectName}_structure.id = ".DB_WARPIT_WEBCATI_BASE.".{$projectName}___EngineLog.id_structure
            where ".DB_WARPIT_WEBCATI_BASE.".{$projectName}___EngineLog.id_structure = {$idStructure}
            and ".DB_WARPIT_WEBCATI_BASE.".{$projectName}___EngineLog.questEnd IS NULL";

    try {
        $result = $db->SQLexecute($sql);
        $row = $db->fetchAssoc($result);

        return $row['questStart'];
    } catch (Exception $e) {
        error_log("ERROR GETTIng LATEST SMS :". json_encode($e));

    }

}
function updateSmsStatistics($phoneNumber)
{

    global $db;
    try {
        $db->SQLexecute("UPDATE ".DB_WARPIT_USERSPOOL."._smsStatistics 
                SET status = 1
                where telephone = {$phoneNumber}
                ORDER by send_date DESC
                LIMIT 1 ");
    } catch (Exception $e) {
        error_log("updateSmsStatistics :". json_encode($e));
    }

}

?>


