<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."_class/class.Extjs_tree.php");
include_once(PATH_TO_ROOT."_class/class.Extjs_grid.php");

$grid = new MakeGrid();
$gridName = $grid->getName();
$id_user = $_SESSION["UserInfo"]["id"];
$user_type = $_SESSION["UserInfo"]["user_type"];
$tabId = $_POST['uniqueTabId'];
$projectId = $_POST['id_project'];
$projName = $_POST['projName'];
$tableName = $projName.'___telIndex';
$database = DB_WARPIT_WEBCATI_BASE;

//let's check if there is any telIndex table
if(!$db->TableExists($projName.'___telIndex',DB_WARPIT_WEBCATI_BASE))
{
	echo "Ext.Msg.alert('Error','There is no telephone sample reserved for the project!');
	removeSession('$tabId')";
	exit;
}

// if I have custom telephone fields, I need ID of telephone table
$id_telname = $db->get('_Projects',$projectId,'id_telname',DB_WARPIT_WEBCATI_BASE);
$telTable = 'tel___'.$db->get('_TelephoneTables',$id_telname,'name',DB_WARPIT_WEBCATI_BASE);

//$grid = new MakeGrid();

$countGrid = new MakeGrid();

$grid->setMainTable($tableName,DB_WARPIT_WEBCATI_BASE);

// I need additional columns, if exists
$extraFields = $db->get('_TelephoneTablesAddon','id_telbaza = '.$id_telname.' AND is_leaf = 1','name' );
if(is_array($extraFields)) {
	$sql_extraFields = ",b.tel_".implode(",b.tel_", $extraFields);
	// put all possible sort fields to ajax request
	$str_extraFields = "oms,tel_".implode(",tel_", $extraFields);
}

$grid->selectSQL = "SELECT a.*,a.id, a.status,b.oms,b.telephone,b.name $sql_extraFields FROM $tableName a INNER JOIN $telTable b ON a.id_tel = b.id";
$grid->setReqUrl('webcati/_ajax/telNumberManagment/ajax.appointmentMan.php');
//$grid->baseParams = "SQLwhere : '(a.status = 91 OR a.status = 89)'";
$grid->baseParams = "SQLwhere : '(a.status IN (21,22,24,25,89,91) AND a.tdisable=0)', str_extraFields : '$str_extraFields', id_project:$projectId";

$grid->addColumn('id');
$grid->addColumn('statIcon');
$grid->addColumn('statTooltip');
$grid->addRowAction('icons',"new Ext.ux.grid.RowActions({

	actions:[{
		iconIndex:'statIcon',
		qtipIndex:'statTooltip'
		},
		{
		iconCls:'RMicon_delete_app',
		tooltip:'Delete'
		},
		{
		iconCls:'RMicon_reactivate_app',
		tooltip:'Reactivate'
		}
	],
	listeners: {
		action: function(g,r,a){
			var act;
			if(a == 'RMicon_cancel_app') act = 'cancelApp';
			else if(a == 'RMicon_restore_app') act = 'restoreApp';
			else if(a == 'RMicon_delete_app') act = 'deleteApp';
			else if(a == 'RMicon_reactivate_app') act = 'reactivateApp';
			$grid.RMconn.request({params:{
				action:act,
				id:r.id},
				success:function(){ $grid.getStore().reload(); $countGrid.getStore().reload();}
			});
		}
	}
})");
$grid->addSetter("'app_time','id_ank'");

$grid->addColumn('id','ID')->type('int')->width(40)->tableAs('a');
$grid->addColumn('tdisable','tdisable')->type('checkColumn')->width(60)->tableAs('a');
$grid->addColumn('status','Status')->type('int')->width(50)->tableAs('a');
$grid->addColumn('status_rec','Status rec')->type('int')->width(50)->tableAs('a');
$grid->addColumn('call_num','No. of calls')->type('int')->width(50);
$grid->addColumn('id_tel','Id tel.')->type('int')->width(50);
$grid->addColumn('id_ank','Int. ID')->type('int')->width(50)->editor("new Ext.form.TextField()");
//oms and telefon from the tel___database!
//$grid->addColumn('oms','Tel. num.')->type('int')->width(150)->renderer("function(val,md,rec){return val+'/'+rec.data.telephone;}");
$grid->addColumn('oms','Area code')->width(50)->tableAs('b');
$grid->addColumn('telephone','Telephone')->width(150)->tableAs('b');
$grid->addColumn('name','Name')->width(200);
$grid->addColumn('region','Region')->type('int')->tableAs('b');


//$grid->addColumn('ime','Name');



$grid->dateSQL = 'U';
$grid->dateDisplay = 'd.m.Y H:i:s';

$grid->addColumn('last_call','Last call')->type('date')->width(200);
//$grid->addColumn('call_time',"Call time")->type('date')->width(200)->editor('new Ext.ux.form.DateTime()');

$grid->addColumn('app_time','Next call time (app, busy, no answer)')->type('date')->width(200)->editor('new Ext.ux.form.DateTime()');
$grid->addColumn('app_call_this_num','New call number')->width(150)->editor('new Ext.form.TextField()');
$grid->addColumn('status_comment','Status comment')->width(200)->editor('new Ext.form.TextField()');
$grid->addColumn('app_koment','Appointment comment')->width(200)->editor('new Ext.form.TextField()');

if(is_array($extraFields)) {
	foreach ($extraFields as $telField) {
		$extraCol = $grid->addColumn('tel_'.$telField,$telField)->tableAs('b');

	}
}


$grid->setAutoExpand('id_tel');
$grid->setCheckBoxSelectionModel()
	->setSearchField()
	->setFiltering()
	->region('center');

$grid->setPaging()
	->region('center')
	->setCheckBoxSelectionModel(true)
	->setRemoteSort()
	->setFiltering(true)
	->setSearchField('Search','top');

$grid->addtBarItem("{
			text:'On hold',
			iconCls:'cancelMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiCancel', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

$grid->addtBarItem("{
			text:'Restore',
			iconCls:'restoreMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiRestore', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

$grid->addtBarItem("{
			text:'Delete',
			iconCls:'deleteMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiDelete', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

$grid->addtBarItem("{
			text:'Reactivate',
			iconCls:'reactivateMultiAppointments',
			handler:function(bt,state){

			var q = $grid.selModel.getSelections();
			if(q) {
				var qId = new Array();
				for(var i=0;i<q.length;i++)
					qId.push( q[i].id );
			}
			$grid.RMconn.request({
					  url:'webcati/_ajax/telNumberManagment/ajax.appointmentActions.php',
					  params:{action:'MultiReactivate', database:'$database', RMtable:'$tableName', selRecords:Ext.encode(qId) },
					  success:function(){
					  	$grid.getStore().reload();
					  }
				})
       		}
	   }");

	   $gridUsers = "";
	   $gridStatuses = "";
	   $formDateTime = "";

	   $grid->addtBarItem("{
		   		xtype: 'button',
				text:'Advanced Filter',
				iconCls:'iconFilter',
	   			handler:function(sender,state){
					CallScript('webcati/_forms/telNumberManagment/window.advancedFilter.php', {
						id_project: $projectId,
						project_name: '$projName',
						mainGrid: '$gridName'
					});
	          	}
	   	   }");

		if(quotaLockExists($projectId) === true){
			$grid->addtBarItem("{
				xtype: 'button',
				text:'Show all',
				id: 'onlyValidRows_" .  $projName. "',
				iconCls:'iconFilter',
				enableToggle:true,
				handler:function(sender){
					if(sender.pressed){
						sender.setText('Show only valid');
					}
					else{
						sender.setText('Show all');
					}
					$gridName.getStore().reload();
				}
			}");
       }

		$grid->addtBarItem("'->'");
	 	$grid->addExportButton();

		$grid->addBottomBarItem(
		"{
				xtype: 'button',
				text:'Clear Advanced Filter',
				iconCls:'iconClearFilter',
				handler:function(sender,state)
				{
					var store = $gridName.getStore();
					delete store.lastOptions.params.advanceFilter;
					delete store.lastOptions.params.advanceFilterIds;
					delete store.lastOptions.params.advanceFilterStatuses;
					delete store.lastOptions.params.advanceFilterStatusesRec;
					delete store.lastOptions.params.advanceFilterDateFrom;
					delete store.lastOptions.params.advanceFilterDateTo;
					delete store.lastOptions.params.advanceFilterTimeFrom;
				    delete store.lastOptions.params.advanceFilterTimeTo;
					delete store.baseParams.advanceFilterOnlyOpenQuota;

					delete store.baseParams.advanceFilter;
					delete store.baseParams.advanceFilterIds;
					delete store.baseParams.advanceFilterStatuses;
					delete store.baseParams.advanceFilterStatusesRec;
					delete store.baseParams.advanceFilterDateFrom;
					delete store.baseParams.advanceFilterDateTo;
					delete store.baseParams.advanceFilterTimeFrom;
					delete store.baseParams.advanceFilterTimeTo;
					delete store.baseParams.advanceFilterOnlyOpenQuota;
					store.reload();

					delete $gridName.advancedFilter;
				}
		   }"
	   );

/*
$grid->addTbarItem(" new Ext.form.ComboBox({
	    typeAhead: true,
	    triggerAction: 'all',
	    mode: 'local',
	    store: new Ext.data.ArrayStore({
	        fields: [
	            'filID',
	            'displayText'
	        ],
	        data: [
	        		[1,' Show all numbers'],
	        	 	[2,' Show only available numbers (tdisable = 0)']
	        	  ]
	   	 }),
	   	 valueField: 'filID',
	   	 value: '1',
	   	 displayField: 'displayText',
	   	  listeners: {
	   	 	select : function(combo,rec) {
				$grid.getStore().reload({params:{ ShowFilter : rec.get('filID')} });
	   	 	}
	   	 }

		}) ");
*/
//20160524 Bojan Orter - We read from config if we show only appointments on load. If we do we set filter and apply it before grid render
$configWebcati = configLoader::loadConfig('webcati');
$applyFilterBeforeRender = "";
if($configWebcati["show_only_app"])
{
	$applyFilterBeforeRender = "
		var statusFilter = $grid.filters.getFilter('status');
		statusFilter.menu.fields.eq.value = 91;
		statusFilter.active = true;
	";
}
//END Bojan Orter


$grid->addListener('beforerender',"function(){

	//20160524 Bojan Orter - we apply filter for status
	$applyFilterBeforeRender
	//END Bojan Orter

	this.getStore().on('beforeload',function(store, options){
	
		if ( Ext.getCmp('onlyValidRows_" .  $projName. "') != undefined ) {
		    var onlyValidRows = Ext.getCmp('onlyValidRows_" .  $projName. "').pressed === false ? 1 : 0;
		} else {
		    var onlyValidRows = 1;
		}
        
        options.params.onlyValidRows = onlyValidRows;
		$countGrid.getStore().reload();
	});

//20170223 Tanis: if you are on page 6 and then you filter records to only 4 pages your position will still be page 6 and you will see no records.
// in this case we check what is the number of total records in store and how many records are we displaying. If there should be some records but we
// don't display any this means that we are on wrong page so we go to the last aviable page
	this.getStore().on('load',function(store, records){
			if(store.totalLength > 0 && records.length == 0)
			{
				$grid.getBottomToolbar().moveLast();
			}
	});
	//20170223 Tanis: END
	
}");


$countGrid->setTitle('Appointments count');
$countGrid->setMainTable($tableName,DB_WARPIT_WEBCATI_BASE);
$countGrid->setReqUrl('webcati/_ajax/telNumberManagment/ajax.appointmentMan.php');
$countGrid->baseParams = "countGrid : true";
$countGrid->setAutoLoad(false);
$countGrid->addColumn('date','Date');
//$countGrid->addColumn('count','All numbers');
$countGrid->addColumn('count','Available numbers');
//$countGrid->addColumn('countAvail','Available numbers');
$countGrid->setHeight(200)->region('south');

//20170104 Bojan Orter - We hidde and add order columns by saved state, before grid is rendered
$allColumns = getFieldsOrderHidden($db, $id_telname, $id_user, $user_type, $projectId);
$gridColumns = $grid->getColumns();

$newOrder = Array();
foreach($allColumns as $column)
{
	if(array_key_exists($column["name"], $gridColumns))
	{
		$gridColumn = $gridColumns[$column["name"]];
		if(is_object($gridColumn))
		{
			$gridColumn->hidden($column["hidden"]);
			$gridColumn->setProperty("orderHiddenID", $column["id"]);
			$gridColumn->setProperty("realOrderBy", $column["orderBy"]);
		}
		$newOrder[$column["name"]] = $gridColumn;
	}
}
$grid->setColumns($newOrder);
//END Bojan Orter

echo $grid->createGrid();
echo $countGrid->createGrid();

//20170104 Bojan Orter - Method for hide and show columns (updating saved state)
echo "$grid.getColumnModel().on('hiddenchange', function(columnModel, colIndex, hidden){
	var id = columnModel.config[colIndex].orderHiddenID;
	$grid.RMconn.request({
		params:{action:'columnHide',id_field:id,hidden:hidden}
	});
});";

//20170104 Bojan Orter - Method for moving columns (updating saved state)
echo "$grid.getColumnModel().on('columnmoved',function(colModel,oldInd,newInd){
	var movedColumn = colModel.config[newInd];
	if(movedColumn.realOrderBy)
	{
		var oldIndex = movedColumn.realOrderBy;
		var newIndex = newInd;

		while(newIndex > 0)
		{
			newIndex--;
			var leftColumn = colModel.config[newIndex];
			if(leftColumn.realOrderBy)
			{
				newIndex = leftColumn.realOrderBy;
				break;
			}
		}
		$grid.RMconn.request({
			params:{action:'columnMove',projectId:$projectId, telbaseId:$id_telname,newInd:newIndex, oldInd:oldIndex},
			success: function(result)
			{
				result = JSON.parse(result.responseText);
				updatedOrderBy = result.updatedOrderBy;
				for(var i = 0; i < updatedOrderBy.length; i++)
				{
					var colIndex = colModel.getIndexById(updatedOrderBy[i].name);
					if(colIndex != -1)
					{
						colModel.config[colIndex].realOrderBy = updatedOrderBy[i].orderBy;
					}
				}
			}
		});
	}
});";

//20170104 Bojan Orter - We look if all fields are saved, if not we add missing fields
function getFieldsOrderHidden($db, $id_telname, $id_user, $user_type, $id_project)
{
	//CHECK if all fields exist
	$db->changeDatabase(DB_WARPIT_WEBCATI_BASE);
	$sqlAllFieldsCount = "SELECT name FROM _TelephoneTablesAddon WHERE id_telbaza = $id_telname AND is_leaf = 1 UNION SELECT name FROM _TelephoneTableSystemFields";
	if(!$res = $db->SQLexecute($sqlAllFieldsCount))
	{
		echo 	"alert(\"".$db->GetError()."\");";
		exit;
	}
	$totalFieldsNumber = $db->NumRows($res);

	$sqlSelectFields = "SELECT * FROM _TelephoneFieldOrder WHERE id_user = $id_user AND user_type = $user_type AND id_project = $id_project ORDER BY orderBy";
	if(!$res = $db->SQLexecute($sqlSelectFields))
	{
		echo 	"alert(\"".$db->GetError()."\");";
		exit;
	}
	$currentFieldsNumber = $db->NumRows($res);

	//if not all field exists add missing
	if($totalFieldsNumber != $currentFieldsNumber)
	{
		addMissingFields($db, $id_telname, $id_user, $user_type, $id_project);
		//after adding new fields we need to update retrived fields
		if(!$res = $db->SQLexecute($sqlSelectFields))
		{
			echo 	"alert(\"".$db->GetError()."\");";
			exit;
		}
	}
	while($row = $db->fetchAssoc($res)) $rowsOrderHidden[] = $row;

	return $rowsOrderHidden;
}

//20170104 Bojan Orter Method adds missing fields into table
function addMissingFields($db, $id_telname, $id_user, $user_type, $id_project)
{
	$db->changeDatabase(DB_WARPIT_WEBCATI_BASE);

	$sqlSetStartOrderBy = "SET @startOrderBy=(SELECT ifnull(MAX(`orderBy`), 0) FROM _TelephoneFieldOrder WHERE `id_user` = $id_user AND user_type = $user_type AND id_project = $id_project);";
	$sqlAddMissingFields = " INSERT IGNORE INTO _TelephoneFieldOrder (`name`,`id_user`,`user_type`,`id_project`, `orderBy`,`hidden`) ";
	$sqlInsertSelect = " SELECT name, $id_user as id_user, $user_type as user_type, $id_project as id_project,  @startOrderBy := @startOrderBy + 1 as `orderBy`, 0 as hidden FROM _TelephoneTableSystemFields";
	$sqlInsertSelect .= " UNION SELECT CONCAT('tel_', name), $id_user as id_user, $user_type as user_type, $id_project as id_project,  @startOrderBy := @startOrderBy + 1 as `orderBy`, 0 as hidden FROM _TelephoneTablesAddon WHERE id_telbaza = $id_telname AND is_leaf = 1";

	$sqlAddMissingFields .= $sqlInsertSelect;
	if(!$db->SQLexecute($sqlSetStartOrderBy))
	{
		echo 	"alert(\"".$db->GetError()."\");";
		exit;
	}
	if(!$db->SQLexecute($sqlAddMissingFields))
	{
		echo 	"alert(\"".$db->GetError()."\");";
		exit;
	}
}

echo "$grid.getStore().on('update',function(a,b,c){ if(c=='commit') $countGrid.getStore().reload(); });
mainTabPanel.add({
		id:'$tabId',
		title:'Calls scheduler - $projName',
		iconCls:'RMicon_Appointment',
		closable:true,
		layout:'border',
		items: [$grid,$countGrid]
}).show();";

?>
