<?php
include_once ('_dirinfo.php');
include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_class/class.Extjs_grid.php");
include_once (PATH_TO_ROOT . "_class/createQuestion/Question.php");

$tabId = $_POST['uniqueTabId'];
$projectId = $_POST['projectId'];
$projectName = $_POST['projectName'];
$reqUrl = "webcati/_ajax/recordingOverview/ajax.recordingOverview.php";

$db->ChangeDatabase(DB_WARPIT_WEBCATI);

//lets get all recording columns on project
$sql = "SELECT id, q_name as fieldName FROM $projectName WHERE tip_sql = 12";
$res = $db->SQLexecute($sql);
if($db->NumRows($res) == 0){
    echo "Ext.Msg.alert('Error','No questions of type recording on project!');
    removeSession('$tabId')";
    exit;
}

$recFields = [];
$fieldNames = [];
$fieldNamesWithQuotas = [];
while($row = $db->fetchAssoc($res)){
    $recFields[] = $row;
    $fieldNames[] = $row['fieldName'];
    $fieldNamesWithQuotas[] = "'" . $row['fieldName'] . "'";
}

$grid = new MakeGrid();
$gridName = $grid->getName();

$grid->setReqUrl($reqUrl);
$grid->setMainTable($projectName . "_structure", DB_WARPIT_WEBCATI_BASE);
$grid->setFiltering(true);
$grid->setPaging();
$grid->setSearchField('Search','top',0,"['id'," . implode(',', $fieldNamesWithQuotas) . "]");
$grid->addConfig('viewConfig', "{emptyText: 'No data'}");
$grid->baseParams = "projectName:'$projectName', projectId:$projectId, recFields : '" . implode(',', $fieldNames) . "'";

$grid->addColumn('id', 'ID')->width(60)->hidden(true);
$grid->addColumn('user_id', 'ID user')->width(60);
$grid->addColumn('user_type', 'Type user')->width(60);
$grid->addColumn('t_diffs', 'Full time')->width(60);
$grid->addColumn('username', 'User name');
$grid->addColumn('d_start', 'Start')->width(120);
$grid->addColumn('d_stop', 'Stop')->width(120);

$questionIds = $db->get($projectName, 'encrypt = 1','id', DB_WARPIT_WEBCATI);
foreach($questionIds as $questionId){
    $question = Question::createQuestionFromTable($db,$projectName,$questionId);
    foreach($question->getStructureFields() as $field){
        $grid->addColumn($field, $field);
    }
}
$columns = $db->get($projectName,"tip_sql IN (1,2,3,4) ORDER by q_pos",'q_name, tip_sql',DB_WARPIT_WEBCATI);
foreach ($columns as $column) {
    $columnName = $column["q_name"];
    $grid->addColumn($columnName, $columnName)->type('int')->width(50);

    if($column["tip_sql"] == 2){
        $grid->addColumn("{$columnName}_details", "{$columnName} Details")->width(100);
    }
}

foreach ($recFields as $recField) {
    $grid->addColumn($recField['fieldName'], $recField['fieldName'])
    ->setProperty('xtype', "'actioncolumn'")
    ->setProperty('align', "'center'")
    ->setProperty('menuDisabled', 'true')
    ->setProperty('items', "[{
        icon   : '_img/play_16.gif',
        tooltip: 'Download',
        handler: function(grid, rowIndex, colIndex) {
            var store = grid.getStore();
            var record = store.getAt(rowIndex);

            var colModel = grid.getColumnModel();
            var col = colModel.getColumnId(colIndex);

            if(record.get(col) == 0){
               Ext.Msg.alert('Error','Sound file does not exist!');
               return;
            }

            $gridName.RMconn.request({
                params:{
                    action: 'download',
                    projectName: '$projectName',
                    field  : col,
                    structureId: record.get('id'),
                },
                success:function(resp){
                    var result = JSON.parse(resp.responseText);
                    var audioHtml = '<audio controls src=\"data:audio/aac;base64,' + result.recording + '\" />';

                    var winPlaySound = new Ext.Window({
                		title: 'Play recording',
                		width:315,
                		height:65,
                		modal: true,
                		items: [{
                			xtype: 'panel',
                			border: false,
                			html: audioHtml
                		}],
                        listeners:{
                            close : function(){
                                //we stop playing audio files on close
                                $.each($('audio'), function () {
                                    $(this).trigger('stop');
                                });
                            },
                            show : function(){
                                //we start play audio file when we open window
                                $.each($('audio'), function () {
                                    $(this).trigger('play');
                                });
                            }
                        }
                	}).show();
                }
            });
        },
        getClass: function(value, meta, record, rowIndex, colIndex) {
            var colModel = $gridName.getColumnModel();
            var col = colModel.getColumnId(colIndex);

            if(record.get(col) == 0) {
                return 'deleteMultiAppointments';
            }
        }
    }]");
}

$grid->addExportButton("Export");

echo $grid->createGrid();
echo "mainTabPanel.add({
		id:'$tabId',
		title:'Listen to Interviews - $projectName',
		iconCls:'RMicon_rec',
		closable:true,
		layout:'fit',
		items: [$gridName]
}).show();";
?>
