<?php

abstract class Parser
{
    protected $enabled = true;

    protected abstract function parse();

    protected abstract function checkData($row);

    public function disable()
    {
        $this->enabled = false;
    }

    public function enable()
    {
        $this->enabled = true;
    }

}


class InterviwerParser extends Parser
{
  private $explodedLine = null;

  public static $hasBeenUsed = false;

  public function __construct()
  {
      $this->disable();
  }

  private function isHeader()
  {
     return $this->explodedLine[0] == "ID_interviewer";
  }

  public function parse()
  {
    if($this->isHeader()) return false;

    return array('id_user' => $this->explodedLine[0], 'total' => $this->explodedLine[1]);
  }

  public function checkData($row)
  {
    $this->explodedLine = explode(";", $row);
    if($this->isHeader() || $this->enabled)
    {
      $this->enable();
      InterviwerParser::$hasBeenUsed = true;
      return true;
    }

    return false;
  }

}

class RegionParser extends Parser
{
  private $explodedLine = null;

  private $headers = null;

  private function isHeader()
  {
     return strpos($this->explodedLine[0], 'region') !== false;
  }

  public function parse()
  {
      if($this->isHeader())
      {
          $this->headers = $this->explodedLine;
          return false;
      }

      $mi = new MultipleIterator();
      $mi->attachIterator(new ArrayIterator($this->explodedLine));
      $mi->attachIterator(new ArrayIterator($this->headers));

      $rtnArray = array();
      foreach ($mi as $item)
      {
          $rtnArray[] = $item;
      }

      return $rtnArray;
  }

  public function checkData($row)
  {
      $this->explodedLine = explode(";;", $row);
      if($this->isHeader() || $this->enabled)
      {
        $this->enable();
        return true;
      }

      return false;
  }
}

class QuotaFileParser implements Iterator
{
    private $file;

    private $headers;

    private $currentRow = NULL;

    private $parsersList = array();

    public function __construct($filename)
    {
        $this->file = fopen($filename, 'r');

        $this->parsersList[] = new InterviwerParser();
        $this->parsersList[] = new RegionParser();
    }

    public function notify($currentParser)
    {
        foreach($this->parsersList as $parser)
        {
            if($parser != $currentParser)
              $parser->disable();
        }
    }

    public function rewind()
    {
        $this->rowCounter = 0;
        rewind($this->file);
        //we skip first row because it is header
    }

    public function current()
    {
      $row = array_map('trim', (array)fgetcsv($this->file));
      $this->rowCounter++;

      if(strlen($row[0]))
      {
        foreach($this->parsersList as $parser)
        {
            if($parser->checkData($row[0]))
            {
               $this->notify($parser);
               $this->currentRow = $parser->parse();

               if(!$this->currentRow) $this->currentRow = $this->current();
            }
        }
      }

      return $this->currentRow;
    }

    public function key()
    {
        return $this->rowCounter;
    }

    public function next()
    {
        return !feof($this->file);
    }

    public function valid()
    {
        if(!$this->next())
        {
          fclose($this->file);
          return false;
        }

        return true;
    }
}

/*class QuotaFileParser
{
    private $file;

    private $headers;

    public function __construct($filename)
    {
        $this->file = fopen($filename, 'r');
    }

    private function explodeLine($row)
    {
        $line = explode(";;", $row);

        $mi = new MultipleIterator();
        $mi->attachIterator(new ArrayIterator($line));
        $mi->attachIterator(new ArrayIterator($this->headers));

        $rtnArray = array();
        foreach ($mi as $item)
        {
            $rtnArray[] = $item;
        }

        return $rtnArray;

    }

    public function parse()
    {
        $headers = array_map('trim', fgetcsv($this->file));
        $this->headers = explode(";;", $headers[0]);

        while (!feof($this->file)) {
            $row = array_map('trim', (array)fgetcsv($this->file));
            $row = $this->explodeLine($row[0]);
        //    $row = array_combine($headers, $row);
            yield $row;
        }
        return;
    }
}
*/


/*
class ParserMode
{
  		const PARSE_INTERVIEWER = 1;

  		const PARSE_REGION = 2;

}

class ParserState
{
    private static $parserType = ParserMode::PARSE_REGION;

    public static function setParserType($parserType)
    {
        ParserState::$parserType = $parserType;
    }

    public static function getParserType()
    {
        return ParserState::$parserType;
    }

}

class QuotaFileParser implements Iterator
{
    private $file;

    private $headers;

    private $rowCounter = 0;

    private $currentRow = NULL;

    private $mode = ParserMode::PARSE_INTERVIEWER;

    public function __construct($filename)
    {
        $this->file = fopen($filename, 'r');
    }

    private function explodeRegionLine($row)
    {
        $line = explode(";;", $row);

        $mi = new MultipleIterator();
        $mi->attachIterator(new ArrayIterator($line));
        $mi->attachIterator(new ArrayIterator($this->headers));

        $rtnArray = array();
        foreach ($mi as $item)
        {
            $rtnArray[] = $item;
        }

        return $rtnArray;

    }

    private function explodeInterviewerLine($row)
    {
        $interviwer = explode(";", $row);
        return array('id_user' => $interviwer[0], 'total' => $interviwer[1]);
    }

    public function rewind()
    {
        $this->rowCounter = 0;
        rewind($this->file);
        //we skip first row because it is header
        $this->current(true);
    }

    public function setHeaders($headers)
    {
        $this->headers = $headers;
    }

    public static function getMode()
    {
        return QuotaFileParser::$mode;
    }

    public static function setMode($mode)
    {
        QuotaFileParser::$mode = $mode;
    }

    public function current($headers = false)
    {
      $row = array_map('trim', (array)fgetcsv($this->file));
      $this->rowCounter++;
      if($headers)
      {
          $this->currentRow = $row;
          $tmp = explode(";", $row[0]);
          if($tmp[0] == "ID_interviewer")
              QuotaFileParser::setMode(ParserMode::PARSE_INTERVIEWER);
          else
          {
            QuotaFileParser::setMode(ParserMode::PARSE_REGION);
            $this->setHeaders($tmp);
          }
          return $row;
      }

      if(strlen($row[0]) <= 0 && QuotaFileParser::getMode() == ParserMode::PARSE_INTERVIEWER)
      {

          QuotaFileParser::setMode(ParserMode::PARSE_REGION);
          $headers = $this->current(true);
          $this->setHeaders(explode(";;", $headers[0]));

          return $this->current();
      }

      if(QuotaFileParser::getMode() == ParserMode::PARSE_REGION)
      {
          $row = $this->explodeRegionLine($row[0]);
      }
      else
      {
          $row = $this->explodeInterviewerLine($row[0]);
      }

      $this->currentRow = $row;
      return $this->currentRow;
    }

    public function key()
    {
        return $this->rowCounter;
    }

    public function next()
    {
        return !feof($this->file);
    }

    public function valid()
    {
        if(!$this->next())
        {
          fclose($this->file);
          return false;
        }

        return true;
    }
}*/
