<?php
class EmailAppointment
{
  private $db;

  private $loginSID;

  private $id_loginSID;

  private $id_structure;

  private $id_user;

  private $id_project;

  private $projName;

  private $email;

  private $appointments_group;

  private $appointments_template;

  public static function sendAppointmentOnEmail($email, $id_structure, $id_project = NULL, $projName = NULL)
  {
      global $db;

      if($id_project && $projName)
      {
        $sendAppointment = new EmailAppointment($db,$id_structure, $id_project, $projName);
      }
      else
      {
        $sendAppointment = new EmailAppointment($db,$id_structure, $_SESSION['id_project'], $_SESSION['proj_name']);
      }
      $sendAppointment
        ->addEmail($email)
        ->copyExistingData()
        ->sendEmail()
        ->closeCatiAppointment();

  }

  private function __construct($db,$id_structure, $id_project, $projName)
  {
      $this->db = $db;
      $this->id_structure = $id_structure;
      $this->id_project = $id_project;
      $this->projName = $projName;

      $this->loadSettings();

  }

  private function loadSettings()
  {
      $sql = "SELECT email_app_group,email_app_template FROM " . DB_WARPIT_WEBCATI . "." . $this->projName . " WHERE tip_sql = 9 LIMIT 1";
      $res = $this->db->SQLexecute($sql);
      $zad = $this->db->fetchAssoc($res);

      $PoolConfig = configLoader::loadConfig('webuserspool');

      if($zad['email_app_group']) $this->appointments_group = $zad['email_app_group'];
      else $this->appointments_group = $PoolConfig['appointments_group'];

      if($zad['email_app_template'])  $this->appointments_template = $zad['email_app_template'];
      else $this->appointments_template = $PoolConfig['appointments_template'];

  }

  private function prepareCatiLinks()
  {

    $sql = " SELECT id,loginSID FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids
            WHERE
                id_user 	= ".$this->id_user."
              AND user_type 	= 2
              AND	id_project 	= ".$this->id_project;
    //echo $sql;
    $res = $this->db->SQLexecute($sql);
    if ($this->db->NumRows($res)) {

      $zad = $this->db->fetchAssoc($res);

      $this->id_loginSID = $zad['id'];
      $this->loginSID = $zad['loginSID'];

    } else {
      $catiLink = substr(md5(time().$this->id_user.$this->id_project),0,15)."-";
      $sql = "INSERT INTO ".DB_WARPIT_WEBCATI_BASE."._www_ids
          SET id_user 	= ".$this->id_user.",
            user_type 	= 2,
            id_project 	= ".$this->id_project.",
            id_site		= 0,
            loginSID 	= '". $catiLink."'";
      $this->db->SQLexecute($sql);
      $lastId =  $this->db->GetLastInsertId();
      $sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE."._www_ids
            SET loginSID = CONCAT(loginSID,id) WHERE id = ".$lastId;
      $this->db->SQLexecute($sql);
      $catiLink .= $lastId;

      $this->loginSID = $catiLink;
      $this->id_loginSID = $lastId;
    }
    return $this;
  }

  public function deleteOldData($id_structure)
  {
      $sql = "DELETE  FROM " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics WHERE id_structure = " . $id_structure;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "DELETE  FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structure WHERE id = " . $id_structure;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "DELETE  FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog WHERE id_structure = " . $id_structure;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());
  }

  public function copyExistingData()
  {
    /*    //If we create appointment after dailer screen there is no data yet so we don't need to copy it
      */
    $existingIdStructure = $this->db->get("_www_interviewer_statistics","user_type = 2 AND id_user =" . $this->id_user, "id_structure", DB_WARPIT_WEBCATI_BASE);
    if($existingIdStructure)
    {
        $this->deleteOldData($existingIdStructure[0]);
    }

    //if there is appointment make from status screen there is no data for this project so we don't need to copy it. To know where appointment was made from we
	  // check how many records we already have in ___EngineLog table. If there are only 3 (dailer, status and appointment) that means that there is no data yet.
	  // Also if there is no data if we don't have id_structure.
      $sql = "SELECT q_name FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog WHERE id_structure = " . $this->id_structure;
      $res = $this->db->SQLexecute($sql);
      if(!$this->id_structure || $this->db->NumRows($res) <= 3)
      {
          return $this;
      }

      //Copy table and change some fields wihout writing list of the fields -> http://stackoverflow.com/a/15344327
      //1. Create new record in _www_ids table or return existing one
      $this->prepareCatiLinks();

      //2 Copy structure table
      $sql = "DROP TEMPORARY TABLE IF EXISTS " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structur_tmp";
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "CREATE TEMPORARY TABLE " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structure_tmp AS ";
      $sql .= "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structure WHERE id = " . $this->id_structure;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structure_tmp
              SET user_id = " . $this->id_user . ",
              user_type = 2,
              id = NULL,
              status = NULL,
              status_rec = NULL,
              flag_bad = 99,
              d_status = NULL,
              id_loginSID = " . $this->id_loginSID;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structure SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "_structure_tmp";
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $newIdStructre = $this->db->GetLastInsertId();

      //3. Copy data in _www_interviver_statistic table
      $sql = "DROP TEMPORARY TABLE IF EXISTS " . DB_WARPIT_WEBCATI_BASE . ". _www_interviewer_statistics_tmp";
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "CREATE TEMPORARY TABLE " . DB_WARPIT_WEBCATI_BASE ."._www_interviewer_statistics_tmp AS ";
      $sql .= "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics WHERE id_structure = " . $this->id_structure . " AND id_project = " . $this->id_project;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics_tmp
              SET id_user = " . $this->id_user . ",
              user_type = 2,
              endDate = DEFAULT,
              qStatus = 99,
              id = NULL,
              id_structure = " . $newIdStructre . ",
              id_loginSID = " . $this->id_loginSID;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_statistics_tmp";
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      //4. Copy data in ___EngineLog table
      $sql = "DROP TEMPORARY TABLE IF EXISTS " . DB_WARPIT_WEBCATI_BASE. "." . $this->projName . "___EngineLog_tmp";
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "CREATE TEMPORARY TABLE " . DB_WARPIT_WEBCATI_BASE . ".". $this->projName . "___EngineLog_tmp AS ";
      $sql .= "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . ". " . $this->projName . "___EngineLog WHERE q_name NOT IN ('tStatus', 'appointment', 'dialer') AND id_structure = " . $this->id_structure;

      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . ". " . $this->projName . "___EngineLog_tmp
              SET id_user = " . $this->id_user . ",
              user_type = 2,
              id = NULL,
              id_structure = " . $newIdStructre;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog_tmp";
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._www_interviewer_session SET id_loginSID = " . $this->id_loginSID;
      if(!$this->db->SQLexecute($sql)) die($this->db->JsonError());

      //print "neverland:8080/warpit/survey/index.php?loginSID=" . $this->loginSID;
      return $this;
  }

  public function sendEmail()
  {
/*    print "appointments_group: ";
    var_dump($this->appointments_group);
    print "<br>appointments_template:";
    var_dump($this->appointments_template);
*/
  //$url =  "neverland/warpit/webuserspool/_ajax/ajax.showgroup.php?nfield=1";
    $url =  WARPIT_WWW . "/webuserspool/_ajax/ajax.showgroup.php?nfield=1";
    $fields = array(
                'action'=>"sendMail",
                'emails'=>'["' .  $this->email  . '"]',
                'id_group'=> $this->appointments_group,
                'id_project'=> $this->id_project,
                'id_status'=> "1",
                'ids'=> '["' . $this->id_user . '"]',
                'immideately'=> true,
                'project_type'=> 1,
                'templateId'=> $this->appointments_template,
                'schTime' => "0000-00-00 00:00:00"
            );
  /*  $session_name = session_name();
    $session_id = session_id();

    *///open connection

    $ch = curl_init();
    //set the url, number of POST vars, POST data
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
    curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);


    //execute post
    $result = curl_exec($ch);
    /*print "curl response: ";
    var_dump($result);
    exit;*/
    //close connection
    curl_close($ch);
    $resultObject = json_decode($result);
    $url = WARPIT_WWW . '/webuserspool/_ajax/ajax.sendMail.php';
    $fields = array(
                'mailSet'=>urlencode($resultObject->set),
                'appID'=>urlencode("SoulskinerHardCodedAndVerySecure"),
                'appointmentEmail'=>urlencode("1"),
                'mailStatus'=>urlencode("1")
            );
    $ch = curl_init();

    //set the url, number of POST vars, POST data
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
    curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);


    //execute post
    $result = curl_exec($ch);

    //close connection
    curl_close($ch);
    return $this;

  }

  private function addEmail($email)
  {
      $email = trim($email);
      $id_user = $this->db->get("_Interviewer","email LIKE '" . $email . "'","id", DB_WARPIT_USERSPOOL);

      if(!$id_user)
      {
          $sql = "INSERT INTO " . DB_WARPIT_USERSPOOL . "._Interviewer SET email='" . $email . "'";
          $this->db->SQLexecute($sql);

          $id_user = $this->db->GetLastInsertId();
      }
      if(is_array($id_user))
          $id_user = $id_user[0];

      $sql = "INSERT IGNORE INTO " . DB_WARPIT_USERSPOOL . "._group_link SET id_group = " . $this->appointments_group . ", id = " . $id_user;
      $this->db->SQLexecute($sql);

      $this->id_user = $id_user;
      $this->email = $email;



      return $this;
  }

  private function closeCatiAppointment()
  {
      $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog WHERE id_structure = " . $this->id_structure . " AND q_name != 'gotoIdle' ORDER BY id DESC LIMIT 1";

      if(!($res =$this->db->SQLexecute($sql))) die($this->db->JsonError());
    //  $res = $this->db->SQLexecute($sql);
      $row = $this->db->fetchAssoc($res);
      $row['q_name'] = "emailAppointment";
      $row['id'] = "NULL";
      $tmpSql = array();
      foreach ($row as $key => $value)
      {
          $tmpSql[] = $key . "='" . $value ."'";
      }

      $insert = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->projName . "___EngineLog SET " . implode(",",$tmpSql);
      //print $insert; exit;
      $this->db->SQLexecute($insert);

      $_SESSION['finalStatus'] = 93;

  }
}
