<?php

class Recording
{
    public function __construct($db)
    {
        $this->db = $db;
    }

    public function getQuestionPosition($qName, $tableName)
    {
		$sql = "SELECT q_pos FROM " . DB_WARPIT_WEBCATI . "." . $tableName;
        $sql .= " WHERE q_name = '" . $qName . "' LIMIT 1";

		$res = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($res);
        return $row['q_pos'];
    }

    public function getQuestionsInterval($startPos, $endPos, $tableName)
    {
        $sql = "SELECT q_pos, q_name FROM " . DB_WARPIT_WEBCATI . ". ". $tableName ." WHERE q_pos BETWEEN " . $startPos . " and " . $endPos . " ORDER BY q_pos ASC";
        $res = $this->db->SQLexecute($sql);

        $questionNames = [];
        while($row = $this->db->fetchAssoc($res)){
            $questionNames[$row['q_pos']] = $row['q_name'];
        }

        return $questionNames;
    }

    public function getRecQuestion($recQuestionId, $tableName)
    {
        $sql = "SELECT q_name, rec_interval FROM " . DB_WARPIT_WEBCATI . "." . $tableName;
        $sql .= " WHERE id = " . $recQuestionId . " LIMIT 1";

        $res = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($res);
        return [$row['q_name'], $row['rec_interval']];
    }

    public function updateRecQuestionId($recQuestionId, $questions, $tableName)
    {
         $sql = "UPDATE " . DB_WARPIT_WEBCATI . "." . $tableName . " SET rec_question_id =" . $recQuestionId;
         $sql .= " WHERE q_name IN(" . implode(',', array_map([$this, 'addQuotes'], $questions)) . ")";

         $this->db->SQLexecute($sql);
    }

    public function updateRecInterval($recInterval, $recQuestionId, $tableName)
    {
        $sql = "UPDATE " . DB_WARPIT_WEBCATI . "." . $tableName . " SET rec_interval ='" . $recInterval;
        $sql .= "' WHERE id = " . $recQuestionId;

        $this->db->SQLexecute($sql);
    }

    public function addQuotes($str)
    {
        return sprintf("'%s'", $str);
    }

    public function removeRecoridngInterval($recQuestionId, $tableName)
    {
        $sql = "UPDATE " . DB_WARPIT_WEBCATI . "." . $tableName;
        $sql .= " SET rec_interval = NULL ";
        $sql .= " WHERE id = " . $recQuestionId;

        $this->db->SQLexecute($sql);
    }

    public function removeRecordingId($recQuestionId, $tableName)
    {
        $sql = "UPDATE " . DB_WARPIT_WEBCATI . "." . $tableName;
        $sql .= " SET rec_question_id = NULL ";
        $sql .= " WHERE rec_question_id = " . $recQuestionId;

        $this->db->SQLexecute($sql);
    }

    public function getRandomRecordingPosition($recQuestionId, $tableName)
    {
        list($recName, $recInterval) = $this->getRecQuestion($recQuestionId, $tableName);
        list($startQuestion, $endQuestion) = explode(':', $recInterval);

        $startPos = $this->getQuestionPosition($startQuestion, $tableName);
        $endPos   = $this->getQuestionPosition($endQuestion, $tableName);

        $questionArray = $this->getQuestionsInterval($startPos, $endPos, $tableName);

        return array_rand($questionArray);
    }

    public function getRecFieldName($recQuestionId, $tableName)
    {
        $recQuestion = $this->getRecQuestion($recQuestionId, $tableName);
        return $recQuestion[0];
    }
}
