<?php 

class Inbound
{

	private $db;
	private $telNumber;
	public $oms;
	public $telephone;
	
	private $ndc = array(
					4=>array(8228,8180,6910,8227,8181,8281,8280,8189,8288),
					3=>array(596,592,833,816,651,593,590,820,817,599,598,591,838,597),
					2=>array(30,68,40,64,51,49,41,31,70), 
					1=>array(1,2,3,4,5,7)
			);
	
	
	public function __construct($db) {
		$this->db = $db;
	}

	
	public function prepareNumber($tel) {
		$this->telNumber = $tel; // original telephone from Asterisk
		$this->fileLog("telephone: ".$tel,true,"number");
		
		$inbound_telNumber = intval($tel);
		$this->fileLog("telephone: ".$inbound_telNumber,true,"number (removed leading zeros)");
		
		foreach($this->ndc as $key=>$item) {
			$this->fileLog($key."=>".$item,true,"check for oms...");
			$tmpOms = substr($inbound_telNumber,0,$key);
			$tmpTel = substr($inbound_telNumber,$key);
			
			if (in_array($tmpOms,$this->ndc[$key]) == true) {
				// I have dial prefix
				$this->oms = $tmpOms;
				$this->telephone = $tmpTel;
				$this->fileLog("oms: ".$this->oms."\r\ntelephone: ".$this->telephone,true,"parsed telephone - FOUND");
				
				return true;
			}
		}

		// if I could not locate prefix, I take first numebr as prefix
		$this->oms = substr($inbound_telNumber,0,1);
		$this->telephone = substr($inbound_telNumber,1);
		
		$this->fileLog("oms: ".$this->oms."\r\ntelephone: ".$this->telephone,true,"parsed telephone NOT FOUND");
		
		return true;
	}
	
	
	public function checkOutCalls($telData) {
		$sql = "";
		
	}
	
	public function getFromMainTelephone() {
		$sql = "SELECT * FROM ".DB_WARPIT_WEBCATI_BASE.".`".MAIN_TEL_TABLE."` WHERE CONCAT( oms, telephone ) = ".$this->telNumber;
		$this->fileLog($sql,true,"getFromMainTelephone()");
		$rs = $this->db->SQLexecute($sql);
		
		if ($this->db->NumRows($rs) > 0) {
			$row = $this->db->fetchArray($rs);
			$this->fileLog("return array of data for tel number",true,"getFromMainTelephone()");
			return $row;
		} else {
			$this->fileLog("return false, no records",true,"getFromMainTelephone()");
			return false;
		}
	}
	
	
	public function checkInbound() {
		$sql = "SELECT id FROM ".DB_WARPIT_WEBCATI_BASE.".`".OUTBOUND_TEL_TABLE."` WHERE CONCAT( oms, telephone ) = ".$this->telNumber;
		$this->fileLog($sql,true,"checkInbound()");
		if(!$rs = $this->db->SQLexecute($sql)) {
			$this->fileLog("return false SQL",true,"checkInbound()");
			return false;
		}
		if ($this->db->NumRows($rs) > 0) {
			$row = $this->db->fetchArray($rs);
			$this->fileLog("return true with id=".$row['id'],true,"checkInbound()");
			return $row['id'];
		} else {
			$this->fileLog("return false, no rows",true,"checkInbound()");
			return false;
		}
	}
	
	/**
	 * set the time zone and return the date
	 *
	 * @return date in the "H:i:s:u [j.n.Y]" format
	 */
	protected function GetTime() {
		return date("H:i:s:u [j.n.Y]");
	}

	/**
	 * Write debug info to a log file
	 *
	 * @param string $strLog
	 */
	public function fileLog($strLog,$execute=null,$title=null) {
		if (!$execute) return true;
		//return true;
		
		if ($title) $title = " - ".$title;
		$strLog = $this->GetTime().$title." - ".$strLog."\r\n";
	
		if (file_put_contents("/tmp/inbound.txt", $strLog, FILE_APPEND | LOCK_EX)) {
			return true;
		} else {
			return false;
		}
	}
	
	
}

?>