<?php
include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.gridData.php");

class telStatManipulator extends GridDataManipulator
{
	public function selectAction()
	{
        $projectName = $_POST["projectName"];
		$startSelect = $_POST["start"];
		$endSelect = $_POST["limit"];
		$whereFilter = $_POST["filter"];
		$orderBy = $_POST["sort"];
		$orderType = $_POST["dir"];

		$columns = $this->db->get($projectName,"tip_sql IN (1,2,3,4) ORDER BY q_pos",'q_name, tip_sql',DB_WARPIT_WEBCATI);

		$this->arr = $this->engineData($projectName,$columns,$startSelect,$endSelect,$whereFilter,$orderBy,$orderType);

		return json_encode(["success" => true, "results" => count($this->arr), "rows" => $this->arr]);
	}

	private function engineData($projectName,$columns,$startSelect,$endSelect,$whereFilter,$orderBy,$orderType) {
		$sql = "SELECT a.id_user,a.user_type,b.d_start,b.d_stop,b.status,b.status_rec,b.t_diffs,sum(`questEnd`-`questStart`) as tDiff,`id_structure`, `id_question`,`q_name`,`eventLogger`
				FROM ".DB_WARPIT_WEBCATI_BASE.".`".$projectName."___EngineLog` a
				LEFT JOIN ".DB_WARPIT_WEBCATI_BASE.".`".$projectName."_structure` b
				ON a.id_structure = b.id
				WHERE `questStart`>0 AND `questEnd`>0
				GROUP BY `id_structure`,`q_name`";
		//echo "$sql<br>";
		if (!$this->rs = $this->db->SQLexecute( $sql )) {
			return false;
		}
		while($row = $this->db->fetchAssoc($this->rs)){
			$records[$row['id_structure']]['time'][$row['q_name']] = $row['tDiff'];
			$records[$row['id_structure']]['eventLog'][$row['q_name']] = $row['eventLogger'];
			$records[$row['id_structure']]['id_user'] = $row['id_user'];
			$records[$row['id_structure']]['type_user'] = $row['user_type'];
			$records[$row['id_structure']]['d_start'] = $row['d_start'];
			$records[$row['id_structure']]['d_stop'] = $row['d_stop'];
			$records[$row['id_structure']]['status'] = $row['status'];
			$records[$row['id_structure']]['status_rec'] = $row['status_rec'];
			$records[$row['id_structure']]['t_diffs'] = $row['t_diffs'];
		}

		$arr = [];
		foreach($records as $id_structure=>$arrRecord) {
            $row = array();
            $row["id"] = $id_structure;
			$row["id_user"] = $arrRecord['id_user'];
			$row["type_user"] = $arrRecord['type_user'];
			$row["d_start"] = $arrRecord['d_start'];
			$row["d_stop"] = $arrRecord['d_stop'];
			$row["status"] = $arrRecord['status'];
			$row["status_rec"] = $arrRecord['status_rec'];
			$row["t_diffs"] = $arrRecord['t_diffs'];
            foreach ($columns as $column) {
				$columnName = $column["q_name"];
				$row[$columnName] = $arrRecord['time'][$columnName];
				if(isset($arrRecord['time'][$columnName]) AND $column["tip_sql"] == 2){
					$logArr = json_decode($arrRecord['eventLog'][$columnName], true);
					$tmpTime = $logArr[0]['ClientTime'];
					foreach($logArr as $keyLog => $log) {
						if ($keyLog > 0) {
							$itemName[$log['objName']] += $log['clickTimeClient'] - $tmpTime;
							$tmpTime = $log['clickTimeClient'];
						}
					}
					$allItems = array();
					foreach($itemName as $keyVar => $itemTime) {
						$keyVar = str_replace("answers[","",$keyVar);
						$keyVar = str_replace("]","",$keyVar);
						$allItems[] = $keyVar.":".$itemTime;
					}
            		$row["{$columnName}_details"] = implode(";",$allItems);
            	}

			}
			$arr[] = $row;
		}

		return $arr;
	}

}



$db->ChangeDatabase($_POST['database']);
$tableName = $_POST['RMtable'];

$manipulator = new telStatManipulator($db,$_POST['RMtable']);
$manipulator->telIndexTable = $tableName.'___telIndex';
$comm = $_REQUEST['action'].'Action';
if(method_exists($manipulator,$comm))
	echo $manipulator->$comm();
else
{
	echo '{success:false,error:"Unknown action!"}';
}
