<?php

/**
 * creates zip file; file names are taken from database, depending on given version
 *
 */
class CreateZip {
	var $version;
	var $connection;
	var $iserror;
	var $errorMess;

/**
 * set main parameters
 *
 * @param integer $ver version of generated zipfile
 * @param db $con connection to database, where file paths are saved
 */
	function __construct($ver, $con) {
		$this->version = $ver;
		$this->connection = $con;
		$this->iserror = 0;
		$this->errorMess = "";
	}

	/**
	 * creates zip from file paths given from database
	 *
	 */
	function create() {
		$version = $this->version;
		$srv_db = $this->connection;
        if (class_exists('ZipArchive')) {//check if ZIP class is installed
		$zip = new ZipArchive ( );
		//if zip exists, it will be overwritten
	//		echo  "version_$version.zip";
		//define('WARPIT_LIVEUPDATE_ZIPVERSION', '/_liveUpdateFiles/');

		if ($zip->open ( (WARPIT_LIVEUPDATE_ZIPVERSION . "version_$version.zip"), ZIPARCHIVE::CREATE )) {
			$res = $srv_db->SQLexecute ( "SELECT * FROM _LiveUpdateFiles WHERE version=$version" );
			while ( $vrstica = $srv_db->fetchAssoc ( $res ) ) { //get file names and paths from database, where version == $version
				if ($srv_db->IsError ()) {
					$this->errorMess = $srv_db->GetError ();
					return;
				}
				if ($vrstica ["file_type"] == 1) {
                    $file_to_zip = WARPIT_ABSOLUTE;
					//$path_in_zip = str_replace ( "/var/www/", "", WARPIT_ABSOLUTE ); //remove '/var/www/', to avoid creating this dir in zip file
					$path_in_zip = "Warpit/";
				} elseif ($vrstica ["file_type"] == 2) {
					$file_to_zip = WARPIT_WEBPROJECTS;
					//$path_in_zip = str_replace ( "/var/www/", "", WARPIT_WEBPROJECTS ); //remove '/var/www/', to avoid creating this dir in zip file
					$path_in_zip = "WebProjects/";
				}

				$xmlLog[] = "<file><type>".$vrstica ["file_type"]."</type><directory>".$vrstica ["relative_path"]."</directory><filename>".$vrstica ["file_name"]."</filename></file>";

				$path_in_zip .= $vrstica ["relative_path"] . $vrstica ["file_name"]; //set path, which will be generated in zip file
				$file_to_zip .= $vrstica ["relative_path"] . $vrstica ["file_name"]; //real path to file
				$path_parts = pathinfo ( $path_in_zip ); //path in zip is divided in array, from where we can get special parts
				$zip->addEmptyDir ( $path_parts ["dirname"] );
				if (! $zip->addFile ( $file_to_zip, $path_in_zip )) {
					$this->iserror = 1;
					$this->errorMess = 'Could not add file to zip!';
					if (! file_exists ( $file_to_zip )) {
						$this->errorMess = 'File to add to zip, does not exist!';
					}
					return;
				}
			}



			if ($this->SQLgeneratedFiles) {
				$path_in_zip = "SQL_files/";

				foreach ($this->SQLgeneratedFiles as $database=>$sqlFiles) {
					$path_parts = pathinfo ( $path_in_zip.$sqlFiles);
					$zip->addEmptyDir ( $path_parts ["dirname"] );
					$zip->addFile ( WARPIT_LIVEUPDATE_ZIPVERSION."/tmp/".$sqlFiles, $path_in_zip.$sqlFiles );

					$xmlLog[] = "<file><type>3</type><database>".$database."</database><filename>".$sqlFiles."</filename></file>";

				}
			}

			if ($xmlLog)  $zip->addFromString('file-action.xml', '<xml>'.implode(" ",$xmlLog).'</xml>');

		}

		else {
			$this->iserror = 1;
			$this->errorMess = 'Could not create the zip archive.';
		}
		$zip->close ();
		}
		else {
			$this->iserror = 1;
			$this->errorMess = "No ZipArchive class installed.";
		}
	}

	function IsError() {
		return $this->iserror;
	}
	function GetError() {
		return $this->errorMess;
	}
}
?>
