<?php
include_once ("_dirinfo.php");

include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.gridData.php");
include_once (PATH_TO_ROOT."_class/createQuestion/Question.php");


class AnonymizationManipulator extends GridDataManipulator
{
    protected  $db;

	public function selectAction()
	{
        $projectId = intval($_POST['projectId']);
        $projectName = getProjectName($projectId);

        $sql = '';
        $telephoneTableId = getTelephoneTableId($projectId);

        $rows = [];
        if($telephoneTableId !== null){
            $sql =  "(SELECT a.name, b.id IS NOT NULL as anoymize, 2 as fieldType
                    FROM " . DB_WARPIT_WEBCATI_BASE . "._TelephoneTableSystemFields as a
                    LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._TelephoneAnonymization b
                    ON a.id = b.field_id AND b.field_type = 1 AND b.telephone_table_id = " . $telephoneTableId . "
                    LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._TelephoneTblDefaultVar c
                    ON a.name = c.name
                    WHERE c.use_in_index = 1
                    )
                UNION ALL
                    (SELECT a.name, b.id IS NOT NULL as anoymize, 1 as fieldType FROM " . DB_WARPIT_WEBCATI_BASE . "._TelephoneTablesAddon a
                    LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._TelephoneAnonymization b
                    ON a.id_telbaza = b.telephone_table_id 
                    AND a.id = b.field_id
                    AND b.field_type = 2
                    WHERE a.id_telbaza = " . $telephoneTableId . "
                    AND a.is_leaf = 1
                    ORDER BY a.orderBy)
                UNION ALL ";

            $rows[] = [
                'anoymize'  => true,
                'name'      => 'id',
                'fieldType' => 2,
            ];
        }

        $rows[] = [
            'anoymize'  => true,
            'name'      => 'id_loginSID',
            'fieldType' => 4,
        ];

        $sql .= "(SELECT a.q_name as name, a.anonymize, 3 as fieldType 
                    FROM " . DB_WARPIT_WEBCATI . "." . $projectName ." as a
                    WHERE a.tip_sql IN(1,2,3,4)
                    ORDER BY a.q_pos)";

        $sql .= " UNION ALL ";
        $sql .= "(SELECT a.var_name as name, a.anonymize, 5 as fieldType 
                    FROM " . DB_WARPIT_WEBCATI_BASE . "._ProjectExtraVariables as a 
                    WHERE a.id_project = {$projectId})";

        $res = $this->db->SQLexecute($sql);

		while($row = $this->db->fetchAssoc($res)){
		    $rows[] = $row;
        }



        return json_encode([
            'success' => true,
            'results' => count($rows),
            'rows' => $rows,
        ]);

	}

	public function backupStructure($projectName)
    {
        $oldName = $projectName . '_structure';
        $newName = $projectName . '_structure' . time() . 'a';

        $sql = "CREATE TABLE " . DB_WARPIT_WEBCATI_BASE . ".{$newName} DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ENGINE=MyISAM SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . ".{$oldName}";

        $this->db->SQLexecute($sql);

        return $newName;
    }

    public function saveSelectedFields($projectId, $selectedFields, $userId, $backupName = null, $type = 1)

    {
        if($type === 1){
            $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "._Projects 
                SET anonymization_fields = '{$selectedFields}', 
                    anonymization_user ='{$userId}',
                    anonymization_datetime= CURRENT_TIMESTAMP() 
                WHERE id = {$projectId}";

            $this->db->SQLexecute($sql);
        }

        $logRecord = [
            "selectedFields = '{$selectedFields}'",
            "user_id ='{$userId}'",
            "backup_name = '{$backupName}'",
            "type = '{$type}'",
            "modification_date = CURRENT_TIMESTAMP()",
        ];

        if($type === 1){
            $logRecord[] = "project_id = '{$projectId}'";
        }

        if($type === 2){
            $tableId = getTelephoneTableId($projectId);
            $logRecord[] = "tel_id = '{$tableId}'";
        }

        $sql = "INSERT " . DB_WARPIT_WEBCATI_BASE . ". _ProjectsAnonymizationLog
                SET " . implode(',', $logRecord);

        $this->db->SQLexecute($sql);
    }
    public function anonymizeTelephoneField($fieldName)
    {
        if($fieldName === 'id'){
            return "id_tel = ''";
        }

        return "TP_$fieldName = ''";
    }

    public function anonymizeExternalField($fieldName)
    {
        return "EV_$fieldName = ''";
    }

    public function anonymizeSystemField($fieldName)
    {
        return "$fieldName = ''";
    }

    public function anonymizeQuestionField($projectName, $questionName)
    {
        $questionId = getQuestionId($projectName,$questionName);
        $question = Question::createQuestionFromTable($this->db,$projectName,$questionId);

        $questionFields = $question->getStructureFields();

        if($questionFields === null){
            return null;
        }

        $anonymizationArray = [];
        foreach ($questionFields as $questionField){
            $anonymizationArray[] = "$questionField = ''";
        }

        return implode(',', $anonymizationArray);
    }

	public function anonymizeProjectAction()
    {
        $projectId = intval($_POST['projectId']);
        $projectName = getProjectName($projectId);

        $userId = intval($_SESSION['UserInfo']['id']);

        $selectedFieldsString = mysql_real_escape_string($_POST['selectedFields']);
        $selectedFields = json_decode( $_POST['selectedFields'], true);

        $backupConfig = configLoader::loadConfig('backup');
        $backupConfig = boolval($backupConfig['anonymization_data']);

        $backupName = '';
        if($backupConfig === true){
            $backupName = $this->backupStructure($projectName);
        }


        $anonymizationArray = [];
        foreach($selectedFields as $field){
            $fieldType = (int)$field['type'];
            $fieldName = $field['name'];
            $anonymize = $field['anonymize'];

            if($anonymize === false){
                continue;
            }
            $anonymizationString = '';
            if($fieldType === 1 || $fieldType === 2){
                $anonymizationString = $this->anonymizeTelephoneField($fieldName);
            }
            else if($fieldType === 3){
                $anonymizationString = $this->anonymizeQuestionField($projectName,$fieldName);
            }
            else if($fieldType === 4){
                $anonymizationString = $this->anonymizeSystemField($fieldName);
            }
            else if($fieldType === 5){
                $anonymizationString = $this->anonymizeExternalField($fieldName);
            }

            if($anonymizationString !== null){
                $anonymizationArray[] = $anonymizationString;
            }
        }

        if(count($anonymizationArray) > 0){
            $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "." . $projectName . "_structure SET " . implode(',', $anonymizationArray);
            $this->db->SQLexecute($sql);
        }

        $this->saveSelectedFields($projectId, $selectedFieldsString, $userId, $backupName);
    }

    public function anonymizeTelephoneTableAction()
    {
        $projectId = intval($_POST['projectId']);

        $userId = intval($_SESSION['UserInfo']['id']);

        $selectedFieldsString = mysql_real_escape_string($_POST['selectedFields']);
        $selectedFields = json_decode($_POST['selectedFields'], true);

        $telephoneTableId = getTelephoneTableId($projectId);
        $customTelephoneFields = getTableFields($telephoneTableId);

        $anonymizationArray = [];
        foreach($selectedFields as $field){
            $fieldType = (int)$field['type'];
            $fieldName = $field['name'];
            $anonymize = $field['anonymize'];

            if($anonymize === false){
                continue;
            }
            $anonymizationString = null;
            if($fieldType === 1 || $fieldType === 2){
                $anonymizationString = $this->anonymizeTelephoneTableField($fieldName, $customTelephoneFields);
            }

            if($anonymizationString !== null){
                $anonymizationArray[] = $anonymizationString;
            }
        }

        $this->updateTelephoneTable($projectId,$anonymizationArray);
        $this->saveSelectedFields($projectId,$selectedFieldsString,$userId, null,2);
    }

    protected function updateTelephoneTable($projectId, array $anonmyizationArray)
    {
        if(count($anonmyizationArray) <= 0){
            return false;
        }

        $tableName = getTelephoneTableName($projectId);

        $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "." . $tableName;
        $sql .= " SET " .implode(',', $anonmyizationArray);
        $sql .= " WHERE proj_reserved = " . $projectId;

        $this->db->SQLexecute($sql);

    }

    protected function anonymizeTelephoneTableField($field, $customFields)
    {
        if($field === 'id'){
            return null;
        }

        if($field === 'telephone'){
            return 'telephone = id';
        }

        if(in_array($field, $customFields)){
            return "tel_" . $field . " = ''";
        }

        return $field . " = ''";
    }

}

$db->ChangeDatabase($_POST['database']);

$project = $_POST['RMtable'];

$manipulator = new AnonymizationManipulator($db,$project);

$comm = $_POST['action'].'Action';
if(method_exists($manipulator,$comm))
	echo $manipulator->$comm();
else
{

	Echo '{success:false,error:"Unknown action!"}';

}
?>
