<?php
include_once(PATH_TO_ROOT."webcati/_class/class.PostDataHelper.php");
class ProjectJumpManager
{
    private $db;
    private $mainProjectSessionId;

    private $user;

    private $subProjectId;
    private $jumpConditionIndex;

    private $mainProjectParams;
    private $subProjectParams;
    private $modulParams;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function executeResetMainProjectContext()
    {
        $redirectUrl = $_SERVER['PHP_SELF'];

        $postParamsArr = Array(
            "loadParentData" => TRUE,
            "parentData" => $_SESSION["parentData"]
        );

        $formParams = Array(
            "id" => "postForm",
            "method" => "POST",
            "action" => $redirectUrl
        );
        $afterHtml = "<script>document.forms['postForm'].submit();</script>";
        $postForm = new PostDataHelper($formParams, "", $afterHtml);
        $postForm->addData($postParamsArr);

        echo $postForm->getHtml();
        exit;
    }

    public function executeJumpToSubProject($mainProjectPHPsessionId, $subProjectId, $jumpConditionIndex)
    {
        $this->mainProjectSessionId = $mainProjectPHPsessionId;
        $this->subProjectId = $subProjectId;
        $this->jumpConditionIndex = $jumpConditionIndex;
        $this->prepareJumpToSubProject();

        $params = array_merge($this->subProjectParams, $this->modulParams);
        $redirectUrl = $_SERVER['PHP_SELF'];

        $formParams = Array(
            "id" => "postForm",
            "method" => "POST",
            "action" => htmlspecialchars($redirectUrl)
        );
        $beforeHtml = "<html><body>";
        $afterHtml = "<script>document.forms['" . $formParams["id"] . "'].submit();</script></body></html>";

        $postForm = new PostDataHelper($formParams, $beforeHtml, $afterHtml);
        $postForm->addData($this->mainProjectParams, "parentData");
        $postForm->addData($params, "subData");
        echo $postForm->getHtml();
        exit;
    }

    private function prepareJumpToSubProject()
    {
        $this->setUser();
        $this->setModulParams();
        $this->setSubProjectParams();
        $this->setMainProjectParams();
    }

    private function setUser()
    {
        $this->user['id_user'] = $_SESSION['id_user'];
        $this->user['user_type'] = $_SESSION['user_type'];
    }

    private function setModulParams()
    {
        if($this->isCapi())
        {
            $this->modulParams['capi'] = 1;

            $this->modulParams['IDsampleProject'] = $_SESSION['IDsampleProject'];
            $this->modulParams['IDsampleMain'] = $_SESSION['IDsampleMain'];
            $this->modulParams['IDsampleTable'] = $_SESSION['IDsampleTable'];
        }
        else //it is capiTablet
        {
            $this->modulParams['capiTablet'] = 1;
        }
    }

    private function isCapi()
    {
        return (isset($_SESSION['capi']) && $_SESSION['capi'] == 1);
    }

    private function setSubProjectParams()
    {
        $subQuestionnaireParams = Array();
        $this->subProjectParams = ($this->subProjectLoginSIDExists()) ? $this->getExistingLoginSIDAndSite() : $this->generateNewLoginSIDAndSite();

        $this->saveSubProjectToMainProject();
    }

    private function subProjectLoginSIDExists()
    {
        return isset($_SESSION['subQuestionnaire']) && array_key_exists($this->subProjectId, $_SESSION['subQuestionnaire']);
    }

    private function getExistingLoginSIDAndSite()
    {
        $loginSID =  $_SESSION['subQuestionnaire'][$this->subProjectId]['loginSID'];
        $idSite = $_SESSION['subQuestionnaire'][$this->subProjectId]['id_site'];

        return Array(
            "loginSID" => $loginSID,
            "id_site" => $idSite
        );
    }

    private function generateNewLoginSIDAndSite()
    {
        //save context and reset session for generating new loginSID
        $contextSession = $_SESSION;
        $_SESSION = Array();

        $_SESSION["UserInfo"]["id"] = $id_user = $this->user['id_user'];
        $_SESSION["UserInfo"]["user_type"] = $user_type = $this->user['user_type'];
        $_SESSION["capi"]["id_project"] = $id_project = $this->subProjectId;

        $date = date("Y-m-d H:i:s");
        $sql = 	"SELECT proj_name,loginSID,naziv_proj FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids as a
                INNER JOIN ".DB_WARPIT_WEBCATI_BASE."._Projects as b ON a.id_project = b.id
                WHERE 	b.active = 1
                        AND b.start_date < '".$date."'
                        AND b.end_date > '".$date."'
                        AND b.id = ".$id_project."
                        AND a.id_user = ".$id_user."
                        AND a.user_type=".$user_type;
        $res = $this->db->SQLexecute($sql);
        $zad = $this->db->fetchAssoc($res);

        $sql = "INSERT INTO ".DB_WARPIT_WEBCATI_BASE."._Capi_interviewer_visits
                        SET
                            obisk_st = 1,
                            id_project = ".$id_project.",
                            user_id  = ".$id_user.",
                            user_type = '".$user_type."',
                            cas_obiska = NOW() ";
        $this->db->SQLexecute($sql);
        $lastID = $this->db->GetLastInsertId();

        $sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE."._Capi_interviewer_visits SET quest_id = ".$lastID." WHERE id = ".$lastID;
        $this->db->SQLexecute($sql);

        $db = $this->db;
        // -------------- CREATING NEW loginSID ----------------------------------
        include(PATH_TO_ROOT."webcati/_ajax/generateWwwIds/ajax.generate-capi-sid.php");

        $sql = 	" SELECT loginSID FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids WHERE";
        $sqlWhere = "    id_project 	= $id_project
                        AND id_user 	= $id_user
                        AND user_type 	= $user_type";
        $sqlWhere .= (isset($lastID)) ? " AND id_site = $lastID" : "";
        $sql .= $sqlWhere;

        $res = $this->db->SQLexecute($sql);
        $zad = $this->db->fetchAssoc($res);

        $_SESSION = $contextSession;

        return Array(
            "loginSID" => $zad['loginSID'],
            "id_site" => $lastID
        );
    }

    private function saveSubProjectToMainProject()
    {
        $_SESSION['subQuestionnaire'][$this->subProjectId] = $this->subProjectParams;
    }

    private function setMainProjectParams()
    {
        $this->mainProjectParams['session'] = $this->mainProjectSessionId;
        $_SESSION['jumpToSubProject']['post'] = $_POST;
        $_SESSION['jumpToSubProject']['jumpConditionIndex'] = $this->jumpConditionIndex;
    }

    public static function loadMainProjectContext()
    {
        $_POST = $_SESSION['jumpToSubProject']['post'];
        $_SESSION['jumpConditionIndex'] = $_SESSION['jumpToSubProject']['jumpConditionIndex'];
        unset($_SESSION['jumpToSubProject']);
    }


    public static function loadSubProjectContext()
    {
        $_GET = Array();
        $_GET["loginSID"] = $_POST["subData"]["loginSID"];
        $_GET["id_site"] = $_POST["subData"]["id_site"];

        if(isset($_POST["subData"]["capiTablet"]))
        {
            $_GET["capiTablet"] = $_POST["subData"]["capiTablet"];
        }
        else
        {
            $_GET["capi"] = $_POST["subData"]["capi"];
            $_GET["IDsampleProject"] = $_POST["subData"]["IDsampleProject"];
            $_GET["IDsampleMain"] = $_POST["subData"]["IDsampleMain"];
            $_GET["IDsampleTable"] = $_POST["subData"]["IDsampleTable"];
        }
    }
}
?>
