<?php
	ini_set("display_errors", 1);
	session_start();
	
	require_once 'data/class.MapServer.php';
	
	header('Content-type: text/html; charset=utf-8');
	// unset($_SESSION['mapfile']);
	$_SESSION['layers'] = "obcina,ko";
	if (!isset($_SESSION['mapfile']))  $_SESSION['mapfile'] = "/var/www/tmp/" . md5(rand()) . ".map";
	$ms = new MapServer($_SESSION['mapfile']);
	$ms->setLayers(explode(",", $_SESSION['layers']));
	
	$ms->generateMapFile();
	
?>
<!doctype html>
<html lang="en">
  <head>
  	<meta charset="utf-8">
    <link rel="stylesheet" href="http://ol3js.org/en/master/css/ol.css" type="text/css">
    <style>
      .map {
        height: 500px;
        width: 100%;
      }
      .box {
      	background-color: #ffffff;
      	border: 1px solid black;
      	display: none;
      	position: absolute;
      }
    </style>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
    <script src="http://ol3js.org/en/master/build/ol.js" type="text/javascript"></script>
    <title>OpenLayers 3 example</title>
  </head>
  <body>
    <div id="map" class="map"></div>
    <div id="info" class="box"></div>
    <div class="span6" id="mouse-position"></div>
    <button id="fly-to-bern">Fly</button>
    <button id="update">Update</button>
    <label>opacity</label>
	<input id="opacity" type="range" min="0" max="1" step="0.01"/>
	<select id="obmocja"><option value="obala">Obalno-Kraška</option><option value="goriska">Goriška</option><option value="notranjska">Notranjsko-Kraška</option>
		<option value="gorenjska">Gorenjska</option><option value="osrednjeslovenska">Osrednjeslovenska</option><option value="jugovzhod">Jugovzhodna Slovenjia</option>
		<option value="zasavska">Zasavska</option><option value="spodnjeposavska">Spodnjeposavska</option><option value="savinjska">Savinjska</option>
		<option value="koroska">Koroška</option><option value="podravska">Podravska</option><option value="pomurska">Pomurska</option>
	</select>
    <script type="text/javascript">
    var map, view, layer, interval, info = { cX: 0, cY: 0 };
    var scaleLineControl = new ol.control.ScaleLine();
    var mousePositionControl = new ol.control.MousePosition({
	  coordinateFormat: ol.coordinate.createStringXY(4),
	  projection: 'EPSG:4326',
	  className: 'custom-mouse-position',
	  target: document.getElementById('mouse-position'),
	  undefinedHTML: '&nbsp;'
	});
	
	view = new ol.View2D({
          center: ol.proj.transform([14.88, 46.10], 'EPSG:4326', 'EPSG:3857'),
          zoom: 8
        });
        
        layer = new ol.layer.Tile({
		    source: new ol.source.TileWMS({
		      url: 'http://188.226.147.165/cgi-bin/mapserv?MAP=<?php echo $_SESSION['mapfile']; ?>',
		      crossOrigin: 'anonymous',
		      params: {
		        'LAYERS': '<?php echo $_SESSION['layers']; ?>',
		        'FORMAT': 'image/png',
		        'SHA': "test"
		      },
		      serverType: 'mapserver'
		    })
		  });
	
      map = new ol.Map({
      controls: ol.control.defaults().extend([mousePositionControl,scaleLineControl,new ol.control.FullScreen(),
      new ol.control.ZoomToExtent({
      extent: [
        1728259.648838898, 5859805.277778027,
        1748259.648838898, 5879805.277778027
      ]
    })
    ]),
        target: 'map',
        layers: [
          new ol.layer.Tile({
            source: new ol.source.OSM()
          }),
         layer
        ],
        view: view
      });
      
      map.on('singleclick', function(evt) {
  		var coordinate = evt.coordinate;
  		var hdms = ol.coordinate.toStringHDMS(ol.proj.transform(
      		coordinate, 'EPSG:3857', 'EPSG:4326'));
      		
      	$.ajax({
      		url: 'data/update.php',
      		type: 'post',
      		data: { action: 'toggleLayerSelect', zoom: view.getZoom(), coord: evt.coordinate.join(", ") },
      		success: function(data) {
      			var params = layer.getSource().getParams();
				params.SHA = getUniqueParam();
				layer.getSource().updateParams(params);
      		}
      	});

  		/*alert(hdms);
  		console.log(evt.coordinate);
  		console.log(ol.coordinate.toStringXY(ol.proj.transform(
      		coordinate, 'EPSG:3857', 'EPSG:4326')));*/

	});
	
	 /*map.on('doubleclick', function(evt) {
  		var coordinate = evt.coordinate;
  		var hdms = ol.coordinate.toStringHDMS(ol.proj.transform(
      		coordinate, 'EPSG:3857', 'EPSG:4326'));

  		alert("double");
  		console.log(evt.coordinate);
  		console.log(ol.coordinate.toStringXY(ol.proj.transform(
      		coordinate, 'EPSG:3857', 'EPSG:4326')));

	});*/

	/*$(map.getViewport()).on('mousemove', function(evt) {
		clearInterval(interval);
		interval = setTimeout(function() {
			hideInfo();
			info.cX = evt.clientX;
			info.cY = evt.clientY;
			$("#info").html('<div id="inner">' + ol.proj.transform(map.getEventCoordinate(evt), 'EPSG:3857', 'EPSG:4326')[0] + '</div>');
			showInfo("info");
			// $("#info").text(ol.proj.transform(map.getEventCoordinate(evt), 'EPSG:3857', 'EPSG:4326'));
		}, 1000);
	});*/
      
      var flyToBern = document.getElementById('fly-to-bern');
		flyToBern.addEventListener('click', function() {
		  var duration = 2000;
		  var start = +new Date();
		  var pan = ol.animation.pan({
		    duration: duration,
		    source: /** @type {ol.Coordinate} */ (view.getCenter()),
		    start: start
		  });
		  var bounce = ol.animation.bounce({
		    duration: duration,
		    resolution: 2 * view.getResolution(),
		    start: start
		  });
		  map.beforeRender(pan, bounce);
		  view.setCenter(ol.proj.transform([14.9, 46.8], 'EPSG:4326', 'EPSG:3857'));
		}, false);
		
		
		var opacity = new ol.dom.Input(document.getElementById('opacity'));
		opacity.bindTo('value', layer, 'opacity')
    		.transform(parseFloat, String);
    	
    	$("#update").click(function() {
    	layer.getSource().updateParams({layers: 'obcina'});
    	});
    	
    	$("#inner").click(function() {
    		hideInfo();
    	});
    	
    	$("#obmocja").change(function(value) {
		    var valueSelected = this.value;
		    
		    var center = [14.88, 46.10];
		    
		    switch (valueSelected) {
		    	case 'obala':
		    		center = [13.8, 45.65];
		    		break;
		    	case 'goriska':
		    		center = [13.71, 46.1];
		    		break;
		    	case 'notranjska':
		    		center = [14.3, 45.7];
		    		break;
		    	case 'gorenjska':
		    		center = [14.36, 45.98];
		    		break;
		    	case 'osrednjeslovenska':
		    		center = [14.08, 46.33];
		    		break;
		    	case 'jugovzhod':
		    		center = [15.03, 45.77];
		    		break;
		    	case 'zasavska':
		    		center = [14.95, 46.15];
		    		break;
		    	case 'spodnjeposavska':
		    		center = [15.13, 46.33];
		    		break;
		    	case 'savinjska':
		    		center = [15.38, 45.98];
		    		break;
		    	case 'koroska':
		    		center = [15.13, 46.56];
		    		break;
		    	case 'podravska':
		    		center = [15.85, 46.52];
		    		break;
		    	case 'pomurska':
		    		center = [16.25, 46.68];
		    		break;
		    	default:
		    		break;
		    }
		    
		     var duration = 2000;
			  var start = +new Date();
			  var pan = ol.animation.pan({
			    duration: duration,
			    source: /** @type {ol.Coordinate} */ (view.getCenter()),
			    start: start
			  });
			  var bounce = ol.animation.bounce({
			    duration: duration,
			    resolution: 2 * view.getResolution(),
			    start: start
			  });
			  map.beforeRender(pan, bounce);
			  view.setCenter(ol.proj.transform(center, 'EPSG:4326', 'EPSG:3857'));
			  view.setZoom(11);
		    
    	});
    	
    	function getUniqueParam() {
    		return Math.random().toString(36).substring(5);
    	};
    	
    	function clearInfo() {
		var dd = document.getElementById("info");
		dd.style.display = "none";
	};
	
	function showInfo(d) {
		if(d.length < 1) { return; }
		var dd = document.getElementById("info"); //problem, če element s tem imenom ne obstaja IE
		$("#info-text").text(d);
		assignPosition(dd);
		dd.style.display = "block";
	};
	
	function hideInfo() {
		var dd = document.getElementById("info");
		dd.style.display = "none";
	};
	
	function assignPosition(d) {
	
		if(self.pageYOffset) {
			rX = self.pageXOffset;
			rY = self.pageYOffset;
		}
						
		else if(document.documentElement && document.documentElement.scrollTop) {
			rX = document.documentElement.scrollLeft;
			rY = document.documentElement.scrollTop;
		}
						
		else if(document.body) {
			rX = document.body.scrollLeft;
			rY = document.body.scrollTop;
		}
						
		if(document.all) {
			info.cX += rX;
			info.cY += rY;
		}
						
		d.style.left = (info.cX + 10) + "px";
		d.style.top = (info.cY + 10) + "px";
	};
	
	function updateCursorPosition(e){
		var ev = e || window.event;
	
		info.cX = ev.pageX ? ev.pageX : (ev.clientX + document.body.scrollLeft);
		info.cY = ev.pageY ? ev.pageY : (ev.clientY + document.body.scrollTop);
	
		if (info.cX < 0) Gis.info.cX = 0;
		if (info.cY < 0) Gis.info.cY = 0;
	};
    </script>
  </body>
</html>