<?php
	ini_set("display_errors", 1);
	session_start();
	
	require_once 'data/class.MapServer.php';
	
	header('Content-type: text/html; charset=utf-8');
	// unset($_SESSION['mapfile']);
	// $_SESSION['layers'] = "obcina,katastrske_obcine";
	$_SESSION['layers'] = "eu";
	if (!isset($_SESSION['mapfile']))  $_SESSION['mapfile'] = "/var/www/tmp/" . md5(rand()) . ".map";
	$ms = new MapServer($_SESSION['mapfile']);
	$ms->setLayers(explode(",", $_SESSION['layers']));
	
	$ms->generateMapFile();
	
?>
<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
  <title>OpenLayers Example</title>
  <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
    <script src="http://openlayers.org/api/OpenLayers.js"></script>
    <!--[if lte IE 7]>
		<script src="json2.js"></script>
	<![endif]-->
    <style>
    	body {padding:0;margin:0;}
    	.loader {
    		display: none;
    		position: absolute;
    		background: rgba(255, 255, 255, 0.3);
			filter: progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr='#4cffffff', endColorstr='#4cffffff');
    		width: 500px;
    		height: 400px;
    	}
    	.load-img {
			margin-left: 225px;
			margin-top: 175px;
		}
		.smallmap {
			border: 1px solid #ccc;
		}
    </style>
    </head>
    <body>
      <div style="width:100%; height:500px" id="map" class="smallmap cmenu1"><div id="loader" class="loader"><img class="load-img" src="images/ajax-loader.gif"></img></div></div>
      <div id="name"></div>
      <input id="tip1" type="button" value="Tip1" /><input id="tip2" type="button" value="Tip2" /><input id="tip3" type="button" value="Tip3" />
      <script defer="defer" type="text/javascript">
      	var tout, exportMapControl,opacity=1.0, map, markers;
      	
    	$(document).ready(function() {
      	// OpenLayers.ProxyHost = "/cgi-bin/proxy.cgi?url=";
      	
      	var view = 0; // view of map .. 0 = slovenija, 1 = statisticne regije, 2 = obcine, 3 = volilne enote
      	var layers = '<?php echo $_SESSION['layers']; ?>' ;
      	var osm = true;
      	var wms = [];
      	var auto = true;
      	var home = new OpenLayers.LonLat(14.88, 46.10).transform('EPSG:4326', 'EPSG:3857');
      	
       	map = new OpenLayers.Map('map', {
        	units: "m",
			projection: "EPSG:3857",
			/*restrictedExtent: [
                1474983, 5683129, 1865714, 5929025
            ],*/
            allOverlays: true
        });
        
        if (osm) {
        	map.addLayer(new OpenLayers.Layer.OSM('OSM'));
        }
        
        var split = layers.split(",");
        
        for (var i=0;i<split.length;i++) {
        	wms.push(new OpenLayers.Layer.WMS(
			    "StatView",
			    "../cgi-bin/mapserv.fcgi?MAP=<?php echo $_SESSION['mapfile']; ?>",
			    {
			        layers: split[i],
			        transparent: "true",
			        srs: 'EPSG:3857',
			        format: "image/png"
			    },
			    {
			    	isBaseLayer: false
			    }
			));
			map.addLayer(wms[i]);
			
			if (view != i) wms[i].setVisibility(false);
			
			wms[i].events.register("loadstart", wms[i], function() {
                showLoader();
            });
            
            wms[i].events.register("loadend", wms[i], function() {
                hideLoader();
            });
        }
		
		map.setCenter(home, 5);
		
		markers = new OpenLayers.Layer.Vector( "Markers" );
    	map.addLayer(markers);
    	
    	var dragFeature = new OpenLayers.Control.DragFeature(markers);
		
        map.addControls([
        	new OpenLayers.Control.MousePosition({
            	separator: ' | ',
            	numDigits: 2,
            	emptyString: ''
        	}),
        	dragFeature
        ]);
        
        dragFeature.activate();
        
        document.getElementById('map').oncontextmenu = function(e){
		 e = e?e:window.event;
		 if (e.preventDefault) e.preventDefault(); // For non-IE browsers.
		 else return false; // For IE browsers.
		};
       
       function showLoader() {
       	$(".loader").css("display", "block");
       }
       
       function hideLoader() {
       	$(".loader").css("display", "none");
       }
       
       $("#tip1").click(function() {
       		markers.removeAllFeatures();
       		
       		var data = [{'gid': 14, 'geom':{"type":"Point","coordinates":[14.14019177281865,47.592902631260209]},'start':'4.9%','end':'15.8%'},{'gid': 21, 'geom':{"type":"Point","coordinates":[4.663988676898683,50.642851232774568]},'start':'.4%','end':''},{'gid': 25, 'geom':{"type":"Point","coordinates":[17.786530999122014,44.168115071250725]},'start':'1.5%','end':'1.9%'},{'gid': 29, 'geom':{"type":"Point","coordinates":[28.046787502967149,53.539997655873051]},'start':'','end':''},{'gid': 33, 'geom':{"type":"Point","coordinates":[25.231507004214929,42.761376715174869]},'start':'','end':''},{'gid': 70, 'geom':{"type":"Point","coordinates":[15.338411822110849,49.742859002764249]},'start':'','end':'1.1%'},{'gid': 79, 'geom':{"type":"Point","coordinates":[2.551955275865504,46.56450213895868]},'start':'1.1%','end':'1.1%'},{'gid': 89, 'geom':{"type":"Point","coordinates":[10.393646627091341,51.106561919292538]},'start':'1.5%','end':'5.3%'},{'gid': 102, 'geom':{"type":"Point","coordinates":[16.411780148574948,45.051162148643407]},'start':'1.1%','end':'8.6%'},{'gid': 103, 'geom':{"type":"Point","coordinates":[19.413449085021977,47.166502594019782]},'start':'1.5%','end':'1.9%'},{'gid': 111, 'geom':{"type":"Point","coordinates":[12.071741743177709,42.79578204819969]},'start':'9.0%','end':'18.0%'},{'gid': 132, 'geom':{"type":"Point","coordinates":[23.89812216328675,55.335670420610249]},'start':'','end':''},{'gid': 134, 'geom':{"type":"Point","coordinates":[19.491651063700221,48.707530851292717]},'start':'.4%','end':''},{'gid': 146, 'geom':{"type":"Point","coordinates":[21.697475750974132,41.599682669319705]},'start':'','end':''},{'gid': 166, 'geom':{"type":"Point","coordinates":[5.603418501985614,52.249263505013339]},'start':'','end':''},{'gid': 180, 'geom':{"type":"Point","coordinates":[19.400883847684888,52.124609898092992]},'start':'','end':'.4%'},{'gid': 182, 'geom':{"type":"Point","coordinates":[-8.562737946807607,39.600988469274284]},'start':'','end':''},{'gid': 189, 'geom':{"type":"Point","coordinates":[24.969258484682467,45.843614746949825]},'start':'','end':'.4%'},{'gid': 192, 'geom':{"type":"Point","coordinates":[96.577688865591441,61.946135098567254]},'start':'','end':''},{'gid': 201, 'geom':{"type":"Point","coordinates":[14.826536409064799,46.12356340283025]},'start':'76.3%','end':'42.5%'},{'gid': 206, 'geom':{"type":"Point","coordinates":[-3.649565938276162,40.226828764167394]},'start':'','end':'.4%'},{'gid': 207, 'geom':{"type":"Point","coordinates":[20.805457692824017,44.03204591429752]},'start':'2.3%','end':'1.5%'},{'gid': 214, 'geom':{"type":"Point","coordinates":[8.2343918772922,46.802495574579446]},'start':'','end':''},{'gid': 225, 'geom':{"type":"Point","coordinates":[35.179671510067834,39.060595773386979]},'start':'','end':''},{'gid': 231, 'geom':{"type":"Point","coordinates":[-2.895584266889411,54.155349876448255]},'start':'','end':''},{'gid': 232, 'geom':{"type":"Point","coordinates":[31.38711464344507,49.017088169299903]},'start':'','end':'1.1%'}];
       		
	       	var lefturl = "http://chart.apis.google.com/chart?chst=d_map_spin&chld=1|0|72A660|12|_|";
	       	var righturl = "http://chart.apis.google.com/chart?chst=d_map_spin&chld=1|0|B33939|12|_|";
	       	var url = "images/markers/";
	
	    	var size = new OpenLayers.Size(37,62);
            var offset = new OpenLayers.Pixel(-(size.w/2), -size.h);
            
            for (var i=0;i<data.length;i++) {
            	var coord = data[i].geom.coordinates;
            	
            	var left = [coord[0]-0.7, coord[1]];
            	var right = [coord[0]+0.7, coord[1]];
            	
            	if (data[i].start !== "") {
            		var lonLat = new OpenLayers.LonLat(left).transform('EPSG:4326', 'EPSG:3857');
            		
            		var marker = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat), null, {
				        externalGraphic: url + data[i].gid + "_1_s.png",
				        graphicWidth: 36,
				        graphicHeight: 55,
				        fillOpacity: 1
				    });
				    
				    markers.addFeatures([marker]);
            	}
            	
            	if (data[i].end !== "") {
            		var lonLat = new OpenLayers.LonLat(right).transform('EPSG:4326', 'EPSG:3857');
            		
            		var marker = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat), null, {
				        externalGraphic: url + data[i].gid + "_1_e.png",
				        graphicWidth: 36,
				        graphicHeight: 55,
				        fillOpacity: 1 
				    });
				    
				    markers.addFeatures([marker]);
            	}
	    	}
       });
       
       $("#tip2").click(function() {
       		markers.removeAllFeatures();
       		
       		var data = [{'gid': 14, 'geom':{"type":"Point","coordinates":[14.14019177281865,47.592902631260209]},'start':'3.2%','end':'6.2%'},{'gid': 21, 'geom':{"type":"Point","coordinates":[4.663988676898683,50.642851232774568]},'start':'.2%','end':''},{'gid': 25, 'geom':{"type":"Point","coordinates":[17.786530999122014,44.168115071250725]},'start':'3.9%','end':'1.8%'},{'gid': 29, 'geom':{"type":"Point","coordinates":[28.046787502967149,53.539997655873051]},'start':'.4%','end':'.2%'},{'gid': 33, 'geom':{"type":"Point","coordinates":[25.231507004214929,42.761376715174869]},'start':'.7%','end':''},{'gid': 70, 'geom':{"type":"Point","coordinates":[15.338411822110849,49.742859002764249]},'start':'.5%','end':'1.4%'},{'gid': 79, 'geom':{"type":"Point","coordinates":[2.551955275865504,46.56450213895868]},'start':'.4%','end':'2.3%'},{'gid': 89, 'geom':{"type":"Point","coordinates":[10.393646627091341,51.106561919292538]},'start':'2.7%','end':'3.0%'},{'gid': 102, 'geom':{"type":"Point","coordinates":[16.411780148574948,45.051162148643407]},'start':'8.3%','end':'4.9%'},{'gid': 103, 'geom':{"type":"Point","coordinates":[19.413449085021977,47.166502594019782]},'start':'11.7%','end':'12.7%'},{'gid': 111, 'geom':{"type":"Point","coordinates":[12.071741743177709,42.79578204819969]},'start':'22.7%','end':'32.5%'},{'gid': 132, 'geom':{"type":"Point","coordinates":[23.89812216328675,55.335670420610249]},'start':'','end':'.2%'},{'gid': 134, 'geom':{"type":"Point","coordinates":[19.491651063700221,48.707530851292717]},'start':'3.7%','end':'2.1%'},{'gid': 146, 'geom':{"type":"Point","coordinates":[21.697475750974132,41.599682669319705]},'start':'.7%','end':'.2%'},{'gid': 166, 'geom':{"type":"Point","coordinates":[5.603418501985614,52.249263505013339]},'start':'','end':'.2%'},{'gid': 180, 'geom':{"type":"Point","coordinates":[19.400883847684888,52.124609898092992]},'start':'10.8%','end':'7.4%'},{'gid': 182, 'geom':{"type":"Point","coordinates":[-8.562737946807607,39.600988469274284]},'start':'.2%','end':'.2%'},{'gid': 189, 'geom':{"type":"Point","coordinates":[24.969258484682467,45.843614746949825]},'start':'15.2%','end':'9.1%'},{'gid': 192, 'geom':{"type":"Point","coordinates":[96.577688865591441,61.946135098567254]},'start':'.7%','end':'.2%'},{'gid': 201, 'geom':{"type":"Point","coordinates":[14.826536409064799,46.12356340283025]},'start':'5.0%','end':'8.8%'},{'gid': 206, 'geom':{"type":"Point","coordinates":[-3.649565938276162,40.226828764167394]},'start':'1.6%','end':'4.0%'},{'gid': 207, 'geom':{"type":"Point","coordinates":[20.805457692824017,44.03204591429752]},'start':'6.4%','end':'2.1%'},{'gid': 214, 'geom':{"type":"Point","coordinates":[8.2343918772922,46.802495574579446]},'start':'.2%','end':'.2%'},{'gid': 225, 'geom':{"type":"Point","coordinates":[35.179671510067834,39.060595773386979]},'start':'.2%','end':''},{'gid': 231, 'geom':{"type":"Point","coordinates":[-2.895584266889411,54.155349876448255]},'start':'.4%','end':''},{'gid': 232, 'geom':{"type":"Point","coordinates":[31.38711464344507,49.017088169299903]},'start':'.5%','end':'.5%'}];
       		
       		var lefturl = "http://chart.apis.google.com/chart?chst=d_map_spin&chld=1|0|72A660|12|_|";
	       	var righturl = "http://chart.apis.google.com/chart?chst=d_map_spin&chld=1|0|B33939|12|_|";
	       	var url = "images/markers/";
	
	    	var size = new OpenLayers.Size(37,62);
            var offset = new OpenLayers.Pixel(-(size.w/2), -size.h);
            
            for (var i=0;i<data.length;i++) {
            	var coord = data[i].geom.coordinates;
            	
            	var left = [coord[0]-0.7, coord[1]];
            	var right = [coord[0]+0.7, coord[1]];
            	
            	if (data[i].start !== "") {
            		var lonLat = new OpenLayers.LonLat(left).transform('EPSG:4326', 'EPSG:3857');
            		
            		var marker = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat), null, {
				        externalGraphic: url + data[i].gid + "_2_s.png",
				        graphicWidth: 36,
				        graphicHeight: 55,
				        fillOpacity: 1
				    });
				    
				    markers.addFeatures([marker]);
            	}
            	
            	if (data[i].end !== "") {
            		var lonLat = new OpenLayers.LonLat(right).transform('EPSG:4326', 'EPSG:3857');
            		
            		var marker = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat), null, {
				        externalGraphic: url + data[i].gid + "_2_e.png",
				        graphicWidth: 36,
				        graphicHeight: 55,
				        fillOpacity: 1 
				    });
				    
				    markers.addFeatures([marker]);
            	}
	    	}
       });
       
       $("#tip3").click(function() {
       		markers.removeAllFeatures();
       		
       		var data = [{'gid': 14, 'geom':{"type":"Point","coordinates":[14.14019177281865,47.592902631260209]},'start':'3.7%','end':'9.2%'},{'gid': 21, 'geom':{"type":"Point","coordinates":[4.663988676898683,50.642851232774568]},'start':'.2%','end':''},{'gid': 25, 'geom':{"type":"Point","coordinates":[17.786530999122014,44.168115071250725]},'start':'3.1%','end':'1.8%'},{'gid': 29, 'geom':{"type":"Point","coordinates":[28.046787502967149,53.539997655873051]},'start':'.2%','end':'.1%'},{'gid': 33, 'geom':{"type":"Point","coordinates":[25.231507004214929,42.761376715174869]},'start':'.5%','end':''},{'gid': 70, 'geom':{"type":"Point","coordinates":[15.338411822110849,49.742859002764249]},'start':'.4%','end':'1.3%'},{'gid': 79, 'geom':{"type":"Point","coordinates":[2.551955275865504,46.56450213895868]},'start':'.6%','end':'1.9%'},{'gid': 89, 'geom':{"type":"Point","coordinates":[10.393646627091341,51.106561919292538]},'start':'2.3%','end':'3.7%'},{'gid': 102, 'geom':{"type":"Point","coordinates":[16.411780148574948,45.051162148643407]},'start':'6.0%','end':'6.1%'},{'gid': 103, 'geom':{"type":"Point","coordinates":[19.413449085021977,47.166502594019782]},'start':'8.4%','end':'9.2%'},{'gid': 111, 'geom':{"type":"Point","coordinates":[12.071741743177709,42.79578204819969]},'start':'18.3%','end':'27.9%'},{'gid': 132, 'geom':{"type":"Point","coordinates":[23.89812216328675,55.335670420610249]},'start':'','end':'.1%'},{'gid': 134, 'geom':{"type":"Point","coordinates":[19.491651063700221,48.707530851292717]},'start':'2.6%','end':'1.4%'},{'gid': 146, 'geom':{"type":"Point","coordinates":[21.697475750974132,41.599682669319705]},'start':'.5%','end':''},{'gid': 166, 'geom':{"type":"Point","coordinates":[5.603418501985614,52.249263505013339]},'start':'','end':'.1%'},{'gid': 180, 'geom':{"type":"Point","coordinates":[19.400883847684888,52.124609898092992]},'start':'7.3%','end':'5.1%'},{'gid': 182, 'geom':{"type":"Point","coordinates":[-8.562737946807607,39.600988469274284]},'start':'.1%','end':'.1%'},{'gid': 189, 'geom':{"type":"Point","coordinates":[24.969258484682467,45.843614746949825]},'start':'10.3%','end':'6.3%'},{'gid': 192, 'geom':{"type":"Point","coordinates":[96.577688865591441,61.946135098567254]},'start':'.5%','end':'.1%'},{'gid': 201, 'geom':{"type":"Point","coordinates":[14.826536409064799,46.12356340283025]},'start':'27.8%','end':'19.5%'},{'gid': 206, 'geom':{"type":"Point","coordinates":[-3.649565938276162,40.226828764167394]},'start':'1.1%','end':'2.9%'},{'gid': 207, 'geom':{"type":"Point","coordinates":[20.805457692824017,44.03204591429752]},'start':'5.1%','end':'1.9%'},{'gid': 214, 'geom':{"type":"Point","coordinates":[8.2343918772922,46.802495574579446]},'start':'.1%','end':'.1%'},{'gid': 225, 'geom':{"type":"Point","coordinates":[35.179671510067834,39.060595773386979]},'start':'.1%','end':''},{'gid': 231, 'geom':{"type":"Point","coordinates":[-2.895584266889411,54.155349876448255]},'start':'.2%','end':''},{'gid': 232, 'geom':{"type":"Point","coordinates":[31.38711464344507,49.017088169299903]},'start':'.4%','end':'.7%'}];       		

			var lefturl = "http://chart.apis.google.com/chart?chst=d_map_spin&chld=1|0|72A660|12|_|";
	       	var righturl = "http://chart.apis.google.com/chart?chst=d_map_spin&chld=1|0|B33939|12|_|";
	       	var url = "images/markers/";
	
	    	var size = new OpenLayers.Size(37,62);
            var offset = new OpenLayers.Pixel(-(size.w/2), -size.h);
            
            for (var i=0;i<data.length;i++) {
            	var coord = data[i].geom.coordinates;
            	
            	var left = [coord[0]-0.7, coord[1]];
            	var right = [coord[0]+0.7, coord[1]];
            	
            	if (data[i].start !== "") {
            		var lonLat = new OpenLayers.LonLat(left).transform('EPSG:4326', 'EPSG:3857');
            		
            		var marker = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat), null, {
				        externalGraphic: lefturl + data[i].start,
				        graphicWidth: 36,
				        graphicHeight: 55,
				        fillOpacity: 1
				    });
				    
				    markers.addFeatures([marker]);
            	}
            	
            	if (data[i].end !== "") {
            		var lonLat = new OpenLayers.LonLat(right).transform('EPSG:4326', 'EPSG:3857');
            		
            		var marker = new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat), null, {
				        externalGraphic: righturl + data[i].end,
				        graphicWidth: 36,
				        graphicHeight: 55,
				        fillOpacity: 1 
				    });
				    
				    markers.addFeatures([marker]);
            	}
	    	}
       });
       
       $("#tip1").click();
    });
    
	function updateMapSize() {
   		$("#map").width($(document).width() - 5);
   		$("#map").height($(document).height() - 30);
		setTimeout(function() { map.updateSize(); }, 200); 
	}
	
	updateMapSize();
    
      </script>

</body>
</html>