<?php
	ini_set("display_errors", 1);
	session_start();
	require_once 'postgis.php';
	require_once 'class.MapServer.php';
	
	if (!isset($_SESSION['mapfile']))  $_SESSION['mapfile'] = "/var/www/tmp/" . md5(rand()) . ".map";
	$ms = new MapServer($_SESSION['mapfile']);
	
	if (isset($_POST['action'])) {
		if ($_POST['action'] == 'toggleLayerSelect') {
			$zoom = $_POST['zoom'];
			$coord = explode(", ", $_POST['coord']);
			$layer = "ob";
			
			$geom = 'POINT('.$coord[0].' '.$coord[1].')';
			$proj = '3857';
			
			$sql = "SELECT ob_mid FROM layers.".$layer." WHERE ST_Within(ST_Transform(ST_GeomFromText('".$geom."', ".$proj."), 37870), the_geom);";
			$res = pg_query($sql);
			
			$ids = array();
			
			if ($res) {
				if (pg_num_rows($res) > 0) {
					$row = pg_fetch_assoc($res);
					
					$ids[] = $row['ob_mid'];
				}
			}
			
			$def = file_get_contents("/var/www/data/templates/" . $layer . ".map");
			
			if (strpos($def, "#EXPRESSIONS#") != false) {
				$head = substr($def, 0, strpos($def, "#EXPRESSIONS#") + 13);
				$foot = substr($def, strpos($def, "#!EXPRESSIONS#"));
				$cls = "\r\n";
			}
			
			$toAdd = " CLASS\r\n  EXPRESSION {".implode(",", $ids)."}\r\n  STYLE\r\n    WIDTH 1\r\n    OUTLINECOLOR 0 0 0\r\n    COLOR 255 0 0\r\n  END\r\nEND";
			
			$_SESSION['extras'][$layer] = $head . $cls . $toAdd . $foot;
			
			$ms->setLayers(explode(",", $_SESSION['layers']));
			$ms->setExtras($_SESSION['extras']);
			$res = $ms->generateMapFile();
			
			echo json_encode(array("success"=> $res > 0, "sql"=> $sql));
		}

		if ($_POST['action'] == 'getNextFeature') {
			$type = $_POST['type'];
			$coord = explode(", ", $_POST['coord']);
			
			$geom = 'POINT('.$coord[0].' '.$coord[1].')';
			$proj = '3857';
			
			$layer = ($type == 0) ? "ob" : "ko";
			// $row = ($type == 0) ? "ob_mid" : "ko_mid";
			
			// $sql = "SELECT ".$row." FROM layers.".$layer." WHERE ST_Within(ST_Transform(ST_GeomFromText('".$geom."', ".$proj."), 37870), the_geom);";
			$sql = "SELECT ob_id,ST_Extent(ST_Transform(the_geom, 3857)) as extent FROM layers.".$layer." WHERE ST_Within(ST_Transform(ST_GeomFromText('".$geom."', ".$proj."), 37870), the_geom) GROUP BY ob_id;";
			$res = pg_query($sql);
			
			$geom = array();
			$id = 0;
			
			if ($res) {
				if (pg_num_rows($res) > 0) {
					$row = pg_fetch_row($res);
					
					$id = $row[0];
					$geom = $row[1];
					$geom = str_replace("BOX(", "", $geom);
					$geom = str_replace(")", "", $geom);
					$geom = str_replace(",", " ", $geom);
					$geom = explode(" ", $geom);
				}
			}
			
			$colors = array(0=> '255 255 30', 1=> '255 30 255', 2=> '30 255 255', 3=> '255 30 30', 4=> '30 255 30', 5=> '255 255 60', 6=> '255 30 60', 7=> '30 60 255', 8=> '60 255 30', 9=> '90 30 60');
			
			$layer = "katastrske_obcine";
			
			$sql = "SELECT ko_id FROM layers.katastrske_obcine WHERE ob_id='$id'";
			$res = pg_query($sql);
			
			$ko_ids = array();
			
			if ($res) {
				if (pg_num_rows($res) > 0) {
					while($row = pg_fetch_assoc($res)) {
						$ko_ids[rand(0, 9)][] = $row['ko_id'];
					}
				}
			}
			
			$def = file_get_contents("/var/www/data/templates/".$layer.".map");
			
			if (strpos($def, "#EXPRESSIONS#") != false) {
				$head = substr($def, 0, strpos($def, "#EXPRESSIONS#") + 13);
				$foot = substr($def, strpos($def, "#!EXPRESSIONS#"));
				$cls = "\r\n";
			}
			
			$toAdd = array();
			
			for ($i=0; $i<10; $i++) {
				if (isset($ko_ids[$i])) $toAdd[] = " CLASS\r\n  EXPRESSION {".implode(",", $ko_ids[$i])."}\r\n  STYLE\r\n    WIDTH 1\r\n    OUTLINECOLOR 0 0 0\r\n    COLOR ".$colors[$i]."\r\n  END\r\nEND";
			}
			
			$_SESSION['extras'][$layer] = $head . $cls . implode(" ", $toAdd) . $foot;
			
			$_SESSION['layers'] = "ob";
			$ms->setLayers(explode(",", $_SESSION['layers']));
			$ms->setExtras($_SESSION['extras']);
			$res = $ms->generateMapFile();
			
			echo json_encode(array("success"=> $res > 0, "bounds"=> $geom, "sql"=> $sql));
		}

		else if ($_POST['action'] == 'getLayerPositionData') {
			$type = $_POST['type'];
			$coord = explode(", ", $_POST['coord']);
			
			$geom = 'POINT('.$coord[0].' '.$coord[1].')';
			$proj = '3857';
			
			$layer = ($type == 0) ? "ob" : "katastrske_obcine";
			$row = ($type == 0) ? "ob_ime" : "ko_ime";
			
			// $sql = "SELECT ".$row." FROM layers.".$layer." WHERE ST_Within(ST_Transform(ST_GeomFromText('".$geom."', ".$proj."), 37870), the_geom);";
			$sql = "SELECT $row FROM layers.".$layer." WHERE ST_Within(ST_Transform(ST_GeomFromText('".$geom."', ".$proj."), 37870), the_geom);";
			$res = pg_query($sql);
			
			$name = "";
			
			if ($res) {
				if (pg_num_rows($res) > 0) {
					$row = pg_fetch_row($res);
					
					$name = $row[0];
				}
			}
			
			echo json_encode(array("name"=> $name, "sql"=> $sql));
		}
	}
?>