<?php
/*
 * MapServer base CLASS
*
* For all interactions with mapserver & map generation
*
*/
class MapServer
{
	protected $mapfile;
	protected $layers;
	protected $extras;
	protected $path;
	
	public function __construct($mapFileName)
	{
		$this->mapfile = $mapFileName;
		$this->layers = array();
		$this->extras = array();
		$this->path = "/var/www/statview/mape/data/templates/";
	}
	
	public function setLayers($layers) { $this->layers = $layers; }
	public function getLayers() { return $this->layers; }
	public function setExtras($extras) { $this->extras = $extras; }
	public function getExtras() { return $this->extras; }
	
	public function generateMapFile() {
		$saveToFile = array();
		$res = false;
		
		$saveToFile[] = file_get_contents($this->path . "header.map");
		
		foreach ($this->layers as $value) {
			
			if (array_key_exists($value, $this->extras)) {
				$saveToFile[] = $this->extras[$value];
			}
			
			else if (is_file($this->path . $value . ".map")) {
				$saveToFile[] = file_get_contents($this->path . $value . ".map");
			}
		}
		
		$res = file_put_contents($this->mapfile, implode("\r\n\r\n", $saveToFile) . "\r\nEND");
		
		return $res;
	}
}
?>