OpenLayers.IMAGE_RELOAD_ATTEMPTS = 3;

var OL = {
	map: {},
	view: 0,
	layers: '',
	mapfile: '',
	auto: true,
	vector: false,
	mapType: '',
	category: [],
	cX:0,
	cY:0,
	subArea: false,
	zoomLimit: 10
};

var wms = [];
var osm = true;
var tout;
var home = new OpenLayers.LonLat(14.984114741443646, 46.15627738538042).transform('EPSG:4326', 'EPSG:3857');
var iTimer;

var initMap = function() {
	$("#map").empty();
	wms = [];
	
	OL.map = new OpenLayers.Map('map', {
		units: "m",
		projection: "EPSG:3857",
		restrictedExtent: [
	        1474983, 5682329, 1865714, 5929825
	    ],
	    allOverlays: true
	});
	
	if (osm) {
		OL.map.addLayer(new OpenLayers.Layer.OSM('OSM'));
		
		var osmLayer = OL.map.getLayersBy('name', 'OSM')[0];
		OL.map.setLayerIndex(osmLayer, 0);		
	}
	
	// loadBgLayer();
	
	var disableAllControls = function() {
		for (var i = 0; i< OL.map.controls.length; i++) {
			if (OL.map.controls[i].displayClass == "olControlNavigation") {
				OL.map.controls[i].deactivate();
			}
		}
	};        
	        
	disableAllControls();
	
	var split = OL.layers.split(",");
	        
	for (var i=0;i<split.length;i++) {
		wms.push(new OpenLayers.Layer.WMS(
			"StatView",
			"http://episcenter.si/statview/cgi-bin/mapserv.fcgi?MAP="+OL.mapfile,
			{
				layers: split[i],
		        transparent: "true",
		        srs: 'EPSG:3857',
		        format: "image/png"
		    },
		    {
		    	isBaseLayer: false
		    }
		));
		OL.map.addLayer(wms[i]);
		
		if (split[i] != OL.mapType) wms[i].setVisibility(false);
		
		wms[i].events.register("loadstart", wms[i], function() {
	        showLoader();
	    });
	    
	    wms[i].events.register("loadend", wms[i], function() {
	        hideLoader();
	    });
	}
	
	wms[OL.view].redraw(true);
	
	OL.map.setCenter(home, 8);
	reloadWMSLayers();
	setSubAreaId(false);
	
	var dragcontrol = new OpenLayers.Control.DragPan({'map':OL.map, 'panMapDone': function(evt) {
		}
	});
	
	dragcontrol.draw();
			
	OL.map.addControls([
		new OpenLayers.Control.MousePosition({
	    	separator: ' | ',
	    	numDigits: 2,
	    	emptyString: ''
		}),
		dragcontrol
	]);
	
	dragcontrol.activate();
	
	document.getElementById('map').oncontextmenu = function(e){
	 e = e?e:window.event;
	 if (e.preventDefault) e.preventDefault(); // For non-IE browsers.
	 else return false; // For IE browsers.
	};
	
	OL.map.events.register("mousemove", OL.map, function(event) {
		OL.cX = event.xy.x;
		OL.cY = event.xy.y;
		
		if (navigator.userAgent.search("MSIE") >= 0) {
			var offset = (typeof window.pageYOffset !== "undefined") ? window.pageYOffset : (document.documentElement && document.documentElement.scrollTop) || 
	              document.body.scrollTop;
			
			OL.cY -= offset;
		}
		
		var lonlat = OL.map.getLonLatFromPixel(event.xy);
		clearTimeout(tout);
		tout = setTimeout(function() { getMouseEventPosition(lonlat.toShortString()); }, 1000);
	});

	// A control class for capturing click events...
	OpenLayers.Control.Click = OpenLayers.Class(OpenLayers.Control, {
	
		defaultHandlerOptions: {
			'single': true,
			'double': true,
			'pixelTolerance': 0,
			'stopSingle': false,
			'stopDouble': false
		},
		handleRightClicks:true,
		initialize: function(options) {
			this.handlerOptions = OpenLayers.Util.extend(
				{}, this.defaultHandlerOptions
			);
			OpenLayers.Control.prototype.initialize.apply(
				this, arguments
			); 
			this.handler = new OpenLayers.Handler.Click(
				this, this.eventMethods, this.handlerOptions
			);
		},
		CLASS_NAME: "OpenLayers.Control.Click"
	});
	
	
	// Add an instance of the Click control that listens to various click events:
	var oClick = new OpenLayers.Control.Click({
		eventMethods: {
			'rightclick': function(e) {
			},
			'click': function(e) {
				handleZoomEvents(e.xy);
			}
		}
	});
		
	OL.map.addControl(oClick);
	oClick.activate();
	
	getMapOptions();
	getFixData();
};

function loadBgLayer(bgImg) {
	if (typeof OL.map.getLayersBy('name', 'Overlay')[0] !== "undefined") {
		OL.map.removeLayer(OL.map.getLayersBy('name', 'Overlay')[0]);
	}
	
	var bounds = new OpenLayers.Bounds(bgImg.left, bgImg.lower, bgImg.right, bgImg.upper).transform('EPSG:4326', 'EPSG:3857');
	
	var graphic = new OpenLayers.Layer.Image(
        'Overlay',
        'http://episcenter.si/statview/_img/google_bg.png',
        bounds,
        new OpenLayers.Size(bgImg.width, bgImg.height),
        { isBaseLayer: false,
          opacity: 0.9,
          visibility : true,
          maxResolution: 2000
        }, {
			restrictedExtent : bounds,
			minExtent : bounds,
			minExtent : bounds        	
        }
    );
	
	OL.map.addLayer(graphic);
	
	var osmLayer = OL.map.getLayersBy('name', 'Overlay')[0];
	OL.map.setLayerIndex(osmLayer, 1);
};

function getTimeDimension() {

	if ($(".knof").length) {
		var ids = [];
		
		$.each($('.knof'), function(item){
			if ($(this).hasClass("siv")) {
				ids.push($(this).attr("id"));
			}		
		});
		
		return { type: 'months', values: ids.join(",")};
		
	} else if ($("#time_range").length) {
		
		var values = $("#time_range").slider("option", "values");
		
		return { type: 'range', values: timeIds[values[0]] + "," + timeIds[values[1]]};
		
	} else {
		return false;
	}
};

function showFixPositon(index) {
	index++; // Starting with 0
	
	var h = 20;
	var count = 1;
	var id = 0;
	if (!isNaN(index) && index >= 0) { 
		$.each($("#olInnerFix").children(), function(i, value) {
			id = $(value).attr("id");
			if (index == id) {
				$(value).css("background-color", "#cccccc");
				count = i+1;
			}
			else { $(value).css("background-color", "white"); }
		});

		var margin = 0;
		if (count > 2) margin = (h*(count-1)*-1);
		
		$("#olInnerFix").animate({ 'marginTop': margin+'px', }, 500);
	}
	
	$("#olFix").scrollTop(0);
};

var reloadWMSLayers = function() {
	$.each(wms, function(index, value) {
		if (wms[index].getVisibility()) {
			wms[index].redraw(true);
		}
	});
};

function getSubAreaId() {
	return OL.subArea;
};

function setSubAreaId(newId) {
	OL.subArea = newId;
};

function checkImgURL(url) {
    return(url.match(/\.(jpeg|jpg|gif|png)$/) != null);
}

function getPathToRoot() {
	var pathToRoot = "";
	if($('#widget').val() == 'widget') {
		pathToRoot = "../";
		 wLogin();
	}
	
	return pathToRoot;
}

function wLogout() {
	if($('#widget').val() == "widget") {
		wlogout();
	}
}

function updateLayer() {
	var idP = $('input[name=proId]').val();
	var idQ = $('input[name=qId]').val();
	var aId = $('select[name=answId]').val();
	var tipGrafa = 0;

	$.ajax({
		type: 'post',
		url: getPathToRoot() + '_ajax/ajax.mapUpdate.php',
		data: {
			action: 'updateLayer',
			idP: idP,
			idQ: idQ,
			aId: aId,
			type: OL.mapType,
			sub_id: getSubAreaId(),
			time_dimension: getTimeDimension()
		},
		success: function(result) {
			var data = JSON.parse(result);
			
			reloadWMSLayers();
		}
	});
	wLogout();	
}

function getMapOptions() {
	var id = $('input[name=proId]').val();
	var qId = $('input[name=qId]').val();
	var aId = $('select[name=answId]').val();
	var tipGrafa='';
	
	$.each($('.imprevsub'), function(item){
		var stanje = $(this).attr('src').split('_');
		if(stanje[4]=='on.png'){
			tipGrafa=$(this).attr('id');
		}
	});
	tipGrafa = tipGrafa.split('_');
	subId = getSubAreaId();
	
	  $.ajax({
		url: getPathToRoot() + '_ajax/ajax.map.options.php',
 		async: false,
 		type: 'POST',
		data: {
			action: 'loadOptionsJson',
			id_question: qId,
			id_project: id,
			id_answer: aId,
			type: OL.mapType, /*tipGrafa[1],*/
			id_sub: subId,
			time_dimension: getTimeDimension()
		},
	    success: function(response) {
	    	var data = JSON.parse(response);
	    	
	    	var w = 0,
				h = 0,
				opacity = false,
				subLayerSelect = false,
				i = 1,
				bgImg = {},
				footer = {};
		
			$.each(data.options, function(index, value) {
				if (index == "trans_amount") { opacity = value; }
				else if (index == "show_terrain") { updateTerrainVisibility(value); }
				else if (index == "sub_level") { subLayerSelect = value; }
				else if (index == "odmik_levo") { if (isNaN(value)) value = 0; $("#map").parent().css("padding-left", value+"px"); w+= parseInt(value); }
				else if (index == "odmik_desno") { if (isNaN(value)) value = 0;$("#map").parent().css("padding-right", value+"px"); w+= parseInt(value); }
				else if (index == "odmik_spodaj") { if (isNaN(value)) value = 0;$("#map").parent().css("padding-bottom", value+"px"); h+= parseInt(value); }
				else if (index == "odmik_zgoraj") { if (isNaN(value)) value = 0;$("#map").parent().css("padding-top", value+"px"); h+= parseInt(value); }
				
				else if (index == "pot_do_slike") { bgImg.url = value; }
				else if (index == "spodaj_odmik_slike") { bgImg.lower = value; }
				else if (index == "levo_odmik_slike") { bgImg.left = value; }
				else if (index == "zgoraj_odmik_slike") { bgImg.upper = value; }
				else if (index == "desno_odmik_slike") { bgImg.right = value; }
				else if (index == "sirina_slike") { bgImg.width = value; }
				else if (index == "visina_slike") { bgImg.height = value; }
				
				else if (index == "footer_vklop") { footer.enabled = value; }
				else if (index == "vel_footerja") { footer.vel = value; }
				else if (index == "font_footerja") { footer.font = value; }
				else if (index == "poravnava_footerja") { footer.align = value; }
				else if (index == "odmik_footerja") { footer.margin = value; }
				else if (index == "pozicija_footerja") { footer.position = value; }
				else if (index == "pozicija_footerja2") { footer.position2 = value; }
				else if (index == "footer_color_picker") { footer.color = value; }
			
			});
			
			if (footer.enabled == "checked") {

				if (footer.position2 == 'out') {
					var idL = (footer.position == "down") ? "#footerLower" : "#footerText";
					
					if (footer.align == "center") {
						$(idL).html('<center>' + data.text + '</center>').css('width', '100%');
					} else {
						if (footer.align == "right") {
							$(idL).html(data.text).css('float', 'right').css('width', 'auto');
						} else {
							$(idL).html(data.text).css('float', 'left').css('width', 'auto');
						}
					}
					
					$(idL).css('font-family', footer.font).css('font-size', footer.vel)
						.css('margin', footer.margin + 'px').css('color', footer.color); 
				} else {
					
					var hor = (footer.align == "left") ? "left" : "right";
					var ver = (footer.position == "down") ? "bottom" : "top";
					
					var layer = $('<div id="innerFooter" style="height:20px;display:block;position:absolute;'+hor+':'+footer.margin+'px;'+ver+':'+footer.margin+'px;">'+data.text+'</div>');
			
					if (footer.align == 'center') layer.css({left:'50%','margin': '0 0 0 -'+(layer.width() / 2)+'px'});
			
					$("#map").append(layer.css('font-family', footer.font).css('font-size', footer.vel)
						.css('margin', '0 ' + footer.margin + 'px').css('color', footer.color).css('z-index', 99));
				}
			}
			
			if (!isNaN(opacity)) updateTerrainOpacity(opacity);
			updateAutoSelectSubLayer(subLayerSelect);
			
			var pw = $("#map").parent().width();
			var ph = $("#map").parent().height();
			
			if (w > pw-200) w = pw-200;
			if (h > ph-200) h = ph-200;
			
			$("#map").width((pw-w)+"px");
			$("#map").height((ph-h)+"px");
			
			updateMapSize();
			reloadWMSLayers();
			
			if (typeof bgImg.url !== "undefined") {
				if (checkImgURL(bgImg.url)) {
					loadBgLayer(bgImg);
				}
			}
	    }
	});
	
	wLogout();
};

function updateFooter() {
	getFooter();
}

function getFooter() {
	
	$("#footerLower").empty();
	$("#footerText").empty();
	$("#innerFooter").remove();
	
	var id = $('input[name=proId]').val();
	var qId = $('input[name=qId]').val();
	var aId = $('select[name=answId]').val();
	var tipGrafa='';
	
	$.each($('.imprevsub'), function(item){
		var stanje = $(this).attr('src').split('_');
		if(stanje[4]=='on.png'){
			tipGrafa=$(this).attr('id');
		}
	});
	tipGrafa = tipGrafa.split('_');
	subId = getSubAreaId();
	
	  $.ajax({
		url: getPathToRoot() + '_ajax/ajax.map.options.php',
 		async: false,
 		type: 'POST',
		data: {
			action: 'loadOptionsJson',
			id_question: qId,
			id_project: id,
			id_answer: aId,
			type: OL.mapType,
			id_sub: subId,
			time_dimension: getTimeDimension()
		},
	    success: function(response) {
	    	var data = JSON.parse(response);
	    	
	    	var footer = {};
		
			$.each(data.options, function(index, value) {
				if (index == "footer_vklop") { footer.enabled = value; }
				else if (index == "vel_footerja") { footer.vel = value; }
				else if (index == "font_footerja") { footer.font = value; }
				else if (index == "poravnava_footerja") { footer.align = value; }
				else if (index == "odmik_footerja") { footer.margin = value; }
				else if (index == "pozicija_footerja") { footer.position = value; }
				else if (index == "pozicija_footerja2") { footer.position2 = value; }
				else if (index == "footer_color_picker") { footer.color = value; }
			
			});
			
			if (footer.enabled == "checked" || footer.checked == "on") {

				if (footer.position2 == 'out') {
					var idL = (footer.position == "down") ? "#footerLower" : "#footerText";
					
					if (footer.align == "center") {
						$(idL).html('<center>' + data.text + '</center>').css('width', '100%');
					} else {
						if (footer.align == "right") {
							$(idL).html(data.text).css('float', 'right').css('width', 'auto');
						} else {
							$(idL).html(data.text).css('float', 'left').css('width', 'auto');
						}
					}
					
					$(idL).css('font-family', footer.font).css('font-size', footer.vel)
						.css('margin', footer.margin + 'px').css('color', footer.color); 
				} else {
					
					var hor = (footer.align == "left") ? "left" : "right";
					var ver = (footer.position == "down") ? "bottom" : "top";
					
					var layer = $('<div id="innerFooter" style="height:20px;display:block;position:absolute;'+hor+':'+footer.margin+'px;'+ver+':'+footer.margin+'px;">'+data.text+'</div>');
					
					if (footer.align == 'center') layer.css({left:'50%','margin': '0 0 0 -'+(layer.width() / 2)+'px'});
					
					$("#map").append(layer.css('font-family', footer.font).css('font-size', footer.vel)
						.css('margin', '0  ' + footer.margin + 'px').css('color', footer.color).css('z-index', 99));
				}
			}
	    }
	});
	
	wLogout();
};

function getTipGrafa() {
	var tipGrafa = 0;

	$.each($('.imprevsub'), function(item){
		var stanje = $(this).attr('src').split('_');
		if(stanje[4]=='on.png') {
			tipGrafa=$(this).attr('id');
		}
	});

	tipGrafa = tipGrafa.split('_');
	
	return tipGrafa[1] - 1;
}

var handleZoomEvents = function(xy) {
	var lonlat = OL.map.getLonLatFromPixel(xy);
	var coord = lonlat.toShortString();
	
	if (OL.auto) {
		wms[OL.view].setVisibility(false);
		showLoader();
		
		getNextFeature(coord);
	} else {
		$(".pop-select").remove();

		var layers = OL.layers.split(',');
		var items = "";
		
		var texts = ["Regije", "Občine", "Volilne enote", "Volilni okraji"];

		if (layers.length > 1) {
			for (var i=0; i<layers.length; i++) {
				var ind = 0;
				if (layers[i] == "ob") ind = 1;
				else if (layers[i] == "ve") ind = 2;
				else if (layers[i] == "vo") ind = 3;
				
				// if (ind != OL.view) {
					items += "<li onClick=\"showLayerByPosition('"+layers[i]+"','"+coord+"');\">"+texts[ind]+"</li>";
				// }
			}

			$("#map").prepend('<div id="sub-select" class="pop-select"><ul>'+items+'</ul></div>');

			var xx = xy.x + $("#map").position().left;
			var yy = xy.y + $("#map").position().top;

			$("#sub-select").css("left", xx+"px").css("top", yy+"px");

			$("#sub-select").click(function() {
				$(".pop-select").remove();
			});
		} else {

			if (OL.map.getZoom() >= OL.zoomLimit) {
				OL.map.zoomToMaxExtent();
				OL.map.zoomTo(OL.map.getZoom() + 1);
			} else {
				OL.map.zoomTo(OL.map.getZoom() + 2);
			}
		}
	}
};

function showLayerByPosition(newType, coord) {
	wms[OL.view].setVisibility(false);

	getNextFeature(coord, newType);
};

function getNextFeature(coord, newType) {
	var center = coord.split(", ");
	center = new OpenLayers.LonLat(center[0], center[1]);
	
	var idP = $('input[name=proId]').val();
	var idQ = $('input[name=qId]').val();
	var aId = $('select[name=answId]').val();

	showLoader();
	var zoomable = (OL.map.getZoom() <= OL.zoomLimit) ? true : false;
	
	$.ajax({
		type: 'post',
		url: getPathToRoot() + '_ajax/ajax.mapUpdate.php',
		data: {
			action: 'getNextFeature',
			coord: coord,
			type: OL.mapType,
			zoom: zoomable,
			idP: idP,
			idQ: idQ,
			aId: aId,
			sub_id: getSubAreaId(),
			newType: (typeof newType !== "undefined") ? newType : false,
			startType: getTipGrafa(),
			time_dimension: getTimeDimension()
		},
		success: function(result) {
			var data = JSON.parse(result);
			
			if (data.sub === false) {
				if (data.zoomIn) {
					OL.map.zoomTo(OL.map.getZoom() + 2);
					OL.map.setCenter(center);
				} else if (data.maxExtent) {
					OL.map.zoomToMaxExtent();
					OL.map.zoomTo(OL.map.getZoom() + 1);
				}
				
			} else if (data.manual) {
				OL.view = data.view;
				OL.mapType = data.mapType;
				
				setSubAreaId(data.subId);
				
				if (data.ime !== false) {
					$("#olSel").html('<p>' + data.ime + '</p>');
				}
				
				if (data.legend !== false) {
					$("#legend").empty();
					$("#legend").html(data.legend);
				}
				
				OL.map.zoomToMaxExtent();
				OL.map.zoomTo(OL.map.getZoom() + 1);
				
				getFixData();
			}
			 else {
				var fix = (OL.view !== data.view) ? true : false;
	
				OL.view = data.view;
				OL.mapType = data.mapType;
				
				wms[OL.view].redraw(true);
				wms[OL.view].setVisibility(true);
				
				if (data.ime !== false) {
					$("#olSel").html('<p>' + data.ime + '</p>');
				}
				
				if (data.legend !== false) {
					$("#legend").empty();
					$("#legend").html(data.legend);
				}
				
				setSubAreaId(data.subId);
				
				if (data.zoomIn) {
					OL.map.zoomTo(OL.map.getZoom() + 2);
					OL.map.setCenter(center);
				}
				else {
					if (data.maxExtent) {
						OL.map.zoomToMaxExtent();
						OL.map.zoomTo(OL.map.getZoom() + 1);
					} else {
						var bounds = new OpenLayers.Bounds(data.bounds[0], data.bounds[1], data.bounds[2], data.bounds[3]);
						OL.map.zoomToExtent(bounds);
					}
				}
				
				getFixData();
				
			}
			
			wms[OL.view].setVisibility(true);
			hideLoader();
		}
	});
	
	wLogout();
}

function getMouseEventPosition(coord) {
	var idP = $('input[name=proId]').val();
	var idQ = $('input[name=qId]').val();
	var aId = $('select[name=answId]').val();
	var tipGrafa = 0;

	$.each($('.imprevsub'), function(item){
		var stanje = $(this).attr('src').split('_');
		if(stanje[4]=='on.png') {
			tipGrafa=$(this).attr('id');
		}
	});

	tipGrafa = tipGrafa.split('_');

	$.ajax({
		type: 'post',
		url: getPathToRoot() + '_ajax/ajax.mapUpdate.php',
		data: {
			action: 'getLayerPositionData',
			coord: coord,
			mapType: OL.mapType,
			idP: idP,
			idQ: idQ,
			aId: aId,
			tipGrafa: tipGrafa[1],
			sub_id: getSubAreaId(),
			time_dimension: getTimeDimension()
		},
		success: function(result) {
			var data = JSON.parse(result);
				
			if (data.name !== "") {
				showInfo('<div style="margin-left:5px;">' + data.name + '</div><div style="margin-left:5px;">Število: ' + data.data.num + '</div><div style="margin-left:5px;">Odstotek: ' + data.data.proc + ' %</div>');
				iTimer = setTimeout(function() { clearInfo(); }, 2000);

				$("#olInfo").mouseover(function() {
					clearTimeout(iTimer);
				});
				
				$("#olInfo").mouseout(function() {
					iTimer = setTimeout(function() { clearInfo(); }, 1000);
				});
			}
			
			else clearInfo();
			
			if (!$('#sub-select').is(':visible')) {
				showFixPositon((data.id === false ? 0 : data.id - 1));
			} else {
				clearTimeout(iTimer);
				clearInfo();
			}
		}
	});
	wLogout();	
}

function getFixData() {
	var idP = $('input[name=proId]').val();
	var idQ = $('input[name=qId]').val();
	var aId = $('select[name=answId]').val();
	var tipGrafa = 0;

	$.each($('.imprevsub'), function(item){
		var stanje = $(this).attr('src').split('_');
		if(stanje[4]=='on.png') {
			tipGrafa=$(this).attr('id');
		}
	});

	tipGrafa = tipGrafa.split('_');
	
	$.ajax({
		type: 'post',
		url: getPathToRoot() + '_ajax/ajax.mapUpdate.php',
		data: {
			action: 'getFixLayerData',
			mapType: OL.mapType,
			idP: idP,
			idQ: idQ,
			aId: aId,
			tipGrafa: tipGrafa[1],
			sub_id: getSubAreaId(),
			time_dimension: getTimeDimension()
		},
		success: function(result) {
			var data = JSON.parse(result);
			
			$("#olInnerFix").empty();
	
			$.each(data.items, function(index, value) {
				$("#olInnerFix").append("<div id='"+index+"' style='height:20px'>"+value.name+" -> "+value.proc+" %</div>");
			});
		}
	});
	
	wLogout();
}

function showLoader() {
	$(".loader").css("display", "block");
}

function hideLoader() {
	$(".loader").css("display", "none");
}
 
function exportMap() {
	var idP = $('input[name=proId]').val();
	var idQ = $('input[name=qId]').val();
	var aId = $('select[name=answId]').val();
	var tipGrafa = 0;
   		
	$.each($('.imprevsub'), function(item) {
		var stanje = $(this).attr('src').split('_');
		if(stanje[4]=='on.png'){
			tipGrafa=$(this).attr('id');
		}
	});
	
	tipGrafa = tipGrafa.split('_');
		 
	var layer = OL.layers.split(',')[OL.layers.split(",").indexOf(OL.mapType)];
	var extent = OL.map.getExtent().toArray();
		 
	$.ajax({
		type: 'post',
		url: getPathToRoot() + '_ajax/ajax.mapUpdate.php',
		data: {
			action: 'generateExportImage',
			mapType: OL.mapType,
			idP: idP,
			idQ: idQ,
			aId: aId,
			tipGrafa: tipGrafa[1],
			type: OL.layers.split(",").indexOf(OL.mapType),
			layers: OL.layers,
			sub_id: getSubAreaId(),
			url: 'http://episcenter.si/statview/cgi-bin/mapserv?MAP='+OL.mapfile+'&LAYERS='+layer+'&TRANSPARENT=false&SRS=EPSG%3A3857&FORMAT=image%2Fjpeg&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&BBOX='+extent.join(",")+'&WIDTH=590&HEIGHT=400'
		},
		success: function(result) {
			var data = JSON.parse(result);
			window.open(data.path, '_blank');
		}
	});
	
	wLogout();
};
   
function updateTerrainOpacity(value) {
	if (!isNaN(value)) {
		value /= 100;

		var osm = OL.map.getLayersBy('name', 'OSM')[0];
		osm.setOpacity(value);
	}
}
   
function updateTerrainVisibility(value) {
	var osm = OL.map.getLayersBy('name', 'OSM')[0];

	if (value == "on" || value == true) {
		osm.setVisibility(true);
	} else {
		osm.setVisibility(false);
	}
}
   
function updateAutoSelectSubLayer(value) {
	if (value == "on" || value == true) {
		OL.auto = true;
	} else {
		OL.auto = false;
	}
}

function updateMapSize() {
	setTimeout(function() { OL.map.updateSize(); }, 200);
};

function clearInfo() {
	var dd = document.getElementById("olInfo");
	dd.style.display = "none";
};

function showInfo(d) {
	if(d.length < 1) { return; }
	var dd = document.getElementById("olInfo");
	$(dd).html(d);
	assignPosition(dd);
	dd.style.display = "block";
};

function hideInfo() {
	var dd = document.getElementById("olInfo");
	dd.style.display = "none";
};

function assignPosition(d) {
	if(self.pageYOffset) {
		rX = self.pageXOffset;
		rY = self.pageYOffset;
	}

	else if(document.documentElement && document.documentElement.scrollTop) {
		rX = document.documentElement.scrollLeft;
		rY = document.documentElement.scrollTop;
	}

	else if(document.body) {
		rX = document.body.scrollLeft;
		rY = document.body.scrollTop;
	}

	if(document.all) { OL.cX += rX; OL.cY += rY; }

	d.style.left = (OL.cX + 10) + "px";
	d.style.top = (OL.cY + 10) + "px";
};