<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."_config/dbConfig.php");
include_once(PATH_TO_ROOT."statview/init.php");
include_once(PATH_TO_ROOT."statview/_class/class.forms.php");
include_once(PATH_TO_ROOT.'statview/_class/class.chartData.php');

$forms = new FormsEvents($db);

$chartType =  $forms->cleanInput($_GET['type']);
$subType =  $forms->cleanInput($_GET['subType']);
$idQuestion =  $forms->cleanInput($_GET['idQuestion']);
$idCross =  $forms->cleanInput($_GET['idCross']);
$idProject =  $forms->cleanInput($_GET['idProject']);

$chartData = new ChartData($db, $chartType, $subType, $idQuestion, $idCross, $idProject);
$qType = $chartData->getQuestionType();
?>

$(function () {
	var graf = new Highcharts.Chart({
    	chart: {
			renderTo: 'container',
            backgroundColor: '#F6F5F0',
            animation: false,
            shadow: false
        },
        title: {
	        text: ''
	    },
        xAxis: {
            title: {
	    		text: ''
	    	},
	    	labels: {
	        	overflow: false
	        } 
        },
        yAxis: {
            min: 0,
	        title: { 
	        	text: '' 
	    	}
        },
        legend: {
            align: 'right',
	        floating: true,
	        layout: 'vertical',
	        verticalAlign: 'top',
	        enabled: false,
	        borderWidth: 0
        },
        series: [],
        plotOptions: {
        	pie: {
	            allowPointSelect: true,
	            cursor: 'pointer',
	            dataLabels: {
	                enabled: false
	            }
	    	}
        },
        navigation: {
            buttonOptions: {
                enabled: false
            }
        },
        credits: {
            enabled: false
        },
        
        //tega grafa ni mogoče izrisati brez križanja
        chartWarning1: function() {
        	graf.setTitle({ text: 'This chart cannot be drawn without crossing question selected' });
        },
        
        //tega grafa ni mogoče izrisati z križanjem
        chartWarning2: function() {
        	graf.setTitle({ text: 'This chart cannot be drawn with crossing question selected' });
        },
        
        //pie1 nastavitve
		pieSettings1: function() {
	    	graf.legend.options.labelFormatter = function() {
	            return this.name;
	        };
	    	graf.render();
	    },
	   
	    //pie2 nastavitve
		pieSettings2: function() {
			graf.margin[0] = 150;
	    	graf.options.plotOptions.pie.startAngle = -90;
	    	graf.options.plotOptions.pie.endAngle = 90;
			graf.options.plotOptions.pie.allowPointSelect = false;
			graf.options.plotOptions.pie.slicedOffset = 10;
	    	graf.legend.options.labelFormatter = function() {
	            return this.name;
	        };
	    	graf.render();
	    },
	    
	    //pie3 nastavitve
	    pieSettings3: function() {
	    	graf.options.plotOptions.pie.allowPointSelect = false;
		    graf.options.plotOptions.pie.dataLabels.enabled = true;
		    graf.options.plotOptions.pie.showInLegend = false;
		    graf.options.plotOptions.pie.shadow = false;
		    graf.options.plotOptions.pie.center = ['50%', '50%'];
		    graf.render();
	    },
        
        //column2 nastavitve
		columnSettings2: function() {
	    	graf.options.plotOptions.column.stacking = 'normal';
	    	graf.options.plotOptions.bar.stacking = 'normal';
	    	graf.yAxis[0].options.stackLabels.enabled = false;
	    	graf.render();
	   },
	    
	    //column3 nastavitve
		columnSettings3: function() {
	    	graf.options.plotOptions.column.stacking = 'percent';
	    	graf.options.plotOptions.bar.stacking = 'percent';
	    	graf.yAxis[0].options.stackLabels.enabled = false;
	    	graf.render();
	   },
	    
	    //line nastavitve
		lineSettings: function(){
	    	graf.yAxis[0].options.startOnTick = false;
	    	graf.yAxis[0].options.endOnTick = false;
    	  	graf.yAxis[0].options.lineWidth = 1;
    	  	graf.yAxis[0].options.gridLineWidth = 0;
	    	graf.xAxis[0].update({ tickmarkPlacement: 'on' });
	    	graf.xAxis[0].update({ labels: { y: 25 } });
	    	graf.legend.options.symbolPadding = 15;
	    	graf.legend.options.symbolWidth = 0;
	    	graf.render();
	    }
    });
    
    var questionType = <?php echo $qType; ?>;
    var chartType = '<?php echo $chartType; ?>';
	var subType = <?php echo $subType; ?>;
	var idCross = '<?php echo $idCross; ?>';
	var crossing = (idCross == '' ? false : true);
    
    //init chart data and settigs
    $.ajax({
    	url: '_ajax/ajax.chartData.php',
    	type: 'POST',
    	data: {
    		type: '<?php echo $chartType; ?>',
    		subType: '<?php echo $subType; ?>',
    		idQuestion: '<?php echo $idQuestion; ?>',
    		idCross: '<?php echo $idCross; ?>',
    		idProject: '<?php echo $idProject; ?>' 
    	},
    	success: function(res) {
    		//single in multi vprašanja
    		if (questionType != 2) {
	    		//pie
	    		if (chartType == 'pie') {
					if (subType == 1) {
						if (crossing) {
							graf.options.chartWarning2();
						} else {
							graf.options.pieSettings1();
							drawChart(res);
						}		
					}
					else if (subType == 2) {
						if (crossing) {
							graf.options.chartWarning2();
						} else {
							graf.options.pieSettings2();
							drawChart(res);
						}
					}
					else if (subType == 3) {
						if (!crossing) {
							graf.options.chartWarning1();
						} else {
							graf.options.pieSettings3();
							drawChart(res);
						}
					}
				}
				//column
				else if (chartType == 'column') {
					if (subType == 1) {
						drawChart(res);
					} else if (subType == 2) {
						if (!crossing) {
							graf.options.chartWarning1();
						} else {
							graf.options.columnSettings2();
							drawChart(res);
						}
					} else if (subType == 3) {
						if (!crossing) {
							graf.options.chartWarning1();
						} else {
							graf.options.columnSettings3();
							drawChart(res);
						}
					}
				}
				//line
				else if (chartType == 'line') {
					if (subType == 2 || subType == 3) {
						if (!crossing) {
							graf.options.chartWarning1();
						} else {
							graf.options.lineSettings();
							drawChart(res);
						}
					} else {
						graf.options.lineSettings();
						drawChart(res);
					}
				}
			}
			
			//scale vprašanja
			else if (questionType == 2) {
				if (chartType == 'pie') {
					if (subType == 1) {
						graf.options.pieSettings1();
					} else if (subType == 2) {
						graf.options.pieSettings2();
					} else if (subType == 3) {
						graf.options.pieSettings3();
					}
				}
				drawChart(res);
			}
    	}
    });
    
    function drawChart(data) {
		var data = JSON.parse(data);
		
		//legenda grafa
		if (typeof data.options.legendEnable !== 'undefined' || typeof data.options.pieLegendEnable !== 'undefined') {
            graf.options.legend["enabled"] = true;
		}
		
		//nastavitve pred izrisu
		if (typeof data.options.beforeLoad !== 'undefined') {
			for (var i = 0; data.options.beforeLoad.length > i; i++) {
				eval(data.options.beforeLoad[i]);
			}
		}
		
		graf.xAxis[0].setCategories(data.xLabels);
		
		for (var i = 0; data.series.length > i; i++) {
			graf.addSeries(data.series[i]);
		}
		
		//nastavitve po izrisu
		if (typeof data.options.afterLoad !== 'undefined') {
			for (var i = 0; data.options.afterLoad.length > i; i++) {
				eval(data.options.afterLoad[i]);
			}
		}
		
		//nastavitve po izrisu - update
		if (typeof data.options.afterLoadUpdate !== 'undefined') {
			for (var i = 0; data.options.afterLoadUpdate.length > i; i++) {
				eval(data.options.afterLoadUpdate[i]);
			}
		}
    }
});

