<?php
include_once("_dirinfo.php");
$sessionHandling = true;
include_once(PATH_TO_ROOT."_config/dbConfig.php");
include_once(PATH_TO_ROOT."statview/_class/class.forms.widget.php");
include_once(PATH_TO_ROOT."statview/_class/class.selector.php");

$widget = new Widget($db);
$sel = new Selector($db);
$form = new FormsEvents($db);
$language = configLoader::loadLanguage(1,'language','default_admin','widgeti',DB_WARPIT_STATVIEW);
?>

 <div class="naslov-new"><h1><?php echo $form->cleanOutput($language['widgeti']); ?></h1></div>
 <div id="crta" style="margin-top: 10px;"></div>
 
 <div class="table-responsive">
    <table id="WidgetsTable" class="table table-striped table-hover" width="100%" >
        <thead>
            <tr>
               <th>#ID</th>
               <th><?php echo $form->cleanOutput($language['widgeti_title']); ?></th>       
               <th><?php echo $form->cleanOutput($language['widgeti_project']); ?></th>
               <th><?php echo $form->cleanOutput($language['widgeti_code']); ?></th>
               <th><?php echo $form->cleanOutput($language['widget_author']); ?></th>
               <th><?php echo $form->cleanOutput($language['widgeti_published']); ?></th>
               <?php
                   if (in_array('delete_widget', $_SESSION['UserPermissions'])) {
                       echo '<th>'.$form->cleanOutput($language['widgeti_delete']).'</th>';
                   }
               ?>
            </tr>
        </thead>
        <tbody>
            <?php echo $widget->makeWidgetsList($_SESSION['UserInfo']['id'], $_SESSION['UserInfo']['group'], 0); ?>
        </tbody>
    </table>
</div>

<script src="../statview/_javascript/spectrum.js"></script>
<script>
$(document).ready(function() {
    $('#WidgetsTable').dataTable({
        "language": { "url": "_javascript/dataTables.slo.lang.php"},
        "order": [[ 1, "asc" ]],
        "pageLength": 7,
        <?php
           if (in_array('delete_widget', $_SESSION['UserPermissions'])) {
               echo '"aoColumns": [null, null, null, null, null, null, { "bSortable": false }],';
           } 
        ?>
        "initComplete": function(settings, json) {
			$(".table-responsive").find("[type=search]").attr("maxlength", 50);
		},
		"columnDefs": [
            { "type": "string-case", targets: 1 },
            { "type": "string-case", targets: 2 },
            { "type": "string-case", targets: 4 }
        ]
    });
    
    $("#WidgetsTable").on("draw.dt", function () {
        var opt = $("[name='WidgetsTable_length']").find('option');

        var append = true;
        $.each(opt, function (i, val) {
            if ($(val).val() == 7) {
                append = false;
            }  
        });
        
        if (append === true) {
            $("[name='WidgetsTable_length']").append($("<option>", {
                value: 7,
                text: "7"
            }));
            $("[name='WidgetsTable_length']").val("7");
        }
    });
});

//izbris widgeta
function deleteWidget(widgetId) {
    var html = CallScript('_ajax/ajax.forms.php', {action:'getDeleteWidgetDialog', wTitle: widgetTitle, formParameters: null}, '');
    modal.open({content:html});
    rdyFunctions();   
}

var widgetRow = '';
var widgetId = 0;
var widgetTitle = '';

$('#WidgetsTable').on('click', 'tr', function() {
    widgetRow = $(this);
    widgetId = parseInt($(this).find("#wId").html());
    widgetTitle = $(this).find("h5").html();
    if (widgetTitle.slice(-1) == "?") { widgetTitle = widgetTitle.replace("?", ""); }
});

$(".if-tb").click(function() {
    $(this).select();
}); 

$('body').on('click', '#closeNonM', function() {
    modal.close();
});
</script>

<style>
    .project-question {
        margin-top: 10px;
    }
    
    .if-tb {
        height: 51px;
        width: 300px;
        font-size: 12px;
    }
    
    /* predogled widgeta */
    iframe {
        height: 600px;
        width: 83%;
        padding-bottom: 50px;
        padding-right: 10px;
    }
    
    #modal {
        width: auto;
        height: auto;
    }
</style>
