<?php
if (!isset($_SESSION['UserInfo']['language'])) {
	$_SESSION['UserInfo']['language'] = "46"; //default jezik za login je ang.
}
$language = configLoader::loadLanguage(1,'language','default_admin','login',DB_WARPIT_STATVIEW);
?>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sl-si" lang="sl-si" class="ozadje" >
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>Statview | Login</title>
		<link href="<?php echo PATH_TO_ROOT;?>statview/_css/main.css" rel="stylesheet" type="text/css" />
		<link href="<?php echo PATH_TO_ROOT;?>statview/_css/login_style.css" rel="stylesheet" type="text/css" />
		<script type="text/javascript" src="<?php echo PATH_TO_ROOT;?>statview/_javascript/jquery.js"></script>
	</head>

	<body>
		<div id="stranp">
	    	<div id="logo_rest_t">
	      		<div class="logo" style="margin-left:16%;"></div>
	      		<div class="logo_sr">StatView ∙ <?php echo $language['login']; ?></div>
	      		<div class="lng_sel">
	      			<label id="91" class="lng">SL</label> | <label id="46" class="lng">EN</label>
	      		</div>
	    	</div>

	    	<div id="logo_rest_b">
	      		<div class="sd_l">
	      		</div>
	      		<div class="sd_r">
	      			<label id="loginFail"></label>
	      			<form id="loginForm">
	      				<input name="user" id="username" type="text" placeholder="<?php echo $language['loginEma'];?>" required="true" maxlength="50" /><br />
	      				<input name="pass" id="password" type="password" placeholder="<?php echo $language['loginPass'];?>"required="true" maxlength="50"/>
	      			</form>
	      			<div id="cntrl">
		      			<a href="?passwordReset=1" style="color:#3c6a80;font-size:16px;"><?php echo $language['loginFPass'];?></a>
		      			<button type="submit" form="loginForm" class="shrani"><?php echo $language['loginGoButtn'];?></button>
	      			</div>
	      		</div>
	    	</div>
	  	</div>

	<script>
		$(function() {
			$("#username").focus();
		});

		$("#loginForm").submit(function(e) {
			e.preventDefault();

			$.ajax({
	     		url: "<?php echo PATH_TO_ROOT;?>statview/_ajax/ajax.Login.php",
	     		method: "POST",
	     		data: "action=login&survey=&" + $("#loginForm").serialize(),
	     		success: function(data) {
	     			if (data == "true") {
	     				$("#loginFail").hide();
	 					document.location = "index.php";
	     			} else {
						$("#loginFail").show();
						$("#loginFail").text("<?php echo $language['login_err1']; ?>");
	     			}
	  			}
	     	});
		});

		$(".lng").click(function() {
			var lng = $(this).attr("id");

			$.ajax({
	     		url: "<?php echo PATH_TO_ROOT;?>statview/_ajax/ajax.Login.php",
	     		method: "POST",
	     		data: "action=lngChange&lng=" + lng,
	     		success: function() {
	     			location.reload();
	  			}
	     	});
		});
	</script>
	</body>
</html>