<?php
if (!isset($_SESSION['UserInfo']['language'])) {
	$_SESSION['UserInfo']['language'] = "46"; //default jezik za login je ang.
}
$language = configLoader::loadLanguage(1,'language','default_admin','login',DB_WARPIT_STATVIEW);
?>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sl-si" lang="sl-si" class="ozadje" >
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>Statview | Set Password</title>
		<link href="<?php echo PATH_TO_ROOT;?>statview/_css/main.css" rel="stylesheet" type="text/css" />
		<link href="<?php echo PATH_TO_ROOT;?>statview/_css/login_style.css" rel="stylesheet" type="text/css" />
		<script type="text/javascript" src="<?php echo PATH_TO_ROOT;?>statview/_javascript/jquery.js"></script>
	</head>
	
	<body>
		<div id="stranp">
	    	<div id="logo_rest_t">
	      		<div class="logo" style="margin-left:16%;"></div>
	      		<div class="logo_sr">StatView ∙ <?php echo $language['password_reset']; ?></div>
	      		<div class="lng_sel">
	      			<label id="91" class="lng">SL</label> | <label id="46" class="lng">EN</label> 
	      		</div>
	    	</div>
	    	
	    	<div id="logo_rest_b">
	      		<div class="sd_l">
	      			<img width="320px" src="<?php echo PATH_TO_ROOT;?>statview/_img/faktorplus_logo.png">
	      		</div>
	      		<div class="sd_r">
	      			<label id="loginFail"></label>
	      			<form id="loginForm">
	      				<input name="pass_1" id="pass_1" type="password" placeholder="<?php echo $language['loginPass'];?>"required="true" maxlength="50"/><br />
	      				<input name="pass_2" id="pass_2" type="password" placeholder="<?php echo $language['loginPass_repeat'];?>"required="true" maxlength="50"/>
	      			</form>
	      			<div id="cntrl">
		      			<button type="submit" id="resetBtn" form="loginForm" class="shrani"><?php echo $language['forgotenPass_btn']; ?></button>
	      			</div>
	      		</div>
	    	</div>
	  	</div>
	  	
	<script>
		$("#loginForm").submit(function(e) {
			e.preventDefault();
			
			if (checkPasswords($("#pass_1").val(), $("#pass_2").val())) {
				$.ajax({
		     		url: "<?php echo PATH_TO_ROOT;?>_ajax/ajax.password.reset.php",
		     		data: {
		     			action: "updatePassword",
		     			email: getUrlVars().user,
		     			password: $("#pass_2").val()
		     		},
		     		success: function(resp) {
		     			var data = JSON.parse(resp);
		     			$("#loginFail").show();
		     			
		     			if (data.success === true) {
		     				$("#loginFail").html("<?php echo $language['pass_reset_succ']; ?> <a href='index.php'><?php echo $language['login']; ?></a> <?php echo $language['into_system']; ?>");
		     				disableForm();
		     			} else {
		     				if (data.expired) {
		     					$("#loginFail").text("<?php echo $language['pass_reset_err4']; ?>");
		     					disableForm();
		     				}
		     				else if (data.nouser) {
		     					$("#loginFail").text("<?php echo $language['pass_reset_err5']; ?>");
		     					disableForm();
		     				}
		     				else {
		     					$("#loginFail").text("<?php echo $language['pass_reset_err6']; ?>");
		     				}
		     			}
		  			}
		     	});				
			}
		});
		
		function disableForm() {
			$("#pass_1").val("");
			$("#pass_2").val("");
			$('#pass_1').prop("disabled", true);
			$('#pass_2').prop("disabled", true);
			$('#resetBtn').prop("disabled", true);
		}
		
		function getUrlVars() {
		    var vars = {};
		    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m, key, value) {
		        vars[key] = value;
		    });
		    return vars;
		}
		
		function checkPasswords(pass1, pass2) {
			if (pass1.length === 0 || pass2.length === 0) {
				return false;
			}
			if (pass1 !== pass2) {
				return false;
			}
			return true;
		}
		
		$(".lng").click(function() {
			var lng = $(this).attr("id");
			
			$.ajax({
	     		url: "<?php echo PATH_TO_ROOT;?>_ajax/ajax.Login.php",
	     		method: "POST",
	     		data: "action=lngChange&lng=" + lng,
	     		success: function() {
	     			location.reload();
	  			}
	     	});
		});
	</script>
	</body>
</html>