<?php
/**
 * UserAuthenticate and Session system
 *
 */
 
class UserSession {
	
	private $db; // class to database connection
	private $UserAgent; // user agent user is using
	private $php_session_id; // 32 character ascii string created by php
	private $native_session_id; // autoincrement id in database
	private $logged_in; // if user is looged in
	private $sessionTimeOut = 6000; // 10 minutes session timeout
	private $userGroup;
	//private $sessionTimeOut = 60; // 0.1 minutes session timeout
	
	/**
	 * Main constructor where  save handler and database connection is set
	 *
	 * @param object $db
	 */
	public function __construct($db) { 
		$this->db = $db;
		session_set_save_handler(
			array(&$this, '_session_open_method'),
			array(&$this, '_session_close_method'),
			array(&$this, '_session_read_method'),
			array(&$this, '_session_write_method'),
			array(&$this, '_session_destroy_method'),
			array(&$this, '_session_gc_method')		
		);
		$this->UserAgent = @$GLOBALS["HTTP_USER_AGENT"];
		session_name("RMPlusWarpit"); 
		session_start();
	}
	
	/**
	 * called by session_start(.
	 *
	 * @param unknown_type $save_path
	 * @param unknown_type $session_name
	 * @return unknown
	 */
	function _session_open_method($save_path,$session_name) {
		return (true);
	}
	
	/**
	 * called at page end
	 *
	 * @return unknown
	 */
	function _session_close_method() {
		return (true);
	}
	
	/**
	 * called after session_start() 
	 * id is 32 character session ID produced by php system
	 * @param char $id
	 * @return unknown
	 */
	function _session_read_method($id) {
		$this->php_session_id = $id;

		$result = $this->db->SQLexecute("SELECT a.id, logged_in ,id_user,user_type, variable_value, TIME_TO_SEC( TIMEDIFF( NOW( ) , `last_impression` ) )  as diff											
											FROM  ".DB_WARPIT_STATVIEW."._user_session AS a 
												LEFT JOIN ".DB_WARPIT_STATVIEW."._session_variable AS b ON a.id = b.id_session 
													WHERE id_ascii_session = '".$this->php_session_id."'");		
		
		
		
		if ($this->db->NumRows($result)) {
			$data = $this->db->fetchAssoc($result);
						
			// checking for session timeout
			// if condition is true, session record is updated with reset data
			if ( $data['diff'] > $this->sessionTimeOut ) { $this->db->SQLexecute("UPDATE ".DB_WARPIT_STATVIEW."._user_session SET last_impression = 0, logged_in = 0, id_user = 0 WHERE id_ascii_session = '".$this->php_session_id."'");  return ""; }
			
			$this->native_session_id 	= $data['id'];
			$this->logged_in 			= $data['logged_in'];
			$this->user_id 				= $data['id_user']; 	
			
			
			// Update Last Login field
			$this->db->SQLexecute("UPDATE ".DB_WARPIT_STATVIEW."._user_session SET last_impression = NOW() WHERE id = ".$this->native_session_id);
			
			// we return all session variables
			return 						  $data['variable_value'];
			
		} else {
			// Session is not existing, so we need to create new empty record.
			
			$this->logged_in 			= false;
			$this->db->SQLexecute("INSERT INTO   ".DB_WARPIT_STATVIEW."._user_session SET id_ascii_session = '".$id."', user_agent = '".$this->UserAgent."', created = NOW()");		
			$result = $this->db->SQLexecute("SELECT LAST_INSERT_ID()");
			$data = $this->db->fetchArray($result);
			$this->native_session_id 	= $data[0];
			
			return "";
		}
			
		
	}
	
	/**
	 * called when session data is to be written
	 *
	 * @param int $id
	 * @param serialized $sess_data
	 * @return unknown
	 */
	function _session_write_method($id, $sess_data) {
		// if we have any session data we save it into database
		if ($sess_data) {
			$this->db->SQLexecute("INSERT INTO ".DB_WARPIT_STATVIEW."._session_variable (id_session,variable_value) VALUES  								
							  			('".$this->native_session_id."','".$sess_data."') ON DUPLICATE KEY UPDATE variable_value = '".$sess_data."'");	
		}
		return true;
	}
	
	
	/**
	 * called by session_destroy() 
	 *
	 * @param int $id
	 * @return unknown
	 */
	function _session_destroy_method($id) {
		$this->db->SQLexecute("UPDATE ".DB_WARPIT_STATVIEW."._user_session SET logout = NOW(), logged_in = 0 WHERE id = '".$this->native_session_id."'");
		$this->logged_in 	= 0;
		return true;
	}
	
	/**
	 * called randomly
	 *
	 * @return unknown
	 */
	function _session_gc_method() {
		return (true);
	}
	
	/**
	 * Login function, checks for username and password
	 * if login OK session record is updated with login permission
	 *
	 * @param string $username
	 * @param string $password
	 * @return unknown
	 */
	public function Login($username, $password, $isSurvey = false) {
		$sql = "SELECT a.*, b.country_code, NOW() AS LastLogin, 1 AS user_type, `group` 
				FROM ".DB_WARPIT_STATVIEW."._user AS a
				LEFT JOIN ".DB_WARPIT_STATVIEW."._languageCodepage AS b ON a.language = b.id 
				WHERE (a.email = '".mysql_real_escape_string($username)."' OR a.username = '".mysql_real_escape_string($username)."') 
				AND a.password = md5('".mysql_real_escape_string($password)."')";
		$result = $this->db->SQLexecute($sql);
		 
		if ($this->db->NumRows($result)) {
			$data = $this->db->fetchAssoc($result);
			unset($data['password']); //odstrani geslo z $data, da se ta ne shrani v sejo
			$this->db->SQLexecute("UPDATE ".DB_WARPIT_STATVIEW."._user_session SET last_impression = NOW(), logged_in = 1,user_type =1, id_user = ".$data['id']."										
								   WHERE id = '".$this->native_session_id."'");
			$this->user_id = $data['id'];
			$this->logged_in = 1;
			$_SESSION['UserInfo'] = $data;
			
            $this->GetUserPermissions($data['id']);
            
			return true;
		}
		
		return false;
	}
    
    /**
     * Funkcija za pridobivanje imena profila in pravic uporabnika.
     * 
     * @param $uId - ID uporabnika
     */
    private function GetUserPermissions($uId) {
        //ime profila
        $sql = "SELECT p.`profileName`
                FROM ".DB_WARPIT_STATVIEW.".`_permission_profiles` p, ".DB_WARPIT_STATVIEW.".`_user` u
                WHERE p.`id` = u.`group`
                AND u.`id` = ".$uId;
        $res = $this->db->SQLexecute($sql);
        
        if (!empty($_SESSION['UserProfileName'])) {
            unset($_SESSION['UserProfileName']);
        }
        
        $dat = $this->db->fetchAssoc($res);
        $_SESSION['UserProfileName'] = $dat['profileName'];
        
        //pravice
        $sql = "SELECT p.`shortName` 
                FROM ".DB_WARPIT_STATVIEW.".`_permissions` p
                LEFT JOIN ".DB_WARPIT_STATVIEW.".`_permissions_by_p_profiles` pbp
                ON p.`id` = pbp.`idPermission`
                LEFT JOIN ".DB_WARPIT_STATVIEW.".`_permission_profiles` pp
                ON pbp.`idProfile` = pp.`id`
                LEFT JOIN ".DB_WARPIT_STATVIEW.".`_user` u
                ON u.`group` = pp.`id`
                WHERE u.`id` = ".$uId."
                AND p.`enabled` = 1";
        $res = $this->db->SQLexecute($sql);
        
        if (!empty($_SESSION['UserPermissions'])) {
            unset($_SESSION['UserPermissions']);
        }
        
        while($dat = $this->db->fetchAssoc($res)) {
            $_SESSION['UserPermissions'][] = $dat['shortName']; 
        }
    }
    /**
	 * recursive function for finding group allow and deny 
	 *
	 * @param unknown_type $permId - the id of the permission
	 * @param unknown_type $id - the current id of the user/group
	 */
	private function findGroupAD($permId,$id)
	{
		$sql = "SELECT allow,deny FROM ".DB_WARPIT_STATVIEW."._PermissionLink WHERE id_permission = ".$permId." AND id_permission_group = ".$id;
		if (!$res = $this->db->SQLexecute($sql)){ return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
		if ($row = $this->db->fetchArray($res)) 
		{
			if($row[0] || $row[1])
			return $row;	
		}
		$sql = "SELECT id_sup FROM ".DB_WARPIT_STATVIEW."._PermissionGroups WHERE id = $id";
		if (!$res = $this->db->SQLexecute($sql)){ return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
		if ($row = $this->db->fetchArray($res)) 
		{
			if($row[0] > 0 )
				return $this->findGroupAD($permId, $row[0]);	
		}
		return array(0,0);
		
	}
	/**
	 * Enter description here...
	 *
	 */
	public function getRights(){
		
		$sql =  "SELECT id FROM ".DB_WARPIT_STATVIEW."._Permissions";
		if (!$rs = $this->db->SQLexecute($sql)){ echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
		$rightsArr = array();
		while ($row = $this->db->fetchAssoc($rs))
		{
			$permId = $row['id'];
			//lets check if this user has set this right!
			$sql = "SELECT allow,deny FROM ".DB_WARPIT_STATVIEW."._PermissionLink WHERE id_permission = $permId AND id_user = $this->user_id";
			if (!$resGAD = $this->db->SQLexecute($sql)){ echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
				if ($rowGAD = $this->db->fetchArray($resGAD)) 
				{
					if( $rowGAD[0] )
					{
						$rightsArr[$permId] = true;
						continue;
					}
					else if($rowGAD[1])
						continue;
				}
			//lets find the group allow and deny
			$sql = "SELECT permissionGroup FROM ".DB_WARPIT_STATVIEW."._user WHERE id = $this->user_id";
			if (!$resGAD = $this->db->SQLexecute($sql)){ echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
			if ($rowGAD = $this->db->fetchArray($resGAD)) 
			{
				if( $rowGAD[0] > 0)
				{
					$groupAD = $this->findGroupAD($row['id'], $rowGAD[0]);
					if( $groupAD[0] )
					{
						$rightsArr[$permId] = true;
						continue;
					}
					else if($groupAD[1])
						continue;
				}
			}
		}
		//$_SESSION['UserRights'] = $rightsArr;
		$sql = "DELETE FROM ".DB_WARPIT_STATVIEW."._UserPermissions WHERE id_user = $this->user_id";
		if (!$rs = $this->db->SQLexecute($sql)){ echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
		$sql = "INSERT INTO _UserPermissions VALUES ";
		foreach ($rightsArr as $key => $bla) {
			$sqlArr[] = "($this->user_id,$key)";
		}
		$sql .= implode(',',$sqlArr);
		if (!$rs = $this->db->SQLexecute($sql)){ echo '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
		
		
		return $rightsArr;
	}
	
	
	/**
	 * Function returns if user is logged in
	 *
	 * @return unknown
	 */
	public function IsLoggedIn() { return $this->logged_in; }
	
	/**
	 * Function returns session id (32char string)
	 *
	 * @return unknown
	 */	
	public function GetSessionId() { return $this->php_session_id; }
	
	public function getUserGroup() {
		$sql = "SELECT `group` FROM ".DB_WARPIT_STATVIEW."._user WHERE id = '".$this->user_id."'";
		//echo "$sql";
		$result = $this->db->SQLexecute($sql);
		
		if ($this->db->NumRows($result)) {
			$row = $this->db->fetchAssoc($result);
			return $row['group'];			
		} else {
			return 0;
		}
	}
	
	public function CreateTabCheck() {
		if (!$this->IsLoggedIn()) {
			echo "SessionTimeOut";
			exit;
		}
	}
	
}

?>