<?php

include_once "_dirinfo.php";
include_once PATH_TO_ROOT . 'statview/_class/class_labels.php';
//ini_set('display_errors', '1');

/**
 * class input parameters are $db class
 * and table = _research or _projects
 * and workTable = _research or _projects table name
 * and idResProj = ID of research or project
 */
class Calculate
{

    protected $db;
    protected $table;
    protected $workTable;
    protected $idResProj;

    protected $weightVariable;
    protected $properties;
    protected $question;
    protected $Total;

    public function __construct($db, $table, $workTable, $idResProj)
    {
        $this->db = $db;
        $this->table = $table;
        $this->workTable = $workTable;
        $this->idResProj = $idResProj;
    }

    public function setQuestion($var)
    {
        $this->question = $var;

        return true;
    }

    /**
     * Input $table = _research or _projects
     * and $researchId = research or projet ID
     *
     * @param string $table
     * @param integer $researchId
     * @return string weight variable name
     */
    protected function getWeightVariable()
    {
        if (isset($this->weightVariable)) {
            return $this->weightVariable;
        }

        if ($this->table == "_projects") {
            $this->weightVariable = "weight";
            return $this->weightVariable;
        }
        $weightVar = "unweight";
        $sql = "SELECT weighted FROM $this->table WHERE id=" . $this->idResProj;
        //echo $sql."<br>";
        $result = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($result);
        if ($row['weighted']) {
            $weightVar = "weight";
        }

        $this->weightVariable = $weightVar;

        return $this->weightVariable;
    }

    public function getParameters()
    {
        if (isset($this->properties)) {
            return $this->properties;
        }

        $sql = "SELECT `questionType`, `questionVars`, `questionSubType`, `id_tableTemplate`, `id_graphTemplate`, `missings`, `hideAnswers`
                FROM " . $this->workTable . "___calculated WHERE questionName='" . $this->question . "'";
        //echo $sql."<br>";
        $result = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($result);
        $this->properties['questionVars'] = explode(",", $row['questionVars']);
        $this->properties['missings'] = $row['missings'];
        $this->properties['hideAnswers'] = $row['hideAnswers'];
        $this->properties['questionType'] = $row['questionType'];
        $this->properties['questionSubType'] = $row['questionSubType'];
        $this->properties['id_tableTemplate'] = $row['id_tableTemplate'];
        $this->properties['id_graphTemplate'] = $row['id_graphTemplate'];

        return $this->properties;
    }

    protected function calculateTotal($weightVar, $totalCondition)
    {
        $sql = "SELECT sum($weightVar) as total
                FROM `" . $this->workTable . "___data`
                WHERE 1 " . $totalCondition;
        //echo "TOTAL select: ".$sql."<br>";
        $result = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($result);
        $total = $row['total'];

        return $total;
    }

    public function getTotal()
    {
        return $this->Total;
    }

    public function getFrequencies($missings = null, $filter = null)
    {
        //  print $missings;
        // print  "To je filter: " . $filter;
        $weightVar = $this->getWeightVariable();
        $prop = $this->getParameters();

        if ($prop['questionType'] == 1 or $prop['questionType'] == 3) {
            $arr = $this->single_multi($weightVar, $prop, $missings, $filter);
        } elseif ($prop['questionType'] == 2) {
            $arr = $this->scale($weightVar, $prop, $filter);
        } else {
            return false;
        }

        return $arr;
    }

    protected function scale($weightVar, $prop, $filter = null)
    {
        $missingDefined = "";
        foreach ($prop['questionVars'] as $key_var => $var) {
            if (strlen($prop['missings']) > 0) {
                $missingDefined = "AND $var NOT IN (" . $prop['missings'] . ")";
            }

            $filterString = "";
            if ($filter != null) {
                $filterString = " AND  (" . $filter . ")";
            }

            $sql = "SELECT $var AS val, sum($weightVar) AS N FROM `" . $this->workTable . "___data` ";
            $sql .= "WHERE 1 $filterString $missingDefined
                    GROUP BY $var";
            //echo "$sql<br>";

            $result = $this->db->SQLexecute($sql);
            while ($row = $this->db->fetchAssoc($result)) {
                $arr[$row['val']] = $row['N'];
            }

            $this->Total[$this->question][$var] = $this->calculateTotal($weightVar, $missingDefined);
            $arr_question[$this->question][$var] = $arr;
        }

        return $arr_question;
    }

    protected function single_multi($weightVar, $prop, $missed = null, $filter = null)
    {
        //   print $filter;
        if (count($prop['questionVars'] > 1)) {
            $multi = true;
        }

        $defineTotal = "";
        $missingDefined = "";
        if (strlen($prop['missings']) > 0) {
            $missingDefined = "AND x.colcnt NOT IN (" . $prop['missings'] . ")";
        }

        $sql = "SELECT x.colcnt AS val, sum($weightVar) AS N FROM
                (";
        if (isset($filter)) {
            $filter = " AND  (" . $filter . ")";
        }
        if ($multi) {
            $sql_cols = array();
            $miss = array();

            $secondQvars = "";
            if (!is_null($missed)) {
                //$filter = " AND (" . $missed . ")";
                $missingDefined .= " AND (" . implode(" OR ", $missed['filter']) . ") ";
                $secondQvars = "," . implode(",", $missed['vars']);

            }
            foreach ($prop['questionVars'] as $key_var => $var) {
                $wh = "";
                //if($filter != "1")
                //    $wh = " WHERE " . "a".($key_var+1) . ".".$filter;
                //echo "eky and var: $key_var => $var<br>";
                $sql_cols[] = "SELECT a" . ($key_var + 1) . "." . $weightVar . ", a" . ($key_var + 1) . ".$var AS colcnt " . $secondQvars . " FROM `" . $this->workTable . "___data` AS a" . ($key_var + 1) . " WHERE 1 " . $filter;
                // se variable za total si postavim skupaj
                if (strlen($prop['missings']) > 0) {
                    $miss[] = "`$var` IN (" . $prop['missings'] . ")";
                }
            }
            if ($miss) {
                $defineTotal .= implode(" AND ", $miss) . ") ";
            }

            if (count($miss) > 0) {
                $defineTotal = " AND NOT (" . implode(" AND ", $miss) . ") ";
            }

            $sql .= implode(" UNION ALL ", $sql_cols);
        } else {
            $var = $prop['questionVars'][0];
            $sql .= "SELECT a.weight, a.$var AS colcnt FROM `" . $this->workTable . "___data` AS a WHERE 1 " . $filter;
            if (strlen($prop['missings']) > 0) {
                $defineTotal .= " AND NOT (`$var` IN (" . $prop['missings'] . ")) ";
            }
        }
        $sql .= ") AS x
                WHERE 1 " . $missingDefined . "
                GROUP BY x.colcnt";

        /*  if(is_null($missed))
        print $sql;
         */
        // if($filter)
        // echo "$sql<br>";

        // if(!is_null($missings))
        // print $sql;

        //print_r($sql);

        $result = $this->db->SQLexecute($sql);
        while ($row = $this->db->fetchAssoc($result)) {
            //print_r($row);
            $arr[$row['val']] = $row['N'];
        }
        $defineTotal .= $filter;

        //print "total: " . $defineTotal;
        $this->Total[$this->question] = $this->calculateTotal($weightVar, $defineTotal);
        $arr_question[$this->question] = $arr;

        return $arr_question;
    }

    public function getDescriptives($missings = null, $filter = null)
    {
        $weightVar = $this->getWeightVariable();
        $prop = $this->getParameters();

        $questionArray = array();

        if ($prop['questionType'] == 1 or $prop['questionType'] == 2) {
            $result_array = array();
            if (count($prop['questionVars']) > 1) {

                foreach ($prop['questionVars'] as $var) {
                    $questionArray[$this->question][$var] = $this->calculate_descriptives($weightVar, $var, $prop);
                }

                //" AND NOT (`$var` IN (".$prop['missings'].")) ";
            } else {

                $questionArray[$this->question][$prop['questionVars'][0]] = $this->calculate_descriptives($weightVar, $prop['questionVars'][0], $prop);
            }
        }

        return $questionArray;
    }

    private function calculate_descriptives($weightVar, $var, $prop, $misssed = null, $filter = null)
    {
        $wherePart = "WHERE NOT (" . $var . " IN (" . $prop['missings'] . "))";

        if (!is_null($filter)) {
            $wherePart .= " AND " . $filter;
        }

        //  $var = $prop['questionVars'][0];
        $sql = "SELECT sum(" . $weightVar . ") AS N,
                        min(" . $var . ") AS minimum,
                        max(" . $var . ") AS maximum,
                        variance(" . $var . ") AS variance,
                        std(" . $var . ") AS stdev
                 FROM " . $this->workTable . "___data " . $wherePart;

        $result = $this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($result);

        $result_array['N'] = $row['N'];
        $result_array['minimum'] = $row['minimum'];
        $result_array['maximum'] = $row['maximum'];
        $result_array['variance'] = $row['variance'];
        $result_array['stdev'] = $row['stdev'];

        $sql = "SELECT " . $var . " AS variable, sum(" . $weightVar . ") AS sum_weight, sum(" . $weightVar . ")*" . $var . " AS multi_row
                FROM " . $this->workTable . "___data " . $wherePart .
            "GROUP BY " . $var;

        $result = $this->db->SQLexecute($sql);

        while ($row = $this->db->fetchAssoc($result)) {
            $desc_sum += $row['multi_row'];
        }

        $result_array['sum'] = $desc_sum;
        $result_array['sv'] = $desc_sum / $result_array['N'];

        return $result_array;
    }

    private function setLabels($questionId, $qId, $filter)
    {
        $calc = new Calculate($this->db, $this->table, $this->workTable, $this->idResProj);
        $calc->setQuestion($questionId);
        $params = $calc->getParameters();

        $calc2 = new Calculate($this->db, $this->table, $this->workTable, $this->idResProj);
        $calc2->setQuestion($qId);
        $params2 = $calc2->getParameters();
        $allCols = $params2['questionVars'];

        foreach ($allCols as $qVar) {
            $missings['filter'][] = $qVar . " NOT IN(" . $params2['missings'] . ")";
        }
        $missings['vars'] = $params2['questionVars'];

        //     print_r($missings);

        //   print implode(" AND ", $missings);

        if (count($missings['filter']) > 0) {
            $freq = $calc->getFrequencies($missings, $filter);
        } else {
            $freq = $calc->getFrequencies(null, $filter);
        }

        $labelsSelector = new Labels($this->db, $this->table, $this->workTable, $this->idResProj);
        $labelsSelector->setQuestion($questionId);

        $labels = $labelsSelector->getLabels();

        $returnArray['labels'][$questionId]['question'] = $labels[$questionId]['question'];
        $returnArray['labels'][$questionId]['instruction'] = $labels[$questionId]['instruction'];
        $returnArray['labels'][$questionId]['answers'] = $labels[$questionId]['answers'];

        foreach (explode(',', $params['hideAnswers']) as $hiddenAnswer) {
            unset($returnArray['labels'][$questionId]['answers'][$hiddenAnswer]);
        }

        foreach ($returnArray['labels'][$questionId]['answers'] as $key => $val) {
            $returnArray['freq'][$questionId]['data'][$key] = $freq[$questionId][$key];
        }
        $returnArray['freq'][$questionId]['total'] = array_sum($freq[$questionId]);
        return $returnArray;
    }

    public function getCrosstabs($questionId, $value = null, $maxValue = null, $extraFields = null, $widgetFilters = null)
    {
        $tmpFilterStr = "1";

        if ($value != null) {
            if ($maxValue != null) {
                $tmpFilterStr = "research_id BETWEEN " . $value . " AND " . $maxValue;
            } else {
                $tmpFilterStr = "research_id IN(" . implode(',', $value) . ")";
            }
        }

        if ($extraFields != null) {
            $tmpFilterStr = $extraFields;
        }

        if ($widgetFilters != null) {
            $tmpFilterStr .= " AND " . $widgetFilters;
        }

        //print "/*" . $tmpFilterStr . "*/";

        // $This->question gre prvi v križanje
        $returnArray = array_merge_recursive($this->setLabels($questionId, $this->question, $tmpFilterStr), $this->setLabels($this->question, $questionId, $tmpFilterStr));
        //print_r($returnArray);
        foreach ($returnArray['labels'][$this->question]['answers'] as $key => $val) {
            $calc = new Calculate($this->db, $this->table, $this->workTable, $this->idResProj);
            $calc->setQuestion($questionId);
            $params = $this->getParameters();
            $allCols = $params['questionVars'];
            $params2 = $calc->getParameters();
            $tmpFilter = array();
            foreach ($allCols as $qVar) {
                $tmpFilter[] = $qVar . " = " . $key;
            }

            // print "/*" . print_r($params, TRUE) . "*/";
            $freqs = $calc->getFrequencies(null, implode(" OR ", $tmpFilter) . " AND " . $tmpFilterStr);

            //$returnArray['cross'][$this->question][$key][$questionId][key($freqs[$questionId])] = current($freqs[$questionId]);
            if (is_array($freqs[$questionId])) {
                foreach ($freqs[$questionId] as $key1 => $val1) {
                    $returnArray['cross'][$this->question][$key][$questionId][$key1] += $val1;
                }
            }

            // print "<pre>";
            // print_r($returnArray);
            //
            // print "</pre>";
        }

        /*$calc = new Calculate($this->db, $this->table, $this->workTable, $this->idResProj);
        $calc->setQuestion($this->question);
        $tmpArray = $calc->getFrequencies();*/

        return $returnArray;
    }

/*    public function getFilteredCrosstabs($questionId, $filter)
{
$returnArray = array_merge_recursive($this->setLabels($questionId, $this->question), $this->setLabels($this->question, $questionId));

foreach($returnArray['labels'][$this->question]['answers'] as $key => $val)
{
$calc = new Calculate($this->db, $this->table, $this->workTable, $this->idResProj);
$calc->setQuestion($questionId);
$params = $this->getParameters();
$allCols = $params['questionVars'];
$params2 = $calc->getParameters();

$tmpFilter = array();
foreach($allCols as $qVar)
{
$tmpFilter[] = $qVar . " = " . $key;
}
$tmpFilterStr = implode(" OR ", $tmpFilter);

$freqs = $calc->getFrequencies(NULL, $tmpFilterStr." AND research_id IN(".implode(", ", $filter).")" );

if(is_array($freqs[$questionId]))
{
foreach($freqs[$questionId] as $key1 => $val1)
{
$returnArray['cross'][$this->question][$key][$questionId][$key1] += $val1;
}
}
}
return $returnArray;
}

 */
}
