<?php

class Selector
{

	protected $db;

	public function __construct($db) {
		$this->db = $db;
	}

    public function getProjectWidth($idP) {
        $sql = "SELECT resolutionText FROM _graphResolutions WHERE id = (SELECT showWidth FROM `_projects` WHERE id = ".$idP.")";
        if($result=$this->db->SQLexecute($sql)){
            $data = $this->db->fetchAssoc($result);
            return filter_var($data['resolutionText'], FILTER_SANITIZE_NUMBER_INT);
        } else {
            return false;
        }
    }

    public function getLanguages() {
        $sql = "SELECT id, cp_comment FROM _languageCodepage WHERE id IN (SELECT DISTINCT(id_language) FROM _languagePack) AND enable = 1";
        if($res=$this->db->SQLexecute($sql)){
            while($row = $this->db->fetchAssoc($res)) {
                $arr[] = $row;
            }
            return $arr;
        } else {
            return false;
        }
    }
	
	public function getCustomColorSchema($idP) {
		$sql = "SELECT colors FROM _customColorSchemes WHERE idProj = '".$idP."'";
		if ($result = $this->db->SQLexecute($sql)) {
        	$data = $this->db->fetchAssoc($result);
            return $data['colors'];
        }
        
        return false;
	}

	public function getResearch($id) {
		$sql = "SELECT id,project,long_name,weighted,showWidth,colorShema  FROM _research WHERE id=".$id." AND deleted=0";
		if($result=$this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		} else {
			return false;
		}
	}

	public function getClient($id) {
		$sql = "SELECT id,client,longName,lastChangeTime FROM _clients WHERE id=".$id." AND deleted=0";
		if($result=$this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		} else {
			return false;
		}
	}

	public function getProject($id) {
		$sql = "SELECT id,projectName,longName,footerText,isTimed,ready,weighted,showWidth,colorShema,createDate FROM _projects WHERE id=".$id." AND deleted=0";
		if($result=$this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		} else {
			return false;
		}
	}

	public function getResolution($id) {
		$proj = $this->getProject($id);
		$sql = "SELECT hv_resolution FROM _graphResolutions WHERE id=".$proj['showWidth'];
		if($result=$this->db->SQLexecute($sql)){
			$row = $this->db->fetchAssoc($result);
			return $row['hv_resolution'];
		} else {
			return false;
		}
	}

	public function getClientProject($cId) {
		$sql = "SELECT id,project,long_name,weighted FROM _research WHERE id=".$id." AND deleted=0";
		if($result=$this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		} else {
			return false;
		}
	}

	public function getClientPeriods($langId){
		$sql = "SELECT cp.id, period, lp.translate_text FROM _client_periods cp, _languagePack lp WHERE lp.translate_key=cp.unitName AND lp.id_language=$langId GROUP BY cp.id";
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[$row['id']]['period']=$row['period'];
				$arr[$row['id']]['periodUnit']=$row['translate_text'];
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getClientUsers($cId) {
		$arr = array();
		$sql = "SELECT DISTINCT _user.id, _user.group, profileName, _user.Firstname, _user.Surname, _user.email FROM _user,_users_by_clients,_permission_profiles pp ";
		$sql .= " WHERE _user.id = _users_by_clients.id_user AND _user.group=pp.id AND _users_by_clients.id_client=".$cId;
		$sql .= " ORDER BY Firstname,_user.group,Surname";

		//echo $sql;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[$row['id']]['group']=$row['group'];
				$arr[$row['id']]['profile']=$row['profileName'];
				$arr[$row['id']]['firstname']=$row['Firstname'];
				$arr[$row['id']]['surname']=$row['Surname'];
				$arr[$row['id']]['email']=$row['email'];
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getResearchCalculated($resName) {
		$arr = array();
		$resName = str_replace(" ", "_", $resName);
		$sql = "SELECT * FROM ".$resName."___calculated ORDER BY `question` ASC";
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				//if($row['question']) {
					$arr[$row['questionName']]['questionType']=$row['questionType'];
					$arr[$row['questionName']]['questionName']=$row['questionName'];
					$arr[$row['questionName']]['question']=strip_tags($row['question']);
					$arr[$row['questionName']]['hideQuestion']=$row['hideQuestion'];
					$arr[$row['questionName']]['comment']=$row['comment'];
					$arr[$row['questionName']]['crosstabVariables']=$row['crosstabVariables'];
					$arr[$row['questionName']]['instruction']=strip_tags($row['instruction']);
					$arr[$row['questionName']]['question']=strip_tags($row['question']);
					$arr[$row['questionName']]['answer']=strip_tags($row['answer']);
					$arr[$row['questionName']]['legend']=strip_tags($row['legend']);
					$arr[$row['questionName']]['category']=strip_tags($row['category']);
					$arr[$row['questionName']]['title']=strip_tags($row['title']);
					$arr[$row['questionName']]['graph_instruction']=strip_tags($row['graph_instruction']);
					$arr[$row['questionName']]['graph_question']=strip_tags($row['graph_question']);
					$arr[$row['questionName']]['graph_answer']=strip_tags($row['graph_answer']);
					$arr[$row['questionName']]['graph_legend']=strip_tags($row['graph_legend']);
					$arr[$row['questionName']]['graph_category']=strip_tags($row['graph_category']);
					$arr[$row['questionName']]['graph_title']=strip_tags($row['graph_title']);
					$arr[$row['questionName']]['missings']=strip_tags($row['missings']);
					$arr[$row['questionName']]['missings_mean']=strip_tags($row['missings_mean']);
					$arr[$row['questionName']]['hideAnswers']=strip_tags($row['hideAnswers']);
				//}
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getResearchCalculatedClient($resName) {
		$arr = array();
		$resName = str_replace(" ", "_", $resName);
		$sql = "SELECT * FROM ".$resName."___calculated WHERE hideQuestion=0";
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				//if($row['question']) {
				$arr[$row['questionName']]['questionType']=$row['questionType'];
				$arr[$row['questionName']]['question']=strip_tags($row['question']);
				$arr[$row['questionName']]['hideQuestion']=$row['hideQuestion'];
				$arr[$row['questionName']]['comment']=$row['comment'];
				$arr[$row['questionName']]['crosstabVariables']=$row['crosstabVariables'];
				$arr[$row['questionName']]['instruction']=strip_tags($row['instruction']);
				$arr[$row['questionName']]['question']=strip_tags($row['question']);
				$arr[$row['questionName']]['answer']=strip_tags($row['answer']);
				$arr[$row['questionName']]['legend']=strip_tags($row['legend']);
				$arr[$row['questionName']]['category']=strip_tags($row['category']);
				$arr[$row['questionName']]['title']=strip_tags($row['title']);
				$arr[$row['questionName']]['graph_instruction']=strip_tags($row['graph_instruction']);
				$arr[$row['questionName']]['graph_question']=strip_tags($row['graph_question']);
				$arr[$row['questionName']]['graph_answer']=strip_tags($row['graph_answer']);
				$arr[$row['questionName']]['graph_legend']=strip_tags($row['graph_legend']);
				$arr[$row['questionName']]['graph_category']=strip_tags($row['graph_category']);
				$arr[$row['questionName']]['graph_title']=strip_tags($row['graph_title']);
				//}
			}
			return $arr;
		} else {
			return false;
		}
	}


	public function getProjectQuestionEvents($idP, $idQ) {
	    if (strlen($idQ) > 10) { $idQ = substr($idQ, 0, 10); }

		$arr = array();
		$resName = str_replace(" ", "_", $this->getProjectName($idP));
		$sql = "SELECT * FROM ".$resName."___events WHERE id_question='".$idQ."' ORDER BY eventTime ASC";

		$counter=0;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
			    $arr[$counter]['id']=$row['id'];
				$arr[$counter]['eventName']=$row['eventName'];
				$arr[$counter]['event']=$row['event'];
				$arr[$counter]['eventTime']=$row['eventTime'];
				$counter++;
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getSliderLabels($idP, $idQ, $idQCross=false) {
		$arr = array();
		$projName = $this -> getProjectName($idP, $test);
		$projName = str_replace(" ", "_", $projName);
		$sql = "SELECT answer FROM ".$projName."___calculated where questionName='research_id'";
		//$sql = "SELECT * FROM _sliderLabels WHERE id_project=".$idP." AND active=1";

		if($result=$this->db->SQLexecute($sql)){
			$row = $this->db->fetchAssoc($result);
			if($row['answer']) {
				$answExplode = explode("/", $row['answer']);
				foreach($answExplode as $a) {
					$labarr = explode(" ",$a,2);
					$arr[] = array('id' => $labarr[0],'labelText' => $labarr[1]);
				}
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getSliderOptions($idP, $idQ) {
		$arr = array();
		$sql = "SELECT * FROM  _slider_options WHERE id_question = '". $idQ ."' AND id_project = ". $idP;
		if($result=$this->db->SQLexecute($sql)){
			$row = $this->db->fetchAssoc($result);
			if($row['res_ids']) {
				$arr = explode(',',$row['res_ids']);
			}
		}
		return $arr;
	}

	public function getRangedSliderOptions($idP, $idQ) {
		$arr = array();
		$sql = "SELECT * FROM _slider_ranged_options WHERE id_question = '". $idQ ."' AND id_project = ". $idP;
		//print_r($sql);
		if($result=$this->db->SQLexecute($sql)){
			$row = $this->db->fetchAssoc($result);
			if($row['res_id_min'] && $row['res_id_max']) {
				$arr = array($row['res_id_min'], $row['res_id_max']);
			}
		}
		return $arr;
	}

	public function getWidthOptions() {
		$arr = array();
		$sql = "SELECT * FROM _graphResolutions";
		$counter=0;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[$counter]['id']=$row['id'];
				$arr[$counter]['resolutionText']=$row['resolutionText'];
				$arr[$counter]['hv_resolution']=$row['hv_resolution'];
				$counter++;
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getColorOptions() {
		$arr = array();
		$sql = "SELECT * FROM _colorShema";
		$counter=0;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[$counter]['id']=$row['id'];
				$arr[$counter]['shemaName']=$row['shemaName'];
				$arr[$counter]['usedColors']=$row['usedColors'];
				$arr[$counter]['imagePath']=$row['imagePath'];
				$counter++;
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getProjectColorOptions($projectName) {
		/*$arr = array();
		$sql = "SELECT c.usedColors AS colors FROM _colorShema c INNER JOIN _projects p ON c.id = p.colorShema WHERE p.projectName = '$projectName'";
		
		if($result = $this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		}
		return null;*/
		
		$sql = "SELECT id, colorShema FROM _projects WHERE projectName = '".$projectName."'";
		if ($result = $this->db->SQLexecute($sql)) {
			$row = $this->db->fetchAssoc($result);
		}
		
		if ($row["colorShema"] == "99") {
			$sql = "SELECT colors FROM _customColorSchemes WHERE idProj = '".$row["id"]."'";
		} else {
			$sql = "SELECT c.usedColors AS colors FROM _colorShema c INNER JOIN _projects p ON c.id = p.colorShema WHERE p.projectName = '$projectName'";		
		}
		
		if($result = $this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		}
		return null;
	}

	public function getQuestionEvents($idR, $idQ) {
		$arr = array();
		$resName = str_replace(" ", "_", $this->getResearcheName($idR));
		$sql = "SELECT * FROM ".$resName."___events WHERE id_question='".$idQ."'";
		$counter=0;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[$counter]['eventName']=$row['eventName'];
				$arr[$counter]['event']=$row['event'];
				$arr[$counter]['eventTime']=$row['eventTime'];
				$counter++;
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getShowTypes($idR, $idQ) {
		$sql = "SELECT * FROM _researchShowTypes WHERE id_research=".$idR." AND name_question='".$idQ."'";
		if($result=$this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		} else {
			return false;
		}
	}

	public function getProjShowTypes($idP, $idQ) {
		$sql = "SELECT * FROM _projectsShowTypes WHERE id_project=".$idP." AND name_question='".$idQ."'";
		if($result=$this->db->SQLexecute($sql)){
			return $this->db->fetchAssoc($result);
		} else {
			return false;
		}
	}

	public function getWidgetLock($idP, $idQ) {
		$sql = "SELECT * FROM _widget WHERE questionId = '" . $idQ . "' AND projectId = ". $idP;
		$result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		return $row['locked'];
	}

	public function getWidgetShowTypes($idP, $idQ) {
		$returnArray = array();
		for($i=1; $i<5; $i++) {
			$returnArray['tabl'.$i] = 0;
			$returnArray['pie'.$i] = 0;
			$returnArray['bar'.$i] = 0;
			$returnArray['line'.$i] = 0;
			$returnArray['map'.$i] = 0;
		}
		$sql = "SELECT * FROM _widget WHERE questionId = '" . $idQ . "' AND projectId = ". $idP;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$row['type'] = str_replace("table","tabl",$row['type']);
				$returnArray[$row['type']]=1;
			}
		}
		return $returnArray;
	}

	public function getWidgetCross($idP, $idQ) {
		$returnArray = array();
		$sql = "SELECT * FROM _widget WHERE questionId = '" . $idQ . "' AND projectId = ". $idP;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$returnArray[]=$row['id_kriz'];
			}
		}
		return array_unique($returnArray);
	}

	public function getWidgetAnswers($idP, $idQ) {
		$returnArray = array();
		$sql = "SELECT * FROM _widget WHERE questionId = '" . $idQ . "' AND projectId = ". $idP;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$returnArray[]=$row['id_answer'];
			}
		}
		return array_unique($returnArray);
	}

	public function getProjectName($id) {
		$sql = "SELECT projectName FROM _projects WHERE id=".$id;
		$result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		return $row['projectName'];
	}

	public function getResearcheName($id) {
		$sql = "SELECT project FROM _research WHERE id=".$id;
		$result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		return $row['project'];
	}

	public function getCliId($id) {
		$sql = "SELECT id_client FROM _users_by_clients WHERE id_user=".$id;
		$result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		return $row['id_client'];
	}

	public function getResearchCreator($id) {
		$sql = "SELECT Firstname,Surname FROM _user WHERE id=".$id;
		$result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		return $row['Firstname'].' '.$row['Surname'];
	}

	public function getProjectClient($id) {
		$sql = "SELECT DISTINCT _clients.client FROM _clients, _clients_by_projects ";
		$sql .= " WHERE _clients.id = _clients_by_projects.id_client AND _clients_by_projects.id_project=".$id;
		$result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		return $row['client'];
	}

    public function getUserClientId($userId) {
        $sql = "SELECT `id_client`
                FROM `_users_by_clients`
                WHERE `id_user` = ".$userId;
        $result=$this->db->SQLexecute($sql);
        $row = $this->db->fetchAssoc($result);
        return $row['id_client'];
    }

	public function getUserClient($id) {
		$sql = "SELECT DISTINCT _clients.client FROM _clients, _users_by_clients ";
		$sql .= " WHERE _clients.id = _users_by_clients.id_client AND _users_by_clients.id_user=".$id;
		$result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		return $row['client'];
	}

	public function getProjectResNum($projId) {
        $sql = "SELECT count(*) as total FROM _projects_by_research WHERE id_project=" . $projId;
        $result=$this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
        return $row['total'];
    }

	public function getProjResearches($projId) {
		$arr = array();
		$sql = "SELECT DISTINCT _research.id, _research.project, _research.long_name FROM _research,_projects_by_research ";
		$sql .= " WHERE _research.id = _projects_by_research.id_research AND _projects_by_research.id_project=".$projId;
		$sql .= " ORDER BY _research.id";

		//echo $sql;
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[$row['id']]['name']=$row['project'];
				$arr[$row['id']]['longName']=$row['long_name'];
			}
			return $arr;
		} else {
			return false;
		}
	}

	public function getPermissionProfiles($profileId = -1){
		if($profileId == -1){ //select all profiles
			$sql = "SELECT id AS profileId, shortName, profileName FROM _permission_profiles WHERE enabled=1";
		}
		else
		{
			$sql = "SELECT id AS profileId, shortName, profileName FROM _permission_profiles WHERE id=$profileId AND enabled=1";
		}
		$arr = array();
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[] = $row;
			}
			return $arr;
		}
		else {
			return false;
		}
	}

	public function getPermissions($profileId=0){
		if($profileId == 0)
			$sql = "SELECT id AS permId, shortName FROM _permissions WHERE enabled=1";
		else
			$sql = "SELECT idPermission, shortName FROM _permissions_by_p_profiles, _permissions per WHERE idProfile = ".$profileId." AND idPermission=per.id AND enabled=1";

		$arr = array();
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[] = $row;
			}
			return $arr;
		}
		else {
			return false;
		}
	}

    public function getAllPermissions($profiles) {
        $profiles = explode(",", $profiles);

        $data = array();
        foreach($profiles as $profile) {
            $sql = "SELECT idPermission, shortName FROM _permissions_by_p_profiles, _permissions per WHERE idProfile = ".$profile." AND idPermission=per.id AND enabled=1";
            $res = $this->db->SQLexecute($sql);

            while ($dat = $this->db->fetchAssoc($res)) {
                $data[$profile][] = $dat;
            }
        }

        return $data;
    }

	public function getPermissionLanguage($permissions, $idLanguage){

		$arrPerm = array();
		foreach($permissions as $perm){
			$arrPerm[] = $perm['shortName'];
		}
		$permStr = implode("','",$arrPerm);

		$sql = "SELECT per.id, lang.translate_text, lang.translate_key FROM _languagePack lang, _permissions per WHERE lang.id_language=$idLanguage AND
				lang.sub_page='permission' AND lang.translate_key=per.shortName AND lang.translate_key IN('".$permStr."')";

		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[] = $row;
			}
			return $arr;
		}
		else {
			return false;
		}
	}

	protected function cleanHTML($str) {
		$str = str_replace(array("\r\n","\r","\n","\t"), "", $str);
		return $str;
	}

	public function debug_view ( $what ) {
		$a =  '<pre>';
		if ( is_array( $what ) )  {
			$a .=  print_r ( $what );
		} else {
			var_dump ( $what );
		}
		$a .=  '</pre>';
		return $a;
	}
}

?>