<?php 

class ResearchGenerator 
{
	
	protected $db;
	protected $sel;
		
	public function __construct($db, $sel) {
		$this->db = $db;	
		$this->sel = $sel;	
	}	
	
	public function resExist($projName) {	 
		$sql = "SHOW TABLES LIKE '".$projName."___calculated'"; 
		if($result=$this->db->SQLexecute($sql)){
			if ($this->db->NumRows($result) > 0) {
				return true;
			}
			else {
				return false;
			}
		} else {	
			return false;
		}
	}
	
	public function createNewRes($resId, $sqlFile) {
		$resName = str_replace(" ", "_", $this->sel->getResearcheName($resId));
		
		//Naredimo osnovna ogrodja tabel
		$this->createBasicStructure($resName);
		
		// Izvedemo importan sql file				
		
		$expSQl=explode("\r\n\r\n",$sqlFile);
		
		
		foreach($expSQl as $sql) {
			if(!$result=$this->db->SQLexecute($sql)){
				return $this->db->JsonError();
			}
		}	
	}
	
	protected function createBasicStructure($projName) {
		$sql = "CREATE TABLE IF NOT EXISTS `".$projName."___calculated` (
			  `id` int(5) NOT NULL AUTO_INCREMENT,
			  `id_question` int(5) NOT NULL,
			  `questionName` varchar(30) NOT NULL,
			  `questionPosition` int(4) DEFAULT NULL,
			  `questionType` tinyint(1) NOT NULL,
			  `questionVars` text,
			  `questionSubType` tinyint(1) NOT NULL,
			  `questionOpenCount` tinyint(1) NOT NULL,
			  `instruction` text NOT NULL,
			  `question` text NOT NULL,
			  `answer` text NOT NULL,
			  `legend` text NOT NULL,
			  `category` text NOT NULL,
			  `title` text NOT NULL,
			  `graph_instruction` text NOT NULL,
			  `graph_question` text NOT NULL,
			  `graph_answer` text NOT NULL,
			  `graph_legend` text NOT NULL,
			  `graph_category` text NOT NULL,
			  `graph_title` text NOT NULL,
			  `data` text NOT NULL,
			  `id_tableTemplate` int(5) DEFAULT NULL,
			  `id_graphTemplate` int(5) DEFAULT NULL,
			  `missings` varchar(255) NOT NULL DEFAULT '0',
			  `hideAnswers` varchar(255) DEFAULT NULL,
			  `hideQuestion` tinyint(1) NOT NULL,
			  `comment` text NOT NULL,
			  `crosstabVariables` text NOT NULL,
			  PRIMARY KEY (`id`),
			  UNIQUE KEY `id_question` (`id_question`),
			  KEY `hideQuestion` (`hideQuestion`),
			  KEY `questionPosition` (`questionPosition`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
		
		if(!$result=$this->db->SQLexecute($sql)){
			return $this->db->JsonError();
		}

		$sql = "CREATE TABLE IF NOT EXISTS `".$projName."___events` (
			  `id` int(5) NOT NULL AUTO_INCREMENT,
			  `id_question` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
			  `eventName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
			  `event` text COLLATE utf8_unicode_ci,
			  `eventTime` int(11) unsigned DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  KEY `id_question` (`id_question`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;";
		
		if(!$result=$this->db->SQLexecute($sql)){
			return $this->db->JsonError();
		}
	}

}

?>