<?php
include_once "_dirinfo.php";
include_once PATH_TO_ROOT . "statview/init.php";
include_once PATH_TO_ROOT . "statview/_class/class.selector.php";
include_once PATH_TO_ROOT . "statview/_class/class.projectgenerator.php";
include_once PATH_TO_ROOT . 'statview/_class/class_calculate.php';
include_once PATH_TO_ROOT . 'statview/_class/class_labels.php';
include_once PATH_TO_ROOT . 'statview/_class/class.forms.php';

class Widget extends FormsEvents
{
    protected $db;

    public function __construct($db)
    {
        $this->db = $db;
        parent::__construct($db);
    }

    public function makeWidgetFrame($id, $idP, $wId, $uId)
    {
        $pId = $idP;
        $qId = $id;

        $sel = new Selector($this->db);
        $project = $sel->getProject($pId);
        $projQuestions = $sel->getResearchCalculatedClient($project['projectName']);

        return $this->makeWidgetProjQuestion($projQuestions, $qId, $pId, true, $wId, $uId, null);
    }

    public function makeWidget($quest, $id, $idP, $projectName, $wId, $uId, $date, $show_only)
    {
        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'widgets', DB_WARPIT_STATVIEW);
        $sel = new Selector($this->db);
        $resolution = $sel->getResolution($idP);
        $lockHtml = $this->makeLockHtml($id, $idP);
        $resExp = explode('x', $resolution);

        $sql = "SELECT * FROM _user WHERE id = " . parent::cleanInput($uId) . "";
        $res = $this->db->SQLexecute($sql);
        while ($row = $this->db->fetchAssoc($res)) {
            $author = $row['Firstname'] . ' ' . $row['Surname'];
        }

        if (trim($quest[$id]['question']) == "") {
            $quest[$id]['question'] = $language['unnamed_widget'];
        }

        $html .= '
        <tr>
            <td id="wId" style="padding-top: 15px;">' . parent::cleanOutput($wId) . '</td>
            <td><div class="project-question"><img class="iframe-preview" title="Predogled Widgeta" src="_img/view.png"><h5 style="color:#3c6a80;">  ' . parent::cleanOutput($quest[$id]['question']) . '</h5></div></td>
            <td style="padding-top: 15px;"><div class="project-name">' . parent::cleanOutput($projectName) . '</div></td>
            <td style="padding-top: 15px;">
                <textarea class="if-tb" id="objavi_' . parent::cleanOutput($id) . '_' . parent::cleanOutput($idP) . '" name="objavi_' . parent::cleanOutput($id) . '_' . parent::cleanOutput($idP) . '" ><iframe src ="' . WARPIT_WWW . 'statview/_forms/forms.iframe.widget.php?pId=' . parent::cleanOutput($idP) . '&qId=' . parent::cleanOutput($id) . '&uId=' . parent::cleanOutput($uId) . '&wId=' . parent::cleanOutput($wId) . '" frameBorder="0"/></textarea>
            </td>
            <td style="padding-top: 15px;">' . parent::cleanOutput($author) . '</td>
            <td style="padding-top: 15px;">' . parent::cleanOutput($date) . '</td>';

        if (in_array('delete_widget', $_SESSION['UserPermissions'])) {
            $html .= '<td><div class="fr" style="width:50px;padding:15px 15px 0 0;"><a href="javascript:deleteWidget(' . parent::cleanOutput($wId) . ')"><img src=_img/xm.png style="float:right;margin-top:8px;"/></a></div></td>';
        }
        $html .= '</tr>';

        return $html;
    }

    public function makeWidgetsList($userId, $group, $show_only)
    {

        if (!empty($show_only)) //POPRAVI, tudi za regular userje
        {
            $limit_results = "WHERE widgetId IN(" . implode(',', parent::cleanInput($show_only)) . ")";
        } else {
            $limit_results = '';
        }

        if ($group == 1) //Admin group
        {
            $sql = "SELECT * FROM _widget " . $limit_results;
        } else {
            $sql = "SELECT * FROM _widget WHERE userId = " . parent::cleanInput($userId) . " ";
        }

        $res = $this->db->SQLexecute($sql);
        $sel = new Selector($this->db);

        $html = "";

        $usedPQ = array();

        while ($dat = $this->db->fetchAssoc($res)) {
            if (!in_array($dat['projectId'] . $dat['questionId'], $usedPQ)) {
                $usedPQ[] = $dat['projectId'] . $dat['questionId'];
                $pId = $dat['projectId'];
                $qId = $dat['questionId'];
                $wId = $dat['widgetId'];
                $uId = $dat['userId'];
                $date = date("d.m.Y H:i", strtotime($dat['date']));

                $project = $sel->getProject($pId);
                $projQuestions = $sel->getResearchCalculatedClient($project['projectName']);
                $projResearches = $sel->getProjResearches($pId);

                $html .= $this->makeWidget($projQuestions, $qId, $pId, $project['projectName'], $wId, $uId, $date, $show_only);
            }
        }

        return $html;
    }

    public function makeDashboardWidgetsList($userId, $group)
    {
        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'dashboard', DB_WARPIT_STATVIEW);

        if ($group == 1) //Admin group
        {
            $sql = "SELECT * FROM _widget";
        } else {
            $sql = "SELECT * FROM _widget WHERE userId = " . parent::cleanInput($userId);
        }

        $res = $this->db->SQLexecute($sql);
        $sel = new Selector($this->db);
        $usedPQ = array();

        $html = '<div class="table-responsive">
                    <table id="DashboardWidgetsTable" class="table table-striped table-hover" width="100%">
                        <thead>
                            <tr><td></td><td></td></tr>
                        </thead>
                        <tbody id="DashboardWidgetsTbody">';

        while ($dat = $this->db->fetchAssoc($res)) {
            if (!in_array($dat['projectId'] . $dat['questionId'], $usedPQ)) {
                $usedPQ[] = $dat['projectId'] . $dat['questionId'];
                $pId = $dat['projectId'];
                $qId = $dat['questionId'];
                $wId = $dat['widgetId'];
                $uId = $dat['userId'];

                $project = $sel->getProject($pId);
                $projectName = ($project['projectName'] == "" ? $language['unnamed_proj_name'] : $project['projectName']);
                $projCreationDate = date("d.m.Y", strtotime($project['createDate']));
                $projQuestions = $sel->getResearchCalculatedClient($project['projectName']);

                if ($projQuestions[$qId]['question'] == "") {
                    $projQuestions[$qId]['question'] = $language['unnamed_proj_name'];
                }

                $html .= '
                <tr id="' . parent::cleanOutput($wId) . '">
                    <td>
                        <div class="draggable ui-widget-content draggable-widget">
                        	<b>' . parent::cleanOutput($projQuestions[$qId]['question']) . '</b>
                            <input type="hidden" value=\'<iframe src ="' . WARPIT_WWW . 'statview/_forms/forms.iframe.widget.php?pId=' . parent::cleanOutput($pId) . '&qId=' . parent::cleanOutput($qId) . '&uId=' . parent::cleanOutput($uId) . '&wId=' . parent::cleanOutput($wId) . '" frameBorder="0"/>\'/>
                        </div>
                    </td>
                    <td>
                    	<div class="wProj">' . parent::cleanOutput($projectName) . '</div>
                    	<div class="wProjDate">' . parent::cleanOutput($projCreationDate) . '</div>
                    </td>
                </tr>';
            }
        }

        $html .= '</tbody></table></div>';

        return $html;
    }

    private function makeLockHtml($idQ, $idP)
    {
        $sel = new Selector($this->db);
        if ($sel->getWidgetLock($idP, $idQ)) {
            return '<div class="zavrzi w100" onclick=javascript:unlockWidget(' . parent::cleanOutput($idP) . ',\'' . parent::cleanOutput($idQ) . '\');>Odkleni</div>';
        } else {
            return '<div class="zavrzi w100" onclick=javascript:lockWidget(' . parent::cleanOutput($idP) . ',\'' . parent::cleanOutput($idQ) . '\');>Zakleni</div>';
        }
    }

}
