<?php

include_once "_dirinfo.php";

include_once PATH_TO_ROOT . "_config/dbConfig.php";

include_once PATH_TO_ROOT . "statview/init.php";

include_once PATH_TO_ROOT . "statview/_class/class.selector.php";

include_once PATH_TO_ROOT . "statview/_class/class.maps.php";

include_once PATH_TO_ROOT . "statview/_class/class.projectgenerator.php";

include_once PATH_TO_ROOT . "statview/_class/class.researchgenerator.php";

include_once PATH_TO_ROOT . 'statview/_class/class_calculate.php';

include_once PATH_TO_ROOT . 'statview/_class/class_labels.php';

include_once PATH_TO_ROOT . 'statview/_class/class.crossing.php';

include_once PATH_TO_ROOT . "statview/_class/system/class.UserSession.php";

//ini_set("display_errors", 1);

include_once PATH_TO_ROOT . 'statview/firephp/fb.php';

include_once PATH_TO_ROOT . 'statview/firephp/FirePHP.class.php';

class FormsEvents
{

    protected $db;

    protected $formParameters;

    protected $userSession;

    public function __construct($db, $formParams = null, $UserSession = null)
    {

        $this->db = $db;

        if (isset($formParams)) {

            $this->formParameters = $formParams;

        }

        if (isset($UserSession)) {

            $this->userSession = $UserSession;

        }

    }

    //XSS and SQL injection protection

    public function cleanInput($string)
    {

        return mysql_real_escape_string($string);

    }

    public function cleanOutput($string)
    {

        return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');

    }

    //razlika v dnevih med dvema datumoma

    public function calculateDateDiffAction()
    {

        $currDate = $this->cleanInput($_POST['currDate']);

        $currDate = strtotime($currDate);

        if (isset($_POST['secondDate'])) {

            $secondDate = $this->cleanInput($_POST['secondDate']);

            $secondDate = strtotime($secondDate);

            //če je izbran datum manjši od danajšnjega vrne 0

            if ($secondDate < time()) {

                return '{"error":false,"script":false,"returnval":true,"response": { "days": 0,"date": "' . date("d.m.Y", $secondDate) . '" }}';

            }

        } else {

            if ($currDate < time()) {$currDate = time();}

            $addMonths = $this->cleanInput($_POST['addMonths']);

            $secondDate = strtotime("+" . $addMonths . " months", $currDate);

        }

        $dateDiff = $currDate - $secondDate;

        $dateDiff = floor($dateDiff / (60 * 60 * 24));

        $dateDiff = abs($dateDiff);

        return '{"error":false,"script":false,"returnval":true,"response": { "days": ' . $dateDiff . ',"date": "' . date("d.m.Y", $secondDate) . '" }}';

    }

    public function saveQuestionProjectAction()
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($this->cleanInput($this->formParameters['proId']));

        $projName = str_replace(" ", "_", $projName);

        //forma z nastavitvami pogleda grafov, vprašanj za križanje, komentar

        if ($this->formParameters['form_part'] == "question") {

            $show = (isset($this->formParameters['qShow'])) ? 0 : 1;

            $cross = array();

            foreach ($this->formParameters as $key => $fe) {

                if (strpos($key, 'cross_') !== false and $fe) {

                    $cross[] = substr($key, 6);

                }

            }

            // Delete old show types

            $sql = "DELETE FROM _projectsShowTypes

                           WHERE name_question = '" . $this->cleanInput($this->formParameters['qId']) . "'

                           AND id_project = " . intval($this->cleanInput($this->formParameters['proId']));

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

            // Insert new show types

            $sql = "INSERT INTO _projectsShowTypes SET

                id_project = " . intval($this->cleanInput($this->formParameters['proId'])) . ",

                name_question = '" . $this->cleanInput($this->formParameters['qId']) . "',

                pie1 = " . intval($this->cleanInput($this->formParameters['pie1'])) . ",

                pie2 = " . intval($this->cleanInput($this->formParameters['pie2'])) . ",

                pie3 = " . intval($this->cleanInput($this->formParameters['pie3'])) . ",

                bar1 = " . intval($this->cleanInput($this->formParameters['bar1'])) . ",

                bar2 = " . intval($this->cleanInput($this->formParameters['bar2'])) . ",

                bar3 = " . intval($this->cleanInput($this->formParameters['bar3'])) . ",

                line1 = " . intval($this->cleanInput($this->formParameters['line1'])) . ",

                line2 = " . intval($this->cleanInput($this->formParameters['line2'])) . ",

                line3 = " . intval($this->cleanInput($this->formParameters['line3'])) . ",

                line4 = " . intval($this->cleanInput($this->formParameters['line4'])) . ",

                tabl1 = " . intval($this->cleanInput($this->formParameters['table1'])) . ",

                tabl2 = " . intval($this->cleanInput($this->formParameters['table2'])) . ",

                tabl3 = " . intval($this->cleanInput($this->formParameters['table3'])) . ",

                map1 = " . intval($this->cleanInput($this->formParameters['map1'])) . ",

                map2 = " . intval($this->cleanInput($this->formParameters['map2'])) . ",

                map3 = " . intval($this->cleanInput($this->formParameters['map3'])) . ",

                map4 = " . intval($this->cleanInput($this->formParameters['map4']));

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

            // Update ___calculated table

            $sql = "UPDATE " . $projName . "___calculated ";

            $sql .= " SET comment='" . trim($this->cleanInput($this->formParameters['komentar'])) . "'";

            $sql .= ", crosstabVariables='" . implode(",", $cross) . "'";

            $sql .= " WHERE questionName = '" . $this->cleanInput($this->formParameters['qId']) . "'";

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

            $sql = "UPDATE _projects

                    SET ready = " . $this->cleanInput($_POST['ready']) . "

                    WHERE id = '" . $this->cleanInput($this->formParameters['proId']) . "'";

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

        }

        //forma z naslovom, napisom na nogi, časovno komponento, širino, barvo

        else if ($this->formParameters['form_part'] == "other_data") {

            // Update _projects table

            $timed = (isset($this->formParameters['is_timed'])) ? 1 : 0;

            $sql = "UPDATE _projects ";

            $sql .= " SET ready=" . $this->cleanInput($_POST['ready']);

            $sql .= ", longName='" . $this->cleanInput($this->formParameters['naz_proj']) . "'";

            $sql .= ", footerText='" . $this->cleanInput($this->formParameters['footer_text']) . "'";

            $sql .= ", isTimed=" . $timed;

            $sql .= ", showWidth=" . $this->cleanInput($this->formParameters['widths_dropdown']);

            $sql .= ", colorShema=" . $this->cleanInput($this->formParameters['colors_dropdown']);

            $sql .= ", modified_ux=" . time();

            $sql .= " WHERE id = '" . $this->cleanInput($this->formParameters['proId']) . "'";

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function deleteProjEventAction()
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($this->cleanInput($_POST['idP']));

        $projName = str_replace(" ", "_", $projName);

        $sql = "DELETE FROM " . $projName . "___events WHERE id = '" . $this->cleanInput($_POST['idE']) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"returnval":true,"response":true}';

    }

    public function addProjEventAction()
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($this->cleanInput($_POST['idP']));

        $projName = str_replace(" ", "_", $projName);

        $eventDesc = $this->cleanInput($_POST['desc']);

        $eventDate = $this->cleanInput($_POST['dat']);

        $eventDateArray = explode('.', $eventDate);

        $eventDate = mktime(0, 0, 0, trim($eventDateArray[1]), trim($eventDateArray[0]), trim($eventDateArray[2]));

        $sql = "INSERT INTO " . $projName . "___events

                SET id_question = '" . $this->cleanInput($_POST['idQ']) . "',

                event = '" . trim($eventDesc) . "',

                eventTime = '" . $eventDate . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"returnval":true,"response":true}';

    }

    public function updateResearchQuestionAction()
    {

        $resName = $this->getResearcheName($this->cleanInput($_POST['resId']));

        $resName = str_replace(" ", "_", $resName);

        $answerString = '';

        $legendString = '';

        foreach ($this->formParameters as $key => $fe) {

            if (strpos($key, 'aInput_') !== false) {

                $anKeys = explode('_', $key);

                $answerString .= $anKeys[1] . " " . $this->cleanInput($fe) . "/";

            }

            if (strpos($key, 'lInput_') !== false) {

                $lKeys = explode('_', $key);

                $legendString .= $lKeys[1] . " " . $this->cleanInput($fe) . "/";

            }

        }

        $sql = "UPDATE " . $resName . "___calculated ";

        $sql .= " SET question='" . trim($this->cleanInput($this->formParameters['questname'])) . "'";

        $sql .= ", title='" . trim($this->cleanInput($this->formParameters['questtitle'])) . "'";

        $sql .= ", missings='" . trim($this->cleanInput($this->formParameters['questmissings'])) . "'";

        //$sql .= ", missings_mean='" . trim($this -> formParameters['questmeanmissings']) . "'"; //Boštjan Janžovnik - 22.7.2015: zakomentirano, ker tega stolpca ni v tabeli

        $sql .= ", hideAnswers='" . trim($this->cleanInput($this->formParameters['hideansw'])) . "'";

        $sql .= ($answerString != '') ? ", answer='" . rtrim($answerString, "/") . "'" : '';

        $sql .= ($legendString != '') ? ", legend='" . rtrim($legendString, "/") . "'" : '';

        $sql .= " WHERE questionName = '" . $this->cleanInput($this->formParameters['qId']) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function updateProjectQuestionAction()
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($this->cleanInput($_POST['projId']));

        $projName = str_replace(" ", "_", $projName);

        $answerString = '';

        $legendString = '';

        foreach ($this->formParameters as $key => $fe) {

            if (strpos($key, 'aInput_') !== false) {

                $anKeys = explode('_', $key);

                $answerString .= $this->formParameters['aindex_' . $anKeys[1]] . " " . $this->cleanInput($fe) . "/";

            }

            if (strpos($key, 'lInput_') !== false) {

                $lKeys = explode('_', $key);

                $legendString .= $this->formParameters['lindex_' . $lKeys[1]] . " " . $this->cleanInput($fe) . "/";

            }

        }

        //preveri če idji v missings
        $sql = "SELECT *
                FROM " . $projName . "___calculated
                WHERE `id_question` IN (" . trim($this->cleanInput($this->formParameters['questmissings'])) . ")";
        try {
            $result = $this->db->SQLexecute($sql);
        } catch (Exception $e) {
            $this->formParameters['questmissings'] = 0;
        }

        $sql = "UPDATE " . $projName . "___calculated ";

        $sql .= " SET question='" . trim($this->cleanInput($this->formParameters['questname'])) . "'";

        $sql .= ", title='" . trim($this->cleanInput($this->formParameters['questtitle'])) . "'";

        $sql .= ", missings='" . trim($this->cleanInput($this->formParameters['questmissings'])) . "'";

        $sql .= ", missings_mean='" . trim($this->cleanInput($this->formParameters['questmeanmissings'])) . "'";

        $sql .= ", hideAnswers='" . trim($this->cleanInput($this->formParameters['hideansw'])) . "'";

        $sql .= ($answerString != '') ? ", answer='" . rtrim($answerString, "/") . "'" : '';

        $sql .= ($legendString != '') ? ", legend='" . rtrim($legendString, "/") . "'" : '';

        $sql .= " WHERE questionName = '" . $this->cleanInput($this->formParameters['qId']) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function saveResearchWeightAction()
    {

        //$w = ($_POST['weighted'] == true)?1:0;

        $sql = "UPDATE _research ";

        $sql .= " SET weighted=" . $this->cleanInput($_POST['weighted']);

        $sql .= ", modified_ux=" . time();

        $sql .= " WHERE id = '" . $this->cleanInput($_POST['resId']) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    protected function getResearcheName($id)
    {

        $sql = "SELECT project FROM _research WHERE id=" . $this->cleanInput($id);

        $result = $this->db->SQLexecute($sql);

        $row = $this->db->fetchAssoc($result);

        return $row['project'];

    }

    protected function getProjectLongName($id)
    {

        $sql = "SELECT longName FROM _projects WHERE id=" . $this->cleanInput($id);

        $result = $this->db->SQLexecute($sql);

        $row = $this->db->fetchAssoc($result);

        return $row['longName'];

    }

    public function delWidgetAction()
    {

        $sql = "DELETE FROM  _widget WHERE questionId = '" . $this->cleanInput($_POST['qId']) . "'

                                     AND projectId = " . $this->cleanInput($_POST['proId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function removeFromClientAction()
    {

        $sql = "DELETE FROM _clients_by_projects WHERE id_client = " . $this->cleanInput($_POST['cliId']) . "

                                                 AND id_project = " . $this->cleanInput($_POST['proId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function removeFromProjectAction()
    {

        $sel = new Selector($this->db);

        $projGen = new ProjectGenerator($this->db, $sel);

        $projName = $sel->getProjectName($this->cleanInput($_POST['proId']));

        $projGen->removeResFromProj($this->cleanInput($_POST['proId']), $this->cleanInput($_POST['resId']));

        $sql = "DELETE FROM _projects_by_research WHERE id_project = " . $this->cleanInput($_POST['proId']) . "

                                                  AND id_research = " . $this->cleanInput($_POST['resId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        // add HTML generation of clients

        $projRes = $this->makeResearchProjectsHtml($this->cleanInput($_POST['resId']));

        return '{"error":false,"script":false,"response":"' . $projRes . '"}';

    }

    public function addToProjectAction()
    {

        $sel = new Selector($this->db);

        $projGen = new ProjectGenerator($this->db, $sel);

        // Check if project exist

        $projName = str_replace(" ", "_", $sel->getProjectName($this->cleanInput($_POST['proId'])));

        if ($projGen->projExist($projName)) {

            if (!$projGen->resInProj($this->cleanInput($_POST['proId']), $this->cleanInput($_POST['resId']))) {

                $projGen->addResToProj($this->cleanInput($_POST['proId']), $this->cleanInput($_POST['resId']));

            }

        } else {

            $projGen->createNewProj($this->cleanInput($_POST['proId']), $this->cleanInput($_POST['resId']));

        }

        $sql = "INSERT INTO _projects_by_research SET id_project = " . $this->cleanInput($_POST['proId']) . ", id_research = " . $this->cleanInput($_POST['resId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        // add HTML generation of clients

        $projRes = $this->makeResearchProjectsHtml($this->cleanInput($_POST['resId']));

        //return '{"error":false,"script":false,"response":"' . $projRes . '"}';

        return '{"error":false,"script":false,"returnval":true,"response":"' . $projRes . '"}';

    }

    public function makeAnswersDropdown($idQuestion, $idProject, $isWidget = false)
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($idProject);

        $projName = str_replace(" ", "_", $projName);

        $calc = new Calculate($this->db, '_projects', $projName, $idProject);

        $labs = new Labels($this->db, '_projects', $projName, $idProject);

        $labs->setQuestion($idQuestion);

        $calc->setQuestion($idQuestion);

        $params = $calc->getParameters();

        $freq = $calc->getFrequencies();

        $total = $calc->getTotal();

        $labels = $labs->getLabels();

        $aId = 0;

        if ($isWidget) {

            $answArray = $sel->getWidgetAnswers($idProject, $idQuestion);

        }

        $answHtml = "<select id=answId name=answId style='width:360px;height:25px;padding:3px;'>";

        if (intval($params['questionType']) != 2) {

            $first = true;

            foreach ($labels[$idQuestion]['answers'] as $key => $l) {

                if (in_array($key, $answArray) || !$isWidget) {

                    if ($first) {

                        $aId = $key;

                        $first = false;

                    }

                    $answHtml .= "<option value='" . $this->cleanOutput($key) . "'>" . $this->cleanInput($l) . "</option>";

                }

            }

        }

        $answHtml .= '</select>';

        return array('html' => $answHtml, 'aId' => $aId);

    }

    public function showQAnswersAction()
    {

        $sel = new Selector($this->db);

        $idQuestion = $this->cleanInput($_POST['qId']);

        $idProject = $this->cleanInput($_POST['id']);

        $idAnsw = $this->cleanInput($_POST['aId']);

        $projName = $sel->getProjectName($idProject);

        $projName = str_replace(" ", "_", $projName);

        $calc = new Calculate($this->db, '_projects', $projName, $idProject);

        $labs = new Labels($this->db, '_projects', $projName, $idProject);

        $labs->setQuestion($idQuestion);

        $calc->setQuestion($idQuestion);

        $params = $calc->getParameters();

        $freq = $calc->getFrequencies();

        $total = $calc->getTotal();

        $labels = $labs->getLabels();

        if ($_POST['wid'] == "widget") {

            $answArray = $sel->getWidgetAnswers($idProject, $idQuestion);

        }

        $answHtml = "<select id=answId name=answId style='width:360px;height:25px;padding:3px;'>";

        if (intval($params['questionType']) != 2) {

            foreach ($labels[$idQuestion]['answers'] as $key => $l) {

                if (in_array($key, $answArray) || $_POST['wid'] != "widget") {

                    $selected = (trim($idAnsw) == $key) ? "selected" : "";

                    //print_r($selected);

                    $answHtml .= "<option value='" . $this->cleanOutput($key) . "' " . $selected . ">" . $this->cleanOutput($l) . "</option>";

                }

            }

        }

        $answHtml .= '</select>';

        return '{"error":false,"script":false,"response":"' . $answHtml . '"}';

    }

    public function showCrossAction()
    {

        $sel = new Selector($this->db);

        $idQuestion = $this->cleanInput($_POST['qId']);

        $idProject = $this->cleanInput($_POST['id']);

        $idCross = $this->cleanInput($_POST['qIdCross']);

        $project = $sel->getProject($idProject);

        $quest = $sel->getResearchCalculated($project['projectName']);

        if ($_POST['wid'] == "widget") {

            $kriz = $this->makeWidgetCrossDropdown($quest, $idQuestion, $idProject, $idCross);

        } else {

            $kriz = $this->makeCrossDropdown($quest, $idQuestion, $idCross);

        }

        $crossSelect = "<select id=kriz name=kriz>";

        //$crossSelect .= $this->cleanOutput($kriz); //spremenil Boštjan Janžovnik 2.10.2015 13:53

        $crossSelect .= $kriz;

        $crossSelect .= "</select>";

        return '{"error":false,"script":false,"response":"' . $crossSelect . '"}';

    }

    public function checkClientNameAction()
    {

        $title = $this->cleanInput($_POST['name']);

        $action = $this->cleanInput($_POST['checkAction']);

        if ($action == "add") {

            $sql = "SELECT COUNT(id) AS num FROM _clients WHERE client = '" . trim($title) . "'";

        } else {

            $cliId = $this->cleanInput($_POST['id']);

            $sql = "SELECT COUNT(id) AS num FROM _clients WHERE client = '" . trim($title) . "' AND id != " . $cliId;

        }

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($this->db->NumRows($result)) {

            $row = $this->db->fetchAssoc($result);

            if ($row['num'] == "0") {

                return '{"error":false,"script":false,"returnval":true,"response":"ok"}';

            } else {

                return '{"error":false,"script":false,"returnval":true,"response":"duplicated"}';

            }

        }

    }

    public function addToClientAction()
    {

        $sql = "INSERT INTO _clients_by_projects SET id_client = " . $this->cleanInput($_POST['cliId']) . ", id_project = " . $this->cleanInput($_POST['proId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function addNewResearchAction()
    {

        $sel = new Selector($this->db);

        $resGen = new ResearchGenerator($this->db, $sel);

        $sql = "INSERT INTO _research SET project='" . $this->cleanInput($this->formParameters['short_name']) . "',

                                          long_name='" . $this->cleanInput($this->formParameters['res_name']) . "',

                                          created_ux=" . time();

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $resId = $this->db->GetLastInsertId();

        $resName = str_replace(" ", "_", $sel->getResearcheName($resId));

        $sqlFile = str_replace("@ImportFromSPSS@", $resName, $_POST['fdata']);

        $resGen->createNewRes($resId, $sqlFile);

        return '{"error":false,"script":false,"response":""}';

    }

    public function addNewProjectAction()
    {

        $sel = new Selector($this->db);

        $projGen = new ProjectGenerator($this->db, $sel);

        $sql = "INSERT INTO _projects SET projectName = '" . $this->cleanInput($this->formParameters['short_name']) . "',

                                          longName = '" . $this->cleanInput($this->formParameters['proj_name']) . "',

                                          createDate = NOW(),

                                          lastChangeTime = " . time();

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $projId = $this->db->GetLastInsertId();

        $sql = "INSERT INTO _clients_by_projects SET id_client='" . $this->cleanInput($this->formParameters['sel_naroc']) . "',

                                                     id_project='" . $this->cleanInput($projId) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $projName = str_replace(" ", "_", $sel->getProjectName($projId));

        if (isset($this->formParameters['selRes'])) {

            $resArr = explode(",", $this->formParameters['selRes']);

            foreach ($resArr as $resId) {

                if ($projGen->projExist($projName)) {

                    if (!$projGen->resInProj($projId, $resId)) {

                        $projGen->addResToProj($projId, $resId);

                    }

                } else {

                    $projGen->createNewProj($projId, $resId);

                }

                $sql = "INSERT INTO _projects_by_research SET id_project = " . $this->cleanInput($projId) . ", id_research = " . $this->cleanInput($resId);

                if (!$result = $this->db->SQLexecute($sql)) {

                    return $this->db->JsonError();

                }

            }

        }

        return '{"error":false,"script":false,"response":""}';

    }

    // borut, 2015.04.28

    public function saveNewDataAction()
    {

        $uploadedNewData = $this->cleanInput($_POST['fdata']);

        // rabim se na disku file, da lahko naredil LOAD DATA...

        $uploadedFile = "/tmp/" . time() . "newData.txt";

        file_put_contents($uploadedFile, $uploadedNewData);

        //var_dump($uploadedNewData);

        $idP = $_SESSION['project'];

        $sql = "SELECT projectName FROM _projects WHERE id = " . $this->cleanInput($idP);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $row = $this->db->fetchAssoc($result);

        $nameP = $row['projectName'];

        // do some basic check, if this is the real research data, only check for now is, if ID is in first row on first position

        $allData_arr = explode("\r\n", $uploadedNewData);

        $header_arr = explode("\t", $allData_arr[0]);

        if ($header_arr[0] == "id") {

            $allCols_arr = $this->showColumns($nameP . "___data");

            $checkCols = array();

            foreach ($header_arr as $item) {

                if ($item == "weight") {

                    $checkCols[] = "@makeDot";

                } elseif (in_array($item, $allCols_arr)) {

                    $checkCols[] = $item;

                } else {

                    $checkCols[] = "@dummy";

                }

            }

            $sql = "LOAD DATA INFILE '" . $uploadedFile . "'

                    IGNORE INTO TABLE " . $nameP . "___data

                    FIELDS TERMINATED BY '\t'

                    ENCLOSED BY '\"'

                    LINES TERMINATED BY '\r\n'

                    IGNORE 1 LINES

                    (" . implode(",", $checkCols) . ")

                    SET weight = REPLACE(@makeDot, ',', '.')";

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

            unlink($uploadedFile);

            return '{"error":false,"script":false,"response":""}';

        } else {

            return '{"error":true,"script":false,"response":"New data not uploaded!"}';

        }

    }

    // borut, 2015.04.28

    protected function showColumns($table)
    {

        $sql = "SHOW COLUMNS FROM `" . $this->cleanInput($table) . "`";

        $result = $this->db->SQLexecute($sql);

        while ($row = $this->db->fetchAssoc($result)) {

            $arr[] = $row['Field'];

        }

        return $arr;

    }

    public function delResearchAction()
    {

        //$sql = "UPDATE _research SET deleted=1 WHERE id=" . $_POST['resId'];

        $resName = $this->getResearcheName($this->cleanInput($_POST['resId']));

        $resName = str_replace(" ", "_", $resName);

        $sql = "DELETE FROM _research WHERE id=" . $this->cleanInput($_POST['resId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $sql = "DELETE FROM _researchShowTypes WHERE id_research=" . $this->cleanInput($_POST['resId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $sql = "DROP TABLE " . $resName . "___calculated, " . $resName . "___data, " . $resName . "___events";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        // add HTML generation of clients

        //$resAll = $this -> makeResearchesHtml();

        return '{"error":false,"script":false,"response":""}';

    }

    public function delProjectAction()
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($this->cleanInput($_POST['projId']));

        $projName = str_replace(" ", "_", $projName);

        $sql = "DELETE FROM _projects WHERE id=" . $this->cleanInput($_POST['projId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $sql = "DELETE FROM _projectsShowTypes WHERE id_project=" . $this->cleanInput($_POST['projId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $sql = "DELETE FROM _widget WHERE projectId=" . $this->cleanInput($_POST['projId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $sql = "DROP TABLE " . $projName . "___calculated, " . $projName . "___data, " . $projName . "___events";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        // add HTML generation of clients

        //$resAll = $this -> makeResearchesHtml();

        return '{"error":false,"script":false,"response":""}';

    }

    public function delClientAction()
    {

        $sql = "UPDATE _clients SET deleted=1 WHERE id=" . $this->cleanInput($_POST['clientId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        // add HTML generation of clients

        $clientsAll = $this->makeClientsHtml();

        return '{"error":false,"script":false,"response":"' . $clientsAll . '"}';

    }

    public function addClientAction()
    {

        $dateArray = explode('.', $this->cleanInput($this->formParameters['dat_nar']));

        $leaseTime = mktime(0, 0, 0, trim($dateArray[1]), trim($dateArray[0]), trim($dateArray[2]));

        $date2Array = explode('.', $this->cleanInput($this->formParameters['dat_dur']));

        $leaseDuration = mktime(0, 0, 0, trim($date2Array[1]), trim($date2Array[0]), trim($date2Array[2]));

        //$leaseDuration = mktime(0, 0, 0, intval(trim($dateArray[1]))+intval(trim($this -> formParameters['sel_obd'])), trim($dateArray[0]), trim($dateArray[2]));

        $sql = "INSERT INTO _clients SET

        client='" . $this->cleanInput($this->formParameters['nar_ime']) . "',

        longName='" . $this->cleanInput($this->formParameters['nar_polnoime']) . "',

        idColorScheme='" . $this->cleanInput($this->formParameters['colors_dropdown']) . "',

        leaseTime=" . $leaseTime . ",

        leaseDuration=" . $leaseDuration . ",

        idWidgetWidth='" . $this->cleanInput($this->formParameters['widths_dropdown']) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function deleteClientAction()
    {

        $idClient = $this->cleanInput($this->formParameters['cliId']);

        $sql = "SELECT id AS numUsers FROM _users_by_clients WHERE id_client=" . $idClient;

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($this->db->NumRows($result) > 0) {

            return '{"error":false,"script":false, "returnval":true, "response":"client_has_users"}';

        } else {

            $sql = "DELETE FROM _clients WHERE id=" . $idClient;

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

            return '{"error":false,"script":false,"response":"ok"}';

        }

    }

    public function updateClientAction()
    {

        $dateArray = explode('.', $this->cleanInput($this->formParameters['dat_nar']));

        $leaseTime = mktime(0, 0, 0, trim($dateArray[1]), trim($dateArray[0]), trim($dateArray[2]));

        //$leaseDuration = mktime(0, 0, 0, intval(trim($dateArray[1]))+intval(trim($this -> formParameters['sel_obd']))*3, trim($dateArray[0]), trim($dateArray[2]));

        $sql = "UPDATE _clients SET

        client='" . $this->cleanInput($this->formParameters['nar_ime']) . "',

        idColorScheme='" . $this->cleanInput($this->formParameters['colors_dropdown']) . "',

        idWidgetWidth='" . $this->cleanInput($this->formParameters['widths_dropdown']) . "',

        leaseDuration=" . $leaseTime . ",

        longName='" . $this->cleanInput($this->formParameters['nar_polnoime']) . "'

        WHERE id=" . $this->cleanInput($this->formParameters['cliId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        //Change all existing widgets

        /*if (isset($this->formParameters['chngwidgall'])) {

        }

        //Change all existing widgets, if they were set to default

        if (isset($this->formParameters['chngwidg'])) {

        }*/

        return '{"error":false,"script":false,"response":""}';

    }

    public function addProjectAction()
    {

        $sql = "INSERT INTO _projects SET projectName='" . $this->cleanInput($this->formParameters['projName']) . "',

                                          longName='" . $this->cleanInput($this->formParameters['projLongName']) . "',

                                          createDate = NOW(),

                                          lastChangeTime=" . time();

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $cliId = $_SESSION['client'];

        $projId = $this->db->GetLastInsertId();

        $sql = "INSERT INTO _clients_by_projects SET id_client='" . $cliId . "', id_project='" . $projId . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        // add HTML generation of clients

        $cliProj = $this->makeClientProjectsHtml($cliId, null);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($cliProj) . '"}';

    }

    public function addClientUserAction()
    {

        $group = $this->cleanInput($this->formParameters['sel_profil']);

        $group = filter_var($group, FILTER_SANITIZE_NUMBER_INT);

        if (strpos($this->formParameters['nar_ime'], " ")) {

            $user = explode(" ", $this->cleanInput($this->formParameters['nar_ime']));

            $firstname = $user[0];

            $surname = $user[1];

        } else {

            $firstname = $this->cleanInput($this->formParameters['nar_ime']);

            $surname = "";

        }

        $sql = "INSERT INTO `_user` (`group`,`username`,`Firstname`,`Surname`,`email`, `password`,`language`)

                VALUES (" . $group . ",

                        '" . $this->cleanInput($this->formParameters['nar_uname']) . "',

                        '" . $this->cleanInput($firstname) . "',

                        '" . $this->cleanInput($surname) . "',

                        '" . $this->cleanInput($this->formParameters['nar_email']) . "',

                        '" . md5($this->formParameters['nar_pass']) . "',

                        " . $this->cleanInput($this->formParameters['sel_lang']) . ")";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $sql = "INSERT INTO `_users_by_clients`

                SET `id_user`=" . $this->db->GetLastInsertId() . ",

                    `id_client`=" . $this->cleanInput($this->formParameters['sel_naroc']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        $usersAll = $this->makeUsersHtml();

        return '{"error":false,"script":false,"response":""}';

    }

    public function updateUserAction()
    {

        $group = $this->cleanInput($this->formParameters['sel_profil']);

        $group = filter_var($group, FILTER_SANITIZE_NUMBER_INT);

        if (strpos($this->formParameters['nar_ime'], " ")) {

            $user = explode(" ", $this->formParameters['nar_ime']);

            $firstname = $user[0];

            $surname = $user[1];

        } else {

            $firstname = $this->formParameters['nar_ime'];

            $surname = "";

        }

        $password = $this->formParameters['nar_pass'];

        if (strlen($password) > 0) {

            $pass = "`password` = md5('" . $this->formParameters['nar_pass'] . "'), ";

        }

        $sql = "UPDATE `_user` SET

                `group` = " . $group . ",

                `username` = '" . $this->cleanInput($this->formParameters['nar_email']) . "',

                `firstname` = '" . $this->cleanInput($firstname) . "',

                `surname` = '" . $this->cleanInput($surname) . "',

                " . $pass . "

                `email` = '" . $this->cleanInput($this->formParameters['nar_email']) . "',

                `username` = '" . $this->cleanInput($this->formParameters['nar_uname']) . "',

                `language` = " . $this->cleanInput($this->formParameters['sel_lang']) . "

                WHERE `id` = " . $this->cleanInput($this->formParameters['userId']);

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($this->formParameters['sel_naroc'] != 1) {

            $sql = "UPDATE `_users_by_clients` SET

                        `id_client` = " . $this->cleanInput($this->formParameters['sel_naroc']) . "

                        WHERE `id_user` = " . $this->cleanInput($this->formParameters['userId']);

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

        }

        return '{"error":false,"script":true,"response":""}';

    }

    public function deleteUserAction()
    {

        $userId = $this->cleanInput($this->formParameters['userId']);

        $userGroup = $this->cleanInput($this->formParameters['userGroup']);

        $sql = "DELETE FROM _user WHERE id=" . $userId;

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($userGroup > 1) {

            $sql = "DELETE FROM _users_by_clients WHERE id_user=" . $userId;

            if (!$result = $this->db->SQLexecute($sql)) {

                return $this->db->JsonError();

            }

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function getPermissionsAction()
    {

        $profileId = $this->cleanInput($_POST['profileId']);

        $sel = new Selector($this->db);

        $arr = $sel->getPermissions($profileId);

        if ($arr === false) {

            return $this->db->JsonError();

        }

        $jsonEncoded = json_encode($arr);

        return '{"error":false,"script":false, "returnval":true, "response":' . $jsonEncoded . '}';

    }

    public function getAllPermissionsAction()
    {

        $profiles = $this->cleanInput($_POST['profiles']);

        $sel = new Selector($this->db);

        $arr = $sel->getAllPermissions($profiles);

        if ($arr === false) {

            return $this->db->JsonError();

        }

        $jsonEncoded = json_encode($arr);

        return '{"error":false,"script":false, "returnval":true, "response":' . $jsonEncoded . '}';

    }

    public function addNewPermissionProfileAction()
    {

        $permIds = $this->cleanInput($_POST['permIds']);

        $profileName = htmlspecialchars($this->cleanInput($_POST['profName']), ENT_QUOTES);

        if (strlen($profileName) > 5) {

            $profShortName = strtolower(substr($profileName, 0, 5));

        } else {

            $profShortName = strtolower($profileName);

        }

        $sql = "SELECT id FROM _permission_profiles WHERE profileName='" . $profileName . "' AND enabled=1";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        if ($this->db->NumRows($result) > 0) {

            return '{"error":false,"script":false, "returnval":true, "response":"profile_exists"}';

        }

        $sql = "INSERT INTO _permission_profiles(shortName,profileName,enabled) VALUES('" . $profShortName . "','" . $profileName . "',1)";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        $profileId = $this->db->GetLastInsertId();

        if (strlen($permIds) != 0) {

            $permIds = explode(',', $permIds);

            foreach ($permIds as $id) {

                $sql = "INSERT INTO _permissions_by_p_profiles(idProfile,idPermission) VALUES(" . $profileId . "," . $id . ")";

                if (!$result = $this->db->SQLexecute($sql)) {

                    echo $this->db->JsonError();

                    exit;

                }

            }

        } else {

            $sql = "INSERT INTO _permissions_by_p_profiles(idProfile,idPermission) VALUES(" . $profileId . ",0)";

            if (!$result = $this->db->SQLexecute($sql)) {

                echo $this->db->JsonError();

                exit;

            }

        }

        //permissions

        //$perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        return '{"error":false,"script":false, "returnval":true, "response":"' . $this->cleanHTML($this->makePermissionProfilesOptionHtml()) . '"}';

    }

    public function deletePermissionProfileAction()
    {

        $profileId = $this->cleanInput($_POST['profId']);

        if (!isset($profileId)) {

            $profileId = 0;

        }

        $sql = "SELECT COUNT(id) AS num FROM _user u WHERE u.group=" . $profileId;

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        $row = $this->db->fetchAssoc($result);

        if ($row['num']) {

            $numUsers = $row['num'];

            $json = array('res' => 'napaka', 'num' => $numUsers);

            $json = json_encode($json);

            return '{"error":false,"script":false, "returnval":true, "response":' . $json . '}';

        } else {

            $sql = "DELETE FROM _permissions_by_p_profiles WHERE idProfile=" . $profileId;

            if (!$result = $this->db->SQLexecute($sql)) {

                echo $this->db->JsonError();

                exit;

            }

            $sql = "DELETE FROM _permission_profiles WHERE id=" . $profileId;

            if (!$result = $this->db->SQLexecute($sql)) {

                echo $this->db->JsonError();

                exit;

            }

            $json = array('res' => 'deleted');

            $json = json_encode($json);

            return '{"error":false,"script":false, "returnval":true, "response":' . $json . '}';

        }

    }

    public function showUserByClient($userId = 0, $idGroup = 0)
    {

        $arr = array();

        $sql = "SELECT id_client FROM _users_by_clients WHERE id_user=" . $this->cleanInput($userId);

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        if ($this->db->NumRows($result) > 0) {

            $row = $this->db->fetchAssoc($result);

            if ($row['id_client'] == 0) {

                $hasClient = false;

            } else {

                $hasClient = true;

            }

        } else {

            $hasClient = false;

        }

        if (!$hasClient) {

            $sql = "SELECT u.group AS usergroup,username,Firstname,Surname,email,language FROM _user u

                WHERE id=" . $this->cleanInput($userId);

        } else {

            $sql = "SELECT u.group AS usergroup,username,Firstname,Surname,email,language,c.id AS clientId, c.client AS client FROM _user u, _users_by_clients uc, _clients c

                WHERE u.id=" . $this->cleanInput($userId) . " AND uc.id_user=u.id AND uc.id_client=c.id ";

        }

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        while ($row = $this->db->fetchAssoc($result)) {

            $arr['userId'] = $userId;

            $arr['group'] = $row['usergroup'];

            $arr['username'] = $row['username'];

            $arr['firstname'] = $row['Firstname'];

            $arr['surname'] = $row['Surname'];

            $arr['email'] = $row['email'];

            $arr['language'] = $row['language'];

            if (!$hasClient) {

                $arr['clientId'] = 0;

                $arr['client'] = '';

            } else {

                $arr['clientId'] = $row['clientId'];

                $arr['client'] = $row['client'];

            }

        }

        return $arr;

    }

    protected function getNumUsersByClient()
    {

        $sql = "SELECT c.id, COUNT(uc.id) AS numUsers FROM _clients c, _users_by_clients uc WHERE deleted=0 AND uc.id_client=c.id GROUP BY client ";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        while ($row = $this->db->fetchAssoc($result)) {

            $arr[$row['id']]['numUsers'] = $row['numUsers'];

        }

        $sql = "SELECT id,client,longName,leaseDuration FROM _clients WHERE deleted=0 ORDER BY client";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        while ($row = $this->db->fetchAssoc($result)) {

            $clients[$row['id']]['name'] = $row['client'];

            $clients[$row['id']]['longName'] = $row['longName'];

            $clients[$row['id']]['leaseDuration'] = $row['leaseDuration'];

        }

        $clientsCopy = $clients;

        foreach ($clients as $id => $client) {

            $found = false;

            foreach ($arr as $cliId => $num) {

                if ($id == $cliId) {

                    $clientsCopy[$id]['numUsers'] = $num['numUsers'];

                    $found = true;

                }

            }

            if (!$found) {

                $clientsCopy[$id]['numUsers'] = 0;

            }

        }

        return $clientsCopy;

    }

    public function getClientData($id)
    {

        return $this->getClients($id);

    }

    protected function getClients()
    {

        $sql = "SELECT id,client,longName,idColorScheme,idWidgetWidth,leaseTime,leaseDuration FROM _clients WHERE deleted=0 ORDER BY client"; // spremenjeno 05.02.2014, Sandi

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        while ($row = $this->db->fetchAssoc($result)) {

            $arr[$row['id']]['name'] = $row['client'];

            $arr[$row['id']]['longName'] = $row['longName'];

            $arr[$row['id']]['showWidth'] = $row['idWidgetWidth'];

            $arr[$row['id']]['colorShema'] = $row['idColorScheme'];

            $arr[$row['id']]['leaseTime'] = $row['leaseTime'];

            $arr[$row['id']]['leaseDuration'] = $row['leaseDuration'];

        }

        return $arr;

    }

    public function getClientPeriodsOptionHtml($idLang)
    {

        $sql = "SELECT cp.id, period, lp.translate_text FROM _client_periods cp, _languagePack lp WHERE cp.enabled=1 AND lp.id_language=" . $this->cleanInput($idLang) . " AND cp.unitName=lp.translate_key";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        $html = '';

        while ($row = $this->db->fetchAssoc($result)) {

            $html .= "<option value='" . $this->cleanOutput($row['period']) . "'>" . $this->cleanOutput($row['period'] . " " . $row['translate_text']) . "</option>";

        }

        return $this->cleanHTML($html);

    }

    protected function getUsers()
    {

        $sql = "SELECT u.id,u.group,Firstname,profileName,Surname,email FROM _user u,_permission_profiles pp WHERE pp.id=u.group  ORDER BY Firstname,u.group,Surname";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        while ($row = $this->db->fetchAssoc($result)) {

            $arr[$row['id']]['firstname'] = $row['Firstname'];

            $arr[$row['id']]['surname'] = $row['Surname'];

            $arr[$row['id']]['email'] = $row['email'];

            $arr[$row['id']]['group'] = $row['group'];

            $arr[$row['id']]['profile'] = $row['profileName'];

        }

        return $arr;

    }

    protected function getResearches()
    {

        $arr = array();

        $sql = "SELECT id,project,long_name,weighted,created_idUser,created_ux FROM _research WHERE deleted=0 ORDER BY project";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        while ($row = $this->db->fetchAssoc($result)) {

            $arr[$row['id']]['name'] = $row['project'];

            $arr[$row['id']]['longName'] = $row['long_name'];

            $arr[$row['id']]['weighted'] = $row['weighted'];

            $arr[$row['id']]['created_ux'] = $row['created_ux'];

            $arr[$row['id']]['created_idUser'] = $row['created_idUser'];

        }

        return $arr;

    }

    protected function getClientResearches($cliId)
    {

        $arr = array();

        $sql = "SELECT id, project, long_name, weighted, created_idUser, created_ux

                FROM _research

                WHERE deleted = 0 AND id IN

                (

                    SELECT DISTINCT id_research FROM _projects_by_research WHERE id_project IN

                    (

                        SELECT DISTINCT p.id

                        FROM _projects p, _clients_by_projects c

                        WHERE p.id = c.id_project AND c.id_client=" . $this->cleanInput($cliId) . " AND p.deleted=0

                    )

                )

                ORDER BY project";

        if (!$result = $this->db->SQLexecute($sql)) {

            echo $this->db->JsonError();

            exit;

        }

        while ($row = $this->db->fetchAssoc($result)) {

            $arr[$row['id']]['name'] = $row['project'];

            $arr[$row['id']]['longName'] = $row['long_name'];

            $arr[$row['id']]['weighted'] = $row['weighted'];

            $arr[$row['id']]['created_ux'] = $row['created_ux'];

            $arr[$row['id']]['created_idUser'] = $row['created_idUser'];

        }

        return $arr;

    }

    protected function getProjects()
    {

        $arr = array();

        $sql = "SELECT id, projectName, longName, ready, createDate FROM _projects WHERE deleted=0 ORDER BY ready";

        if ($result = $this->db->SQLexecute($sql)) {

            while ($row = $this->db->fetchAssoc($result)) {

                $arr[$row['id']]['name'] = $row['projectName'];

                $arr[$row['id']]['longName'] = $row['longName'];

                $arr[$row['id']]['ready'] = $row['ready'];

                $arr[$row['id']]['createDate'] = $row['createDate'];

            }

            return $arr;

        } else {

            return false;

        }

    }

    public function getClientProjects($cliId)
    {

        $arr = array();

        $sql = "SELECT DISTINCT _projects.id, _projects.projectName, _projects.longName, _projects.ready, _projects.createDate FROM _projects,_clients_by_projects ";

        $sql .= " WHERE _projects.id = _clients_by_projects.id_project AND _clients_by_projects.id_client=" . $this->cleanInput($cliId);

        $sql .= " AND _projects.deleted=0 ORDER BY _projects.ready";

        if ($result = $this->db->SQLexecute($sql)) {

            while ($row = $this->db->fetchAssoc($result)) {

                $arr[$row['id']]['name'] = $row['projectName'];

                $arr[$row['id']]['longName'] = $row['longName'];

                $arr[$row['id']]['ready'] = $row['ready'];

                $arr[$row['id']]['createDate'] = $row['createDate'];

            }

            return $arr;

        } else {

            return false;

        }

    }

    public function getClientReadyProjects($cliId)
    {

        $arr = array();

        $sql = "SELECT DISTINCT _projects.id, _projects.projectName, _projects.longName, _projects.ready FROM _projects,_clients_by_projects ";

        $sql .= " WHERE _projects.id = _clients_by_projects.id_project AND _clients_by_projects.id_client=" . $this->cleanInput($cliId);

        $sql .= " AND _projects.deleted=0 AND _projects.ready=1 ORDER BY _projects.projectName";

        //echo $sql;

        if ($result = $this->db->SQLexecute($sql)) {

            while ($row = $this->db->fetchAssoc($result)) {

                $arr[$row['id']]['name'] = $row['projectName'];

                $arr[$row['id']]['longName'] = $row['longName'];

                $arr[$row['id']]['ready'] = $row['ready'];

            }

            return $arr;

        } else {

            return false;

        }

    }

    public function checkProjectNameAction()
    {

        $sql = "SELECT project FROM _research WHERE project LIKE '" . $this->cleanInput($_POST['projName']) . "'";

        $res = $this->db->SQLexecute($sql);

        if ($this->db->NumRows($res) > 0) {

            $returnVal = "false";

        } else {

            $returnVal = "true";

        }

        return '{"error":false,"script":false,"returnval":true,"response":"' . $returnVal . '"}';

    }

    public function checkShortResAction()
    {

        $sql = "SELECT * FROM _research where project='" . $this->cleanInput($_POST['short']) . "'";

        if ($result = $this->db->SQLexecute($sql)) {

            $returnVal = ($this->db->NumRows($result) > 0) ? "true" : "false";

        } else {

            $returnVal = "false";

        }

        return '{"error":false,"script":false,"returnval":true,"response":' . $returnVal . '}';

    }

    protected function checkResProjects($resId, $projId)
    {

        $sql = "SELECT * FROM _projects_by_research WHERE id_research=" . $this->cleanInput($resId) . " and id_project=" . $this->cleanInput($projId);

        $result = $this->db->SQLexecute($sql);

        $row = $this->db->fetchAssoc($result);

        return ($row) ? true : false;

    }

    //dashboard

    public function makeDashboardsDropdownHtml($dashId = null)
    {

        $html = "";

        $sql = "SELECT `id`, `name` FROM `_dashboard` ORDER BY `create_date` DESC";

        $res = $this->db->SQLexecute($sql);

        $num = $this->db->NumRows($res);

        if ($num > 0) {

            while ($dat = $this->db->fetchAssoc($res)) {

                $selected = "";

                if ($dat['id'] == $dashId) {

                    $selected = ' selected="true"';

                }

                if (strlen($dat['name']) > 30) {

                    $dat['name'] = substr($dat['name'], 0, 30) . "...";

                }

                $html .= '<option value="' . $this->cleanOutput($dat['id']) . '"' . $selected . '>' . $this->cleanOutput($dat['name']) . '</option>';

            }

        } else {

            $html .= "<option disabled>No dashboards</option>";

        }

        return $html;

    }

    //dashboard

    public function makeUsersHtml()
    {

        $html = "";

        $sel = new Selector($this->db);

        /*if($_SESSION['UserInfo']['group'] == 1 && (!isset($_POST['id_n']) or $_POST['id_n'] == 0))

        $users = $this->getUsers();

        else

        $users = $sel->getClientUsers($_POST['id_n']);*/

        if ($_SESSION['UserInfo']['group'] == 1) {

            $users = $this->getUsers();

        } else {

            $cliId = $sel->getUserClientId($_SESSION['UserInfo']['id']);

            $users = $sel->getClientUsers($cliId);

        }

        foreach ($users as $key => $user) {

            $client = $sel->getUserClient($key);

            $html .= '<tr>';

            if (in_array('edit_user', $_SESSION['UserPermissions'])) {

                $html .= '<td><h5><a href=javascript:showUser(' . $this->cleanOutput($key) . ',' . $this->cleanOutput($user['group']) . ');>' . $this->cleanOutput($user['firstname'] . ' ' . $user['surname']) . '</a></h5></td>';

            } else {

                $html .= '<td><h5>' . $this->cleanOutput($user['firstname'] . ' ' . $user['surname']) . '</h5></td>';

            }

            $html .= '<td>' . $this->cleanOutput($client) . '</td>

                      <td>' . $this->cleanOutput($user['profile']) . '</td>

                      </tr>';

        }

        return $this->cleanHTML($html);

    }

    public function makeClientsHtml()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'clients', DB_WARPIT_STATVIEW);

        $html = "";

        $clients = $this->getNumUsersByClient();

        foreach ($clients as $key => $client) {

            $days = floor(($client['leaseDuration'] - time()) / (60 * 60 * 24));

            $daysLeft = ($days >= 0) ? $days : 0;

            $html .= '<tr>

                      <td><h5 style="margin-top:3px;"><a href=javascript:showClient(' . $this->cleanOutput($key) . ');>' . $this->cleanOutput($client['name']) . '</a></h5></td>

                      <td>' . date("j.n.Y", $client['leaseDuration']) . ' (' . $this->cleanOutput($language['subscription_ExtAftr'] . ' ' . $daysLeft . ' ' . $language['subscription_ExtDay']) . ')</td>

                      <td>' . $this->cleanOutput($client['numUsers']) . '</td>

                      </tr>';

        }

        return $this->cleanHTML($html);

    }

    public function makeClientsOptionHtml($selectedId = 0)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'project'", "'default'"), DB_WARPIT_STATVIEW);

        $html = "";

        $clients = $this->getClients();

        if ($_SESSION['UserInfo']['group'] == 1) {

            foreach ($clients as $key => $client) {

                if ($key == $selectedId) {

                    $html .= '<option value="' . $this->cleanOutput($key) . '" selected="true">' . $this->cleanOutput($client['name']) . '</option>';

                } else {

                    $html .= '<option value="' . $this->cleanOutput($key) . '" >' . $this->cleanOutput($client['name']) . '</option>';

                }

            }

        } else {

            $sel = new Selector($this->db);

            $cliId = $sel->getCliId($_SESSION['UserInfo']['id']);

            $html .= '<option value="' . $this->cleanOutput($cliId) . '" >' . $this->cleanOutput($clients[$cliId]['name']) . '</option>';

        }

        return $this->cleanHTML($html);

    }

    public function makeLaguagesOptionHtml()
    {

        $sel = new Selector($this->db);

        $html = "";

        $languages = $sel->getLanguages();

        foreach ($languages as $key => $val) {

            $html .= '<option value="' . $this->cleanOutput($val['id']) . '">' . $this->cleanOutput($val['cp_comment']) . '</option>';

        }

        return $this->cleanHTML($html);

    }

    public function getClientHtmlAction()
    {

        $cId = $this->cleanInput($_POST['cId']);

        $clientData = $this->getClientData($cId);

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'project'", "'clients'", "'default'", "'users'"), DB_WARPIT_STATVIEW);

        $days = floor(($clientData[$cId]['leaseDuration'] - time()) / (60 * 60 * 24));

        $daysLeft = ($days >= 0) ? $days : 0;

        $readonly = "";

        if (!in_array('edit_client', $_SESSION['UserPermissions'])) {

            $readonly = " readonly ";

        }

        $html = "

        <!-- name, full name -->

        <form id='clientUpdateForm' name='narocnikForm'>

        <input type='hidden' name='cliId' value='" . $this->cleanOutput($cId) . "'/>

        <div class='sd5'>

           <div class='nap'>" . $this->cleanOutput($language['cli_title']) . ":</div>

           <div class='vnos'><input name='nar_ime' type='text' required='true' maxlength='100' value='" . $this->cleanOutput($clientData[$cId]['name']) . "'";

        if (!in_array('edit_client', $_SESSION['UserPermissions'])) {$html .= "readonly";}$html .= "/></div>

           <div class='nap' style='clear:both'>" . $this->cleanOutput($language['name_full']) . ":</div>

           <div class='vnos'><input name='nar_polnoime' type='text' maxlength='200' value='" . $this->cleanOutput($clientData[$cId]['longName']) . "'";

        if (!in_array('edit_client', $_SESSION['UserPermissions'])) {$html .= "readonly";}$html .= "/></div>

        </div>

        <!-- subscription -->

        <div class='sd5g w960'>

           <div class='nap' style='margin-top:-5px;'>" . $this->cleanOutput($language['subscription']) . "</div>

        </div>

        <div class='passica w960' style='height:auto;margin-bottom:5px;'>

            <div class='s_x4w'>" . $this->cleanOutput($language['subscription_date']) . ": <b>" . date("j.n.Y", $clientData[$cId]['leaseTime']) . "</b></div>

            <div class='crtax w960'></div>";

        if (in_array('edit_client', $_SESSION['UserPermissions'])) {

            $html .= "<div class='s_x4' style='width:400px;margin-right:200px;margin-top:3px;'>" . $this->cleanOutput($language['subscription_periodExpp']) . ":

                         <input type='text' id='dat_nar' name='dat_nar' required='true' readonly='true'

                         pattern='^([1-9]|0[1-9]|[1-2][0-9]|3[0-1]).([1-9]|0[1-9]|1[0-2]).[0-9]{4}$' title='" . $language['urs_alertName23'] . "'

                         value='" . date("j.n.Y", $clientData[$cId]['leaseDuration']) . "'>";

        } else {

            $html .= "<div class='s_x4' style='width:450px;'>" . $this->cleanOutput($language['subscription_periodExpp']) . ":

                         <b>" . date("j.n.Y", $clientData[$cId]['leaseDuration']) . "</b>";

        }

        $html .= "

                <span class='red'><b>(" . $this->cleanOutput($language['subscription_ExtAftr'] . " " . $daysLeft . " " . $language['subscription_ExtDay']) . ")</b></span>

            </div>";

        if (in_array('edit_client', $_SESSION['UserPermissions'])) {

            $html .= "<div class='s_x4' style='width:auto;margin-top:3px;float:left;'>

                              " . $language['subscription_periodExt'] . ":

                              <select class='sezrazobd' name='sel_obd'>

                                <option value='' disabled selected>" . $this->cleanOutput($language['proj_select']) . "...</option>

                                " . $this->getClientPeriodsOptionHtml($_SESSION['UserInfo']['language']) . "

                              </select>

                          </div>";

        }

        $html .= "

        </div>

        <!-- default settings -->

        <div class='sd5g w960' style='margin-top: -10px;'>

            <div class='nap' style='margin-top:-5px;'>" . $this->cleanOutput($language['subscription_defSet']) . "</div>

        </div>

        <div class='passica w960' id='def_sett_div' style='height:auto;margin-bottom:5px;margin-top:20px'>

            <table>

                <tr>

                   <td><div id='sirina_label' class='sel' style='width:170px;margin-bottom:5px;'>" . $this->cleanOutput($language['subscription_ww']) . ":</div></td>

                   <td><div id='color_label' class='sel' style='width:170px;margin-bottom:5px;'>" . $this->cleanOutput($language['subscription_col']) . ":</div></td>

                </tr>

                <tr>

                    <td>" . $this->makeCliWidthDropdown($clientData[$cId]) . "</td>

                    <td>" . $this->makeCliColorDropdown($clientData[$cId]) . "</td>

                </tr>

            </table>";

        if (in_array('edit_client', $_SESSION['UserPermissions'])) {

            $html .= "

                <div class='nar_cb'>

                    <input name='chngwidgall' type='checkbox'/>" . $this->cleanOutput($language['client_Change']) . "

                </div>

                <div class='nar_cb'>

                    <input name='chngwidg' type='checkbox'/>" . $this->cleanOutput($language['client_ChangeIfDef']) . "

                </div>";

        }

        $html .= "

        </div>

        <div id='crta' style='width:100%;margin-top:10px;'></div>";

        if (in_array('edit_client', $_SESSION['UserPermissions'])) {

            $html .= "<div class='izbira' style='margin-top:25px;width:100%'>

                          <button type='submit' form='clientUpdateForm' class='shraniosn'><img src='_img/kljukica.png' alt='kljukica' /> " . $language['save'] . "</button>

                          <a href='#'><div class='zavrzi' id='cancelUpdateClientButton'>" . $this->cleanOutput($language['cancel']) . "</div></a>

                          <a href='#'><div class='zavrzir' id='deleteClientButton' style='float:right;'>" . $this->cleanOutput($language['client_DelClient']) . "</div></a>

                          <input type=hidden name=selcolor value='" . $this->cleanOutput($clientData[$cId]['colorShema']) . "'>

                          <input type=hidden name=selwidth value='" . $this->cleanOutput($clientData[$cId]['showWidth']) . "'>

                          <input type=hidden name=cliId value='" . $this->cleanOutput($cId) . "'>

                     </div>";

        }

        $html .= "</form>";

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getClientProjectsHtmlAction()
    {

        $cId = $this->cleanInput($_POST['cId']);

        $clientData = $this->getClientData($cId);

        $cliProj = $this->getClientProjects($cId);

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'project'", "'clients'", "'default'", "'users'"), DB_WARPIT_STATVIEW);

        $html = "

        <input type='hidden' name='cliId' value='" . $this->cleanOutput($cId) . "'/>

        <div class='table-responsive' style='float:left;width:100%;'>

            <table id='ClientProjectsTable' class='table table-striped table-hover' width='100%' >

                <thead>

                    <tr>

                        <td>" . $this->cleanOutput($language['client_editPro']) . "</td>";

        if (in_array('edit_client', $_SESSION['UserPermissions'])) {

            $html .= "<td></td>";

        }

        $html .= "</tr>

                </thead>

                <tbody>

                    " . $this->makeClientProjects($cliProj) . "

                </tbody>

            </table>

        </div>";

        if (in_array('edit_client', $_SESSION['UserPermissions'])) {

            $html .= "

            <div class='sd5g w960'>

                <div class='nap' style='margin-top:-5px;'>" . $this->cleanOutput($language['client_editProAdd']) . "</div>

            </div>

            <select class='sezraz' id='projDrop' style='padding:0;margin-top:15px;height:32px;float:left;width:350px;'>

                <option value='' disabled selected>" . $this->cleanOutput($language['proj_select']) . "...</option>

                " . $this->makeClientProjSelector($cliProj) . "

            </select>

            <div class='zavrzi w80' style='float:left;padding:5px; margin:15px 15px 0;' id='addClientProjBtn' onclick='javascript:addProjToCli();'>" . $this->cleanOutput($language['add_btn']) . "</div>";

        }

        $html .= "<div id='crta' style='margin-top:15px;width:100%;'></div>

        <script>

            $(document).ready(function(){

                $('#ClientProjectsTable').dataTable({

                    'language': { 'url': '_javascript/dataTables.slo.lang.php'},";

        if (in_array('edit_client', $_SESSION['UserPermissions'])) {

            $html .= "'aoColumns': [null, { 'bSortable': false }],";

        }

        $html .= "

                    'initComplete': function(settings, json) {

                        $('.table-responsive').find('[type=search]').attr('maxlength', 50);

                    },

                    'columnDefs': [

			            { 'type': 'string-case', targets: 0 }

			        ]

                });

            });

        </script>

        ";

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function makePermissionProfilesOptionHtml($selectedId = -1)
    {

        $html = "";

        $sel = new Selector($this->db);

        $profiles = $sel->getPermissionProfiles($selectedId);

        foreach ($profiles as $profile) {

            $profileId = filter_var($profile['profileId'], FILTER_SANITIZE_NUMBER_INT);

            if ($profile['profileId'] == $selectedId) {

                $html .= '<option value="' . $this->cleanOutput($profileId) . '" selected="true">' . $this->cleanOutput($profile['profileName']) . '</option>';

            } else {

                $html .= '<option value="' . $this->cleanOutput($profileId) . '" >' . $this->cleanOutput($profile['profileName']) . '</option>';

            }

        }

        return $html;

    }

    public function makePermissionsHtml($forIdProfile = 0)
    {

        $html = "";

        $idLang = $_SESSION['UserInfo']['language'];

        $sel = new Selector($this->db);

        if ($forIdProfile == 0) {

            $allPermissions = $sel->getPermissions();

            $permissionLanguage = $sel->getPermissionLanguage($allPermissions, $idLang);

        } else {

            $userPermissions = $sel->getPermissions($forIdProfile);

            $permissionLanguage = $sel->getPermissionLanguage($userPermissions, $idLang);

        }

        foreach ($permissionLanguage as $permission) {

            /*$html .= '<div class="s_x4" style="width:95%;">'.$this->cleanOutput($permission['translate_text']) .'</div>

            <div class="s_x2"><input name="permission" type="checkbox" value="'.$this->cleanOutput($permission['id']).'" /></div>

            <div class="crtax" style="width:97%;"></div>';*/

            $html .= '<tr>

                        <td>' . $this->cleanOutput($permission['translate_text']) . '</td>

                        <td><input name="permission" type="checkbox" value="' . $this->cleanOutput($permission['id']) . '" /></td>

                     </tr>';

        }

        return $this->cleanHTML($html);

    }

    public function makeResearchesHtml()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = "";

        $sel = new Selector($this->db);

        if ($_SESSION['UserInfo']['group'] == 1) {

            $researches = $this->getResearches();

        } else {

            $sel = new Selector($this->db);

            $cliId = $sel->getCliId($_SESSION['UserInfo']['id']);

            $researches = $this->getClientResearches($cliId);

        }

        if (!empty($researches)) {

            foreach ($researches as $key => $research) {

                $resCreator = $sel->getResearchCreator($research['created_idUser']);

                $weighted = ($research['weighted']) ? "<img src='_img/utez_ze.png' alt='utež ze' /> " . $this->cleanOutput($language['yes']) : "<img src='_img/utez_rd.png' alt='utež rd' /> " . $this->cleanOutput($language['no']);

                $html .= "<tr>

                            <td><h5><a href=javascript:showResearch(" . $this->cleanOutput($key) . ");>" . $this->cleanOutput($research['longName']) . "</a></h5>

                            (" . $this->cleanOutput($language['research_id']) . ": " . $this->cleanOutput($key) . ", " . $this->cleanOutput($resCreator) . ", " . date("j.n.Y H:i", $research['created_ux']) . ")

                            </td>

                            <td style='padding-top:12px;'>" . $weighted . "</td>

                         </tr>";

            }

        }

        return $this->cleanHTML($html);

    }

    public function makeProjResearches($researches)
    {

        $html = "";

        foreach ($researches as $key => $res) {

            $html .= "<tr>

                         <td><input type='hidden' id='res_id_" . $this->cleanOutput($key) . "' value='" . $this->cleanOutput($key) . "' />

                             <h5 style='margin-top:3px;margin-bottom:0'>" . $this->cleanOutput($res['longName']) . "</h5></td>

                         <td>";

            if (in_array('edit_project', $_SESSION['UserPermissions'])) {

                $html .= "<div class=fr style='text-align:right;margin-right:12px;'><a href='javascript:removeFromProject(" . $this->cleanOutput($key) . ")'><img src=_img/xm.png /></a></div>";

            }

            $html .= "</td>

                      </tr>";

        }

        return $html;

    }

    public function makeClientProjects($projects)
    {

        $html = "";

        foreach ($projects as $key => $proj) {

            $html .= "<tr>

                      <td><h5>" . $this->cleanOutput($proj['longName']) . "</h5></td>";

            if (in_array('edit_client', $_SESSION['UserPermissions'])) {

                $html .= "<td><div class=fr><a href='javascript:removeFromClient(" . $this->cleanOutput($key) . ")'><img src=_img/xm.png style='float:right;margin-top:3px;'/></a></div></td>";

            }

            $html .= "</tr>";

        }

        return $html;

    }

    public function addProjResearcheAction()
    {

        $researches = $this->getResearches();

        $html = "";

        $researches = $this->getResearches();

        foreach ($researches as $key => $res) {

            if ($key == $_POST['resId']) {

                $html .= "<tr>

                    <td><input type='hidden' id='res_id_" . $this->cleanOutput($_POST['resId']) . "' value='" . $this->cleanOutput($_POST['resId']) . "' /><h5>" . $this->cleanOutput($res['longName']) . "</h5></td>

                    <td><div class=fd><a href='javascript:removeFromAddProject(" . $this->cleanOutput($key) . ")'><img src=_img/xm.png style='float:right;margin:3px;'/></a></div></td>

                </tr>";

                break;

            }

        }

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    private function key_compare_func($key1, $key2)
    {

        if ($key1 == $key2) {

            return 0;

        } else if ($key1 > $key2) {

            return 1;

        } else {

            return -1;

        }

    }

    public function makeProjResearchesSelector($researches)
    {

        $sel = new Selector($this->db);

        $allResearches = $this->getResearches();

        foreach ($allResearches as $key => $a) {

            foreach ($researches as $key2 => $r) {

                if ($key == $key2) {

                    unset($allResearches[$key]);

                }

            }

        }

        $html = "";

        foreach ($allResearches as $key => $res) {

            $html .= "<option value=" . $this->cleanOutput($key) . " >" . $this->cleanOutput($res['longName']) . "</option>";

        }

        return $html;

    }

    public function makeClientProjSelector($projects)
    {

        $sel = new Selector($this->db);

        $allProjects = $this->getProjects();

        foreach ($allProjects as $key => $a) {

            foreach ($projects as $key2 => $r) {

                if ($key == $key2) {

                    unset($allProjects[$key]);

                }

            }

        }

        $html = "";

        foreach ($allProjects as $key => $proj) {

            $html .= "<option value=" . $this->cleanOutput($key) . " >" . $this->cleanOutput($proj['longName']) . "</option>";

        }

        return $html;

    }

    public function makeAddProjResSelector()
    {

        $sel = new Selector($this->db);

        if ($_SESSION['UserInfo']['group'] == 1) {

            $allResearches = $this->getResearches();

        } else {

            $sel = new Selector($this->db);

            $cliId = $sel->getCliId($_SESSION['UserInfo']['id']);

            $allResearches = $this->getClientResearches($cliId);

        }

        $html = "";

        foreach ($allResearches as $key => $res) {

            $html .= "<option value=" . $this->cleanOutput($key) . " >" . $this->cleanOutput($res['longName']) . "</option>";

        }

        return $html;

    }

    public function makeProjectsHtml()
    {

        $html = "";

        if ($_SESSION['UserInfo']['group'] == 1) {

            $projects = $this->getProjects();

        } else {

            $sel = new Selector($this->db);

            $cliId = $sel->getCliId($_SESSION['UserInfo']['id']);

            $projects = $this->getClientProjects($cliId);

        }

        $sel = new Selector($this->db);

        foreach ($projects as $key => $proj) {

            $client = $sel->getProjectClient($key);

            $resNum = $sel->getProjectResNum($key);

            //$weighted = ($proj['weighted']) ? "<img src='_img/utez_ze.png' alt='utež ze' /> DA" : "<img src='_img/utez_rd.png' alt='utež rd' /> NE";

            //$html .= "<div class='pasica'><div class='s3'><h4><a href=javascript:showResearch(" . $key . ");>" . $proj['name'] . "</a><a href=javascript:delResearch(" . $key . ");><span><img src='_img/delete.png'></span></a></h4>(Mojca Tisu, 12.12.2013 12:00)</div><div class='s4'>" . $weighted . "</div></div>";

            $edited = ($proj['ready']) ? "<h5><a href=javascript:showProject(" . $this->cleanOutput($key) . ");>" . $this->cleanOutput($proj['longName']) . "</a></h5>" : "<h4><a href=javascript:showProject(" . $this->cleanOutput($key) . ");><img src='_img/edit.png' alt='edit' />" . $this->cleanOutput($proj['longName']) . "</a></h4>";

            $createDate = date("d.m.Y H:i:s", strtotime($proj['createDate']));

            $html .= '<tr>

                        <td>' . $edited . '</td>

                        <td>' . $this->cleanOutput($createDate) . '</td>

                        <td>' . $this->cleanOutput($client) . '</td>

                        <td>' . $this->cleanOutput($resNum) . '</td>

                      </tr>';

        }

        return $this->cleanHTML($html);

    }

    public function makeResearchProjectsHtml($resId)
    {

        $html = "";

        $researches = $this->getResearches();

        foreach ($researches as $key => $res) {

            if ($key == $resId) {

                $html .= "<tr>

                         <td><input type='hidden' id='res_id_" . $this->cleanOutput($key) . "' value='" . $this->cleanOutput($key) . "' />

                             <h5 style='margin-top:5px;margin-bottom:0'>" . $this->cleanOutput($res['longName']) . "</h5>

                         </td>

                         <td>";

                if (in_array('edit_project', $_SESSION['UserPermissions'])) {

                    $html .= "<div class=fr style='text-align:right;margin-right:12px;'><a href='javascript:removeFromProject(" . $this->cleanOutput($key) . ")'><img src=_img/xm.png /></a></div>";

                }

                $html .= "</td>

                      </tr>";

                break;

            }

        }

        return $this->cleanHTML($html);

    }

    public function makeFEClientProjects($projects)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $sel = new Selector($this->db);

        $html = "";

        if ($projects) {

            foreach ($projects as $key => $proj) {

                $client = $sel->getProjectClient($key);

                $resNum = $sel->getProjectResNum($key);

                $edited = ($proj['ready']) ? "<h5><a href=javascript:showProject(" . $this->cleanOutput($key) . ");>" . $this->cleanOutput($proj['longName']) . "</a></h5>" : "<h4><a href=javascript:showProject(" . $this->cleanOutput($key) . ");><img src='_img/edit.png' alt='edit' />" . $this->cleanOutput($proj['longName']) . "</a></h4>";

                $html .= '<div class="sx6p">' . $edited . '</div>

                          <div class="sx8p">' . $this->cleanOutput($client) . '</div>

                          <div class="sx7p">' . $this->cleanOutput($resNum) . '</div>

                          <div class="crta_x"></div>';

            }

        } else {

            $html = "<div><h5>" . $this->cleanOutput($language['no_project_aval']) . "</h5></div>";

        }

        //$this->debug_view($html);

        return $this->cleanHTML($html);

    }

    public function makeClientProjectsHtml($cliId, $pId)
    {

        $html = "";

        $projects = $this->getClientProjects($cliId);

        if ($projects) {

            foreach ($projects as $key => $project) {

                $class = ($key == $pId) ? "projLinked" : "proj";

                $edited = ($project['ready']) ? "" : "<div class='pic fl'><img src='_img/edit.png' alt='edit' /></div>";

                $html .= "<div class=" . $class . " id=menproj_" . $this->cleanOutput($key) . ">" . $this->cleanOutput($edited) . "<h4><a href='javascript:changeProject(" . $this->cleanOutput($key) . ")'>" . $this->cleanOutput($project['name']) . "</a><a href=javascript:delProject(" . $this->cleanOutput($key) . ");><span><img src='_img/delete.png'></span></a><img src=_img/utez_ze.png alt='utež ze' style='float:right' /></h4></div>";

            }

        }

        //$this->debug_view($html);

        return $this->cleanHTML($html);

    }

    public function makeClientProjectsReadyHtml($cliId, $pId)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = "";

        $projects = $this->getClientReadyProjects($cliId);

        if ($projects) {

            foreach ($projects as $key => $project) {

                $class = ($key == $pId) ? "projLinked" : "proj";

                $html .= "<div class=" . $class . " id=menproj_" . $this->cleanOutput($key) . "><a href='javascript:changeProject(" . $this->cleanOutput($key) . ")'><h4>" . $this->cleanOutput($project['name']) . "</h4></a></div>";

            }

        } else {

            $html = "<div><h4>" . $this->cleanOutput($language['no_project_aval']) . "</h4></div>";

        }

        //$this->debug_view($html);

        return $this->cleanHTML($html);

    }

    public function makeClientUsers($cliId)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = "";

        $sel = new Selector($this->db);

        $users = $sel->getClientUsers($cliId);

        if ($users) {

            foreach ($users as $key => $u) {

                $html .= "<div class=sx6><a href='javascript:void(0)'>" . $this->cleanOutput($u['firstname'] . " " . $u['surname']) . "</a></div>";

                $html .= "<div class=sx8>" . $this->cleanOutput($u['email']) . "</div>";

                $html .= "<div class=sx7>" . $this->cleanOutput($u['group']) . "</div>";

                $html .= "<div class=crta_x></div>";

            }

        } else {

            $html = "<div><h4>" . $this->cleanOutput($language['no_users_aval']) . "</h4></div>";

        }

        return $html;

    }

    protected function makeCrossCheck($quest, $qId)
    {

        $html = "";

        $crossArray = explode(',', $quest[$qId]['crosstabVariables']);

        if ($quest) {

            foreach ($quest as $key => $q) {

                if ($key != $qId) {

                    $checked = (in_array($key, $crossArray)) ? 'checked' : '';

                    $html .= '<div class=ur_napw>

                                <div class=ur_cb>

                                    <input name=cross_' . $this->cleanOutput($key) . ' type=checkbox ' . $checked;

                    if (!in_array('edit_research', $_SESSION['UserPermissions'])) {

                        $html .= " disabled='disabled' ";

                    }

                    $html .= '/>';

                    $html .= '</div>

                                <div class=ur_texw>' . $this->cleanOutput($q['question']) . '</div>

                            </div>';

                }

            }

        }

        return $html;

    }

    protected function makeCrossCheckProj($quest, $qId)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'project'", "'default'"), DB_WARPIT_STATVIEW);

        $html = "";

        $crossArray = explode(',', $quest[$qId]['crosstabVariables']);

        if ($quest) {

            $html .= "<div class='table-responsive'>

                        <table id='ProjQuestions2Table' class='table table-striped table-hover' style='width:100%'>

                            <thead>

                                <tr>

                                    <td></td><td></td>

                                </tr>

                            </thead>

                            <tbody>";

            foreach ($quest as $key => $q) {

                if ($key != $qId) {

                    $checked = (in_array($key, $crossArray)) ? 'checked' : '';

                    $html .= "<tr>

                                  <td><input style='margin-top:10px;width:20px;' name=cross_" . $this->cleanOutput($key) . " type=checkbox " . $checked;

                    if (!in_array('edit_project', $_SESSION['UserPermissions'])) {$html .= " disabled='disabled' ";}

                    $html .= "/></td>

                                  <td><div class=cross_q_tex style='margin-top:4px'>" . $this->cleanOutput($q['questionName'] . " - " . $q['question']) . "</div></td>

                              </tr>";

                }

            }

            $html .= "</tbody></table></div>";

        }

        return $html;

    }

    protected function makeCrossDropdown($quest, $qId, $idCross = false, $qType = null)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = "<option value='' selected='selected'>" . $this->cleanOutput($language['project_preview_cross']) . "</option>";

        $crossArray = explode(',', $quest[$qId]['crosstabVariables']);

        if ($quest) {

            foreach ($quest as $key => $q) {

                if ($key != $qId and in_array($key, $crossArray)) {

                    $selected = (trim($idCross) == $key) ? "selected" : "";

                    $html .= "<option value='" . $this->cleanOutput($key) . "' " . $selected . ">" . $this->cleanOutput($language['project_cross2']) . ": " . substr($this->cleanOutput($q['question']), 0, 48) . "</option>";

                }

            }

        }

        return $html;

    }

    protected function makeWidgetCrossDropdown($quest, $qId, $pId, $idCross = false)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $sel = new Selector($this->db);

        $html = "<option value='' selected='selected'>" . $this->cleanOutput($language['project_preview_cross']) . "</option>";

        //$crossArray = explode(',', $quest[$qId]['crosstabVariables']);

        $crossArray = $sel->getWidgetCross($pId, $qId);

        if ($quest) {

            foreach ($quest as $key => $q) {

                if ($key != $qId and in_array($key, $crossArray)) {

                    $selected = (trim($idCross) == $key) ? "selected" : "";

                    $html .= "<option value='" . $this->cleanOutput($key) . "' " . $selected . ">" . $this->cleanOutput($language['project_cross2']) . ": " . substr($this->cleanOutput($q['question']), 0, 48) . "</option>";

                }

            }

        }

        return $html;

    }

    protected function getWidgetFirstCross($qId, $pId)
    {

        $sel = new Selector($this->db);

        $crossArray = $sel->getWidgetCross($pId, $qId);

        if (count($crossArray)) {

            return $crossArray[0];

        }

        return null;

    }

    // <!--<input name=dog_dat_' . $idQ . '_' . $i . ' type=text value=' . $events[$i]['eventName'] . '>-->

    protected function makeQuestionsEvents($idR, $idQ)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $sel = new Selector($this->db);

        $events = $sel->getQuestionEvents($idR, $idQ);

        $html = '';

        for ($i = 0; $i < count($events); $i++) {

            $eventTime = ($events[$i]['eventTime']) ? $events[$i]['eventTime'] : time();

            $html .= '<div id=dog_' . $idQ . '_' . $i . ' class=dogodekw>

                        <input name=dog_date_' . $idQ . '_' . $i . ' type=text class=datepick value=\'' . date("j.n.Y", $eventTime) . '\' />

                        <textarea name=dog_opis_' . $idQ . '_' . $i . ' cols= rows=>' . $events[$i]['event'] . '</textarea>

                        <div class=dog_add><a href=\'javascript:void(0)\' >' . $language['add'] . '</a></div>

                        <div class=dog_rem><a href=\'javascript:void(0)\' >' . $language['cancel'] . '</a></div>

                      </div>';

        }

        return $html;

    }

    protected function makePrevEvents($idR, $idQ)
    {

        $sel = new Selector($this->db);

        $events = $sel->getQuestionEvents($idR, $idQ);

        $html = '';

        for ($i = 0; $i < count($events); $i++) {

            $eventTime = ($events[$i]['eventTime']) ? $events[$i]['eventTime'] : time();

            $html .= '<div class=dogodek>

                        <div>' . $this->cleanOutput($events[$i]['eventName']) . ' (' . date("j. n. Y", $eventTime) . ')</div><br />

                        <div>' . $this->cleanOutput($events[$i]['event']) . '</div>

                      </div>';

        }

        return $html;

    }

    protected function makeProjectPrevEvents($idP, $idQ)
    {

        $sel = new Selector($this->db);

        $events = $sel->getProjectQuestionEvents($idP, $idQ);

        $html = '';

        for ($i = 0; $i < count($events); $i++) {

            $eventTime = ($events[$i]['eventTime']) ? $events[$i]['eventTime'] : time();

            $html .= '<div class=dogodek>

                        <div>' . $this->cleanOutput($events[$i]['eventName']) . ' (' . date("j. n. Y", $eventTime) . ')</div><br />

                        <div>' . $this->cleanOutput($events[$i]['event']) . '</div>

                      </div>';

        }

        return $html;

    }

    public function getProjectQuestionsEventsTableAction()
    {

        $idQ = $this->cleanInput($_POST['idQ']);

        $idP = $this->cleanInput($_POST['idP']);

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $sel = new Selector($this->db);

        $events = $sel->getProjectQuestionEvents($idP, $idQ);

        $html = "";

        if (!empty($events)) {

            for ($i = 0; $i < count($events); $i++) {

                $html .= "<tr>

                            <td><input type='hidden' name='event_id_" . $this->cleanOutput($events[$i]['id']) . "' value='" . $this->cleanOutput($events[$i]['id']) . "'>(" . date("j.n.Y", $events[$i]['eventTime']) . ") " . $this->cleanOutput($events[$i]['event']) . "</td>

                            <td>";

                if (in_array('edit_project', $_SESSION['UserPermissions'])) {

                    $html .= "<div class=fr style='text-align:right;margin-right:12px;'><a href='javascript:removeEvent(" . $this->cleanOutput($events[$i]['id']) . ")'><img src=_img/xm.png /></a></div>";

                }

                $html .= "  </td>

                          </tr>";

            }

        }

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    protected function makeProjectQuestionsEvents($idP, $idQ)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $sel = new Selector($this->db);

        $events = $sel->getProjectQuestionEvents($idP, $idQ);

        $html = "<div class='table-responsive'>

                    <table id='ProjEventsTable' class='table table-striped table-hover' style='width:100%' >

                        <thead>

                            <tr>

                                <td></td><td></td>

                            </tr>

                        </thead>

                        <tbody id='EventsTableBody'>";

        if (!empty($events)) {

            for ($i = 0; $i < count($events); $i++) {

                $html .= "<tr>

                            <td><input type='hidden' name='event_id_" . $this->cleanOutput($events[$i]['id']) . "' value='" . $this->cleanOutput($events[$i]['id']) . "'>(" . date("j.n.Y", $events[$i]['eventTime']) . ") " . $this->cleanOutput($events[$i]['event']) . "</td>

                            <td>";

                if (in_array('edit_project', $_SESSION['UserPermissions'])) {

                    $html .= "<div class=fr style='text-align:right;margin-right:12px;'><a href='javascript:removeEvent(" . $this->cleanOutput($events[$i]['id']) . ")'><img src=_img/xm.png /></a></div>";

                }

                $html .= "  </td>

                          </tr>";

            }

        }

        $html .= "</tbody></table></div>";

        return $html;

    }

    protected function getGraphSliderType($idQ, $idP, $idQcross, $type, $subType)
    {

        if ($type == "line" && $subType == 4) {$idQcross = "id_research";}

        if ($idQcross != null) {

            $sql = "SELECT options FROM _graph_options WHERE id_question = '" . $this->cleanInput($idQ) . "'

                                                       AND id_cross_question = '" . $this->cleanInput($idQcross) . "'

                                                       AND id_project = '" . $this->cleanInput($idP) . "'

                                                       AND sub_type = '" . $this->cleanInput($subType) . "'

                                                       AND type = '" . $this->cleanInput($type) . "'";

        } else {

            $sql = "SELECT options FROM _graph_options WHERE id_question = '" . $this->cleanInput($idQ) . "'

                                                       AND id_cross_question = ''

                                                       AND id_project = '" . $this->cleanInput($idP) . "'

                                                       AND sub_type = '" . $this->cleanInput($subType) . "'

                                                       AND type = '" . $this->cleanInput($type) . "'";

        }

        $res = mysql_query($sql);

        $options = '';

        if ($res) {

            $row = mysql_fetch_assoc($res);

            $options = $row['options'];

        }

        $time_int = "brez";

        if ($options != null) {

            $optionsArr = json_decode($options, true);

            foreach ($optionsArr as $opt) {

                if ($opt['name'] === 'time_int') {

                    $time_int = $opt['value'];

                }

            }

        }

        return $time_int;

    }

    protected function getMapSliderType($idQ, $idP, $idQcross, $idA, $subType)
    {

        $sql = "SELECT * FROM _map_options WHERE id_question = '" . $idQ . "'

                                           AND id_project = '" . $idP . "'

                                           AND type = '" . $idQcross . "'

                                           AND sub_type = '" . $subType . "'

                                           AND id_answer = '" . $idA . "'";

        $res = mysql_query($sql);

        $options = '';

        if ($res) {

            $row = mysql_fetch_assoc($res);

            $options = $row['options'];

        }

        $time_int = "brez";

        if ($options != null) {

            $optionsArr = json_decode($options, true);

            foreach ($optionsArr as $opt) {

                if ($opt['name'] === 'time_int') {

                    $time_int = $opt['value'];

                }

            }

        }

        return $time_int;

    }

    public function getCrosstabs($calc, $idQ, $idCross, $idP, $iframe = false, $client = false, $extraParams = null)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $sql = "SELECT options FROM _table_options WHERE id_project = '" . $this->cleanInput($idP) . "'

                                                   AND id_question = '" . $this->cleanInput($idCross) . "'

                                                   AND id_cross = '" . $this->cleanInput($idQ) . "'";

        $res = mysql_query($sql);

        $hasOptions = false;

        $sel = new Selector($this->db);

        $project = $sel->getProject($idP);

        $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        foreach ($perm as $p) {

            if ($p['shortName'] == 'display_settings') {

                $hasOptions = true;

            }

        }

        //var_dump($hasOptions);

        while ($row = mysql_fetch_assoc($res)) {

            $optionsArray[] = $row;

        }

        if (count($optionsArray) == 0) {

            $time_int = 'brez';

            $n_dec = '0';

            $proc_dec = '2';

            $show_n = 'checked';

            $show_vrsta = 'checked';

            $show_kolona = 'checked';

            $show_proc = 'checked';

            $total_row_column = 'checked';

            $total_column_column = 'checked';

            $total_n_column = "checked";

            $total_row_row = 'checked';

            $total_column_row = 'checked';

            $total_n_row = "checked";

            $total_row_total = 'checked';

            $total_column_total = 'checked';

            $total_n_total = "checked";

            $vertical_orientation = "";

        } else {

            $options = json_decode($optionsArray[0]['options']);

            //print_r($options);

            foreach ($options as $o) {

                switch ($o->name) {

                    case 'time_int':

                        $time_int = $o->value;

                    case "n_dec":

                        $n_dec = $o->value;

                        break;

                    case "proc_dec":

                        $proc_dec = $o->value;

                        break;

                    case "show_n":

                        $show_n = "checked";

                        break;

                    case "show_kolona":

                        $show_kolona = "checked";

                        break;

                    case "show_vrsta":

                        $show_vrsta = "checked";

                        break;

                    case "show_proc":

                        $show_proc = "checked";

                        break;

                    case "total_row_column":

                        $total_row_column = "checked";

                        break;

                    case "total_column_column":

                        $total_column_column = "checked";

                        break;

                    case "total_n_column":

                        $total_n_column = "checked";

                        break;

                    case "total_row_row":

                        $total_row_row = "checked";

                        break;

                    case "total_column_row":

                        $total_column_row = "checked";

                        break;

                    case "total_n_row":

                        $total_n_row = "checked";

                        break;

                    case "total_row_total":

                        $total_row_total = "checked";

                        break;

                    case "total_column_total":

                        $total_column_total = "checked";

                        break;

                    case "total_n_total":

                        $total_n_total = "checked";

                        break;

                    case "vertical_orientation":

                        $vertical_orientation = " class = 'rotate'";

                        break;

                }

            }

        }

        // print "<span>" . $vertical_orientation . "</span>";

        $html = "";

        if ($calc != null) {

            /*if(isset($_POST['minId']) && isset($_POST['maxId'])){

            $rangeArray[0] = $_POST['minId'];

            $rangeArray[1] = $_POST['maxId'];

            $slider ="";  */

            if ($project['isTimed']) {

                $slider = $this->makeProjSlider($idCross, $idP, $iframe, $time_int);

                if ($time_int == 'range') {

                    if (isset($_POST['minId']) && isset($_POST['maxId'])) {

                        $rangeArray[0] = $this->cleanInput($_POST['minId']);

                        $rangeArray[1] = $this->cleanInput($_POST['maxId']);

                        $slider = "";

                    } else {

                        $rangeArray = $sel->getRangedSliderOptions($idP, $idCross);

                    }

                    $data = $calc->getCrosstabs($idCross, $rangeArray[0], $rangeArray[1]);

                } else if ($time_int == 'months') {

                    if (isset($_POST['slider_sett'])) {

                        $rangeArray = explode(",", $this->cleanInput($_POST['slider_sett']));

                        $slider = "";

                    } else {

                        $rangeArray = $sel->getSliderOptions($idP, $idCross);

                    }

                    $data = $calc->getCrosstabs($idCross, $rangeArray);

                } else {

                    $data = $calc->getCrosstabs($idCross, null, null, $extraParams);

                }

            } else {

                $data = $calc->getCrosstabs($idCross, null, null, $extraParams);

            }

            $options = "";

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div style='margin:10px;' id=tableOpcije>+</div>";

            }

            //  var_dump("tu sem");

            /* print "<pre>";

            print_r($data);

            print "</pre>";

             */

            $html = "<style type='text/css'>



                    </style>

                    <input type='hidden' value='" . $this->cleanOutput($idQ) . "' name='idCross'>

                    <div id=gwrap><div id=sli_wrap> " . $slider . "</div>

                        <div style='width:100%;float:left;margin-bottom:20px;'>";

            if (in_array('display_settings', $_SESSION['UserPermissions'])) {

                $html .= $options;

            }

            $html .= "</div>

                        <div id='tableDivision'>

                            <table id=outer-table></table>



                            <table id=cross-table cellpadding = '0' cellspacing='0'>

                                    <tr><td colspan='2' style='border-bottom:1px solid #000000;'>" . $this->cleanOutput($data['labels'][$idQ]['question']) . "<img src='_img/spacer.gif' width='150px' height='1px' /></td>";

            //izpis odgovorov na x-osi

            foreach ($data['labels'][$idQ]['answers'] as $key => $val) {

                if ($vertical_orientation == " class = 'rotate'") {

                    $html .= "<td  style='border-bottom:1px solid #000000;' id='horizontal-label'><table width='20px' height='150px'><tr><td><font " . $vertical_orientation . ">" . $this->cleanOutput($val) . "</font></td></tr></table></td>";

                }

                // $html.="<td id='horizontal-label'><table width='20px' height='150px'><tr><td class='rotate'>" . $val ."</td></tr></table></td>";

                else {

                    $html .= "<td style='border-bottom:1px solid #000000;' id='horizontal-label'><div " . $vertical_orientation . ">" . $this->cleanOutput($val) . "</div></td>";

                }

            }

            if ($total_row_column == "checked" || $total_column_column == "checked" || $total_n_column == "checked") {

                if ($vertical_orientation == " class = 'rotate'") {

                    $html .= "<td  id='horizontal-label' style='border-bottom:1px solid #000000;'><table width='20px' height='150px'><tr><td><font " . $vertical_orientation . ">" . $this->cleanOutput($language['project_total_lab']) . "</font></tr></td></table></td>";

                } else {

                    $html .= "<td  id='horizontal-label' style='border-bottom:1px solid #000000;'><div " . $vertical_orientation . ">" . $this->cleanOutput($language['project_total_lab']) . "</div></td>";

                }

            }

            $html .= "</tr>";

            $totalColumnSum = array();

            foreach ($data['labels'][$idCross]['answers'] as $questionNum => $labela) {

                $label = "<td id='set1'  width='150px'>" . $this->cleanOutput($data['labels'][$idCross]['answers'][$questionNum]) . "</td>";

                $nTr = "<td id='set2'>N</td>";

                $rowTr = "<td id='set2'>%&nbsp;" . $this->cleanOutput($language['table_show_row']) . "</td>";

                $columnTr = "<td style='border-bottom:1px solid #000000;' id='set2'>%&nbsp;stolpec</td>";

                $totalSum = 0;

                foreach ($data['labels'][$idQ]['answers'] as $questionNum2 => $labela2) {

                    if (isset($data['cross'][$idQ][$questionNum2][$idCross][$questionNum])) {

                        $nTr .= "<td id='set2'>" . round($data['cross'][$idQ][$questionNum2][$idCross][$questionNum], $n_dec) . "</td>";

                    } else {

                        $nTr .= "<td id='set2'>" . number_format(0, $n_dec, '.', '') . "</td>";

                    }

                    $rowTr .= "<td id='set2'> " . number_format($data['cross'][$idQ][$questionNum2][$idCross][$questionNum] / $data['freq'][$idCross]['data'][$questionNum] * 100, $proc_dec, '.', '') . "%</td>";

                    $columnTr .= "<td id='set2' style='border-bottom:1px solid #000000;' >" . number_format($data['cross'][$idQ][$questionNum2][$idCross][$questionNum] / $data['freq'][$idQ]['data'][$questionNum2] * 100, $proc_dec, '.', '') . "%</td>";

                    $totalSum += $data['cross'][$idQ][$questionNum2][$idCross][$questionNum] / $data['freq'][$idCross]['data'][$questionNum];

                    $totalColumnSum[$questionNum2] += $data['cross'][$idQ][$questionNum2][$idCross][$questionNum] / $data['freq'][$idQ]['data'][$questionNum2];

                    // FB::info($totalSum,"total sum");

                }

                /*     $rowTr .= "<td id='set2'>". number_format(100, $proc_dec) ."%</td>";

                $columnTr .= "<td id='set2'>" . number_format(intval($data['freq'][$idCross]['data'][$questionNum])/intval($data['freq'][$idQ]['total']) * 100, $proc_dec) . "%</td>";

                $nTr .= "<td id='set2'>" . number_format(isset($data['freq'][$idCross]['data'][$questionNum])?$data['freq'][$idCross]['data'][$questionNum]:0, $n_dec) . "</td>";

                 */

                if ($total_row_column == "checked") {

                    $rowTr .= "<td id='set2' >" . number_format(100, $proc_dec, '.', '') . "%</td>";

                }

                // $rowTr .= "<td id='set2'>". number_format($totalSum * 100, $proc_dec, '.', '' ) ."%</td>";

                if ($total_column_column == "checked") {

                    $columnTr .= "<td id='set2' style='border-bottom:1px solid #000000;'>" . number_format($data['freq'][$idCross]['data'][$questionNum] / $data['freq'][$idQ]['total'] * 100, $proc_dec, '.', '') . "%</td>";

                }

                if ($total_n_column == "checked") {

                    $nTr .= "<td id='set2'>" . number_format(isset($data['freq'][$idCross]['data'][$questionNum]) ? $data['freq'][$idCross]['data'][$questionNum] : 0, $n_dec, '.', '') . "</td>";

                }

                // $nTr .= "</tr>";

                if ($show_n == "checked") {

                    $html .= "<tr>" . $label . $nTr . "</tr>";

                    $label = "<td></td>";

                }

                if ($show_vrsta == "checked") {

                    $html .= "<tr>" . $label . $rowTr . "</tr>";

                    $label = "<td style='border-bottom:1px solid #000000;'></td>";

                }

                if ($show_kolona == "checked") {

                    $html .= "<tr>" . $label . $columnTr . "</tr>";

                    $label = "<td style='border-bottom:1px solid #000000;'></td>";

                }

            }

            //TOTAL VODORAVNO

            //   $nTr = "<tr>";

            $label = "<td id='set1'>" . $this->cleanOutput($language['project_total_lab']) . "</td>";

            $nTr = "";

            $rowTr = "";

            $columnTr = "";

            $totalSum = 0;

            foreach ($data['freq'][$idQ]['data'] as $key => $val) {

                $nTr .= "<td id='set2'>" . number_format($val, $n_dec, '.', '') . "</td>";

                $rowTr .= "<td id='set2' >" . number_format($val / $data['freq'][$idQ]['total'] * 100, $proc_dec, '.', '') . "%</td>";

                $columnTr .= "<td id='set2' >" . number_format(100, $proc_dec, '.', '') . "%</td>";

                //$columnTr .=  "<td id='set2'>" . number_format($totalColumnSum[$key] * 100, $proc_dec, '.', '' ) . "%</td>";

                $totalSum += $totalColumnSum[$key];

            }

            //$html .= "<td id='set2'> " . number_format($data['freq'][$idQ]['total'], $n_dec) . "</td>";

            //  $html .= "</tr>";

            if ($total_n_row == "checked") {

                $html .= "<tr>" . $label . "<td id='set2'>N</td> " . $nTr;

                if ($total_n_total == "checked") {

                    $html .= "<td id='set2'>" . number_format($data['freq'][$idQ]['total'], $n_dec, '.', '') . "</td>";

                }

                $html .= "</tr>";

                $label = "<td id='set1'></td>";

            }

            if ($total_row_row == "checked") {

                $html .= "<tr>" . $label . "<td id='set2'>%&nbsp;" . $this->cleanOutput($language['table_show_row']) . "</td>" . $rowTr;

                if ($total_row_total == "checked") {

                    $html .= " <td id='set2'>" . number_format(100, $proc_dec, '.', '') . "%</td>";

                }

                $html .= "</tr>";

                $label = "<td id='set1'></td>";

            }

            if ($total_column_row == "checked") {

                $html .= "<tr>" . $label . "<td id='set2'>%&nbsp;" . $this->cleanOutput($language['table_show_column']) . "</td>" . $columnTr;

                if ($total_column_total == "checked")

                //$html .= "<td id='set2'>". number_format($totalSum * 100, $proc_dec, '.', '' ) ."%</td>";

                {

                    $html .= "<td id='set2'>" . number_format(100, $proc_dec, '.', '') . "%</td>";

                }

                $html .= "</tr>";

                $label = "<td id='set1'></td>";

            }

            $html .= "</table></div>";

            if ($time_int == 'brez' || !$time_int) {

                $html .= "

                                <script>

                                    $('#tableOpcije').css('top', '7px');

                                </script>";

            } else {

                $html .= "

                                <script>

                                    $('#tableOpcije').css('top', '80px');

                                </script>";

            }

            return $html;

        }

    }

    /* -------------------------------------- PROJEKTI -------------------------------------- */

    //izris tabel za projekte

    public function makeProjTableView($idQ, $idP, $idQcross = null, $tType, $iframe = false, $client = false, $extraFields = null)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        if (!$idQcross) {

            $sel = new Selector($this->db);

            $projName = $sel->getProjectName($idP);

            $projName = str_replace(" ", "_", $projName);

            $calc = new Calculate($this->db, '_projects', $projName, $idP);

            $labs = new Labels($this->db, '_projects', $projName, $idP);

            $project = $sel->getProject($idP);

            $hasOptions = false;

            $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

            foreach ($perm as $p) {

                if ($p['shortName'] == 'display_settings') {

                    $hasOptions = true;

                }

            }

            $decimal = 1;

            $sql = "SELECT options FROM _table_options WHERE id_project = '" . $this->cleanInput($idP) . "'

                                                       AND id_question = '" . $this->cleanInput($idQ) . "'

                                                       AND id_cross = 'NULL'";

            $res = mysql_query($sql);

            $optionsArray = array();

            while ($row = mysql_fetch_assoc($res)) {

                $optionsArray[] = $row;

            }

            $show_proc = '';

            $show_n = '';

            if (count($optionsArray) == 0) {

                $n_dec = '0';

                $proc_dec = '2';

                $show_n = 'checked';

                $show_vrsta = 'checked';

                $show_proc = "checked";

                $show_kolona = "checked";

                $time_int = "";

            } else {

                $options = json_decode($optionsArray[0]['options']);

                foreach ($options as $o) {

                    switch ($o->name) {

                        case "time_int":

                            $time_int = $o->value;

                            break;

                        case "n_dec":

                            $n_dec = $o->value;

                            break;

                        case "proc_dec":

                            $proc_dec = $o->value;

                            break;

                        case "show_n":

                            $show_n = "checked";

                            break;

                        case "show_kolona":

                            $show_kolona = "checked";

                            break;

                        case "show_vrsta":

                            $show_vrsta = "checked";

                            break;

                        case "show_proc":

                            $show_proc = "checked";

                            break;

                    }

                }

            }

            if ($project['isTimed']) {

                $slider = $this->makeProjSlider($idQ, $idP, $iframe, $time_int);

            }

            if ($time_int == 'range') {

                if (isset($_POST['minId']) && isset($_POST['maxId'])) {

                    $rangeArray[0] = $this->cleanInput($_POST['minId']);

                    $rangeArray[1] = $this->cleanInput($_POST['maxId']);

                    $slider = "";

                } else {

                    $rangeArray = $sel->getRangedSliderOptions($idP, $idQ);

                }

                $filter = "research_id BETWEEN " . $rangeArray[0] . " AND " . $rangeArray[1];

            } else if ($time_int == 'months') {

                if (isset($_POST['slider_sett'])) {

                    $rangeArray = explode(",", $this->cleanInput($_POST['slider_sett']));

                    $slider = "";

                } else {

                    $rangeArray = $sel->getSliderOptions($idP, $idQ);

                }

                $filter = "research_id IN(" . implode(',', $rangeArray) . ") ";

            } else if (strlen($_REQUEST['extraParams']) > 0) {

                $filter = $_REQUEST['extraParams'];

            } else {

                $filter = null;

            }

            $filterString = null;

            //<widget filtri>

            $widgetFilterString = null;

            if (!empty($_SESSION[$idP . "_" . $idQ . "_widget_filter"])) {

                $widgetFilterString = $_SESSION[$idP . "_" . $idQ . "_widget_filter"];

            }

            if ($filter == null && $widgetFilterString != null) {

                $filterString = $widgetFilterString;

            } else if ($filter != null && $widgetFilterString == null) {

                $filterString = $filter;

            } else if ($filter != null && $widgetFilterString != null) {

                $filterString = $filter . " AND " . $widgetFilterString;

            }

            //</widget filtri>

            $labs->setQuestion($idQ);

            $calc->setQuestion($idQ);

            $params = $calc->getParameters();

            $freq = $calc->getFrequencies(null, $filterString);

            $desc = $calc->getDescriptives(null, $filterString);

            $total = $calc->getTotal();

            $labels = $labs->getLabels();

            foreach (explode(',', $params['hideAnswers']) as $hiddenAnswer) {

                unset($freq[$idQ][$hiddnAnswer]);

                unset($labels[$idQ]['graph_answers'][$hiddenAnswer]);

            }

            //hideAnswers

            $html = "<div id=gwrap><div id=sli_wrap>" . $slider . "<div>";

            $html .= "";

            $i = 0;

            $options = "";

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div id=tableOpcije style='margin:10px 10px 0 0;'>+</div>";

            }

            if (intval($params['questionType']) != 2) {

                if (in_array('display_settings', $_SESSION['UserPermissions'])) {

                    $html .= $options;

                }

                $html .= "<div id='tableDivision' style='float:left;width:100%;'><div class='tekst fl'>  </div>";

                $html .= "<table width='90%' style='margin-left:20px;margin-top:20px;'>";

                $html .= "<tr>

                            <td style='border-bottom:1px dashed #D1D3D4;'></td>";

                if ($show_n == 'checked') {

                    $html .= "<td width='45px' align='center' style='border-bottom:1px dashed #D1D3D4;'>N</td>";

                }

                if ($show_proc == 'checked') {

                    if (intval($params['questionType']) == 3) {

                        $html .= "<td width='60px' align='center' style='border-bottom:1px dashed #D1D3D4;'>%&nbsp;od&nbsp;" . $this->cleanOutput($language['project_units_lab']) . "</td>";

                        $html .= "<td width='45px' align='center' style='border-bottom:1px dashed #D1D3D4;'>%</td>";

                    } else {

                        $html .= "<td width='60px' align='center' style='border-bottom:1px dashed #D1D3D4;'>%</td>";

                    }

                }

                $html .= "</tr>";

                $calcTotalProc = 0;

                $calcTotalProc2 = 0;

                $arraySum = array_sum($freq[$idQ]);

                foreach ($labels[$idQ]['graph_answers'] as $key => $l) {

                    $sFreq = (isset($freq[$idQ][$key])) ? $freq[$idQ][$key] : 0;

                    $html .= "<tr><td style='border-bottom:1px dashed #D1D3D4;'>" . $this->cleanOutput($l) . "</td>";

                    if ($show_n == 'checked') {

                        $html .= "<td align='center' style='border-bottom:1px dashed #D1D3D4;'>" . number_format($sFreq, $n_dec, '.', '') . "</td>";

                    }

                    if ($show_proc == 'checked') {

                        if (intval($params['questionType']) == 3) {

                            $html .= "<td align='center' style='border-bottom:1px dashed #D1D3D4;'> " . number_format($sFreq / $arraySum * 100, $proc_dec, '.', '') . "</td>";

                            $html .= "<td align='center' style='border-bottom:1px dashed #D1D3D4;'>" . number_format(($sFreq / $total[$idQ]) * 100, $proc_dec, '.', '') . "</td>";

                        } else {

                            $html .= "<td align='center' style='border-bottom:1px dashed #D1D3D4;'> " . number_format($sFreq / $arraySum * 100, $proc_dec, '.', '') . "</td>";

                        }

                    }

                    // number_format($sFreq/ $arraySum * 100, $proc_dec, '.', '')

                    $html .= "</tr>";

                    $calcTotalProc += $sFreq / $total[$idQ];

                    $calcTotalProc2 += $sFreq / $arraySum;

                }

                $html .= "<tr><td style='border-bottom:1px dashed #D1D3D4;'>" . $this->cleanOutput($language['project_preview_total']) . "</td>";

                if ($show_n == 'checked') {

                    $html .= "<td align='center' style='border-bottom:1px dashed #D1D3D4;'>" . number_format($arraySum, $n_dec, '.', '') . "</td>";

                }

                if ($show_proc == 'checked') {

                    if (intval($params['questionType']) == 3) {

                        $html .= "<td align='center' style='border-bottom:1px dashed #D1D3D4;'>" . number_format($calcTotalProc * 100, $proc_dec, '.', '') . "</td>";

                    }

                    $html .= "<td align='center' style='border-bottom:1px dashed #D1D3D4;'>" . number_format($calcTotalProc2 * 100, $proc_dec, '.', '') . "<td></tr>";

                }

                if (intval($params['questionType']) == 3) {

                    $html .= "<tr>

                                <td>" . $this->cleanOutput($language['project_shnumber_lab']) . "&nbsp;enot:&nbsp;" . number_format($total[$idQ], $n_dec, '.', '') . "</td>

                            </tr>";

                }

                $html .= "</table>";

                // tukaj manjka css jquey

                if ($time_int == 'brez' || !$time_int) {

                    $html .= "

                        <script>

                            $('#tableOpcije').css('top', '47px');

                        </script>";

                } else {

                    $html .= "

                        <script>

                            $('#tableOpcije').css('top', '115px');

                        </script>";

                }

            } else {

                //Scale vprašanje

                if (intval($params['questionType']) == 2) {

                    if (strlen($slider) > 0 or $time_int == 'brez') {

                        $html = "<div id=gwrap><div id=sli_wrap>" . $slider . "<div>";

                    }

                    $html .= $options . "

                    	<div class='scale-table-container'>

                    	<table class='scale-table'>

                    		<thead>

	                    		<tr>

			                        <td></td>

			                        <td>N</td>

			                        <td>Max</td>

			                        <td>Min</td>

			                        <td>" . $language["std_dev"] . "</td>

			                        <td>" . $language["variation"] . "</td>

			                        <td>Mean</td>

		                        </tr>

	                        </thead>

                    	<tbody>";

                    $n = 1;

                    foreach ($desc[$idQ] as $key => $array) {

                        $html .= "

					   <tr>

                            <td class='scale_table_1'>" . $labels[$idQ]['answers'][$n] . "</td>

                            <td>" . number_format($array['N'], $sv_dec, '.', '') . "</td>

                            <td>" . number_format($array['maximum'], $sv_dec, '.', '') . "</td>

                            <td>" . number_format($array['minimum'], $sv_dec, '.', '') . "</td>

                            <td>" . number_format($array['stdev'], $proc_dec, '.', '') . "</td>

                            <td>" . number_format($array['variance'], $proc_dec, '.', '') . "</td>

                            <td>" . number_format($array['sv'], $sv_dec, '.', '') . "</td>

                       </tr>";

                        $n++;

                    }

                    $html .= "</tbody></table></div></div><br/>";

                }

                $html .= "<div id=scale-table2-container><table class=scale-table2>";

                foreach ($labels[$idQ]['answers'] as $key1 => $a) {

                    $html .= "

                	<tr class=scale2-title><td colspan=2>" . $this->cleanOutput($a) . "</td><tr>

                	<tr class=scale2-tr>

                		<td style='padding-left:30px;'></td>

						<td style='padding-left:300px;'>N</td>

						<td style='padding-left:30px;'>%</td>

                	</tr>";

                    $i++;

                    $j = 0;

                    foreach ($labels[$idQ]['legend'] as $key2 => $l) {

                        $j++;

                        $sFreq = (isset($freq[$idQ][$idQ . "_" . $i][$j])) ? $freq[$idQ][$idQ . "_" . $i][$j] : 0;

                        $proc = (isset($freq[$idQ][$idQ . "_" . $i][$j]) && isset($total[$idQ][$idQ . "_" . $i])) ? round(($sFreq / $total[$idQ][$idQ . "_" . $i]) * 100, 1) : 0;

                        $html .= "

						<tr class=scale2-tr>

							<td style='padding-left:30px;'>" . $this->cleanOutput($l) . "</td>

							<td style='padding-left:300px;'>" . number_format($sFreq, $sv_dec, '.', '') . "</td>

							<td style='padding-left:30px;'>" . number_format($proc, $proc_dec, '.', '') . "%</td>

						</tr>";

                    }

                }

                $html .= "</table></div>";

                $scaleExportStyle = "margin-bottom:20px;";

            }

        }

        //tabela križanja za projekte

        else {

            $extraFields = null;

            if (strlen($_REQUEST['extraParams']) > 0) {

                $extraFields = $_REQUEST['extraParams'];

            }

            $sel = new Selector($this->db);

            $projName = $sel->getProjectName($idP);

            $projName = str_replace(" ", "_", $projName);

            $calc = new Calculate($this->db, '_projects', $projName, $idP);

            $calc->setQuestion($idQcross);

            $html = "";

            $html = $this->getCrosstabs($calc, $idQcross, $idQ, $idP, $iframe, $client, $extraFields);

            if (!$iframe) {

                $html .= "<div style='padding-bottom:80px;margin-top:20px;'>";

                if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

                    $html .= "<div class='exportSuccessMsg'></div><div id=izvozi1 class=izvozi onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>";

                }

                $html .= "</div>";

            }

            return $html;

        }

        if (!$iframe) {

            $html .= "<div style='padding-bottom:80px'>";

        }

        if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

            $html .= "<div class='exportSuccessMsg'></div><div id=izvozi1 class=izvozi style='float:right;" . $scaleExportStyle . "' onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>";

        }

        $html .= "</div>";

        return $html;

    }

    //izris column grafa za widgete

    private function makeWidgetBarView($idQ, $idP, $idQcross = null, $bType, $iframe = false, $client = false, $slider_sett)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $options = "";

        $export = "";

        $slider = "";

        $sel = new Selector($this->db);

        $project = $sel->getProject($idP);

        $hasOptions = false;

        $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        foreach ($perm as $p) {

            if ($p['shortName'] == 'display_settings') {

                $hasOptions = true;

            }

        }

        if ($project['isTimed']) {

            $time_int = $this->getGraphSliderType($idQ, $idP, $idQcross, 'column', $bType);

            $slider = $this->makeProjSlider($idQ, $idP, $iframe, $time_int);

        }

        if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

            if (!$iframe) {

                $export = "<div style='position:relative;height:40px;padding-bottom:25px'>

                                        <div class='exportSuccessMsg'></div>

                                        <div id=izvozi1 class=izvozi onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>

                                    </div>";

            }

        }

        if (in_array('display_settings', $_SESSION['UserPermissions'])) {

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div id=columnOpcije>+</div><br><br>";

            }

        }

        $html = "<div id='container'></div>" . $export . "<br>";

        if (!$idQcross) {

            $html .= "<script type='text/javascript' src='" . PATH_TO_ROOT . "statview/_javascript/init_chart_widget.php?type=column&id=" . $idQ . "&idProject=" . $idP . "&subType=" . $bType . "&slider_sett=" . $slider_sett . "'></script><br />";

        } else {

            $html .= "<script type='text/javascript' src='" . PATH_TO_ROOT . "statview/_javascript/init_chart_widget.php?type=column&id=" . $idQ . "&idProject=" . $idP . "&idQcross=" . $idQcross . "&subType=" . $bType . "&slider_sett=" . $slider_sett . "'></script><br />";

        }

        return $html;

    }

    //izris line grafa za widgete

    private function makeWidgetLineView($idQ, $idP, $idQcross = null, $lType, $iframe = false, $client = false, $slider_sett)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $options = "";

        $export = "";

        $slider = "";

        $sel = new Selector($this->db);

        $project = $sel->getProject($idP);

        $hasOptions = false;

        $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        foreach ($perm as $p) {

            if ($p['shortName'] == 'display_settings') {

                $hasOptions = true;

            }

        }

        if ($project['isTimed']) {

            $time_int = $this->getGraphSliderType($idQ, $idP, $idQcross, 'line', $lType);

            $slider = $this->makeProjSlider($idQ, $idP, $iframe, $time_int);

        }

        if ($lType == 4) {

            $idQcross = "id_research";

        }

        if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

            if (!$iframe) {

                $export = "<div style='position:relative;height:40px;padding-bottom:25px'>

                                        <div class='exportSuccessMsg'></div>

                                        <div id=izvozi1 class=izvozi onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>

                                    </div>";

            }

        }

        if (in_array('display_settings', $_SESSION['UserPermissions'])) {

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div id=columnOpcije>+</div><br><br>";

            }

        }

        $html = ".<div id='container'> </div><div id='plotline'></div> " . $export;

        if (!$idQcross) {

            $html .= "<script type='text/javascript' src='" . PATH_TO_ROOT . "statview/_javascript/init_chart_widget.php?type=line&id=" . $idQ . "&idProject=" . $idP . "&subType=" . $lType . "&slider_sett=" . $slider_sett . "'/></script><br />";

        } else {

            $html .= "<script type='text/javascript' src='" . PATH_TO_ROOT . "statview/_javascript/init_chart_widget.php?type=line&id=" . $idQ . "&idProject=" . $idP . "&idQcross=" . $idQcross . "&subType=" . $lType . "&slider_sett=" . $slider_sett . "'/></script><br />";

        }

        return $html;

    }

    //izris pie grafa za widgete

    private function makeWidgetPieView($idQ, $idP, $idQcross = null, $pType, $iframe = false, $client = false, $slider_sett)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $options = "";

        $export = "";

        $slider = "";

        $sel = new Selector($this->db);

        $project = $sel->getProject($idP);

        $hasOptions = false;

        $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        foreach ($perm as $p) {

            if ($p['shortName'] == 'display_settings') {

                $hasOptions = true;

            }

        }

        if ($project['isTimed']) {

            $time_int = $this->getGraphSliderType($idQ, $idP, $idQcross, 'pie', $pType);

            $slider = $this->makeProjSlider($idQ, $idP, $iframe, $time_int);

        }

        if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

            if (!$iframe) {

                $export = "<div style='position:relative;height:40px;padding-bottom:25px'>

                                        <div class='exportSuccessMsg'></div>

                                        <div id=izvozi1 class=izvozi onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>

                                    </div>";

            }

        }

        if (in_array('display_settings', $_SESSION['UserPermissions'])) {

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div id=columnOpcije>+</div><br><br>";

            }

        }

        $html = "<div id='container'> </div> " . $export . "

                    <script type='text/javascript' src='" . PATH_TO_ROOT . "statview/_javascript/init_chart_widget.php?type=pie&id=" . $idQ . "&idProject=" . $idP . "&idQcross=" . $idQcross . "&subType=" . $pType . "&slider_sett=" . $slider_sett . "'></script>

                  <br />";

        return $html;

    }

    //izris column grafa za projekte

    private function makeProjBarView($idQ, $idP, $idQcross = null, $bType, $iframe = false, $client = false, $extraParams = null)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $options = "";

        $export = "";

        $slider = "";

        $sel = new Selector($this->db);

        $project = $sel->getProject($idP);

        $hasOptions = false;

        $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        foreach ($perm as $p) {

            if ($p['shortName'] == 'display_settings') {

                $hasOptions = true;

            }

        }

        if ($project['isTimed']) {

            $time_int = $this->getGraphSliderType($idQ, $idP, $idQcross, 'column', $bType);

            $slider = $this->makeProjSlider($idQ, $idP, $iframe, $time_int);

        }

        if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

            if (!$iframe) {

                $export = "<div style='position:relative;height:40px;padding-bottom:25px'>

                                        <div class='exportSuccessMsg'></div>

                                        <div id=izvozi1 class=izvozi onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>

                                    </div>";

            }

        }

        if (in_array('display_settings', $_SESSION['UserPermissions'])) {

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div id=columnOpcije>+</div>";

            }

        }

        $html = "<div id=gwrap><div id=sli_wrap>" . $slider . "</div>

                <div class=graf id=grafWraper>

                " . $options . "<br><br>";

        $html .= "<div id='container'></div>" . $export . "<br>";

        $pathToRoot = ($iframe == true ? PATH_TO_ROOT : "../");

        $showIframe = ($iframe == true ? "&iframe=true" : "");

        //<filtri>

        $filtersString = null;

        if (!empty($_SESSION[$idP . "_" . $idQ . "_widget_filter"])) {

            $filtersString = $_SESSION[$idP . "_" . $idQ . "_widget_filter"];

        }

        //</filtri>

        if (!$idQcross) {

            $html .= "<script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/init_chart.php?type=column&extraParams=" . rawurlencode($_REQUEST['extraParams']) . "&id=" . $idQ . "&idProject=" . $idP . "&subType=" . $bType . $showIframe . "&aFilters=" . $filtersString . "'></script></div><br /></div>";

        } else {

            $html .= "<script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/init_chart.php?type=column&extraParams=" . rawurlencode($_REQUEST['extraParams']) . "&id=" . $idQ . "&idProject=" . $idP . "&idQcross=" . $idQcross . "&subType=" . $bType . $showIframe . "&aFilters=" . $filtersString . "'></script></div><br /></div>";

        }

        //TEST. Dodal Boštjan Janžovnik 15.02.2016 za nov način izrisa grafov

        // $html .= "<script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/drawChart.php?type=column&subType=" . $bType . "&idQuestion=" . $idQ . "&idCross=" . $idQcross . "&idProject=" . $idP . "'></script>";

        // $html .= "</div><br /></div>";

        return $html;

    }

    //izris line grafa za projekte

    private function makeProjLineView($idQ, $idP, $idQcross = null, $lType, $iframe = false, $client = false, $extraParams = null)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $options = "";

        $export = "";

        $slider = "";

        $sel = new Selector($this->db);

        $project = $sel->getProject($idP);

        $hasOptions = false;

        $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        foreach ($perm as $p) {

            if ($p['shortName'] == 'display_settings') {

                $hasOptions = true;

            }

        }

        if ($project['isTimed']) {

            $time_int = $this->getGraphSliderType($idQ, $idP, $idQcross, 'line', $lType);

            $slider = $this->makeProjSlider($idQ, $idP, $iframe, $time_int);

        }

        if ($lType == 4) {

            $idQcross = "id_research";

        }

        if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

            if (!$iframe) {

                $export = "<div style='position:relative;height:40px;padding-bottom:25px'>

                                        <div class='exportSuccessMsg'></div>

                                        <div id=izvozi1 class=izvozi onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>

                                    </div>";

            }

        }

        if (in_array('display_settings', $_SESSION['UserPermissions'])) {

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div id=columnOpcije>+</div>";

            }

        }

        //<filtri>

        $filtersString = null;

        if (!empty($_SESSION[$idP . "_" . $idQ . "_widget_filter"])) {

            $filtersString = $_SESSION[$idP . "_" . $idQ . "_widget_filter"];

        }

        //</filtri>

        $html = "";

        $html .= "<div id=gwrap><div id=sli_wrap>" . $slider . "</div>

                <div class=graf id=grafWraper>

                " . $options . "<br><br>";

        $html .= "<div id='container'> </div><div id='plotline'></div> " . $export;

        $pathToRoot = ($iframe == true ? PATH_TO_ROOT : "../");

        $showIframe = ($iframe == true ? "&iframe=true" : "");

        if (!$idQcross) {

            $html .= "<script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/init_chart.php?type=line&extraParams=" . rawurlencode($_REQUEST['extraParams']) . "&id=" . $idQ . "&idProject=" . $idP . "&subType=" . $lType . $showIframe . "&aFilters=" . $filtersString . "'/></script></div><br /></div>";

        } else {

            $html .= "<script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/init_chart.php?type=line&extraParams=" . rawurlencode($_REQUEST['extraParams']) . "&id=" . $idQ . "&idProject=" . $idP . "&idQcross=" . $idQcross . "&subType=" . $lType . $showIframe . "&aFilters=" . $filtersString . "'/></script></div><br /></div>";

        }

        //TEST. Dodal Boštjan Janžovnik 15.02.2016 za nov način izrisa grafov

        // $html .= "<script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/drawChart.php?type=line&subType=" . $lType . "&idQuestion=" . $idQ . "&idCross=" . $idQcross . "&idProject=" . $idP . "'></script>";

        // $html .= "</div><br /></div>";

        return $html;

    }

    //izris pie grafa za projekte

    private function makeProjPieView($idQ, $idP, $idQcross = null, $pType, $iframe = false, $client = false, $extraParams = null)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $options = "";

        $export = "";

        $slider = "";

        $sel = new Selector($this->db);

        $project = $sel->getProject($idP);

        $hasOptions = false;

        $perm = $sel->getPermissions($_SESSION['UserInfo']['group']);

        foreach ($perm as $p) {

            if ($p['shortName'] == 'display_settings') {

                $hasOptions = true;

            }

        }

        if ($project['isTimed']) {

            $time_int = $this->getGraphSliderType($idQ, $idP, $idQcross, 'pie', $pType);

            $slider = $this->makeProjSlider($idQ, $idP, $iframe, $time_int);

        }

        if (in_array('export_to_widget', $_SESSION['UserPermissions'])) {

            if (!$iframe) {

                $export = "<div style='position:relative;height:40px;padding-bottom:25px'>

                                        <div class='exportSuccessMsg'></div>

                                        <div id=izvozi1 class=izvozi onclick=javascript:shmenu('1');>" . $this->cleanOutput($language['project_preview_export']) . "</div>

                                    </div>";

            }

        }

        if (in_array('display_settings', $_SESSION['UserPermissions'])) {

            if (!$client || ($hasOptions && !$iframe)) {

                $options = "<div id=columnOpcije>+</div>";

            }

        }

        //<filtri>

        $filtersString = null;

        if (!empty($_SESSION[$idP . "_" . $idQ . "_widget_filter"])) {

            $filtersString = $_SESSION[$idP . "_" . $idQ . "_widget_filter"];

        }

        //</filtri>

        $pathToRoot = ($iframe == true ? PATH_TO_ROOT : "../");

        $showIframe = ($iframe == true ? "&iframe=true" : "");

        $html = "<div id=gwrap><div id=sli_wrap>" . $slider . "</div>

                <div class=graf id=grafWraper>

                " . $options . "<br><br>";

        $html .= "<div id='container'> </div> " . $export . "

                    <script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/init_chart.php?type=pie&extraParams=" . rawurlencode($_REQUEST['extraParams']) . "&id=" . $idQ . "&idProject=" . $idP . "&idQcross=" . $idQcross . "&subType=" . $pType . $showIframe . "&aFilters=" . $filtersString . "'></script>

                  </div><br />

                </div>";

        //TEST. Dodal Boštjan Janžovnik 15.02.2016 za nov način izrisa grafov

        // $html .= "<div id='container'> </div> " . $export;

        // $html .= "<script type='text/javascript' src='" . $pathToRoot . "statview/_javascript/drawChart.php?type=pie&subType=" . $pType . "&idQuestion=" . $idQ . "&idCross=" . $idQcross . "&idProject=" . $idP . "'></script>";

        // $html .= "</div><br /></div>";

        return $html;

    }

    private function insertSliderOptions($idQuestion, $idProject, $resIds)
    {

        $sql = "SELECT * FROM  _slider_options WHERE id_question = '" . $this->cleanInput($idQuestion) . "' AND id_project = " . $this->cleanInput($idProject);

        $res = mysql_query($sql);

        while ($row = mysql_fetch_assoc($res)) {

            $optionsArray[] = $row;

        }

        if (count($optionsArray) == 0) {

            $sql = "INSERT INTO _slider_options (id_question, id_project, res_ids)

            VALUES ('" . $this->cleanInput($idQuestion) . "', " . $this->cleanInput($idProject) . ", '" . $this->cleanInput($resIds) . "')";

            $this->db->SQLexecute($sql);

        } else {

            $sql = "UPDATE _slider_options SET res_ids = '" . $this->cleanInput($resIds) . "'

            WHERE id_question = '" . $this->cleanInput($idQuestion) . "' AND id_project = " . $this->cleanInput($idProject);

            $this->db->SQLexecute($sql);

        }

    }

    private function insertRangedSliderOptions($idQuestion, $idProject, $ranged)
    {

        $sql = "SELECT * FROM  _slider_ranged_options WHERE id_question = '" . $this->cleanInput($idQuestion) . "' AND id_project = " . $this->cleanInput($idProject);

        $res = mysql_query($sql);

        while ($row = mysql_fetch_assoc($res)) {

            $optionsArray[] = $row;

        }

        if (count($optionsArray) == 0) {

            $sql = "INSERT INTO _slider_ranged_options (id_question, id_project, res_id_min, res_id_max)

            VALUES ('" . $this->cleanInput($idQuestion) . "', " . $this->cleanInput($idProject) . ", '" . $this->cleanInput($ranged[0]) . "', '" . $this->cleanInput($ranged[1]) . "')";

            $this->db->SQLexecute($sql);

        } else {

            $sql = "UPDATE _slider_ranged_options SET res_id_min = '" . $this->cleanInput($ranged[0]) . "', res_id_max = '" . $this->cleanInput($ranged[1]) . "'

            WHERE id_question = '" . $this->cleanInput($idQuestion) . "' AND id_project = " . $this->cleanInput($idProject);

            $this->db->SQLexecute($sql);

        }

    }

    public function getRangedSliderAction()
    {

        $isWidget = ($_POST['wid'] == "widget") ? true : false;

        $time_int = $this->getMapSliderType($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['subType']), $this->cleanInput($_POST['aId']), 0);

        $slider = $this->makeProjSlider($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $isWidget, $time_int);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($slider) . '"}';

    }

    public function makeProjSlider($idQ, $idP, $iframe, $time_int)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = "";

        $script = "";

        $newLabels = array();

        $newRanged = array();

        $sel = new Selector($this->db);

        if ($iframe) {

            $pathToRoot = PATH_TO_ROOT . "statview/";

        } else {

            $pathToRoot = '';

        }

        //echo "PATH->".$pathToRoot;

        $labels = $sel->getSliderLabels($idP, $idQ, "id_research");

        $options = $sel->getSliderOptions($idP, $idQ);

        $optionsRanged = $sel->getRangedSliderOptions($idP, $idQ);

        $projName = str_replace(" ", "_", $sel->getProjectName($idP));

        $projQuestions = $sel->getResearchCalculated($projName);

        $last = $labels[count($labels) - 1]['id'];

        $resetSlider = (!$iframe) ? "<div onclick=resetMonthSlider('" . $idQ . "'," . $last . "," . $idP . ") >" . $this->cleanOutput($language['project_reset_lbl']) . "</div>" : "";

        if ($time_int == "months") {

            $html .= "<div class=slider>

                        " . $resetSlider . "

                        <div id=levo1 class=g_levo><img src='" . $pathToRoot . "_img/pul.jpg' alt=prev onclick='scrll(1,-97)' /></div>

                          <div class=drsnik>

                            <div id=slider1 style=position:relative;right:" . (count($labels) * 97 - 585) . "px;width:50000px;z-index:3;>";

            for ($i = 0; $i < count($labels); $i++) {

                $farba = (in_array($labels[$i]['id'], $options)) ? 'siv' : 'beli';

                if (count($options) == 0 && $i > count($labels) - 5) {

                    $farba = 'siv';

                    $newLabels[] = $labels[$i]['id'];

                }

                $html .= "<div class='knof " . $this->cleanOutput($farba) . "' id='" . $this->cleanOutput($labels[$i]['id']) . "'>" . $this->cleanOutput($labels[$i]['labelText']) . "</div>";

            }

            $html .= "      </div>

                          </div>

                        <div id=desno1 class=g_desno><img src='" . $pathToRoot . "_img/pud.jpg' width=18 height=39 alt=next onclick='scrll(1,97)' /></div>

                      </div>";

        } else if ($time_int == "range") {

            $timeItemsJs = "var items = [";

            $timeIdsJs = "var timeIds = [";

            $lowVal = array(0, 0);

            $highVal = array(0, 0);

            for ($i = 0; $i < count($labels); $i++) {

                $timeItemsJs .= ($i != count($labels) - 1) ? "['" . $labels[$i]['labelText'] . "']," : "['" . $labels[$i]['labelText'] . "']];";

                $timeIdsJs .= ($i != count($labels) - 1) ? "'" . $labels[$i]['id'] . "'," : "'" . $labels[$i]['id'] . "'];";

                //$lowVal = (($labels[$i]['id'] <  $lowVal[1] || $lowVal[1] == 0) && in_array($labels[$i]['id'], $options))?array($i, $labels[$i]['id']):$lowVal;

                //$highVal =(($labels[$i]['id'] >  $highVal[1] || $highVal[1] == 0) && in_array($labels[$i]['id'], $options))?array($i, $labels[$i]['id']):$highVal;

            }

            if (count($optionsRanged) == 0) {

                $sub = (count($labels) > 4) ? 4 : (count($labels) - 1);

                $lowVal = array((count($labels) - $sub), 0);

                $highVal = array((count($labels) - 1), 0);

                $newRanged = array($labels[$lowVal[0]]['id'], $labels[$highVal[0]]['id']);

            } else {

                for ($i = 0; $i < count($labels); $i++) {

                    if ($optionsRanged[0] == $labels[$i]['id']) {

                        $lowVal = array($i, 0);

                    }

                    if ($optionsRanged[1] == $labels[$i]['id']) {

                        $highVal = array($i, 0);

                    }

                }

            }

            $html .= "  <div id='time_r_slider' class=slider>

                            <div style='float:left;'><input type='text' id='time_r_amount1' name='time_r_amount1' class='time_lvl_range' value='" . $this->cleanOutput($labels[$lowVal[0]]['labelText']) . "' readonly>&nbsp;&nbsp;<input type='submit' id='save_rslider' name='save_rslider' onclick='return false;' value='Potrdi izbiro'/></div>

                            <div style='float:right;'><input type='text' id='time_r_amount2' name='time_r_amount2' class='time_lvl_range' value='" . $this->cleanOutput($labels[$highVal[0]]['labelText']) . "' readonly></div></br></br>

                            <div><div id='time_range'></div></div>

                           </div>";

            $script .= $timeItemsJs . $timeIdsJs . "

            $('#time_range').slider({

                range: true,

                step: 1,

                max: " . (count($labels) - 1) . ",

                min: 0,

                values: [ " . $lowVal[0] . ", " . $highVal[0] . " ],

                slide: function( event, ui ) {

                    $('#time_r_amount1').val( items[ui.values[ 0 ]]);

                    $('#time_r_amount2').val( items[ui.values[ 1 ]]);

                },create: function(event, ui) {

                    $(this).slider('values',0," . $lowVal[0] . ");

                    $(this).slider('values',1," . $highVal[0] . ");

                }

            });

            ";

        } else {

            return "";

        }

        if (count($newLabels)) {

            $this->insertSliderOptions($idQ, $idP, implode(',', $newLabels));

        }

        if (count($newRanged)) {

            $this->insertRangedSliderOptions($idQ, $idP, $newRanged);

        }

        $retHtml = $html . "<script>" . $script . "</script>";

        return $retHtml;

    }

    public function makeWidgetProjQuestion($quest, $id, $idP, $iframe = false, $wId = false, $uId = false, $extraParams = null)
    {

        if ($iframe) {

            //$kriz = "<select name=kriz style='width:350px' id='kriz'>".$this -> makeWidgetCrossDropdown($quest, $id, $idP)."</select>";

            $pathToRoot = PATH_TO_ROOT . "statview/";

        } else {

            //$kriz = $this -> makeCrossDropdown($quest, $id);

            $pathToRoot = '';

        }

        $sel = new Selector($this->db);

        $html = "";

        $view = '';

        $slider = '';

        $qIdCross = null;

        if ($quest) {

            if ($iframe) {

                $showTypes = $sel->getWidgetShowTypes($idP, $id, $wId, $uId);

            } else {

                $showTypes = $sel->getProjShowTypes($idP, $id);

            }

            $active = false;

            $hasTable = $hasPie = $hasBar = $hasLine = $hasMap = 'disabled';

            // def setting for buttons

            for ($i = 1; $i < 4; $i++) {

                if ($showTypes['tabl' . $i]) {

                    $hasTable = 'off';

                    if ($active) {

                        ${"table$i"} = '<a href=javascript:void(0)><img id=PTable_' . $i . ' src=' . $pathToRoot . '_img/icon_table' . $i . '_42_off.png alt=table' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    } else {

                        ${"table$i"} = '<a href=javascript:void(0)><img id=PTable_' . $i . ' src=' . $pathToRoot . '_img/icon_table' . $i . '_42_on.png alt=table' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                        $active = true;

                        $view = $this->makeProjTableView($id, $idP, null, $i, $iframe, true, $extraParams);

                    }

                } else {

                    ${"table$i"} = '';

                }

            }

            for ($i = 1; $i < 4; $i++) {

                if ($showTypes['pie' . $i]) {

                    $hasPie = 'off';

                    if ($active) {

                        ${"pie$i"} = '<a href=javascript:void(0)><img id=PPie_' . $i . ' src=' . $pathToRoot . '_img/icon_pie' . $i . '_42_off.png alt=pie' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                    } else {

                        ${"pie$i"} = '<a href=javascript:void(0)><img id=PPie_' . $i . ' src=' . $pathToRoot . '_img/icon_pie' . $i . '_42_on.png alt=pie' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                        $active = true;

                        if ($i == 3 && $iframe) {

                            $qIdCross = $this->getWidgetFirstCross($id, $idP);

                        }

                        $view = $this->makeProjPieView($id, $idP, $qIdCross, $i, $iframe, true, $extraParams);

                    }

                } else {

                    ${"pie$i"} = '';

                }

            }

            for ($i = 1; $i < 4; $i++) {

                if ($showTypes['bar' . $i]) {

                    $hasBar = 'off';

                    if ($active) {

                        ${"bar$i"} = '<a href=javascript:void(0)><img id=PBar_' . $i . ' src=' . $pathToRoot . '_img/icon_bar' . $i . '_42_off.png alt=bar' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                    } else {

                        ${"bar$i"} = '<a href=javascript:void(0)><img id=PBar_' . $i . ' src=' . $pathToRoot . '_img/icon_bar' . $i . '_42_on.png alt=bar' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                        $active = true;

                        if (($i == 2 || $i == 3) && $iframe) {

                            $qIdCross = $this->getWidgetFirstCross($id, $idP);

                        }

                        $view = $this->makeProjBarView($id, $idP, $qIdCross, $i, $iframe, true, $extraParams);

                    }

                } else {

                    ${"bar$i"} = '';

                }

            }

            for ($i = 1; $i < 5; $i++) {

                if ($showTypes['line' . $i]) {

                    $hasLine = 'off';

                    if ($active) {

                        ${"line$i"} = '<a href=javascript:void(0)><img id=PLine_' . $i . ' src=' . $pathToRoot . '_img/icon_line' . $i . '_42_off.png alt=line' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    } else {

                        ${"line$i"} = '<a href=javascript:void(0)><img id=PLine_' . $i . ' src=' . $pathToRoot . '_img/icon_line' . $i . '_42_on.png alt=line' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                        $active = true;

                        if (($i == 2 || $i == 3) && $iframe) {

                            $qIdCross = $this->getWidgetFirstCross($id, $idP);

                        }

                        $view = $this->makeProjLineView($id, $idP, $qIdCross, $i, $iframe, true, $extraParams);

                        //$slider = $this -> makeProjSlider($id, $idP);

                    }

                } else {

                    ${"line$i"} = '';

                }

            }

            if ($iframe) {

                $kriz = "<select name=kriz id='kriz'>" . $this->makeWidgetCrossDropdown($quest, $id, $idP, $qIdCross) . "</select>";

            } else {

                $kriz = "<select name=kriz id='kriz'>" . $this->makeCrossDropdown($quest, $id) . "</select>";

            }

            for ($i = 1; $i < 5; $i++) {

                if ($showTypes['map' . $i]) {

                    $hasMap = 'off';

                    if ($active) {

                        ${"map$i"} = '<a href=javascript:void(0)><img id=PMap_' . $i . ' src=' . $pathToRoot . '_img/icon_map' . $i . '_42_off.png alt=map' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    } else {

                        ${"map$i"} = '<a href=javascript:void(0)><img id=PMap_' . $i . ' src=' . $pathToRoot . '_img/icon_map' . $i . '_42_on.png alt=map' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                        $active = true;

                        $asnwArr = $this->makeAnswersDropdown($id, $idP, $iframe);

                        $kriz = $asnwArr['html'];

                        $view = $this->makeProjMapView($id, $idP, null, $i, $iframe, true, $asnwArr['aId']);

                    }

                } else {

                    ${"map$i"} = '';

                }

            }

            $html .= "

            <div class=sd3d>

            	<div class=predc style='overflow:hidden;'>

              		<div class='sd3d b15 vprasc' style='font-size: 16px;'>

                 		" . $this->cleanOutput($quest[$id]['question']) . "

                  	</div>



                  	<div class=w-cross-drop-container>

                  		<div class=w-opcijen id=crossWrap>

                        	" . $kriz . "

                      	</div>

                  	</div>



                  	<div class=w-charts-conatiner>

                  		<div class=opcije style='border-bottom:none;'>

                      		" . $pie1 . $pie2 . $pie3 . $bar1 . $bar2 . $bar3 . $line1 . $line2 . $line3 . $line4 . $table1 . $map1 . $map2 . $map3 . $map4 . "

                     	</div>

                  	</div>



                  	<div class=graf>

                    	" . $view . "

                  	</div>



                  	<div class='w-komentar'>

                    	" . $this->cleanOutput($quest[$id]['comment']) . "

                  	</div>

            	</div>

            </div>

            <input type=hidden name=qId value=" . $this->cleanOutput($id) . ">



			<script>

				$(function() {

					$('.izvozi').remove();

				});

			</script>

            ";

        }

        return $html;

    }

    public function makeClientProjQuestion($quest, $id, $idP, $iframe = false, $wId = false, $uId = false)
    {

        if ($iframe) {

            $kriz = "<select name=kriz style='width:350px' id='kriz'>" . $this->makeWidgetCrossDropdown($quest, $id, $idP) . "</select>";

            $pathToRoot = PATH_TO_ROOT . "statview/";

        } else {

            $kriz = "<select name=kriz style='width:350px' id='kriz'>" . $this->makeCrossDropdown($quest, $id) . "</select>";

            $pathToRoot = '';

        }

        $sel = new Selector($this->db);

        $html = "";

        $view = '';

        $slider = '';

        if ($quest) {

            if ($iframe) {

                $showTypes = $sel->getWidgetShowTypes($idP, $id, $wId, $uId);

            } else {

                $showTypes = $sel->getProjShowTypes($idP, $id);

            }

            $active = false;

            $hasTable = $hasPie = $hasBar = $hasLine = $hasMap = 'disabled';

            // def setting for buttons

            for ($i = 1; $i < 4; $i++) {

                if ($showTypes['tabl' . $i]) {

                    $hasTable = 'off';

                    if ($active) {

                        ${"table$i"} = '<a href=javascript:void(0)><img id=PTable_' . $i . ' src=' . $pathToRoot . '_img/icon_table' . $i . '_42_off.png alt=table' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    } else {

                        ${"table$i"} = '<a href=javascript:void(0)><img id=PTable_' . $i . ' src=' . $pathToRoot . '_img/icon_table' . $i . '_42_on.png alt=table' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                        $active = true;

                        $view = $this->makeProjTableView($id, $idP, null, $i, $iframe, true);

                    }

                } else {

                    ${"table$i"} = '';

                }

            }

            for ($i = 1; $i < 4; $i++) {

                if ($showTypes['pie' . $i]) {

                    $hasPie = 'off';

                    if ($active) {

                        ${"pie$i"} = '<a href=javascript:void(0)><img id=PPie_' . $i . ' src=' . $pathToRoot . '_img/icon_pie' . $i . '_42_off.png alt=pie' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                    } else {

                        ${"pie$i"} = '<a href=javascript:void(0)><img id=PPie_' . $i . ' src=' . $pathToRoot . '_img/icon_pie' . $i . '_42_on.png alt=pie' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                        $active = true;

                        //if($i == 3 && $iframe) $qIdCross = $this->getWidgetFirstCross($id, $idP);

                        $view = $this->makeProjPieView($id, $idP, null, $i, $iframe, true);

                    }

                } else {

                    ${"pie$i"} = '';

                }

            }

            for ($i = 1; $i < 4; $i++) {

                if ($showTypes['bar' . $i]) {

                    $hasBar = 'off';

                    if ($active) {

                        ${"bar$i"} = '<a href=javascript:void(0)><img id=PBar_' . $i . ' src=' . $pathToRoot . '_img/icon_bar' . $i . '_42_off.png alt=bar' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                    } else {

                        ${"bar$i"} = '<a href=javascript:void(0)><img id=PBar_' . $i . ' src=' . $pathToRoot . '_img/icon_bar' . $i . '_42_on.png alt=bar' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                        $active = true;

                        //if(($i == 2 || $i == 3) && $iframe) $qIdCross = $this->getWidgetFirstCross($id, $idP);

                        $view = $this->makeProjBarView($id, $idP, null, $i, $iframe, true);

                    }

                } else {

                    ${"bar$i"} = '';

                }

            }

            for ($i = 1; $i < 5; $i++) {

                if ($showTypes['line' . $i]) {

                    $hasLine = 'off';

                    if ($active) {

                        ${"line$i"} = '<a href=javascript:void(0)><img id=PLine_' . $i . ' src=' . $pathToRoot . '_img/icon_line' . $i . '_42_off.png alt=line' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    } else {

                        ${"line$i"} = '<a href=javascript:void(0)><img id=PLine_' . $i . ' src=' . $pathToRoot . '_img/icon_line' . $i . '_42_on.png alt=line' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                        $active = true;

                        //if(($i == 2 || $i == 3) && $iframe) $qIdCross = $this->getWidgetFirstCross($id, $idP);

                        $view = $this->makeProjLineView($id, $idP, null, $i, $iframe, true);

                        //$slider = $this -> makeProjSlider($id, $idP);

                    }

                } else {

                    ${"line$i"} = '';

                }

            }

            for ($i = 1; $i < 5; $i++) {

                if ($showTypes['map' . $i]) {

                    $hasMap = 'off';

                    if ($active) {

                        ${"map$i"} = '<a href=javascript:void(0)><img id=PMap_' . $i . ' src=' . $pathToRoot . '_img/icon_map' . $i . '_42_off.png alt=map' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    } else {

                        ${"map$i"} = '<a href=javascript:void(0)><img id=PMap_' . $i . ' src=' . $pathToRoot . '_img/icon_map' . $i . '_42_on.png alt=map' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                        $active = true;

                        $asnwArr = $this->makeAnswersDropdown($id, $idP, $iframe);

                        $kriz = $asnwArr['html'];

                        $view = $this->makeProjMapView($id, $idP, null, $i, $iframe, true, $asnwArr['aId']);

                    }

                } else {

                    ${"map$i"} = '';

                }

            }

            $html .= "

            <div class=sd3d>

                        <div class=predc>

                          <div class='sd3d b15 vprasc'>

                         " . $quest[$id]['question'] . "

                          </div>

                          <div class=ur_l>

                              <div class=opcijen id=crossWrap style='height:25px;padding-top:30px;margin-top:-10px'>

                                " . $kriz . "

                              </div>

                          </div>



                          <div class=ur_d style='font-size:14px;'>

                              <div class=opcije style='border-bottom:none;'>

                                <a href=javascript:void(0)><img src=" . $pathToRoot . "_img/icon_pie_36_" . $hasPie . ".png alt=graf1 class=imprev /></a>

                                <a href=javascript:void(0)><img src=" . $pathToRoot . "_img/icon_bar_36_" . $hasBar . ".png alt=graf2 class=imprev /></a>

                                <a href=javascript:void(0)><img src=" . $pathToRoot . "_img/icon_line_36_" . $hasLine . ".png alt=graf3 class=imprev /></a>

                                <a href=javascript:void(0)><img src=" . $pathToRoot . "_img/icon_table_36_" . $hasTable . ".png alt=graf4 class=imprev /></a>

                                <!--<a href=javascript:void(0)><img src=" . $pathToRoot . "_img/icon_map_36_" . $hasMap . ".png alt=graf4 class=imprev /></a>-->

                             </div>

                            <div class='ur_l1 ur_bs' id=ppiesub>"

                . $pie1

                . $pie2

                . $pie3 . "

                            </div>

                            <div class='ur_l1 ur_bs' id=pbarsub>"

                . $bar1

                . $bar2

                . $bar3 . "

                            </div>

                            <div class='ur_l1 ur_bs' id=plinesub>"

                . $line1

                . $line2

                . $line3

                . $line4 . "

                            </div>

                            <div class='ur_l1 ur_bs' id=ptablesub>"

                . $table1 . "

                            </div>

                          </div>

                          <div class=graf>

                            " . $view . "

                          </div>

                          <div>&nbsp;</div>

                          <div class='komentar'>

                            " . $quest[$id]['comment'] . "

                          </div>

                        </div>

                      </div>

                    <input type=hidden name=qId value=" . $id . ">";

        }

        return $html;

    }

    public function showClientPPieAction()
    {

        $isWidget = ($_POST['wid'] == "widget") ? true : false;

        if (isset($_POST['slider_sett'])) {

            $html = $this->makeWidgetPieView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true, $_POST['slider_sett']);

        } elseif (isset($_POST['minId']) && isset($_POST['maxId'])) {

            $sett = $_POST['minId'] . "," . $_POST['maxId'];

            $html = $this->makeWidgetPieView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true, $sett);

        } else {

            $html = $this->makeProjPieView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true);

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function showClientPBarAction()
    {

        $isWidget = ($_POST['wid'] == "widget") ? true : false;

        if (isset($_POST['slider_sett'])) {

            if (isset($_POST['qIdCross'])) {

                $html = $this->makeWidgetBarView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true, $_POST['slider_sett']);

            } else {

                $html = $this->makeWidgetBarView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true, $_POST['slider_sett']);

            }

        } elseif (isset($_POST['minId']) && isset($_POST['maxId'])) {

            $sett = $_POST['minId'] . "," . $_POST['maxId'];

            if (isset($_POST['qIdCross'])) {

                $html = $this->makeWidgetBarView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true, $sett);

            } else {

                $html = $this->makeWidgetBarView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true, $sett);

            }

        } else {

            if (isset($_POST['qIdCross'])) {

                $html = $this->makeProjBarView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true);

            } else {

                $html = $this->makeProjBarView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true);

            }

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function showClientPLineAction()
    {

        $isWidget = ($_POST['wid'] == "widget") ? true : false;

        if (isset($_POST['slider_sett'])) {

            if (isset($_POST['qIdCross'])) {

                $html = $this->makeWidgetLineView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true, $_POST['slider_sett']);

            } else {

                $html = $this->makeWidgetLineView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true, $_POST['slider_sett']);

            }

        } elseif (isset($_POST['minId']) && isset($_POST['maxId'])) {

            $sett = $_POST['minId'] . "," . $_POST['maxId'];

            if (isset($_POST['qIdCross'])) {

                $html = $this->makeWidgetLineView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true, $sett);

            } else {

                $html = $this->makeWidgetLineView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true, $sett);

            }

        } else {

            if (isset($_POST['qIdCross'])) {

                $html = $this->makeProjLineView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true);

            } else {

                $html = $this->makeProjLineView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true);

            }

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function showClientPTableAction()
    {

        $isWidget = ($_POST['wid'] == "widget") ? true : false;

        if (isset($_POST['qIdCross'])) {

            $html = $this->makeProjTableView($_POST['qId'], $_POST['pId'], $_POST['qIdCross'], $_POST['subType'], $isWidget, true);

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        } else {

            $html = $this->makeProjTableView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true);

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        }

    }

    public function showClientPMapAction()
    {

        $isWidget = ($_POST['wid'] == "widget") ? true : false;

        if (isset($_POST['aId'])) {

            $html = $this->makeProjMapView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true, $_POST['aId']);

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

            /*$html = $data['html'];

        $mapfile = $data['mapfile'];

        $mapdata = $data['mapdata'];

        $_SESSION['layers'] = implode(",", $data['types']);

        $mapdata = json_decode(htmlspecialchars_decode($mapdata));

        $type = $mapdata->data->type;

        $resp = 'OL.mapfile=\"' . $mapfile.'\";OL.layers=\"' . $_SESSION['layers'] . '\";OL.category='.$data['cat'].';OL.mapType=\"' . $type . '\";';

        return '{"error":false,"script":true,"response":"' . $resp . '", "html":"' . $this -> cleanHTML($html) . '"}';*/

        } else {

            $html = $this->makeProjMapView($_POST['qId'], $_POST['pId'], null, $_POST['subType'], $isWidget, true, null);

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

            /*$html = $data['html'];

        $mapfile = $data['mapfile'];

        $mapdata = $data['mapdata'];

        $_SESSION['layers'] = implode(",", $data['types']);

        $mapdata = json_decode(htmlspecialchars_decode($mapdata));

        $type = $mapdata->data->type;

        $resp = 'OL.mapfile=\"' . $mapfile.'\";OL.layers=\"' . $_SESSION['layers'] . '\";OL.category='.$data['cat'].';OL.mapType=\"' . $type . '\";';

        return '{"error":false,"script":true,"response":"' . $resp . '", "html":"' . $this -> cleanHTML($html) . '"}';*/

        }

    }

    public function getProjQuestionsHtmlAction()
    {

        $pId = $this->cleanInput($_POST['pId']);

        $sel = new Selector($this->db);

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'project'", "'default'"), DB_WARPIT_STATVIEW);

        $qkeys = array();

        $project = $sel->getProject($this->cleanInput($_POST['pId']));

        $client = $sel->getProjectClient($pId);

        $projQuestions = $sel->getResearchCalculated($project['projectName']);

        $projResearches = $sel->getProjResearches($pId);

        if ($projQuestions) {

            $qkeys = array_keys($projQuestions);

        }

        $pName = (isset($project['longName'])) ? $project['longName'] : '';

        $fText = (isset($project['footerText'])) ? $project['footerText'] : '';

        $isTimed = ($project['isTimed']) ? "checked" : '';

        $_SESSION['project'] = $pId;

        if (isset($_POST['qId']) && $_POST['qId'] != '') {

            $qId = $this->cleanInput($_POST['qId']);

        } else if (isset($qkeys[0])) {

            $qId = $qkeys[0];

        } else {

            $qId = null;

        }

        $html = "

        <!-- vprašanja projekta -->

        <div id='questions'>

            <div class='table-responsive'>

            <table id='ProjQuestionsTable' class='table table-striped table-hover' width='98%'>

                <thead>

                    <tr>

                        <td></td><td></td>

                    </tr>

                </theah>

                <tbody>";

        $html .= $this->makeProjQuestions($projQuestions, $qId);

        $html .= "</tbody>

            </table>

            </div>

        </div>

        <!-- urejanje in predogled projekta -->

        <div id='edit'>

            <div id='m1' class='menuy'>

                <ul>

                    <li id='my1' class='vmy vm_acty'>" . $this->cleanOutput($language['project_edit']) . "</li>

                    <li id='my2' class='vmy'>" . $this->cleanOutput($language['project_preview']) . "</li>

                </ul>

            </div>

            <div id='qWraper'>";

        $html .= $this->makeProjQuestion($projQuestions, $qId, $pId);

        $html .= "</div>

        </div>

        ";

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getProjSettingsHtmlAction()
    {

        $pId = $this->cleanInput($_POST['pId']);

        $qId = $this->cleanInput($_POST['qId']);

        $sel = new Selector($this->db);

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'project'", "'default'"), DB_WARPIT_STATVIEW);

        $project = $sel->getProject($pId);

        $pName = (isset($project['longName'])) ? $project['longName'] : '';

        $fText = (isset($project['footerText'])) ? $project['footerText'] : '';

        $isTimed = ($project['isTimed']) ? "checked" : '';

        $projResearches = $sel->getProjResearches($pId);

        $_SESSION['project'] = $pId;

        $html = "

        <div class='utn' style='border-bottom:none;float:left;'>";

        if (in_array('edit_project', $_SESSION['UserPermissions'])) {

            $html .= "<div class='shraniosn' id='addProjData'>" . $this->cleanOutput($language['upload_new_data']) . " <div class='frm10'>+</div></div>";

        }

        $html .= "

        </div>



        <form id='questionForm'>

            <!-- naziv in footer projekta -->

            <div class='sd5'>

               <div class='nap'>" . $this->cleanOutput($language['project_title']) . ":</div>

               <div class='vnos'><input name='naz_proj' type='text' required='true' maxlength='200' value='" . $this->cleanOutput($pName) . "' ";

        if (!in_array('edit_project', $_SESSION['UserPermissions'])) {$html .= "readonly";}$html .= "/></div>

               <div class='nap' style='clear:both'>" . $this->cleanOutput($language['project_foot_text']) . ":</div>

               <div class='vnos'><input name='footer_text' type='text' maxlength='200' value='" . $this->cleanOutput($fText) . "' ";

        if (!in_array('edit_project', $_SESSION['UserPermissions'])) {$html .= "readonly";}$html .= "/></div>

            </div>



            <!-- time cmp, širine in barve -->";

        if (in_array('edit_project', $_SESSION['UserPermissions'])) {

            $html .= "<div class='sd5g w960'>

                            <div class='nap' style='margin-top:-5px;'>" . $this->cleanOutput($language['default_sett']) . "</div>

                        </div>

                        <div class='passica w960' id='def_sett_div' style='height:auto;margin-bottom:5px;margin-top:20px'>

                            <table>

                                <tr>

                                   <td><div id='sirina_label' class='sel' style='width:170px;margin-bottom:5px;'>" . $this->cleanOutput($language['project_width']) . ":</div></td>

                                   <td><div id='color_label' class='sel' style='width:170px;margin-bottom:5px;'>" . $this->cleanOutput($language['project_color']) . ":</div></td>

                                </tr>

                                <tr>

                                    <td>" . $this->makeProjWidthDropdown($pId) . "</td>

                                    <td>" . $this->makeProjColorDropdown($pId) . "</td>

                                </tr>

                            </table>

                        </div>";

        }

        $html .= "

            <!--tabela vklučenih raziskav-->

            <div class='sd5g w960'>

                <div class='nap' style='margin-top:-5px;'>" . $this->cleanOutput($language['project_use_research']) . "</div>

            </div>

            <div class='passica' style='height:auto;margin-bottom:5px;margin-top:0;width:100%;margin-bottom:0;'>

                <div id='added_res'>

                    <div class='table-responsive'>

                        <table id='ProjResTable2' class='table table-striped table-hover' width='100%' >

                            <thead>

                                <tr>

                                    <td></td><td></td>

                                </tr>

                            </thead>

                            <tbody id='ProjResTable2Body'>

                                " . $this->makeProjResearches($projResearches) . "

                            </tbody>

                        </table>

                    </div>

                </div>";

        if (in_array('edit_project', $_SESSION['UserPermissions'])) {

            $html .= "

                    <div class='s_x4o'>" . $this->cleanOutput($language['project_use_research']) . ":</div>

                        <div class='s_x2'>

                            <select class='sezraz' name='raziskava' id='resDrop' style='padding:0;height:32px;float:left;width:400px;'>

                                <option value='0'>" . $this->cleanOutput($language['proj_select']) . "...</option>

                                " . $this->makeAddProjResSelector() . "

                            </select>

                        <div class='zavrzi w80' style='float:left;padding:5px; margin:5px 15px 0;' id='addProjectResBtn'>" . $this->cleanOutput($language['add_btn']) . "</div>

                    </div>

                    <div id='crta'></div>";

        }

        $html .= "

            </div>



            <input type=hidden name=proId value=" . $this->cleanOutput($pId) . ">

            <input type=hidden name=qId value=" . $this->cleanOutput($qId) . ">

            <input type=hidden name=form_part value=other_data>

        </form>";

        $html .= $this->makeProjectCustomColorSchemeWindow($pId, $sel);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    private function makeProjectCustomColorSchemeWindow($pId, $sel)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $colors = explode(",", $sel->getCustomColorSchema($pId));

        if (!is_array($colors) || count($colors) < 2) {

            //seznam privzetih barv za highcahrts

            $colors = array(0 => "#7cb5ec", 1 => "#434348", 2 => "#90ed7d", 3 => "#f7a35c", 4 => "#8085e9", 5 => "#f15c80", 6 => "#e4d354", 7 => "#2b908f", 8 => "#f45b5b", 9 => "#91e8e1");

        }

        $html = "<div id='projectCustomColorSchemeDialog' title='" . $this->cleanOutput($language['custom_color_scheme']) . "'>

    				<div class='color-pickers'>";

        foreach ($colors as $key => $color) {

            $i = $key + 1;

            $html .= "<div class='color-pick-container'>

		            	<label>" . $this->cleanOutput($language['color']) . " $i:</label>

	            		<input type='text' value='" . $color . "' id='full-spectrum-picker-$i' class='full-spectrum-picker' />

	            	  </div>";

        }

        $html .= "</div>

			  <div class='shraniosn' id='remove-color-selector' onclick='removeColorPicker()'>-</div>

			  <div class='shraniosn' id='add-new-color-selector' onclick='addNewColorPicker()'>+</div>

		  </div>";

        return $html;

    }

    public function saveProjectCustomColorSchemeAction()
    {

        $pId = $this->cleanInput($_POST['pId']);

        $colors = $this->cleanInput($_POST['colors']);

        $sql = "SELECT * FROM _customColorSchemes WHERE idProj = '" . $pId . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($this->db->NumRows($result)) {

            $sql = "UPDATE _customColorSchemes SET colors = '" . $colors . "' WHERE idProj = '" . $pId . "'";

        } else {

            $sql = "INSERT INTO _customColorSchemes (idProj, colors) VALUES ('" . $pId . "', '" . $colors . "')";

        }

        $this->db->SQLexecute($sql);

        return '{"error":false,"script":false,"response":""}';

    }

    public function getProjEventsHtmlAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $id = $this->cleanInput($_POST['qId']);

        $idP = $this->cleanInput($_POST['pId']);

        $html = "<!--tabela dogodkov in dodajanje teh-->

                <div id=dog_" . $this->cleanOutput($id) . "_cont>

                    " . $this->makeProjectQuestionsEvents($idP, $id) . "

                </div>";

        if (in_array('edit_project', $_SESSION['UserPermissions'])) {

            $html .= "<div class=dog_dod id=addResEvent><a href=javascript:addProEvent('" . $this->cleanOutput($id) . "') >+ " . $this->cleanOutput($language['project_event_add']) . "</a></div>";

        }

        $html .= "

                <input type=hidden name=proId value=" . $this->cleanOutput($idP) . ">

                <input type=hidden name=qId value=" . $this->cleanOutput($id) . ">";

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function makeProjQuestion($quest, $id, $idP)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $sel = new Selector($this->db);

        $idQ = $id;

        $html = "";

        if ($quest) {

            $projName = $sel->getProjectName($idP);

            $projName = str_replace(" ", "_", $projName);

            $calc = new Calculate($this->db, '_projects', $projName, $idP);

            $labs = new Labels($this->db, '_projects', $projName, $idP);

            $labs->setQuestion($idQ);

            $calc->setQuestion($idQ);

            $params = $calc->getParameters();

            $freq = $calc->getFrequencies();

            $total = $calc->getTotal();

            $labels = $labs->getLabels();

            $showTypes = $sel->getProjShowTypes($idP, $id);

            $pie1 = ($showTypes['pie1']) ? 'on' : 'off';

            $pie2 = ($showTypes['pie2']) ? 'on' : 'off';

            $pie3 = ($showTypes['pie3']) ? 'on' : 'off';

            $pie1Val = ($showTypes['pie1']) ? '1' : '0';

            $pie2Val = ($showTypes['pie2']) ? '1' : '0';

            $pie3Val = ($showTypes['pie3']) ? '1' : '0';

            $bar1 = ($showTypes['bar1']) ? 'on' : 'off';

            $bar2 = ($showTypes['bar2']) ? 'on' : 'off';

            $bar3 = ($showTypes['bar3']) ? 'on' : 'off';

            $bar1Val = ($showTypes['bar1']) ? '1' : '0';

            $bar2Val = ($showTypes['bar2']) ? '1' : '0';

            $bar3Val = ($showTypes['bar3']) ? '1' : '0';

            $line1 = ($showTypes['line1']) ? 'on' : 'off';

            $line2 = ($showTypes['line2']) ? 'on' : 'off';

            $line3 = ($showTypes['line3']) ? 'on' : 'off';

            $line1Val = ($showTypes['line1']) ? '1' : '0';

            $line2Val = ($showTypes['line2']) ? '1' : '0';

            $line3Val = ($showTypes['line3']) ? '1' : '0';

            $table1 = ($showTypes['tabl1']) ? 'on' : 'off';

            $table2 = ($showTypes['tabl2']) ? 'on' : 'off';

            $table3 = ($showTypes['tabl3']) ? 'on' : 'off';

            $table1Val = ($showTypes['tabl1']) ? '1' : '0';

            $html .= "<div id=vseb_v1b class=sd3l></div>

                      <div id=projEdit class='quest_label'>";

            $html .= $this->cleanOutput($quest[$id]['question']);

            if (in_array('edit_project', $_SESSION['UserPermissions'])) {

                $html .= "<div class=fl style='float:right;margin-left:10px'><a href=javascript:showProjNameInput('" . $this->cleanOutput($id) . "');><img src=_img/edit.png></a></div>";

            }

            $html .= "</div>

                      <form id=questionForm>

                      <div id=vsebina>

                          <div class=vseb_main>

                            <!--oblike prikaza-->

                            <div class=q_cont>

                                <div class=ur_napb>" . $this->cleanOutput($language['project_apperance']) . ":<br /></div>

                            </div>

                            <div class=ur_l1>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_pie_64_off.png alt=graf1 class=immain /></a>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_bar_64_off.png alt=graf2 class=immain /></a>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_line_64_off.png alt=graf3 class=immain /></a>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_table_64_off.png alt=graf4 class=immain /></a>

                            </div>

                            <div class='ur_l1 ur_bs' id=piesub>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_pie1_42_" . $pie1 . ".png alt=pie1 style=background-color:#fff; class=imedit /><input type=hidden name=pie1 value=" . $pie1Val . "></a>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_pie2_42_" . $pie2 . ".png alt=pie2 style=background-color:#fff; class=imedit /><input type=hidden name=pie2 value=" . $pie2Val . "></a>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_pie3_42_" . $pie3 . ".png alt=pie3 style=background-color:#fff; class=imedit /><input type=hidden name=pie3 value=" . $pie3Val . "></a>

                            </div>

                            <div class='ur_l1 ur_bs' id=barsub>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_bar1_42_" . $bar1 . ".png alt=bar1 style=background-color:#fff; class=imedit /><input type=hidden name=bar1 value=" . $bar1Val . "></a>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_bar2_42_" . $bar2 . ".png alt=bar2 style=background-color:#fff; class=imedit /><input type=hidden name=bar2 value=" . $bar2Val . "></a>";

            if ($params["questionType"] != 2) {

                //Dodal Boštjan Janžovnik 15.02.2016 ker se pri scale uporabljata samo prva dva tipa grafov.

                $html .= "<a href=javascript:void(0)><img src=../statview/_img/icon_bar3_42_" . $bar3 . ".png alt=bar3 style=background-color:#fff; class=imedit /><input type=hidden name=bar3 value=" . $bar3Val . "></a>";

            }

            $html .= "

                            </div>

                            <div class='ur_l1 ur_bs' id=linesub>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_line1_42_" . $line1 . ".png alt=line1 class=imedit style=background-color:#fff; /><input type=hidden name=line1 value=" . $line1Val . "></a>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_line2_42_" . $line2 . ".png alt=line2 class=imedit style=background-color:#fff; /><input type=hidden name=line2 value=" . $line2Val . "></a>";

            if ($params["questionType"] != 2) {

                $html .= "<a href=javascript:void(0)><img src=../statview/_img/icon_line3_42_" . $line3 . ".png alt=line3 class=imedit style=background-color:#fff; /><input type=hidden name=line3 value=" . $line3Val . "></a>";

            }

            $html .= "

                            </div>

                            <div class='ur_l1 ur_bs' id=tablesub>

                              <a href=javascript:void(0)><img src=../statview/_img/icon_table1_42_" . $table1 . ".png alt=table1 class=imedit style=background-color:#fff; /><input type=hidden name=table1 value=" . $table1Val . "></a>

                            </div>



                            <!--tabela vprašanj za križanje-->

                            <div class=q_cont style=';border-top:#d1d3d4 solid 1px;'>

                              <div class=ur_napb>" . $this->cleanOutput($language['project_cross']) . "</div>

                              " . $this->makeCrossCheckProj($quest, $id) . "

                            </div>



                            <!--komentar-->

                            <div class=q_cont>

                              <div class=ur_napb>" . $this->cleanOutput($language['project_comment']) . ":<br /></div>

                              <div style='width:100%'>

                              <textarea name=komentar maxlength='2000' type=text style='width:100%;height:100px;'>" . trim($this->cleanOutput($quest[$id]['comment'])) . "</textarea>

                              </div>

                            </div>



                         </div>



                         <div id=chart_prev style=display:none;>

                            <!-- grafi, tabele -->

                         </div>

                      </div>

                      <input type=hidden name=proId value=" . $this->cleanOutput($idP) . ">

                      <input type=hidden name=qId value=" . $this->cleanOutput($id) . ">

                      <input type=hidden name=form_part value=question>

                      <input type=hidden name=qType value=" . $params["questionType"] . ">

                      </form>";

        }

        return $html;

    }

    public function makeResQuestions($quest, $idR)
    {

        $html = "";

        if (count($quest)) {

            foreach ($quest as $key => $q) {

                $html .= "<tr>

                          <td>

                            <div class=resQuest onclick=javascript:shhi('vseb_" . $this->cleanOutput($key) . "'," . $this->cleanOutput($idR) . ");>

                                <div id=vseb_" . $this->cleanOutput($key) . "b class=res_droparrow><img src='_img/pusdol.png'></div>

                                <div>

                                    <div>

                                        <div id='qName_" . $this->cleanOutput($key) . "' class=res_qname>" . $this->cleanOutput($q['questionName'] . " - " . $q['question']) . "</div>

                                    </div>

                                </div>

                                <div id='vseb_" . $this->cleanOutput($key) . "' class='sd3dw skrit'></div>

                            </div>

                          </td>

                          </tr>";

            }

        }

        return $html;

    }

    public function makeResQuestion($quest, $id, $idR)
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'research'", "'default'"), DB_WARPIT_STATVIEW);

        $sel = new Selector($this->db);

        $idQ = $id;

        $res = $sel->getResearch($idR);

        $resName = $sel->getResearcheName($idR);

        $resName = str_replace(" ", "_", $resName);

        $calc = new Calculate($this->db, '_research', $resName, $idR);

        $labs = new Labels($this->db, '_research', $resName, $idR);

        $labs->setQuestion($idQ);

        $calc->setQuestion($idQ);

        $params = $calc->getParameters();

        $freq = $calc->getFrequencies();

        $total = $calc->getTotal();

        $labels = $labs->getLabels();

        $calcHtml = "";

        $numHtml = "";

        $tableHead = "";

        $i = 0;

        if (intval($params['questionType']) != 2) {

            $numArr = array();

            $calcHtml .= "<tr><td></td><td class=num_td><b class=num_label>N</b></td><td class=perc_td><b class=percent_label>%</b></td></tr>";

            foreach ($labels[$idQ]['answers'] as $key => $l) {

                $num = (isset($freq[$idQ][$key]) == true ? $freq[$idQ][$key] : 0);

                array_push($numArr, $num);

                $proc = round(($freq[$idQ][$key] / $total[$idQ]) * 100, 1);

                $calcHtml .= "<tr>

                                <td>" . $this->cleanOutput($l) . "</td>

                                <td class=num_td><b class=num_label>" . $this->cleanOutput($num) . "</b></td>

                                <td class=perc_td><b class=percent_label>" . $this->cleanOutput($proc) . "%</b></td>

                              </tr>";

            }

            //$all = ($res['weighted']) ? floatval($total[$idQ]) : $total[$idQ];

        } else {

            $numArr = array();

            foreach ($labels[$idQ]['answers'] as $key1 => $a) {

                $calcHtml .= "<tr>

                                <td>" . $this->cleanOutput($a) . "</td>

                              </tr>";

                $i++;

                $j = 0;

                foreach ($labels[$idQ]['legend'] as $key2 => $l) {

                    $j++;

                    $num = (isset($freq[$idQ][$idQ . "_" . $i][$j]) == true ? $freq[$idQ][$idQ . "_" . $i][$j] : 0);

                    array_push($numArr, $num);

                    $proc = (isset($freq[$idQ][$idQ . "_" . $i][$j]) && isset($total[$idQ][$idQ . "_" . $i])) ? round(($freq[$idQ][$idQ . "_" . $i][$j] / $total[$idQ][$idQ . "_" . $i]) * 100, 1) : 0;

                    $calcHtml .= "<tr style='padding-left:30px'>

                    				<td>" . $this->cleanOutput($l) . "</td>

                    				<td><b class=num_label>" . $this->cleanOutput($num) . "</b></td>

                                    <td><b class=percent_label>" . $this->cleanOutput($proc) . "%</b></td>

                                  </tr>";

                }

            }

            //$numHtml = "<div class=numerus>N=" . number_format(($total[$idQ][$idQ . "_" . $i]), 0,  '.', '')."</div>";

        }

        $totalNum = (sizeof($numArr) > 0 ? array_sum($numArr) : 0);

        $numHtml .= "<div class=numerus>N=" . $totalNum . "</div>";

        $html = "";

        if ($quest) {

            $html .= "<table class=calc_table>

                         <tbody>

                             " . $calcHtml . "

                         </tbody>

                     </table>

                     " . $numHtml;

        }

        return $html;

    }

    public function showAdminPPieAction()
    {

        //if($_POST['id'] == "SESSION") $_POST['Id'] = $_SESSION['project'];

        $html = $this->makeProjPieView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function showAdminPBarAction()
    {

        if (isset($_POST['qIdCross'])) {

            $html = $this->makeProjBarView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

        } else {

            $html = $this->makeProjBarView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), null, $this->cleanInput($_POST['subType']));

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function showAdminPLineAction()
    {

        if (isset($_POST['qIdCross'])) {

            $html = $this->makeProjLineView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

        } else {

            $html = $this->makeProjLineView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), null, $this->cleanInput($_POST['subType']));

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function showAdminPTableAction()
    {

        if (isset($_POST['qIdCross'])) {

            $html = $this->makeProjTableView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

            //TEST

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        } else {

            $html = $this->makeProjTableView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), null, $this->cleanInput($_POST['subType']));

            //TEST

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        }

    }

    public function showAdminRPieAction()
    {

        $html = $this->makeResPieView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function showAdminRBarAction()
    {

        if (isset($_POST['qIdCross'])) {

            $html = $this->makeResBarView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        } else {

            $html = $this->makeResBarView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), null, $this->cleanInput($_POST['subType']));

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        }

    }

    public function showAdminRLineAction()
    {

        if (isset($_POST['qIdCross'])) {

            $html = $this->makeResLineView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        } else {

            $html = $this->makeResLineView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), null, $this->cleanInput($_POST['subType']));

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        }

    }

    public function showAdminRTableAction()
    {

        if (isset($_POST['qIdCross'])) {

            $html = $this->makeResTableView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), $this->cleanInput($_POST['qIdCross']), $this->cleanInput($_POST['subType']));

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        } else {

            $html = $this->makeResTableView($this->cleanInput($_POST['qId']), $this->cleanInput($_POST['id']), null, $this->cleanInput($_POST['subType']));

            return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        }

    }

    public function makeProjPrev($quest, $id, $idP)
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($idP);

        $projName = str_replace(" ", "_", $projName);

        $calc = new Calculate($this->db, '_projects', $projName, $idP);

        $calc->setQuestion($id);

        $params = $calc->getParameters();

        $sel = new Selector($this->db);

        $showTypes = $sel->getProjShowTypes($idP, $id);

        $idQ = $id;

        $active = false;

        $calcHtml = '';

        $view = '';

        $hasTable = $hasPie = $hasBar = $hasLine = $hasMap = 'disabled';

        for ($i = 1; $i < 4; $i++) {

            if ($showTypes['tabl' . $i]) {

                $hasTable = 'off';

                if ($active) {

                    ${"table$i"} = '<a href=javascript:void(0)><img id=PTable_' . $i . ' src=../statview/_img/icon_table' . $i . '_42_off.png alt=table' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                } else {

                    ${"table$i"} = '<a href=javascript:void(0)><img id=PTable_' . $i . ' src=../statview/_img/icon_table' . $i . '_42_on.png alt=table' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    $active = true;

                    $view = $this->makeProjTableView($id, $idP, null, $i);

                }

            } else {

                ${"table$i"} = '';

            }

        }

        for ($i = 1; $i < 4; $i++) {

            if ($showTypes['pie' . $i]) {

                $hasPie = 'off';

                if ($active) {

                    ${"pie$i"} = '<a href=javascript:void(0)><img id=PPie_' . $i . ' src=../statview/_img/icon_pie' . $i . '_42_off.png alt=pie' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                } else {

                    ${"pie$i"} = '<a href=javascript:void(0)><img id=PPie_' . $i . ' src=../statview/_img/icon_pie' . $i . '_42_on.png alt=pie' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                    $active = true;

                    $view = $this->makeProjPieView($id, $idP, null, $i);

                }

            } else {

                ${"pie$i"} = '';

            }

        }

        for ($i = 1; $i < 4; $i++) {

            if ($showTypes['bar' . $i]) {

                $hasBar = 'off';

                if ($active) {

                    ${"bar$i"} = '<a href=javascript:void(0)><img id=PBar_' . $i . ' src=../statview/_img/icon_bar' . $i . '_42_off.png alt=bar' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                } else {

                    ${"bar$i"} = '<a href=javascript:void(0)><img id=PBar_' . $i . ' src=../statview/_img/icon_bar' . $i . '_42_on.png alt=bar' . $i . ' style=background-color:#fff; class=imprevsub /></a>';

                    $active = true;

                    $view = $this->makeProjBarView($id, $idP, null, $i);

                }

            } else {

                ${"bar$i"} = '';

            }

        }

        for ($i = 1; $i < 5; $i++) {

            if ($showTypes['line' . $i]) {

                $hasLine = 'off';

                if ($active) {

                    ${"line$i"} = '<a href=javascript:void(0)><img id=PLine_' . $i . ' src=../statview/_img/icon_line' . $i . '_42_off.png alt=line' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                } else {

                    ${"line$i"} = '<a href=javascript:void(0)><img id=PLine_' . $i . ' src=../statview/_img/icon_line' . $i . '_42_on.png alt=line' . $i . ' class=imprevsub style=background-color:#fff; /></a>';

                    $active = true;

                    $view = $this->makeProjLineView($id, $idP, null, $i);

                    //$slider = $this -> makeProjSlider($id, $idP);

                }

            } else {

                ${"line$i"} = '';

            }

        }

        $hideCombo = ($params['questionType'] == 2 ? " disabled" : "");

        $html = "<div style='float:left;margin:10px 20px 0 0'>

                    <select id=kriz name=kriz style='width:350px;height:25px;font-weight:normal;'" . $hideCombo . ">

                        " . $this->makeCrossDropdown($quest, $id, null, $params['questionType']) . "

                    </select>

                </div>

                <div class=ur_d style='font-size:14px; padding:5px; '>

                        <div class=opcije style='border-bottom:none;'>

                            <a href=javascript:void(0)><img src=../statview/_img/icon_pie_36_" . $hasPie . ".png alt=graf1 class=imprev /></a>

                            <a href=javascript:void(0)><img src=../statview/_img/icon_bar_36_" . $hasBar . ".png alt=graf2 class=imprev /></a>

                            <a href=javascript:void(0)><img src=../statview/_img/icon_line_36_" . $hasLine . ".png alt=graf3 class=imprev /></a>

                            <a href=javascript:void(0)><img src=../statview/_img/icon_table_36_" . $hasTable . ".png alt=graf4 class=imprev /></a>

                        </div>

                        <div class='ur_l1 ur_bs' id=ppiesub>"

            . $pie1

            . $pie2

            . $pie3 . "

                        </div>

                        <div class='ur_l1 ur_bs' id=pbarsub>"

            . $bar1

            . $bar2

            . $bar3 . "

                        </div>

                        <div class='ur_l1 ur_bs' id=plinesub>"

            . $line1

            . $line2

            . $line3 . "

                        </div>

                        <div class='ur_l1 ur_bs' id=ptablesub>"

            . $table1 . "

                        </div>

                 " . $calcHtml . "

                </div>

                <div style=border-right:none; border-bottom:#cbcac6 dashed 1px;padding:15px 0;>

                    " . $view . "

                </div>";

        return $html;

    }

    public function changePrewResAction()
    {

        $sel = new Selector($this->db);

        $resId = $_SESSION['research'];

        $res = $sel->getResearch($resId);

        $resQuestions = $sel->getResearchCalculated($res['project']);

        $html = $this->makeResPrev($resQuestions, $this->cleanInput($_POST['qId']), $resId);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changePrewProjAction()
    {

        $html = "";

        $sel = new Selector($this->db);

        $projId = $_SESSION['project'];

        $pro = $sel->getProject($projId);

        $projQuestions = $sel->getResearchCalculated($pro['projectName']);

        $html = $this->makeProjPrev($projQuestions, $this->cleanInput($_POST['qId']), $projId);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function makeProjQuestions($resQuestions, $selQ = null)
    {

        $html = "";

        if ($resQuestions) {

            foreach ($resQuestions as $key => $quest) {

                $selClass = ($key == $selQ) ? 'bgta' : '';

                $isChecked = ($quest['hideQuestion']) ? '' : 'checked';

                $qName = $quest['questionName'];

                $quest = (strlen($quest['question']) > 100) ? substr($quest['question'], 0, 100) . "..." : $quest['question'];

                $html .= "<tr id=proj_q_tr_" . $this->cleanOutput($key) . ">

                                  <td><input type=checkbox style='margin-top:5px;' name=shhd_" . $this->cleanOutput($key) . " onchange=shHdQuest('" . $this->cleanOutput($key) . "'); " . $isChecked;

                if (!in_array('edit_project', $_SESSION['UserPermissions'])) {$html .= " disabled='disabled' ";}

                $html .= "/></td>

                                  <td style='cursor:pointer;' onclick=changeProjectQuestion('" . $this->cleanOutput($key) . "');><h5 style='margin-top: 3px;'>" . $this->cleanOutput($qName . " - " . $quest) . "</h5></td>

                              </tr>";

            }

        }

        return $html;

    }

    public function makeProjQuestionsClient($resQuestions, $selQ = null)
    {

        $html = "";

        if ($resQuestions) {

            foreach ($resQuestions as $key => $quest) {

                $selClass = ($key == $selQ) ? 'bgta' : '';

                $quest = (strlen($quest['question']) > 100) ? substr($quest['question'], 0, 100) . "..." : $quest['question'];

                $html .= "<div class='proj " . $this->cleanOutput($selClass) . "'>";

                $html .= "<div class='fl w215' style='padding-left:10px;width:220px;min-height:45px;' onclick=changeProjectQuestion('" . $this->cleanOutput($key) . "');><h5>" . $this->cleanOutput($quest) . "</h5></div>";

                $html .= "</div>";

            }

        }

        return $html;

    }

    public function makeResQuestionDropdown($resQuestions)
    {

        $html = "";

        if ($resQuestions) {

            $counter = count($resQuestions);

            foreach ($resQuestions as $key => $quest) {

                if ($counter == count($resQuestions)) {

                    $html .= "<div id=vpras class=sel style='color: rgb(88, 89, 91);' value=" . $this->cleanOutput($key) . ">" . $this->cleanOutput($quest['question']) . "</div>";

                    $html .= "<div class='drop' id='dropm'> <img src='_img/pusdol.png' alt='drop'/></div>";

                    $html .= "<div id='dropmo' class='dropmo skrit' style='max-height:300px; display: none;'>";

                }

                $border = ($counter > 1) ? "border-bottom:#cbcac6 solid 1px;" : "border-bottom:none";

                $html .= '<div class=dr value=' . $this->cleanOutput($key) . ' style=\'' . $border . '\'>' . $this->cleanOutput($quest['question']) . '</div>';

                $counter--;

            }

            $html .= "</div>";

        }

        return $html;

    }

    public function makeProjWidthDropdown($pId, $iframe = false)
    {

        $sel = new Selector($this->db);

        $pro = $sel->getProject($pId);

        $options = $sel->getWidthOptions();

        $selId = ($pro['showWidth']) ? $pro['showWidth'] : 2;

        $html = "<select class='widths_dropdown' name='widths_dropdown'>";

        for ($i = 0; $i < count($options); $i++) {

            $selected = ($options[$i]['id'] == $selId ? " selected" : "");

            $html .= "<option value='" . $this->cleanOutput($options[$i]['id']) . "'" . $selected . ">" . $this->cleanOutput($options[$i]['resolutionText']) . "</option>";

        }

        $html .= "</select>";

        $html .= "

        <script>

            $('.widths_dropdown')

            .iconselectmenu()

            .iconselectmenu('menuWidget')

            .addClass('ui-menu-icons');

        </script>";

        return $html;

    }

    public function makeProjColorDropdown($pId, $iframe = false)
    {

        $pathToRoot = ($iframe == true ? PATH_TO_ROOT . "statview/" : "");

        $sel = new Selector($this->db);

        $pro = $sel->getProject($pId);

        $options = $sel->getColorOptions();

        $selId = ($pro['colorShema'] != null ? $pro['colorShema'] : 0);

        $html = "<select class='colors_dropdown' name='colors_dropdown'>";

        $selected = ($selId == 0 ? " selected" : "");

        $html .= "<option value='0'" . $selected . " data-style='background-image: url(&apos;" . $pathToRoot . "_img/default_colors.png&apos;);background-size: 15px 15px;'>Default</option>";

        for ($i = 0; $i < count($options); $i++) {

            $selected = ($options[$i]['id'] == $selId ? " selected" : "");

            $html .= "<option value='" . $this->cleanOutput($options[$i]['id']) . "'

                              data-style='background-image: url(&apos;" . $this->cleanOutput($pathToRoot . $options[$i]['imagePath']) . "&apos;);background-size: 15px 15px;'

                              " . $selected . ">

                            " . $this->cleanOutput($options[$i]['shemaName']) . "

                      </option>";

        }

        $selected = ($selId == 99 ? " selected" : "");

        $html .= "<option id='custom-scheme-pick' value='99'" . $selected . " data-style='background-image: url(&apos;" . $pathToRoot . "_img/default_colors.png&apos;);background-size: 15px 15px;'>Custom...</option>";

        $html .= "</select>";

        $html .= "

        <script>

            $('.colors_dropdown')

            .iconselectmenu()

            .iconselectmenu('menuWidget')

            .addClass('ui-menu-icons');



			$('.colors_dropdown').iconselectmenu({

			  select: function(event, ui) {

				 if (ui.item.value == '99') {

				 	showCustomSchemeDialog($pId);

				 }

		  	  }

			});

        </script>";

        return $html;

    }

    public function makeCliWidthDropdown($client = null)
    {

        $sel = new Selector($this->db);

        $options = $sel->getWidthOptions();

        $selId = ($client != null ? $client['showWidth'] : 2);

        $html = "<select class='widths_dropdown' name='widths_dropdown'>";

        for ($i = 0; $i < count($options); $i++) {

            $selected = ($options[$i]['id'] == $selId ? " selected" : "");

            $html .= "<option value='" . $this->cleanOutput($options[$i]['id']) . "'" . $selected . ">" . $this->cleanOutput($options[$i]['resolutionText']) . "</option>";

        }

        $html .= "</select>";

        $html .= "

        <script>

            $('.widths_dropdown')

            .iconselectmenu()

            .iconselectmenu('menuWidget')

            .addClass('ui-menu-icons');

        </script>";

        return $html;

    }

    public function makeCliColorDropdown($client = null)
    {

        $sel = new Selector($this->db);

        $options = $sel->getColorOptions();

        $selId = ($client != null ? $client['colorShema'] : 2);

        $html = "<select class='colors_dropdown' name='colors_dropdown'>";

        for ($i = 0; $i < count($options); $i++) {

            $selected = ($options[$i]['id'] == $selId ? " selected" : "");

            $html .= "<option value='" . $this->cleanOutput($options[$i]['id']) . "'

                              data-style='background-image: url(&apos;" . $this->cleanOutput($pathToRoot . $options[$i]['imagePath']) . "&apos;);background-size: 15px 15px;'

                              " . $selected . ">

                            " . $this->cleanOutput($options[$i]['shemaName']) . "

                      </option>";

        }

        $html .= "</select>";

        $html .= "

        <script>

            $('.colors_dropdown')

            .iconselectmenu()

            .iconselectmenu('menuWidget')

            .addClass('ui-menu-icons');

        </script>";

        return $html;

    }

    private function makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $description = '')
    {

        $html = "<div class=sd4 style='width:" . $this->cleanOutput($width) . "px;text-align:center;padding:15px;'>

                  <div class=napis style='width:100%;font-size:16px;margin:20px 0 10px;'>

                    " . $this->cleanOutput($title) . "

                  </div>

                  <p style=width:100%;float:left;>" . $this->cleanOutput($description) . "</p>

                  <div class=izbira style=width:100%;margin-top:10px;margin-bottom:0;>

                    <a href=javascript:void(0)>

                    	<div id=" . $this->cleanOutput($b1Id) . "  class=shraniosn style='margin-right:10px;padding-left:0;width:125px'><img src=_img/kljukica.png alt=" . $this->cleanOutput($b1text) . " /> " . $this->cleanOutput($b1text) . "</div>

                	</a>";

        if (strlen($b2Id)) {

            $html .= "<a href=javascript:void(0)>

                        			<div id=" . $this->cleanOutput($b2Id) . "  class=zavrzir style='float:right;width:125px;'>" . $this->cleanOutput($b2text) . "</div>

                				  </a>";

        }

        $html .= "

                  </div>

                </div>

                </form>";

        return $html;

    }

    public function makeEditPopAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'project'", "'research'"), DB_WARPIT_STATVIEW);

        $width = 780;

        $sel = new Selector($this->db);

        $idQ = $this->cleanInput($_POST['qId']);

        $i = 0;

        if ($_POST['type'] == "res") {

            $title = $language['research_edit_settings'];

            $b1text = $language['save'];

            $b2text = $language['cancel'];

            $b1Id = "sEditRQA";

            $b2Id = "closeM";

            $idR = $this->cleanInput($_POST['resId']);

            $resName = $sel->getResearcheName($idR);

            $resName = str_replace(" ", "_", $resName);

            $calc = new Calculate($this->db, '_research', $resName, $idR);

            $labs = new Labels($this->db, '_research', $resName, $idR);

            $resQuestions = $sel->getResearchCalculated($resName);

            //$question = $resQuestions[$idQ]['question'];

            //$question = "asdasdasd";

        } else {

            $title = $language['project_edit_settings'];

            $b1text = $language['save'];

            $b2text = $language['cancel'];

            $b1Id = "sEditPQA";

            $b2Id = "closeM";

            $idP = $this->cleanInput($_POST['proId']);

            $projName = $sel->getProjectName($idP);

            $projName = str_replace(" ", "_", $projName);

            $calc = new Calculate($this->db, '_projects', $projName, $idP);

            $labs = new Labels($this->db, '_projects', $projName, $idP);

            $resQuestions = $sel->getResearchCalculated($projName);

            //$question = $resQuestions[$idQ]['question'];

        }

        $question = $resQuestions[$idQ]['question'];

        $qTitle = $resQuestions[$idQ]['title'];

        $qMiss = $resQuestions[$idQ]['missings'];

        $qSMiss = $resQuestions[$idQ]['missings_mean'];

        $qHAnsw = $resQuestions[$idQ]['hideAnswers'];

        //$time_int = $resQuestions[$idQ]['missings'];

        $labs->setQuestion($idQ);

        $calc->setQuestion($idQ);

        $params = $calc->getParameters();

        $freq = $calc->getFrequencies();

        $total = $calc->getTotal();

        $labels = $labs->getLabels();

        $calcHtml = "";

        if (intval($params['questionType']) != 2) {

            foreach ($labels[$idQ]['answers'] as $key => $l) {

                $i++;

                $calcHtml .= "<div class='answ_wrap'>

                                <div class='nap' style='width:auto;'>" . $this->cleanOutput($language['research_edit_settings_a']) . " " . $this->cleanOutput($i) . "</div>

                                <div class='vnos'>

                                   <input class='imp1' style='float:none;width:503px;' name='aInput_" . $this->cleanOutput($i) . "' maxlength='200' required='true' type='text' value='" . $this->cleanOutput($l) . "'>

                                   <input class='imp2' style='float:none;' name='aindex_" . $this->cleanOutput($i) . "' maxlength='5' required='true' type='text' value='" . $this->cleanOutput($key) . "' />

                                 </div>

                               </div>";

            }

            $calcHtml .= "<input class='answEditButtons' type='submit' id='add_answ' name='add_answ' onclick='return false;' maxlength='200' value='" . $this->cleanOutput($language['project_edit_settings_aA']) . "'/>

                          <input class='answEditButtons' type='submit' id='rem_answ' name='rem_answ' onclick='return false;' maxlength='200' value='" . $this->cleanOutput($language['research_edit_settings_aD']) . "'/>";

        } else {

            foreach ($labels[$idQ]['answers'] as $key1 => $a) {

                $i++;

                $calcHtml .= "<div class='answ_wrap' style='float:left;'>

                                <div class='nap' style='width:auto;'>" . $this->cleanOutput($language['research_edit_settings_a']) . " " . $this->cleanOutput($i) . ":</div>

                                <div class='vnos'>

                                	<input class='imp1' style='float:none;width:503px;' name='aInput_" . $this->cleanOutput($i) . "' maxlength='200' required='true' type='text' value='" . $this->cleanOutput($a) . "'>

                                    <input class='imp2' style='float:none;' name='aindex_" . $this->cleanOutput($i) . "' maxlength='5' required='true' type='text' value='" . $this->cleanOutput($key1) . "' />

                                </div>

                              </div>";

                $j = 0;

                $legendHtml = "<div style='font-size:16px;margin:20px 0;border-bottom: #cbcac6 solid 1px;'>" . $this->cleanOutput($language['research_edit_settings_le']) . ":</div>";

                foreach ($labels[$idQ]['legend'] as $key2 => $l) {

                    $j++;

                    $legendHtml .= "<div class='leg_wrap'>

                                       <div class='nap' style='width:auto;'>" . $this->cleanOutput($language['res_map_legend'] . " " . $j) . "</div>

                                       <div class='vnos'>

                                          <input class='imp1' style='float:none;width:503px;' name='lInput_" . $this->cleanOutput($j) . "' maxlength='200' type='text' value='" . $this->cleanOutput($l) . "' />

                                          <input class='imp2' style='float:none;' name='lindex_" . $this->cleanOutput($j) . "' maxlength='5' required='true' type='text' value='" . $this->cleanOutput($key2) . "' />

                                       </div>

                                     </div>";

                }

            }

            $calcHtml .= "<input class='answEditButtons' type='submit' id='add_answ' name='add_answ' onclick='return false;' maxlength='200' value='" . $this->cleanOutput($language['research_edit_settings_aA']) . "'/>

                          <input class='answEditButtons' type='submit' id='rem_answ' name='rem_answ' onclick='return false;' maxlength='200' value='" . $this->cleanOutput($language['research_edit_settings_aD']) . "'/>";

            $legendHtml .= "<input class='answEditButtons' type='submit' id='add_legend' name='add_legend' onclick='return false;' maxlength='200' value='" . $this->cleanOutput($language['research_edit_settings_al']) . "'/>

                            <input class='answEditButtons' type='submit' id='rem_legend' name='rem_legend' onclick='return false;' maxlength='200' value='" . $this->cleanOutput($language['research_edit_settings_dl']) . "'/>";

        }

        $html = "<div class=sd4 style='width:" . $this->cleanOutput(($width + 15)) . "px;padding:15px;height:auto;'>

            <div class=napis style='width:" . $this->cleanOutput($width) . "px;font-size:16px;text-align:center;'>

            " . $this->cleanOutput($title) . "

            </div>

            <form id=editForm name=editForm>

            <div class='sd5 proj-props' style='width:770px; height:auto; overflow-y: auto;'>

                 <div class='nap'>" . $this->cleanOutput($language['missings']) . ": </div>

                 <div class='vnos'><input name='questmissings' type='text' maxlength='200' pattern='^[0-9, ]+$' value='" . $this->cleanOutput($qMiss) . "' /></div>

                 <!--<div class='nap' style='clear:both'>" . $this->cleanOutput($language['miss_mean_value']) . ":</div>

                 <div class='vnos'><input name='questmeanmissings' type='text' maxlength='200' value='" . $this->cleanOutput($qSMiss) . "' /></div>-->

                 <div class='nap' style='clear:both'>" . $this->cleanOutput($language['project_edit_settings_hi']) . ": </div>

                 <div class='vnos'><input name='hideansw' type='text' maxlength='200' value='" . $this->cleanOutput($qHAnsw) . "' /></div>

                 <div class='nap' style='clear:both'>" . $this->cleanOutput($language['project_edit_settings_q']) . ": </div>

                 <div class='vnos'><input name='questname' type='text' required='true' maxlength='200' value='" . $this->cleanOutput($question) . "' required='true'/></div>

                 <div class='nap' style='clear:both'>" . $this->cleanOutput($language['project_edit_settings_ti']) . ": </div>

                 <div class='vnos'><input name='questtitle' type='text' maxlength='200' value='" . $this->cleanOutput($qTitle) . "' /></div>

            </div>



            <div class='sd5' style='width:770px;max-height:300px;overflow:auto;'>

                <div style='font-size:16px;margin-bottom:5px;text-align:center;'>" . $this->cleanOutput($language['research_edit_settings_as']) . "</div>

                 " . $calcHtml . "

                 " . $legendHtml . "

            </div>



            <input type=hidden name=qId value=" . $this->cleanOutput($idQ) . ">

            <div class=izbira style=width:775px;margin-top:10px;margin-bottom:0;>

                <button type='submit' form='editForm' class='shraniosn'><img src=_img/kljukica.png alt=" . $this->cleanOutput($b1text) . " />" . $this->cleanOutput($b1text) . "</button>";

        if (strlen($b2Id)) {

            $html .= "<a href=javascript:void(0)><div id=" . $this->cleanOutput($b2Id) . "  class=zavrzir>" . $this->cleanOutput($b2text) . "</div></a>";

        }

        $html .= "

            </div>

            </form>

        </div>

        </form>";

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    /*

    public function getRemovePDialogAction() {

    $html = '';

    $width = 300;

    $text = "Ali želite odstraniti raziskavo iz projekta?";

    $b1text = "Da";

    $b2text = "Ne";

    $b1Id = "remRToP";

    $b2Id = "closeM";

    $html = $this -> makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

    return '{"error":false,"script":false,"returnval":true,"response":"' . $this -> cleanHTML($html) . '"}';

    }

    public function getAddPDialogAction() {

    $html = '';

    $width = 300;

    $text = "Ali želite dodati izbrano raziskavo v projekt?";

    $b1text = "Da";

    $b2text = "Ne";

    $b1Id = "addRToP";

    $b2Id = "closeM";

    $html = $this -> makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

    return '{"error":false,"script":false,"returnval":true,"response":"' . $this -> cleanHTML($html) . '"}';

    }*/

    public function getCancelRDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['research_cancel'];

        $b1text = $language['yes'];

        $b2text = $language['no'];

        $b1Id = "cSaveR";

        $b2Id = "closeM";

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getSaveRDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['research_save'];

        $b1text = $language['research_save_btn'];

        $b2text = $language['research_cancel_btn'];

        $b1Id = "saveR";

        $b2Id = "closeM";

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getDeleteRDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['research_del'];

        $b1text = $language['yes'];

        $b2text = $language['no'];

        $b1Id = "deleteResOK";

        $b2Id = "closeM";

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getCancelDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['discart'];

        $b1text = $language['yes'];

        $b2text = $language['no'];

        $b1Id = "cSaveP";

        $b2Id = "closeM";

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getSavePDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['save_for_client_di'];

        $b1text = $language['save'];

        $b2text = $language['cancel'];

        $b1Id = "saveP";

        $b2Id = "closeM";

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getSaveEditPDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['save_as_draft_di'];

        $b1text = $language['save'];

        $b2text = $language['cancel'];

        $b1Id = "savePEdit";

        $b2Id = "closeM";

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getDelPDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'project', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['delete_proj_di'];

        $b1text = $language['delete'];

        $b2text = $language['cancel'];

        $b1Id = "delP";

        $b2Id = "closeM";

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getClientHasUsersDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'client', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['client_users'];

        $desc = $language['client'] . ' ' . $this->formParameters['nar_ime'] . ' ' . $language['client_users_desc'];

        $b1text = $language['ok'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getImportOkAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['research_import_successfu'];

        $b1text = $language['ok'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getImportErrorAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['research_exist'];

        $b1text = $language['ok'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getSelectProjAlertAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $text = $language['select_project'];

        $b1text = $language['ok'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $text, $b1text, $b2text, $b1Id, $b2Id);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function checkEmailAction()
    {

        $email = $this->cleanInput($_POST['email']);

        $action = $this->cleanInput($_POST['checkAction']);

        if ($action == "update") {

            $id = $this->cleanInput($_POST['userId']);

            $sql = "SELECT COUNT(id) AS num, firstname, surname FROM _user WHERE email = '" . $email . "' AND id != " . $id;

        } else {

            $sql = "SELECT COUNT(id) AS num, firstname, surname FROM _user WHERE email = '" . $email . "'";

        }

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($this->db->NumRows($result)) {

            $row = $this->db->fetchAssoc($result);

            if ($row['num'] == "0") {

                return '{"error":false,"script":false,"returnval":true,"response":"ok"}';

            } else {

                $json = array('res' => 'duplicate_email', 'msg' => $row['firstname'] . ' ' . $row['surname']);

                $json = json_encode($json);

                return '{"error":false,"script":false,"returnval":true,"response":' . $json . '}';

            }

        }

    }

    public function checkUsernameAction()
    {

        $username = $this->cleanInput($_POST['username']);

        $action = $this->cleanInput($_POST['checkAction']);

        if ($action == "update") {

            $id = $this->cleanInput($_POST['userId']);

            $sql = "SELECT COUNT(id) AS num, firstname, surname FROM _user WHERE username = '" . $username . "' AND id != " . $id;

        } else {

            $sql = "SELECT COUNT(id) AS num, firstname, surname FROM _user WHERE username = '" . $username . "'";

        }

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($this->db->NumRows($result)) {

            $row = $this->db->fetchAssoc($result);

            if ($row['num'] == "0") {

                return '{"error":false,"script":false,"returnval":true,"response":"ok"}';

            } else {

                return '{"error":false,"script":false,"returnval":true,"response":"duplicated"}';

            }

        }

    }

    public function getSaveUserDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['input_err_msg'];

        $b1text = $language['profile_ok_btn'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $desc = '';

        if (strlen($this->formParameters['nar_ime']) == 0) {

            $desc = $language['urs_alertName11'];

        } else

        if (strlen($this->formParameters['nar_email']) == 0) {

            $desc = $language['urs_alertName12'];

        }

        /*else

        if(!(filter_var($this->formParameters['nar_email'], FILTER_VALIDATE_EMAIL) && preg_match('/@.+\./', $this->formParameters['nar_email'])))

        $desc = 'Prosim vnesite veljaven e-naslov uporabnika!';*/

        else

        if ($this->formParameters['sel_naroc'] == 0 && $this->formParameters['sel_profil'] != 1) {

            $desc = $language['urs_alertName13'];

        } else

        if ($this->formParameters['sel_naroc'] != 0 && $this->formParameters['sel_profil'] == 1) {

            $desc = $language['urs_alertName14'];

        } else

        if ($this->formParameters['sel_profil'] == 0) {

            $desc = $language['urs_alertName15'];

        } else

        if (strlen($this->formParameters['nar_pass']) > 0) {

            if ($this->formParameters['nar_pass'] != $this->formParameters['nar_passp']) {

                $desc = $language['urs_alertName16'];

            }

        } else

        if (strlen($this->formParameters['nar_pass']) == 0) {

            $desc = $language['urs_alertName17'];

        }

        if (strlen($desc) == 0) {

            return '{"error":false,"script":false,"returnval":true,"response":"ok"}';

        }

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getUpdateUserDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['input_err_msg'];

        $b1text = $language['profile_ok_btn'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $desc = '';

        if (strlen($this->formParameters['nar_ime']) == 0) {

            $desc = $language['urs_alertName11'];

        } else

        if (strlen($this->formParameters['nar_email']) == 0) {

            $desc = $language['urs_alertName12'];

        }

        /*else

        if(!(filter_var($this->formParameters['nar_email'], FILTER_VALIDATE_EMAIL) && preg_match('/@.+\./', $this->formParameters['nar_email'])))

        $desc = 'Prosim vnesite veljaven e-naslov uporabnika!';*/

        else

        if ($this->formParameters['sel_naroc'] == 0 && $this->formParameters['sel_profil'] != 1) {

            $desc = $language['urs_alertName13'];

        } else

        if ($this->formParameters['sel_naroc'] != 0 && $this->formParameters['sel_profil'] == 1) {

            $desc = $language['urs_alertName14'];

        } else

        if (strlen($this->formParameters['nar_pass']) > 0) {

            if ($this->formParameters['nar_pass'] != $this->formParameters['nar_passp']) {

                $desc = $language['urs_alertName16'];

            }

        }

        $res = $this->checkMail($this->formParameters['nar_email'], $this->formParameters['userId']);

        if ($res !== true) {

            $desc = $res;

        }

        if (strlen($desc) == 0) {

            return '{"error":false,"script":false,"returnval":true,"response":"ok"}';

        }

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    private function checkMail($email, $userId)
    {

        $sql = "SELECT email, Firstname, Surname FROM _user WHERE email='$email' AND id <> $userId";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        if ($this->db->NumRows($result)) {

            $row = $this->db->fetchAssoc($result);

            return "Uporabnik z e-naslovom $email že obstaja! Uporablja ga " . $row['Firstname'] . " " . $row['Surname'] . "";

        } else {

            return true;

        }

    }

    public function getDeleteClientDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'clients', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['delete_cli_title'];

        $desc = $language['delete_cli_desc'] . ' ' . $this->formParameters['nar_ime'] . '?';

        $b1text = $language['delete_cli_btn1'];

        $b2text = $language['delete_cli_btn2'];

        $b1Id = 'deleteClientOkButton';

        $b2Id = 'closeM';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getSaveClientDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', array("'users'", "'clients'"), DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['input_err_msg'];

        $desc = '';

        $b1text = $language['profile_ok_btn'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $desc = '';

        if (strlen($this->formParameters['nar_ime']) == 0) {

            $desc = $language['subscription_alertClientN'];

        } else

        if (strlen($this->formParameters['nar_polnoime']) == 0) {

            $desc = $language['client_err_longname'];

        }

        if (strlen($desc) == 0) {

            return '{"error":false,"script":false,"returnval":true,"response":"ok"}';

        }

        return '{"error":false,"script":false,"returnval":true,"response":"' . $desc . '"}';

    }

    public function getDeleteUserDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 320;

        $title = $language['delete_usr_title'];

        $desc = $language['delete_usr_desc'] . ' ' . $this->formParameters['nar_ime'] . '?';

        $b1text = $language['delete_usr_btn'];

        $b2text = $language['cancel_usr_btn'];

        $b1Id = 'deleteUserOkButton';

        $b2Id = 'closeM';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getDeleteProfileDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'default', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 320;

        $title = $language['alert_msg'];

        $desc = $language['delete_profile_msg'];

        $b1text = $language['delete_btn'];

        $b2text = $language['cancel_btn'];

        $b1Id = 'deleteProfileButtonOK';

        $b2Id = 'closeNonM';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getPreviewWidgetDialogAction()
    {

        $content = $this->cleanInput($_POST['cont']);

        $html = "<div class=sd4 style='width:auto;height:auto;text-align:center;padding:15px;'>

                  <div class=napis style='margin:0 -50px -50px -30px;width:775px;height:auto'>

                    " . $content . "

                  </div>

                </div>";

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getDeleteWidgetDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'widgets', DB_WARPIT_STATVIEW);

        $wTitle = (trim($_POST['wTitle']) != "" ? trim($this->cleanInput($_POST['wTitle'])) : $language['unnamed_widget']);

        $html = '';

        $width = 330;

        $title = $language['del_alert_msg'];

        $desc = $language['widget_delete_msg'] . " " . $wTitle . "?";

        $b1text = $language['del_btn_confirm'];

        $b2text = $language['del_btn_cancel'];

        $b1Id = 'deleteWidgetButtonOK';

        $b2Id = 'closeNonM';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    /*

    public function getSaveAddPrAction() {

    $html = '';

    $width = 300;

    $title = 'Dodajanje projekta';

    $desc = 'Želite ustvariti nov projekt?';

    $b1text = "Potrdi";

    $b2text = 'Prekliči';

    $b1Id = 'addPrOk';

    $b2Id = 'closeM';

    $html = $this -> makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

    return '{"error":false,"script":false,"returnval":true,"response":"' . $this -> cleanHTML($html) . '"}';

    }

     */

    public function getUsersInProfileDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['usr_profile_alert1'];

        $desc = $language['wish_to_del'] . ' ' . $this->cleanInput($_POST['numUsers']) . ' ' . $language['num_of_users'];

        $b1text = $language['profile_ok_btn'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getNoProfileSelectedDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['no_profile_selected'];

        $desc = $language['select_profile_msg'];

        $b1text = $language['profile_ok_btn'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getProfileNameExistsDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['permission_profile'];

        $desc = $language['profile_name'] . ' ' . $this->cleanInput($_POST['profile']) . ' ' . $language['allready_exists'];

        $b1text = $language['profile_ok_btn'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getProfileSavedDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['profile'] . ' ' . $this->cleanInput($_POST['profile']) . ' ' . $language['has_been_saved'];

        $desc = '';

        $b1text = "V redu";

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getDefinedProfileExistsDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'users', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['profile'] . ' ' . $this->cleanInput($_POST['profile']);

        $desc = $language['profile_allready_ex'];

        $b1text = $language['profile_ok_btn'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getCancelWeightsDialogAction()
    {

        $language = configLoader::loadLanguage(1, 'language', 'default_admin', 'research', DB_WARPIT_STATVIEW);

        $html = '';

        $width = 300;

        $title = $language['research_weight_alert1'];

        $desc = $language['research_weight_alert2'];

        $b1text = $language['ok'];

        $b2text = '';

        $b1Id = 'closeM';

        $b2Id = '';

        $html = $this->makeDialog($width, $title, $b1text, $b2text, $b1Id, $b2Id, $desc);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changeProjQuestionsColorAction()
    {

        $html = '';

        $sel = new Selector($this->db);

        $projId = $_SESSION['project'];

        $html = $this->makeProjColorDropdown($projId);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changeProjQuestionsWidthAction()
    {

        $html = '';

        $sel = new Selector($this->db);

        $projId = $_SESSION['project'];

        $html = $this->makeProjWidthDropdown($projId);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changeProjQuestionAction()
    {

        $sel = new Selector($this->db);

        $html = '';

        //$cliId = $_SESSION['client'];

        //$projects = $this -> getClientProjects($cliId);

        //$keys = array_keys($projects);

        //$selProjId = (isset($_SESSION['project'])) ? $_SESSION['project'] : $keys[0];

        $projQuestions = $sel->getResearchCalculated($projects[$selProjId]['name']);

        if ($projQuestions) {

            $qkeys = array_keys($projQuestions);

            $selQId = ($_POST['qId'] != 0) ? $this->cleanInput($_POST['qId']) : $qkeys[0];

            $html = $this->makeProjQuestion($projQuestions, $selQId, $selProjId);

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changeQuestionProjClientAction()
    {

        $pId = $_SESSION['project'];

        $sel = new Selector($this->db);

        $html = '';

        //$cliId = $_SESSION['client'];

        $project = $sel->getProject($pId);

        $client = $sel->getProjectClient($pId);

        $projQuestions = $sel->getResearchCalculated($project['projectName']);

        if ($projQuestions) {

            $qkeys = array_keys($projQuestions);

            $selQId = ($_POST['qId'] != 0) ? $this->cleanInput($_POST['qId']) : $qkeys[0];

            $html = $this->makeClientProjQuestion($projQuestions, $this->cleanInput($_POST['qId']), $pId);

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changeClientQuestionAction()
    {

        $sel = new Selector($this->db);

        $html = '';

        $cliId = $_SESSION['client'];

        $projects = $this->getClientReadyProjects($cliId);

        $keys = array_keys($projects);

        $selProjId = (isset($_SESSION['project'])) ? $_SESSION['project'] : $keys[0];

        $projQuestions = $sel->getResearchCalculated($projects[$selProjId]['name']);

        if ($projQuestions) {

            $qkeys = array_keys($projQuestions);

            $selQId = ($_POST['qId']) ? $this->cleanInput($_POST['qId']) : $qkeys[0];

            $html = $this->makeClientProjQuestion($projQuestions, $selQId, $selProjId);

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

        //return '{"error":false,"script":false,"response":""}';

    }

    public function changeProjQuestionsDropdownAction()
    {

        $sel = new Selector($this->db);

        $html = '';

        $cliId = $_SESSION['client'];

        $projects = $this->getClientProjects($cliId);

        $keys = array_keys($projects);

        $selProjId = (isset($_SESSION['project'])) ? $_SESSION['project'] : $keys[0];

        $projQuestions = $sel->getResearchCalculated($projects[$selProjId]['name']);

        if ($projQuestions) {

            $html = $this->makeResQuestionDropdown($projQuestions);

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changeQuestionResAction()
    {

        $sel = new Selector($this->db);

        $resId = $_SESSION['research'];

        $res = $sel->getResearch($resId);

        $resQuestions = $sel->getResearchCalculated($res['project']);

        $html = $this->makeResQuestion($resQuestions, $this->cleanInput($_POST['qId']), $resId);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function changeQuestionProjAction()
    {

        $html = '';

        $sel = new Selector($this->db);

        $projId = $_SESSION['project'];

        $pro = $sel->getProject($projId);

        $projQuestions = $sel->getResearchCalculated($pro['projectName']);

        $html = $this->makeProjQuestion($projQuestions, $this->cleanInput($_POST['qId']), $projId);

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($html) . '"}';

    }

    public function getProjNameAction()
    {

        $projName = $this->getProjectLongName($this->cleanInput($_POST['projId']));

        return '{"error":false,"script":false,"returnval":true,"response":"' . $projName . '"}';

        return '{"error":false,"script":false,"returnval":true,"response":"' . $projName . '"}';

    }

    public function getQuestNameAction()
    {

        $sel = new Selector($this->db);

        $pId = $_SESSION['project'];

        $project = $sel->getProject($pId);

        $projQuestions = $sel->getResearchCalculated($project['projectName']);

        return '{"error":false,"script":false,"returnval":true,"response":"' . $this->cleanOutput($projQuestions[$_POST['qId']]['question']) . '"}';

    }

    public function colorSelResAction()
    {

        $resId = $_SESSION['research'];

        $sql = "UPDATE _research SET colorShema=" . $this->cleanInput($_POST['cId']) . " WHERE id=" . $resId;

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function widthSelResAction()
    {

        $resId = $_SESSION['research'];

        $sql = "UPDATE _research SET showWidth=" . $this->cleanInput($_POST['wId']) . " WHERE id=" . $resId;

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function colorSelProjAction()
    {

        $projId = $_SESSION['project'];

        $sql = "UPDATE _projects SET colorShema=" . $this->cleanInput($_POST['cId']) . ", lastChangeTime=" . time() . " WHERE id=" . $projId;

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function widthSelProjAction()
    {

        $projId = $_SESSION['project'];

        $sql = "UPDATE _projects SET showWidth=" . $this->cleanInput($_POST['wId']) . ", lastChangeTime=" . time() . " WHERE id=" . $projId;

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function showClientQuestionAction()
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($this->cleanInput($_POST['proId']));

        $projName = str_replace(" ", "_", $projName);

        $sql = "UPDATE " . $projName . "___calculated ";

        $sql .= " SET hideQuestion=0 ";

        $sql .= " WHERE questionName = '" . $this->cleanInput($_POST['qId']) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":"' . $this->cleanHTML($sql) . '"}';

    }

    public function hideClientQuestionAction()
    {

        $sel = new Selector($this->db);

        $projName = $sel->getProjectName($this->cleanInput($_POST['proId']));

        $projName = str_replace(" ", "_", $projName);

        $sql = "UPDATE " . $projName . "___calculated ";

        $sql .= " SET hideQuestion=1 ";

        $sql .= " WHERE questionName = '" . $this->cleanInput($_POST['qId']) . "'";

        if (!$result = $this->db->SQLexecute($sql)) {

            return $this->db->JsonError();

        }

        return '{"error":false,"script":false,"response":""}';

    }

    public function setResSessionAction()
    {

        $_SESSION['research'] = $this->cleanInput($_POST['researchId']);

        return '{"error":false,"script":false,"response":""}';

    }

    public function setClientSessionAction()
    {

        $_SESSION['client'] = $this->cleanInput($_POST['clientId']);

        return '{"error":false,"script":false,"response":""}';

    }

    public function setProjectSessionAction()
    {

        $_SESSION['project'] = $this->cleanInput($_POST['projId']);

        return '{"error":false,"script":false,"response":""}';

    }

    public function getResSessionAction()
    {

        $returnVal = (isset($_SESSION['research'])) ? 'true' : 'false';

        return '{"error":false,"script":false,"returnval":true,"response":' . $returnVal . '}';

    }

    public function getCliSessionAction()
    {

        $returnVal = (isset($_SESSION['client'])) ? 'true' : 'false';

        return '{"error":false,"script":false,"returnval":true,"response":' . $returnVal . '}';

    }

    public function checkResProjAction()
    {

        $sql = "SELECT DISTINCT _projects_by_research.* FROM _projects_by_research, _projects WHERE _projects_by_research.id_research=" . $this->cleanInput($_POST['resId']);

        $sql .= " AND _projects.id = _projects_by_research.id_project AND _projects.deleted = 0";

        if ($result = $this->db->SQLexecute($sql)) {

            $returnVal = ($this->db->NumRows($result) > 0) ? "true" : "false";

        } else {

            $returnVal = "false";

        }

        return '{"error":false,"script":false,"returnval":true,"response":' . $returnVal . '}';

    }

    public function checkShortAction()
    {

        $sql = "SELECT * FROM _projects where projectName='" . $this->cleanInput($_POST['short']) . "'";

        if ($result = $this->db->SQLexecute($sql)) {

            $returnVal = ($this->db->NumRows($result) > 0) ? "true" : "false";

        } else {

            $returnVal = "false";

        }

        return '{"error":false,"script":false,"returnval":true,"response":' . $returnVal . '}';

    }

    protected function cleanHTML($str)
    {

        $str = str_replace(array("\r\n", "\r", "\n", "\t"), "", $str);

        return $str;

    }

    public function debug_view($what)
    {

        $a = '<pre>';

        if (is_array($what)) {

            $a .= print_r($what);

        } else {

            var_dump($what);

        }

        $a .= '</pre>';

        return $a;

    }

}
