<?php 
include_once ("_dirinfo.php");   
include_once(PATH_TO_ROOT."statview/_class/class.selector.php");
include_once(PATH_TO_ROOT."statview/_class/class.projectgenerator.php");
include_once(PATH_TO_ROOT.'statview/_class/class_calculate.php');
include_once(PATH_TO_ROOT.'statview/_class/class_labels.php');

class ExcelData
{
       private $idProject;
       
       private $idQuestion;
       
       private $db;
       
       private $returnArray;
       
       private $question;
       
       private $projName;
           
       private $table;
       
       private $idCross;
       
       private $total;
       
       private $params;
       
       private $sel;
       
       public function __construct($db, $idProject, $idQuestion, $table, $idCross = "")
       {
           $this->idProject = $idProject;
           $this->idQuestion = $idQuestion;
           $this->db = $db;
           $this->idCross = $idCross;
           $this->table = $table;
       }
       
       public function getProjName()
       {
           if(isset($this->projName)) return;
           $this->sel = new Selector($this->db);
            if($this->table == '_projects')
                $this->projName = $this->sel->getProjectName($this->idProject);
            else 
                $this->projName = $this->sel->getResearcheName($this->idProject);
         
            $this->projName = str_replace(" ", "_", $this->projName);
            return $this->projName;
       }
       
       
       private function loadData($time_int)
       {
            $calc = new Calculate($this->db, $this->table, $this->projName,$this->idProject);
            $labs = new Labels($this->db, $this->table, $this->projName,$this->idProject);
            $labs->setQuestion($this->idQuestion);
            $calc->setQuestion($this->idQuestion);
            $params = $calc->getParameters();   

            if($time_int == 'range')
            {
                $rangeArray = $this->sel->getRangedSliderOptions($this->idProject, $this->idQuestion);
                
                $filter = "research_id BETWEEN " . $rangeArray[0] . " AND " . $rangeArray[1]; 
            }
            else if($time_int == 'months')
            {
                $rangeArray = $this->sel->getSliderOptions($this->idProject, $this->idQuestion);
                
                $filter = "research_id IN(" . implode(',', $rangeArray) . ") "; 
            }
            else{
                $filter = null;
            }
            
            $freq = $calc->getFrequencies(null, $filter);
            $this->total = $calc->getTotal();
            $labels = $labs->getLabels();
            
            $this->returnArray = array();
            $tmpArray = array();
            $this->params = $params;
            $i = 0;
            $this->question =  $labels[$this->idQuestion]['question'];
            foreach(explode(',', $params['hideAnswers']) as $hiddenAnswer)
            {
                unset($labels[$this->idQuestion]['answers'][$hiddenAnswer]);
            }
           
           //preverimo če je več vprašanj
           if(intval($params['questionType']) != 2)
           {
               foreach ($labels[$this->idQuestion]['answers'] as $key => $l) 
                    $tmpArray[$l] = isset($freq[$this->idQuestion][$key])?$freq[$this->idQuestion][$key]:0;
               $this->returnArray[$labels[$this->idQuestion]['question'] ] = $tmpArray;
               
           }
           else 
           {
               foreach ($labels[$this->idQuestion]['answers'] as $key => $a)
               {
                    $i++;
                    $j=0;
                    foreach ($labels[$this->idQuestion]['legend'] as $key2 => $l) 
                    {
                        $j++;
                        $proc = (isset($freq[$this->idQuestion][$this->idQuestion."_".$i][$j]) && isset($this->total[$this->idQuestion][$this->idQuestion."_".$i]))?($freq[$this->idQuestion][$this->idQuestion."_".$i][$j]/$this->total[$this->idQuestion][$this->idQuestion."_".$i])*100:0;
                        $tmpArray[$l] = $proc;
                    }
                    $this->returnArray[$a] = $tmpArray;
               }
           }
           
       }

       private function loadCrossData($time_int)
       {
           $calc = new Calculate($this->db, $this->table, $this->projName,$this->idProject);
           $calc->setQuestion($this->idQuestion);
           
           
           if($time_int == 'range')
            {
                $rangeArray = $this->sel->getRangedSliderOptions($this->idProject, $this->idQuestion);
                $this->returnArray =  $calc->getCrosstabs($this->idCross, $rangeArray[0], $rangeArray[1]);
                
            }
            else if($time_int == 'months')
            {
                $rangeArray = $this->sel->getSliderOptions($this->idProject, $this->idQuestion);
                $this->returnArray =  $calc->getCrosstabs($this->idCross, $rangeArray);
            }
            else{
                $this->returnArray =  $calc->getCrosstabs($this->idCross);
            }
          /* print "Class Excel<pre>";
           print_r($this->returnArray);
           print "</pre>"; */
       }
       
       public function getData($time_int)
       {
           if(!isset($this->returnArray)) 
           {
               $this->getProjName();
               if(strlen($this->idCross) > 0)
                    $this->loadCrossData($time_int);
               else
                   $this->loadData($time_int);
           }
           return $this->returnArray;
       }
       
       public function getQuestionName()
       {
           if(!isset($this->question))
           {
               $this->loadData();
           }
           $name = $this->idQuestion;
           if(strlen($this->idCross)> 0)
                $name .= "_" . $this->idCross;
           return $name;
       }
       
       public function getTotal()
       {
           if(!isset($this->question))
           {
               $this->loadData();
           }
           
           return $this->total;
       }
       
       public function getProjectName()
       {
           return $this->projName;
       }
       
       public function getParams()
       {
           return $this->params;
       }
       
}



?>