<?php
/**
 * Created by PhpStorm.
 * User: Jure
 * Date: 29.4.2014
 * Time: 14:48
 */

class NfieldSurveyDataService implements INfieldSurveyDataService,INfieldConnectionClientObject {


    private $client = null;

    public function getClient()
    {
        return $this->client;
    }

    public function setClient(INfieldHttpClient $client)
    {
        $this->client = $client;
    }

    function post(SurveyDownloadDataRequest $surveyDownloadDataRequest)
    {
        return $this->initializeNfieldConnection()->post($this->surveyDataApi().$surveyDownloadDataRequest->getSurveyId().'/Data', $surveyDownloadDataRequest);
    }

    private function surveyDataApi()
    {

        //Uri must get from connection client
        return 'https://api.nfieldmr.com/v1' . '/Surveys/';
    }

    public function initializeNfieldConnection()
    {
        $this->client = $this->connectionClient();
        return $this->client;
    }


    public function connectionClient()
    {

        $this->client = new NFieldHttpClient('https://api.nfieldmr.com/v1');
        return $this->client;


    }
}