<?php
class Calculator
{
    protected $mainCategory;
    protected $recordsResult;

    protected $categoryMaxTotals;
    protected $categoryRecordTotals;

    function __construct($mainCategory)
    {
        $this->mainCategory = $mainCategory;
        $categoryMaxTotals = Array();
    }

    public function getStructure()
    {
        return $this->mainCategory;
    }

    public function getRecordsResult()
    {
        return $this->recordsResult;
    }

    public function questionMaxTotal($question)
    {
        return intval($question->getMaxAnswerValue());
    }

    public function categoryMaxTotal($id)
    {
        //if(isset($this->categoryMaxTotals["id"])) return $this->categoryMaxTotals["id"];

        $category = $this->mainCategory->getCategoryRecursive($id);
        $maxTotal = 0;
        if($category->hasCategories())
        {
            foreach ($category->getCategories() as $subcategory)
            {
                $val = $this->categoryMaxTotal($subcategory->getId());
                $maxTotal += $val;
            }
        }

        if($category->hasQuestions())
        {
            foreach ($category->getQuestions() as $question)
            {
                $val = $this->questionMaxTotal($question);
                $maxTotal += $val;
            }
        }


        //$this->categoryMaxTotals["id"] = intval($maxTotal);
        return $maxTotal;
    }

    public function categoryRecordTotal($id, $record)
    {
        $category = $this->mainCategory->getCategoryRecursive($id);
        $categoryRecordsSum = 0;

        if($category->hasCategories())
        {
            foreach ($category->getCategories() as $subCategory)
            {
                $categoryRecordsSum += $this->categoryRecordTotal($subCategory->getId(), $record);
            }
        }

        if($category->hasQuestions())
        {
            foreach ($category->getQuestions() as $question)
            {
                $categoryRecordsSum += $this->questionRecordTotal($question, $record);
            }
        }

        return $categoryRecordsSum;
    }

    public function categoryRecordTotalProcent($id, $record)
    {
        return max ( (( $this->categoryRecordTotal($id, $record) / $this->categoryMaxTotal($id) ) * 100), 0);
    }

    public function questionRecordTotal($question, $record)
    {
        $questionRecordSum = 0;
        if($question->getAnswersDatabaseName() == null)
            return 0;

        foreach ($question->getAnswersDatabaseName() as $columnName)
        {
            $questionRecordSum += $record[$columnName];
        }
        return $questionRecordSum;
    }

    public function questionRecordTotalProcent($question, $record)
    {
        if($this->questionMaxTotal($question) == 0) return 0;

        return max ( (( $this->questionRecordTotal($question, $record) / $this->questionMaxTotal($question) ) * 100), 0);
    }

    public function recordTotal($record)
    {
        return $this->recordTotalHelper($this->mainCategory, $record);
    }

    protected function recordTotalHelper($category, $record)
    {
        $categoryRecordsSum = 0;
        if($category->hasCategories())
        {
            foreach ($category->getCategories() as $subCategory)
            {
                $categoryRecordsSum += $this->categoryRecordTotal($subCategory->getId(), $record);
            }
        }
        return $categoryRecordsSum;
    }

    public function maxTotal()
    {
        return $this->maxTotalHelper($this->mainCategory);
    }

    protected function maxTotalHelper($category)
    {
        //$category = $this->mainCategory->getCategoryRecursive($id);

        $maxTotal = 0;
        if($category->hasCategories())
        {
            foreach ($category->getCategories() as $subcategory)
            {
                $maxTotal += $this->categoryMaxTotal($subcategory->getId());
            }
        }
        return $maxTotal;
    }

    public function recordTotalProcent($record)
    {
        return (( $this->recordTotal($record) / $this->maxTotal() ) * 100);
    }

    public function categoryRecordsTotal($id)
    {
        $category = $this->mainCategory->getCategoryRecursive($id);
        $categoryRecordsSum = 0;

        if($category->hasCategories())
        {
            foreach ($category->getCategories() as $subCategory)
            {
                $categoryRecordsSum += $this->categoryRecordsTotal($subCategory->getId());
            }
        }

        if($category->hasQuestions())
        {
            foreach ($category->getQuestions() as $question)
            {
                $categoryRecordsSum += $this->questionRecordsTotal($question);
            }
        }

        return $categoryRecordsSum;
    }

    protected function questionRecordsTotal($question)
    {
        $questionRecordsSum = 0;
        foreach ($this->recordsResult as $recResult)
        {
            $questionRecordsSum += $this->questionRecordTotal($question, $recResult);
        }
        return $questionRecordsSum;
    }


    public function calculateRecords($records)
    {
        foreach ($records as $rec)
        {
            $this->recordsResult[$rec["id"]] = $this->calculateRecord($rec);
        }
    }


    protected function calculateRecord($record)
    {
        $recordResult = Array();
        foreach ($record as $columnName => $value)
        {
            $legendId = explode("_", $columnName)[1];


            $question = $this->mainCategory->getQuestionRecursive($columnName);
            if(is_null($question)){continue;}

            if(!array_key_exists($columnName, $recordResult))
            {
                $recordResult[$columnName] = 0;
            }
            $recordResult[$columnName] += $question->getAnswerScalarValue($value, $legendId);
        }

        return $recordResult;
    }

}

class UltimativeCalculator extends Calculator
{
    protected $ulitimateiveScore;
    public function __construct($mainCategory)
    {
        parent::__construct($mainCategory);
        $this->ulitimateiveScores = null;
    }

    public function ultimativeScore()
    {
        if(!is_null($this->ulitimateiveScore))
        {
            return $this->ulitimateiveScore;
        }

        $procentSum = 0;
        foreach ($this->recordsResult as $rec)
        {
            $procentSum += $this->recordTotalProcent($rec);
        }

        $this->ulitimateiveScore = ($procentSum / count($this->recordsResult));
        return $this->ulitimateiveScore;
    }

    public function categoryUltimativeScore($id)
    {
        $category = $this->mainCategory->getCategory($id);

        $procentSum = 0;
        foreach ($this->recordsResult as $rec)
        {
            $procentSum += $this->categoryRecordTotalProcent($id, $rec);
        }
        return ($procentSum / count($this->recordsResult));
    }
}

class GroupCalculator extends Calculator
{
    private $groups;

    public function __construct($mainCategory)
    {
        parent::__construct($mainCategory);
    }

    public function setGroups($groups)
    {
        $this->groups = $groups;
    }

    public function getGroups()
    {
        return $this->groups;
    }

    public function groupScore($groupId)
    {
        $group = $this->groups[$groupId]["ids"];
        $procentSum = 0;
        foreach ($group as $idRecord)
        {
            $record = $this->recordsResult[$idRecord];
            $procentSum += $this->recordTotalProcent($record);
        }
        return ($procentSum / count( $group ));
    }

    public function categroyGroupScore($id, $groupId)
    {
        $group = $this->groups[$groupId]["ids"];
        $procentSum = 0;
        foreach ($group as $idRecord)
        {
            $record = $this->recordsResult[$idRecord];
            $procentSum += $this->categoryRecordTotalProcent($id, $record);
        }
        return ($procentSum / count($group));
    }

    public function questionGroupScore($question, $groupId)
    {
        $group = $this->groups[$groupId]["ids"];
        $procentSum = 0;
        foreach ($group as $idRecord)
        {
            $record = $this->recordsResult[$idRecord];
            $procentSum += $this->questionRecordTotalProcent($question, $record);
        }
        return ($procentSum / count($group));
    }
}

class PositiveNegativeCalculator extends Calculator
{

    public function __construct($mainCategory)
    {
        parent::__construct($mainCategory);
    }

    public function categoryPositiveNegativeRecordTotal($id, $record, $isPositive = TRUE)
    {
        $category = $this->mainCategory->getCategoryRecursive($id);
        $categoryRecordSum = 0;

        if($category->hasCategories())
        {
            foreach ($category->getCategories() as $subCategory)
            {
                $categoryRecordSum += $this->categoryPositiveNegativeRecordTotal($subCategory->getId(), $record, $isPositive);
            }
        }

        if($category->hasQuestions())
        {
            foreach ($category->getQuestions() as $question)
            {
                $categoryRecordSum += $this->questionPositiveNegativeRecordTotal($question, $record, $isPositive);
            }
        }

        return $categoryRecordSum;
    }

    public function categoryPositiveNegativeTotal($id, $record)
    {
        $categorySum = 0;
        $categorySum += $this->categoryPositiveNegativeRecordTotal($id, $record, TRUE);
        $categorySum += $this->categoryPositiveNegativeRecordTotal($id, $record, FALSE);
        return $categorySum;
    }

    public function questionPositiveNegativeTotal($question, $record)
    {
        $questionSum = 0;
        $questionSum += $this->questionPositiveNegativeRecordTotal($question, $record, TRUE);
        $questionSum += $this->questionPositiveNegativeRecordTotal($question, $record, FALSE);
        return $questionSum;
    }

    public function questionPositiveNegativeRecordTotal($question, $record, $isPositive = TRUE)
    {
        $questionRecordSum = 0;
        if(is_null($question->getAnswersDatabaseName()))
            return 0;

        foreach ($question->getAnswersDatabaseName() as $columnName)
        {
            $addToSum = FALSE;
            $addValue = $record[$columnName];

            if($isPositive && ($addValue >= 0))
            {
                $addToSum = TRUE;
            }
            else if(!$isPositive && ($addValue <= 0) )
            {
                $addToSum = TRUE;
            }

            if($addToSum)
            {
                $questionRecordSum += abs($addValue);
            }
        }

        return $questionRecordSum;
    }

    public function questionPositiveNegativeTotalProcent($question, $record, $isPositive = TRUE)
    {
        $total = $this->questionPositiveNegativeTotal($question, $record);
        if($total == 0) return 0;

        return max ( (( $this->questionPositiveNegativeRecordTotal($question, $record, $isPositive) / $total ) * 100), 0);
    }

    public function categoryPositiveNegativeTotalProcent($id, $record, $isPositive = TRUE)
    {
        $total = $this->categoryPositiveNegativeTotal($id, $record);
        if($total == 0) return 0;

        return max ( (( $this->categoryPositiveNegativeRecordTotal($id, $record, $isPositive) / $total ) * 100), 0);
    }
}





?>
