<?php

namespace SolveX\Facades;

class Facade
{
    protected static $instances = [];


    public static function setInstance($className, $instance)
    {
        static::$instances[$className] = $instance;
    }


    public static function __callStatic($method, $args)
    {
        $instance = static::$instances[static::class]; // static::class returns the derived class on which a static method was called

        // Delegate method call to the underlying instance
        switch (count($args)) {
            case 0: return $instance->$method();
            case 1: return $instance->$method($args[0]);
            case 2: return $instance->$method($args[0], $args[1]);
            case 3: return $instance->$method($args[0], $args[1], $args[2]);
            case 4: return $instance->$method($args[0], $args[1], $args[2], $args[3]);
            default:
                return call_user_func_array([$instance, $method], $args);
        }
    }
}
