<?php

namespace SolveX\Exceptions;

use Exception;

/**
 * NotFoundHttpException.
 *
 * @link https://github.com/symfony/http-kernel/blob/master/Exception/NotFoundHttpException.php
 */
class NotFoundHttpException extends HttpException
{
    /**
     * Constructor.
     *
     * @param string     $message  The internal exception message
     * @param \Exception $previous The previous exception
     * @param int        $code     The internal exception code
     */
    public function __construct($message = null, Exception $previous = null, $code = 0)
    {
        parent::__construct(404, $message, $previous, [], $code);
    }
}
