<?php

namespace SolveX\Exceptions;

use Exception;

/**
 * @link https://github.com/symfony/http-kernel/blob/master/Exception/HttpException.php
 *
 */
class HttpException extends \RuntimeException
{
    private $statusCode;
    private $headers;


    public function __construct($statusCode, $message = null, Exception $previous = null, $headers = [], $code = 0)
    {
        $this->statusCode = $statusCode;
        $this->headers = $headers;
        parent::__construct($message, $code, $previous);
    }


    public function getStatusCode()
    {
        return $this->statusCode;
    }


    public function getHeaders()
    {
        return $this->headers;
    }


    /**
     * Set response headers.
     *
     * @param array $headers Response headers.
     */
    public function setHeaders(array $headers)
    {
        $this->headers = $headers;
    }
}
