#!/usr/bin/env bash

if [ ! -d "/var/www/webProjects" ]; then
  mkdir /var/www/webProjects
fi

if [ ! -d "/var/www/webProjects/logs" ]; then
  mkdir /var/www/webProjects/logs
fi

if [ ! -d "/var/www/webProjects/mysqlupload" ]; then
  mkdir /var/www/webProjects/mysqlupload
fi

if [ ! -d "vendor" ]; then
  echo "Installing composer"
  php composer.phar global require hirak/prestissimo
fi

php composer.phar install

if [ ! -f /var/www/warpit/.install ]; then
  echo "Copying .install"
  cp deployment/php/docker.install .install
fi

chmod a+rx /var/www/warpit/deployment/wait-for-it.sh
bash /var/www/warpit/deployment/wait-for-it.sh -t 30 -s database:3306 -- echo "Database available, continuing."

php cli warpit:check-installation
status=$?

if [ $status -ne 0 ]; then
  echo "Installing Warpit..."
  # cli warpit:install bails out if dbConfig.php exists,
  # so we remove it here.
  rm _config/dbConfig.php
  cat .install
  php cli warpit:install
fi

chown -R www-data: /var/www/webProjects

php cli warpit:migrate

# start cron in the background
/usr/sbin/crond -l 8

php-fpm
