--
-- Table structure for table `_ProgramMenu`
--

DROP TABLE IF EXISTS `_ProgramMenu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_ProgramMenu` (
  `id` int(3) NOT NULL,
  `id_sup` int(5) NOT NULL,
  `orderBy` tinyint(3) NOT NULL,
  `idLab` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `node_img` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_ProgramMenu`
--

LOCK TABLES `_ProgramMenu` WRITE;
/*!40000 ALTER TABLE `_ProgramMenu` DISABLE KEYS */;
INSERT INTO `_ProgramMenu` VALUES (1,0,0,'Dashboard','statview/_img/program_menu/Dashboard.png'),(2,0,1,'Research','statview/_img/program_menu/Research.png'),(3,0,2,'Projects','statview/_img/program_menu/Projects.png'),(4,0,3,'Widgets','statview/_img/program_menu/Widgets.png');
/*!40000 ALTER TABLE `_ProgramMenu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_client_periods`
--

DROP TABLE IF EXISTS `_client_periods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_client_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period` varchar(50) CHARACTER SET utf8 NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `unitName` varchar(50) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_client_periods`
--

LOCK TABLES `_client_periods` WRITE;
/*!40000 ALTER TABLE `_client_periods` DISABLE KEYS */;
INSERT INTO `_client_periods` VALUES (1,'3',1,'months'),(2,'6',1,'months'),(3,'9',1,'months'),(4,'12',1,'months'),(5,'15',1,'months'),(6,'18',1,'months'),(7,'24',1,'months');
/*!40000 ALTER TABLE `_client_periods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_clients`
--

DROP TABLE IF EXISTS `_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_clients` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `client` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `longName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `id_research` int(5) DEFAULT NULL,
  `lastChangeTime` int(11) unsigned DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `idColorScheme` int(11) NOT NULL,
  `idWidgetWidth` int(11) NOT NULL,
  `leaseTime` int(11) unsigned NOT NULL,
  `leaseDuration` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `client` (`client`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_clients`
--

LOCK TABLES `_clients` WRITE;
/*!40000 ALTER TABLE `_clients` DISABLE KEYS */;
INSERT INTO `_clients` VALUES (1,'Test Client','Test Client',NULL,NULL,0,5,3,1455231600,1463004000);
/*!40000 ALTER TABLE `_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_clients_by_projects`
--

DROP TABLE IF EXISTS `_clients_by_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_clients_by_projects` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_client` int(5) DEFAULT NULL,
  `id_project` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_client` (`id_client`,`id_project`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_clients_by_projects`
--

LOCK TABLES `_clients_by_projects` WRITE;
/*!40000 ALTER TABLE `_clients_by_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `_clients_by_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_colorShema`
--

DROP TABLE IF EXISTS `_colorShema`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_colorShema` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `shemaName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `usedColors` text COLLATE utf8_unicode_ci NOT NULL,
  `imagePath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_colorShema`
--

LOCK TABLES `_colorShema` WRITE;
/*!40000 ALTER TABLE `_colorShema` DISABLE KEYS */;
INSERT INTO `_colorShema` VALUES (1,'Episcenter','#404762,#2c3148,#27435d,#355675,#ededee,#c4c3bf,#939598,#808285,#505356,#231f20','_img/dropdown_palete/bs-epis.png'),(2,'Siol','#283957,#5a739d,#8999be,#b8b8dc,#f1e3db,#d1d3d4,#bcbec0,#717476,#2c3031,#231f20','_img/dropdown_palete/bs-siol.png'),(3,'Magenta','#662d91,#91278f,#9e1f63,#d91c5c,#ee2b7b,#be1e2d,#f15a29,#f7931e,#ba5716,#7f4a1a','_img/dropdown_palete/bs-3.png'),(4,'Brown','#c2b59b,#9b8578,#716558,#5a4a42,#3c2415,#603913,#8b5d3b,#a87b50,#c49a6b,#caa97f','_img/dropdown_palete/bs-4.png'),(5,'Yellow','#fff200,#fbb040,#f7931e,#ef4036,#d7df23,#8cc63f,#009344,#006738,#00a79d,#00867e','_img/dropdown_palete/bs-5.png'),(6,'Blue','#29aae2,#1b75bc,#2a3990,#262261,#662d91,#461065,#352a23,#5a4a42,#716558,#c2b59b','_img/dropdown_palete/bs-6.png');
/*!40000 ALTER TABLE `_colorShema` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_config`
--

DROP TABLE IF EXISTS `_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prefix` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cName` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cValue` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `prefix` (`prefix`(3))
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_config`
--

LOCK TABLES `_config` WRITE;
/*!40000 ALTER TABLE `_config` DISABLE KEYS */;
INSERT INTO `_config` VALUES (1,'paths','www','http://82.117.208.195/statview/'),(2,'paths','absolute','/var/www/statview/'),(3,'language','default_admin','91'),(4,'language','default_client','91'),(5,'warpitServer2','host','localhost'),(6,'warpitServer2','username','root'),(7,'warpitServer2','password','r2sd1a.1970'),(8,'warpitServer2','database','Warpit'),(9,'databases','main','statview'),(10,'warpitServer1','host','localhost'),(11,'warpitServer1','username','root'),(12,'warpitServer1','password','r2sd1a.1970'),(13,'warpitServer1','database','Warpit'),(14,'paths','js_path','statview'),(15,'versionControl','version','1');
/*!40000 ALTER TABLE `_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_customColorSchemes`
--

DROP TABLE IF EXISTS `_customColorSchemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_customColorSchemes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idProj` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `colors` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_customColorSchemes`
--

LOCK TABLES `_customColorSchemes` WRITE;
/*!40000 ALTER TABLE `_customColorSchemes` DISABLE KEYS */;
/*!40000 ALTER TABLE `_customColorSchemes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_dashboard`
--

DROP TABLE IF EXISTS `_dashboard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `last_change_date` datetime NOT NULL,
  `file_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dash_settings` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_dashboard`
--

LOCK TABLES `_dashboard` WRITE;
/*!40000 ALTER TABLE `_dashboard` DISABLE KEYS */;
/*!40000 ALTER TABLE `_dashboard` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_graphResolutions`
--

DROP TABLE IF EXISTS `_graphResolutions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_graphResolutions` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `resolutionText` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `hv_resolution` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_graphResolutions`
--

LOCK TABLES `_graphResolutions` WRITE;
/*!40000 ALTER TABLE `_graphResolutions` DISABLE KEYS */;
INSERT INTO `_graphResolutions` VALUES (1,'320px','320x200'),(2,'640px','640x480'),(3,'800px','800x600'),(4,'1024px','1024x768'),(5,'1280px','1280x1024');
/*!40000 ALTER TABLE `_graphResolutions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_graph_option_templates`
--

DROP TABLE IF EXISTS `_graph_option_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_graph_option_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `graph_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `template_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `options` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_graph_option_templates`
--

LOCK TABLES `_graph_option_templates` WRITE;
/*!40000 ALTER TABLE `_graph_option_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `_graph_option_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_graph_options`
--

DROP TABLE IF EXISTS `_graph_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_graph_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_question` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `id_cross_question` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `id_project` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `sub_type` tinyint(11) NOT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `options` longtext COLLATE utf8_unicode_ci NOT NULL,
  `hidden_series` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_graph_options`
--

LOCK TABLES `_graph_options` WRITE;
/*!40000 ALTER TABLE `_graph_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `_graph_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_languageCodepage`
--

DROP TABLE IF EXISTS `_languageCodepage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_languageCodepage` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `enable` tinyint(1) NOT NULL DEFAULT '0',
  `id_codepage` int(4) DEFAULT NULL,
  `country_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `codepage` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_comment` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `enable` (`enable`,`id_codepage`)
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_languageCodepage`
--

LOCK TABLES `_languageCodepage` WRITE;
/*!40000 ALTER TABLE `_languageCodepage` DISABLE KEYS */;
INSERT INTO `_languageCodepage` VALUES (1,0,1252,'ZAF','windows-1252','Afrikaans'),(2,0,1250,'ALB','windows-1250','Albanian'),(3,0,1256,'DZA','windows-1256','Arabic (Algeria)'),(4,0,1256,'BHR','windows-1256','Arabic (Bahrain)'),(5,0,1256,'EGY','windows-1256','Arabic (Egypt)'),(6,0,1256,'IRQ','windows-1256','Arabic (Iraq)'),(7,0,1256,'JOR','windows-1256','Arabic (Jordan)'),(8,0,1256,'KWT','windows-1256','Arabic (Kuwait)'),(9,0,1256,'LBN','windows-1256','Arabic (Lebanon)'),(10,0,1256,'LBY','windows-1256','Arabic (Libya)'),(11,0,1256,'MAR','windows-1256','Arabic (Morocco)'),(12,0,1256,'OMN','windows-1256','Arabic (Oman)'),(13,0,1256,'QAT','windows-1256','Arabic (Qatar)'),(14,0,1256,'SAU','windows-1256','Arabic (Saudi Arabia)'),(15,0,1256,'SYR','windows-1256','Arabic (Syria)'),(16,0,1256,'TUN','windows-1256','Arabic (Tunisia)'),(17,0,1256,'ARE','windows-1256','Arabic (U.A.E.)'),(18,0,1256,'YEM','windows-1256','Arabic (Yemen)'),(19,0,1251,'AZE','windows-1251','Azeri (Cyrillic)'),(20,0,1254,'AZE','windows-1254','Azeri (Latin)'),(21,0,1252,'ESP','windows-1252','Basque'),(22,1,1251,'BLR','windows-1251','Belarusian'),(23,1,1251,'BGR','windows-1251','Bulgarian'),(24,0,1252,'ESP','windows-1252','Catalan'),(25,0,950,'HKG','windows-950','Chinese (Hong Kong S.A.R.)'),(26,0,950,'MCO','windows-950','Chinese (Macau S.A.R.)'),(27,0,936,'CHN','windows-936','Chinese (PRC)'),(28,0,936,'SGP','windows-936','Chinese (Singapore)'),(29,0,950,'TWN','windows-950','Chinese (Taiwan)'),(30,1,1250,'HRV','windows-1250','Croatian'),(31,1,1250,'CZE','windows-1250','Czech'),(32,1,1252,'DNK','windows-1252','Danish'),(33,0,1252,'BEL','windows-1252','Dutch (Belgium)'),(34,1,1252,'NLD','windows-1252','Dutch (Netherlands)'),(35,0,1252,'AUS','windows-1252','English (Australia)'),(36,0,1252,'BLZ','windows-1252','English (Belize)'),(37,0,1252,'CAN','windows-1252','English (Canada)'),(38,0,1252,'CAR','windows-1252','English (Caribbean)'),(39,0,1252,'IRL','windows-1252','English (Ireland)'),(40,0,1252,'JAM','windows-1252','English (Jamaica)'),(41,0,1252,'NZL','windows-1252','English (New Zealand)'),(42,0,1252,'PHL','windows-1252','English (Philippines)'),(43,0,1252,'ZAF','windows-1252','English (South Africa)'),(44,0,1252,'TTO','windows-1252','English (Trinidad)'),(45,1,1252,'GBR','windows-1252','English (United Kingdom)'),(46,1,1252,'USA','windows-1252','English (United States)'),(47,0,1252,'ZWE','windows-1252','English (Zimbabwe)'),(48,1,1257,'EST','windows-1257','Estonian'),(49,0,1252,'FRO','windows-1252','Faroese'),(50,0,1256,'IRN','windows-1256','Farsi'),(51,1,1252,'FIN','windows-1252','Finnish'),(52,1,1252,'BEL','windows-1252','French (Belgium)'),(53,0,1252,'CAN','windows-1252','French (Canada)'),(54,1,1252,'FRA','windows-1252','French (France)'),(55,0,1252,'LUX','windows-1252','French (Luxembourg)'),(56,0,1252,'MCO','windows-1252','French (Monaco)'),(57,0,1252,'CHE','windows-1252','French (Switzerland)'),(58,1,1251,'MKD','windows-1251','FYRO Macedonian'),(59,0,1252,'ESP','windows-1252','Galician'),(60,1,1252,'AUT','windows-1252','German (Austria)'),(61,1,1252,'DEU','windows-1252','German (Germany)'),(62,1,1252,'LIE','windows-1252','German (Liechtenstein)'),(63,1,1252,'LUX','windows-1252','German (Luxembourg)'),(64,1,1252,'CHE','windows-1252','German (Switzerland)'),(65,1,1253,'GRC','windows-1253','Greek'),(66,0,1255,'ISR','windows-1255','Hebrew'),(67,1,1250,'HUN','windows-1250','Hungarian'),(68,1,1252,'ISL','windows-1252','Icelandic'),(69,0,1252,'IDN','windows-1252','Indonesian'),(70,1,1252,'ITA','windows-1252','Italian (Italy)'),(71,0,1252,'CHE','windows-1252','Italian (Switzerland)'),(72,0,932,'JPN','windows-932','Japanese'),(73,0,1251,'KAZ','windows-1251','Kazakh'),(74,0,949,'KOR','windows-949','Korean'),(75,0,1251,'KGZ','windows-1251','Kyrgyz (Cyrillic)'),(76,1,1257,'LVA','windows-1257','Latvian'),(77,1,1257,'LTU','windows-1257','Lithuanian'),(78,0,1252,'BRN','windows-1252','Malay (Brunei Darussalam)'),(79,0,1252,'MYS','windows-1252','Malay (Malaysia)'),(80,0,1251,'MNG','windows-1251','Mongolian (Cyrillic)'),(81,0,1252,'NOR','windows-1252','Norwegian (Bokmal)'),(82,1,1252,'NOR','windows-1252','Norwegian (Nynorsk)'),(83,1,1250,'POL','windows-1250','Polish'),(84,0,1252,'BRA','windows-1252','Portuguese (Brazil)'),(85,1,1252,'PRT','windows-1252','Portuguese (Portugal)'),(86,1,1250,'ROM','windows-1250','Romanian'),(87,1,1251,'RUS','windows-1251','Russian'),(88,1,1251,'SPB','windows-1251','Serbian (Cyrillic)'),(89,1,1250,'SPB','windows-1250','Serbian (Latin)'),(90,1,1250,'SVK','windows-1250','Slovak'),(91,1,1250,'SVN','windows-1250','Slovenian'),(92,0,1252,'ARG','windows-1252','Spanish (Argentina)'),(93,0,1252,'BOL','windows-1252','Spanish (Bolivia)'),(94,0,1252,'CHL','windows-1252','Spanish (Chile)'),(95,0,1252,'COL','windows-1252','Spanish (Colombia)'),(96,0,1252,'CRI','windows-1252','Spanish (Costa Rica)'),(97,0,1252,'DOM','windows-1252','Spanish (Dominican Republic)'),(98,0,1252,'ECU','windows-1252','Spanish (Ecuador)'),(99,0,1252,'SLV','windows-1252','Spanish (El Salvador)'),(100,0,1252,'GTM','windows-1252','Spanish (Guatemala)'),(101,0,1252,'HND','windows-1252','Spanish (Honduras)'),(102,0,1252,'ESP','windows-1252','Spanish (International Sort)'),(103,0,1252,'MEX','windows-1252','Spanish (Mexico)'),(104,0,1252,'NIC','windows-1252','Spanish (Nicaragua)'),(105,0,1252,'PAN','windows-1252','Spanish (Panama)'),(106,0,1252,'PRY','windows-1252','Spanish (Paraguay)'),(107,0,1252,'PER','windows-1252','Spanish (Peru)'),(108,0,1252,'PRI','windows-1252','Spanish (Puerto Rico)'),(109,1,1252,'ESP','windows-1252','Spanish (Traditional Sort)'),(110,0,1252,'URY','windows-1252','Spanish (Uruguay)'),(111,0,1252,'VEN','windows-1252','Spanish (Venezuela)'),(112,0,1252,'KEN','windows-1252','Swahili'),(113,1,1252,'SWE','windows-1252','Swedish'),(114,0,1252,'FIN','windows-1252','Swedish (Finland)'),(115,0,1251,'RUS','windows-1251','Tatar'),(116,0,874,'THA','windows-874','Thai'),(117,1,1254,'TUR','windows-1254','Turkish'),(118,1,1251,'UKR','windows-1251','Ukrainian'),(119,0,1256,'PAK','windows-1256','Urdu'),(120,1,1251,'UZB','windows-1251','Uzbek (Cyrillic)'),(121,0,1254,'UZB','windows-1254','Uzbek (Latin)'),(122,0,1258,'VNM','windows-1258','Vietnamese'),(123,1,1250,'BIH','windows-1250','Bosnia'),(125,1,1250,'URD','windows-1250','Urdi Pakistan'),(124,1,1251,'MAK','windows-1251','Macedonia');
/*!40000 ALTER TABLE `_languageCodepage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_languagePack`
--

DROP TABLE IF EXISTS `_languagePack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_languagePack` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_programme` tinyint(4) NOT NULL,
  `id_language` mediumint(9) NOT NULL,
  `sub_page` varchar(25) CHARACTER SET utf8 NOT NULL,
  `translate_key` varchar(25) CHARACTER SET utf8 NOT NULL,
  `translate_text` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_select` (`id_programme`,`id_language`,`sub_page`,`translate_key`)
) ENGINE=MyISAM AUTO_INCREMENT=1560 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_languagePack`
--

LOCK TABLES `_languagePack` WRITE;
/*!40000 ALTER TABLE `_languagePack` DISABLE KEYS */;
INSERT INTO `_languagePack` VALUES (1,1,46,'login','loginEma','Username or E-mail'),(2,1,46,'login','loginPass','Password'),(3,1,46,'login','loginFPass','Forgot password?'),(4,1,46,'login','loginGoButtn','Login'),(5,1,46,'login','loginSendButtn','Send'),(6,1,46,'login','loginSendButtnAlrt','This user does not exist'),(7,1,46,'dashboard','tab1','Dashboard'),(8,1,46,'dashboard','tab2','Research'),(9,1,46,'dashboard','tab3','Projects'),(10,1,46,'dashboard','tab4','Widgets'),(11,1,46,'dashboard','tab5','Clients'),(12,1,46,'dashboard','tab6','Users'),(13,1,46,'dashboard','logout','Logout'),(14,1,46,'research','research','Researches'),(15,1,46,'research','research_add','Add research '),(16,1,46,'research','no','NO'),(17,1,46,'research','yes','YES'),(18,1,46,'research','weight_tab','Weight'),(19,1,46,'research','research_tab','Research'),(20,1,46,'research','weight1','Weights are not computed'),(21,1,46,'research','weight2','The weights are not computed. For using the research in a project, compute the weights.'),(22,1,46,'research','weight3','WEIGHT COMPUTING'),(23,1,46,'research','weight4','With selected variables make new weight computing layer:'),(24,1,46,'research','weight_drop1','weight'),(25,1,46,'research','weight_drop2','unweight'),(26,1,46,'research','weight_create','Greate layer'),(27,1,46,'research','weight_layer','Layers'),(28,1,46,'research','weight_layer_del','Delete layer'),(29,1,46,'research','weight_layer_reset','Reset weight variable'),(30,1,46,'research','weight_run','Run'),(31,1,46,'research','weight_layer_table1','Weight (n)'),(32,1,46,'research','weight_layer_table2','% weight (n)'),(33,1,46,'research','weight_layer_factor','Factor'),(34,1,46,'research','research_upload1','Server Epis 1'),(35,1,46,'research','research_upload2','Server Epis 2'),(36,1,46,'research','research_upload3','Upload'),(37,1,46,'research','research_upload4','The research has uploaded successfully.'),(38,1,46,'research','research_id','ID research'),(39,1,46,'research','research_setting1','Default setting'),(40,1,46,'research','research_setting2','Research is weighted'),(41,1,46,'research','research_edit_settings','Edit research'),(42,1,46,'research','research_edit_settings_mi','Missing m.v.'),(43,1,46,'research','research_edit_settings_hi','Hide answ'),(44,1,46,'research','research_edit_settings_q','Question'),(45,1,46,'research','research_edit_settings_ti','Title'),(46,1,46,'research','research_edit_settings_a','Answer'),(47,1,46,'research','research_edit_settings_as','Answers'),(48,1,46,'research','research_edit_settings_aA','Add answer'),(49,1,46,'research','research_edit_settings_aD','Delete answer'),(50,1,46,'research','research_preview','Preview'),(51,1,46,'research','research_preview_cross','Without crossing'),(52,1,46,'research','research_preview_table1','% row'),(53,1,46,'research','research_preview_table2','% column'),(54,1,46,'research','research_preview_advance1','Table settings'),(55,1,46,'research','research_preview_drop1','Slider type'),(56,1,46,'research','research_preview_drop2','None'),(57,1,46,'research','research_preview_drop3','Period'),(58,1,46,'research','research_preview_drop4','Months'),(59,1,46,'research','research_preview_data1','Show data:'),(60,1,46,'research','research_preview_data2','Body'),(61,1,46,'research','research_preview_data3','Total column'),(62,1,46,'research','research_preview_data4','Total row'),(63,1,46,'research','research_preview_data5','Total'),(64,1,46,'research','research_preview_decimal1','Number of decimal places'),(65,1,46,'research','research_preview_decimal2','for N'),(66,1,46,'research','research_preview_decimal3','for %'),(67,1,46,'research','research_preview_label1','Show labels'),(68,1,46,'research','research_preview_label2','Vertical orientation'),(69,1,46,'research','research_preview_use','Use'),(70,1,46,'default','close','Close'),(71,1,46,'research','research_preview_total','TOTAL'),(72,1,46,'research','research_preview_export','Export'),(73,1,46,'default','research_preview_export_i','Image'),(74,1,46,'default','research_preview_export_w','Widget'),(75,1,46,'research','research_edit','Editor'),(76,1,46,'research','research_cross','Crossing with:'),(77,1,46,'research','research_comment','Comment'),(78,1,46,'research','research_event','Events'),(79,1,46,'research','research_event_add','Add event'),(80,1,46,'research','research_event_del','Remove'),(81,1,46,'research','research_weight_alert1','Alert'),(82,1,46,'research','research_weight_alert2','The research is used in other project!'),(83,1,46,'research','research_save','Do you want to save this research?'),(84,1,46,'research','research_cancel','Do you want to cancel the changes?'),(85,1,46,'research','research_del','Do you want to delete this research?'),(86,1,46,'project','project','Projects'),(87,1,46,'project','include_recearch','Included researches '),(88,1,46,'project','project_add','Add new project'),(89,1,46,'project','project_add_error1','Please add project title!'),(90,1,46,'project','project_add_error2','Short title can have only small letters without special characters, numbers (except at start) and \"_\"!'),(91,1,46,'project','project_add_error3','Please, select a client!'),(92,1,46,'project','project_add_error4','Please, add at least 1 research!'),(93,1,46,'project','project_title','Title'),(94,1,46,'project','project_title_short','Short title'),(95,1,46,'project','project_use_research','Use researches'),(96,1,46,'project','project_add_research','Add research '),(97,1,46,'project','project_title_proj','Title project'),(98,1,46,'project','project_foot_text','Chart footer text'),(99,1,46,'project','project_width','Width'),(100,1,46,'project','project_time','Activate time component'),(101,1,46,'project','project_questions','Questions in the project'),(102,1,46,'project','project_apperance','Display formats'),(103,1,46,'project','usrName','Name'),(104,1,46,'project','usrCli','Client'),(105,1,46,'project','usralertCross1','This graph cannot be shown without crossing!'),(106,1,46,'project','usralertCross2','This graph cannot be shown with crossing!'),(107,1,46,'project','project_grapfSettings','Creating an chart area'),(108,1,46,'project','project_grapgOptins_tab','Graph settings'),(109,1,46,'project','project_grapgOptins_drop','Settings proposition'),(110,1,46,'project','project_grapgOptins_butto','Create new'),(111,1,46,'project','project_grapgOptins_new','Proposition name'),(112,1,46,'project','project_grapgOptins_time','Time component'),(113,1,46,'project','project_grapgOptins_heigh','Graph height (px)'),(114,1,46,'project','project_grapgOptins_paddi','Left deviation of graph  (px)'),(115,1,46,'project','project_grapgOptins_decPl','No. decimal places proc.'),(116,1,46,'project','project_grapgOptins_color','Color from dark to ligh '),(117,1,46,'project','project_grapgOptins_label','On/Off labels on X-axis'),(118,1,46,'project','project_grapgOptins_Line','On/Off horizontal line'),(119,1,46,'project','project_grapgOptins_LineA','Line shape'),(120,1,46,'project','project_grapgOptins_LineB','Line tickness (px)'),(121,1,46,'project','project_grapgOptins_LineC','Line color'),(122,1,46,'project','project_grapgOptins_legen','On/Off legend'),(123,1,46,'project','project_grapgOptins_endDa','Data type at the end'),(124,1,46,'project','project_grapgOptins_numer','Numerus'),(125,1,46,'project','project_grapgOptins_proc','Percent'),(126,1,46,'project','project_grapgOptins_words','No. of words in pie legend'),(127,1,46,'project','project_grapgOptins_bar','Bar graph settings '),(128,1,46,'project','project_grapgOptins_barAl','Layout'),(129,1,46,'project','project_grapgOptins_colum','Ascending/descending columns '),(130,1,46,'project','project_grapgOptins_mapSe','Map options'),(131,1,46,'project','project_grapgOptins_map','Map settings'),(132,1,46,'project','project_grapgOptins_mapSl','Slider steps'),(133,1,46,'project','project_grapgOptins_mapDa','Data type'),(134,1,46,'project','project_grapgOptins_mapTr','Terrain transparency (%)'),(135,1,46,'project','project_grapgOptins_mapPa','Left deviation of a map (px)'),(136,1,46,'project','project_grapgOptins_mapTe','Show terrain'),(137,1,46,'project','project_grapgOptins_mapAu','Underlayer automatic selection'),(138,1,46,'project','project_grapgOptins_advan','Advance settings'),(139,1,46,'project','project_grapgOptins_imgBc','Background image'),(140,1,46,'project','project_grapgOptins_geoCo','Geo-referenced coordinates'),(141,1,46,'project','project_grapgOptins_limit','Limit bottom'),(142,1,46,'project','project_grapgOptins_mapFo','Map footnote settings'),(143,1,46,'project','project_grapgOptins_pieCh','Pie graph settings'),(144,1,46,'project','project_grapgOptins_pieSi','Pie size (radius)'),(145,1,46,'project','project_grapgOptins_pieSe','Show settings for pie labels'),(146,1,46,'project','project_grapgOptins_pieOn','On/Off pie labels'),(147,1,46,'project','project_grapgOptins_pieDa','Data type in labels'),(148,1,46,'project','project_grapgOptins_pieLa','Label layout'),(149,1,46,'project','project_grapgOptins_Setti','Reset settings'),(150,1,46,'project','project_grapgOptins_dataS','Data size (px)'),(151,1,46,'project','project_textOptins_tab','Text options'),(152,1,46,'project','project_textOptins_qTitle','Set the question as graph title'),(153,1,46,'project','project_textOptins_TitleS','Title settings'),(154,1,46,'project','project_textOptins_TitleF','Title font'),(155,1,46,'project','project_textOptins_TitleC','Title color'),(156,1,46,'project','project_textOptins_TitleA','Title layout'),(157,1,46,'project','project_textOptins_TitleW','No. of words in a title'),(158,1,46,'project','project_textOptins_Xlabel','X-axis lable settings'),(159,1,46,'project','project_textOptins_Ylabel','Y-axis label settings'),(160,1,46,'project','project_textOptins_legend','Legend settings'),(161,1,46,'project','project_textOptins_fontSi','Legend font size'),(162,1,46,'project','project_textOptins_font','Legend label font'),(163,1,46,'project','project_textOptins_color','Legend label color'),(164,1,46,'project','project_textOptins_bold','Legend lable bold text'),(165,1,46,'project','project_textOptins_align','Legend alignment'),(166,1,46,'project','project_textOptins_alignR','Right'),(167,1,46,'project','project_textOptins_alignL','Left'),(168,1,46,'project','project_textOptins_alignM','In the middle'),(169,1,46,'project','project_textOptins_alignV','Legend vertical layout'),(170,1,46,'project','project_textOptins_layout','Legends layout'),(171,1,46,'project','project_textOptins_paddin','Legend deviation '),(172,1,46,'project','project_advanceOptions_ta','Advance settings'),(173,1,46,'project','project_advanceOptions_to','Tooltip settings'),(174,1,46,'project','project_advanceOptions_fo','Graph footnote settings'),(175,1,46,'project','project_advanceOptions_im','Graph image settings'),(176,1,46,'project','project_Options_body','Show body'),(177,1,46,'widgeti','widgeti','Widgets'),(178,1,46,'widgeti','widgeti_title','Widget title'),(179,1,46,'widgeti','widgeti_project','Project'),(180,1,46,'widgeti','widgeti_code','Code'),(181,1,46,'widgeti','widgeti_published','Published'),(182,1,46,'widgeti','widgeti_publish','Publish'),(183,1,46,'widgeti','widgeti_del_widet','Delete widget'),(184,1,46,'clients','months','Months'),(185,1,46,'clients','month','Month'),(186,1,46,'clients','years','Years'),(187,1,46,'clients','clients','Clients'),(188,1,46,'clients','name','Name'),(189,1,46,'clients','subscription_exp','Subscription expire'),(190,1,46,'clients','all_usr','Users'),(191,1,46,'clients','new_client','New client'),(192,1,46,'clients','name_full','Full name'),(193,1,46,'clients','subscription','Subscription'),(194,1,46,'clients','subscription_date','Order date'),(195,1,46,'clients','subscription_period','Lease period'),(196,1,46,'clients','subscription_periodExpp','Lease period expire'),(197,1,46,'clients','subscription_periodExp','Period will expire'),(198,1,46,'clients','subscription_periodExt','Renew the lease for'),(199,1,46,'clients','subscription_ExtAftr','after'),(200,1,46,'clients','subscription_ExtDay','days'),(201,1,46,'clients','subscription_periodExtBut','Renew'),(202,1,46,'clients','subscription_defSet','Default widget settings'),(203,1,46,'clients','subscription_ww','Widget width'),(204,1,46,'clients','subscription_width','Width'),(205,1,46,'clients','subscription_alertClientN','Please, enter the client\'s name!'),(206,1,46,'clients','client_editPro','Projects'),(207,1,46,'clients','client_editProCli','Client\'s projects'),(208,1,46,'clients','client_editProAdd','Add project'),(209,1,46,'clients','client_editTab','Basic'),(210,1,46,'clients','client_Change','Change all existing widgets'),(211,1,46,'clients','client_ChangeIfDef','Change all existing widgets, if they were set to default '),(212,1,46,'clients','client_DelClient','Delete'),(213,1,46,'clients','client_DelClientAlert1','Deleting a client '),(214,1,46,'clients','client_DelClientAlert2','Are you sure you want to delete the client?'),(215,1,46,'users','name','Name and Surname'),(216,1,46,'users','usr_client','Client'),(217,1,46,'users','profile_drop2','Client'),(218,1,46,'users','permission_profile','Permissions'),(219,1,46,'users','new_user','New user'),(220,1,46,'users','users','Users'),(221,1,46,'users','users_of_client','Users of the Client'),(222,1,46,'users','all_users','All users'),(223,1,46,'users','user','User'),(224,1,46,'users','email','E-mail'),(225,1,46,'users','password','Password'),(226,1,46,'users','repeat_password','Repeat password'),(227,1,46,'users','permissions','Permissions'),(228,1,46,'users','save_as_new_profile','Save as new profile'),(229,1,46,'default','upload','Upload'),(230,1,46,'default','choose','Select…'),(231,1,46,'default','cancel','Cancel'),(232,1,46,'default','save','Save'),(233,1,46,'default','discard','Discard'),(234,1,46,'default','delete','Delete'),(235,1,46,'default','ok','Ok'),(236,1,46,'users','custom','Custom'),(237,1,46,'users','profile','Profile'),(238,1,46,'default','profile_drop1','Administrator'),(239,1,46,'default','editor','Editor'),(1193,1,46,'users','user_name_label','Name'),(1192,1,91,'research','res_weighed_label','Obtežen'),(1191,1,46,'research','res_weighed_label','Weighed down'),(1190,1,91,'research','res_name_label','Naziv'),(1189,1,46,'research','res_name_label','Name'),(1188,1,91,'project','project_label','Projekt'),(246,1,46,'users','profile_name','Profile name'),(247,1,46,'users','delete_profile','Delete profile'),(248,1,46,'users','update','Update'),(249,1,46,'users','urs_alertName1','Please, enter the users name!'),(250,1,46,'users','urs_alertName2','Please, enter the client\'s name and surname separated with space!'),(251,1,46,'users','urs_alertEmail1','Please, enter user\'s e-mail address!'),(252,1,46,'users','urs_alertEmail2','The selected email is not in correct format!'),(253,1,46,'users','urs_alertPass1','Please, enter password!'),(254,1,46,'users','urs_alertPass2','Please, retype the password!'),(255,1,46,'users','urs_alertPass3','Passwords do not match! '),(256,1,46,'users','urs_alertProf','Please, select a profil type!'),(1187,1,46,'project','project_label','Project'),(258,2,46,'login','loginEma','Username or E-mail'),(259,2,46,'login','loginPass','Password'),(260,2,46,'login','loginFPass','Forgot password?'),(261,2,46,'login','loginGoButtn','Login'),(262,2,46,'login','loginSendButtn','Send'),(263,2,46,'login','loginSendButtnAlrt','This user does not exist'),(264,2,46,'dashboard','tab1','Dashboard'),(265,2,46,'dashboard','tab3','Projects'),(266,2,46,'dashboard','tab4','Widgets'),(267,2,46,'dashboard','logout','Logout'),(268,2,46,'default','close','Close'),(269,2,46,'project','project','Projects'),(270,2,46,'project','include_recearch','Included researches '),(1327,1,91,'project','project_color','Barva'),(272,2,46,'project','usrName','Name'),(273,2,46,'project','usrCli','Client'),(274,2,46,'project','usrChooseQ','Please, select a question!'),(275,2,46,'project','usrResTime','Research time'),(276,2,46,'project','usrResCross','Without crossing'),(277,2,46,'project','usrResTotal','TOTAL'),(278,2,46,'default','research_preview_export','Export'),(279,2,46,'project','usralertCross1','This graph cannot be shown without crossing!'),(280,2,46,'project','usralertCross2','This graph cannot be shown with crossing!'),(281,2,46,'project','proj_num','Number'),(282,2,46,'project','proj_proc','Percent'),(283,2,46,'default','research_preview_export_i','Image'),(284,2,46,'default','research_preview_export_w','Widget'),(285,2,46,'widgeti','widgeti','Widgets'),(286,2,46,'widgeti','widgeti_title','Widget name'),(287,2,46,'widgeti','widgeti_project','Project'),(288,2,46,'widgeti','widgeti_code','Code'),(289,2,46,'widgeti','widgeti_published','Published'),(290,2,46,'widgeti','widgeti_publish','Publish'),(291,2,46,'widgeti','widgeti_del_widet','Delete widget'),(292,1,91,'login','loginEma','Uporabniško ime ali E-naslov'),(293,1,91,'login','loginPass','Geslo'),(294,1,91,'login','loginFPass','Ste pozabili geslo?'),(295,1,91,'login','loginGoButtn','Prijava'),(296,1,91,'login','loginSendButtn','Pošlji'),(297,1,91,'login','loginSendButtnAlrt','Ta uporabnik ne obstaja'),(298,1,91,'dashboard','tab1','Dashboard'),(299,1,91,'dashboard','tab2','Raziskave'),(300,1,91,'dashboard','tab3','Projekti'),(301,1,91,'dashboard','tab4','Widgeti'),(302,1,91,'dashboard','tab5','Naročniki'),(303,1,91,'dashboard','tab6','Uporabniki'),(304,1,91,'dashboard','logout','Odjava'),(305,1,91,'research','research','Raziskave'),(306,1,91,'research','research_add','Dodaj novo raziskavo'),(307,1,91,'research','no','NE'),(308,1,91,'research','yes','DA'),(309,1,91,'research','weight_tab','Uteži'),(310,1,91,'research','research_tab','Raziskava'),(311,1,91,'research','weight1','Uteži izračunane'),(312,1,91,'research','weight2','Uteži še niso bile izračunane. Izračunajte jih, da bi raziskavo lahko uporabili v projektu.'),(313,1,91,'research','weight3','RAČUNANJE  OBTEŽITVENIH FAKTORJEV'),(314,1,91,'research','weight4','Z izbranimi spremenljivkami ustvarite nov nivo obteženih faktorjev:'),(315,1,91,'research','weight_drop1','obtežitev'),(316,1,91,'research','weight_drop2','razbremenitev obtežitve'),(317,1,91,'research','weight_create','Ustvari nivo'),(318,1,91,'research','weight_layer','Nivoji'),(319,1,91,'research','weight_layer_del','Izbriši nivo'),(320,1,91,'research','weight_layer_reset','Ponastavi obtežene spremenljivke'),(321,1,91,'research','weight_run','Poženi'),(322,1,91,'research','weight_layer_table1','Teža (n)'),(323,1,91,'research','weight_layer_table2','% Teža (n)'),(324,1,91,'research','weight_layer_factor','Faktor'),(325,1,91,'research','research_upload1','Uvozi Epis 1'),(326,1,91,'research','research_upload2','Uvozi Epis 2'),(327,1,91,'research','research_upload3','Naloži'),(328,1,91,'research','research_upload4','Uvoz raziskave je bil uspešen.'),(329,1,91,'research','research_id','ID raziskave'),(330,1,91,'research','research_setting1','Privzeta nastavitev'),(331,1,91,'research','research_setting2','Raziskava je obtežena'),(332,1,91,'research','research_edit_settings','Urejanje raziskave'),(333,1,91,'research','research_edit_settings_mi','Manjkajoče sr. Vr'),(334,1,91,'research','research_edit_settings_hi','Skrij odg'),(335,1,91,'research','research_edit_settings_q','Vprašanje'),(336,1,91,'research','research_edit_settings_ti','Naslov'),(337,1,91,'research','research_edit_settings_a','Odgovor'),(338,1,91,'research','research_edit_settings_as','Odgovori'),(339,1,91,'research','research_edit_settings_aA','Dodaj odgovor'),(340,1,91,'research','research_edit_settings_aD','Odstrani odgovor'),(341,1,91,'research','research_preview','Predogled'),(342,1,91,'research','research_preview_cross','Brez križanja'),(343,1,91,'research','research_preview_table1','% vrsta'),(344,1,91,'research','research_preview_table2','% stolpec'),(345,1,91,'research','research_preview_advance1','Nastavitve za tabelo'),(346,1,91,'research','research_preview_drop1','Tip sliderja'),(347,1,91,'research','research_preview_drop2','Brez'),(348,1,91,'research','research_preview_drop3','Obdobje'),(349,1,91,'research','research_preview_drop4','Po mesecih'),(350,1,91,'research','research_preview_data1','Prikaz podatkov:'),(351,1,91,'research','research_preview_data2','Telo'),(352,1,91,'research','research_preview_data3','Skupaj stolpec'),(353,1,91,'research','research_preview_data4','Skupaj vrstica'),(354,1,91,'research','research_preview_data5','Skupaj'),(355,1,91,'research','research_preview_decimal1','Število decimalnih mest'),(356,1,91,'research','research_preview_decimal2','za N'),(357,1,91,'research','research_preview_decimal3','za %'),(358,1,91,'research','research_preview_label1','Prikaz label'),(359,1,91,'research','research_preview_label2','Vertikalna orientacija'),(360,1,91,'research','research_preview_use','Uporabi'),(361,1,91,'default','close','Zapri'),(362,1,91,'research','research_preview_total','SKUPAJ'),(363,1,91,'default','research_preview_export','Izvozi'),(364,1,91,'default','research_preview_export_i','Slika'),(365,1,91,'default','research_preview_export_w','Widget'),(366,1,91,'research','research_edit','Urejevalnik'),(367,1,91,'research','research_cross','Križanje mogoče z'),(368,1,91,'research','research_comment','Komentar'),(369,1,91,'research','research_event','Dogodki'),(370,1,91,'research','research_event_add','Dodaj dogodek'),(371,1,91,'research','research_event_del','Odstrani'),(372,1,91,'research','research_weight_alert1','Opozorilo'),(373,1,91,'research','research_weight_alert2','Raziskava je že uporabljena v projektu!'),(374,1,91,'research','research_save','Želite shraniti raziskavo?'),(375,1,91,'research','research_cancel','Želite preklicati spremembe?'),(376,1,91,'research','research_del','Želite izbrisati raziskavo?'),(377,1,91,'project','project','Projekti'),(378,1,91,'project','include_recearch','Vključenih raziskav'),(379,1,91,'project','project_add','Dodaj nov projekt'),(380,1,91,'project','project_add_error1','Prosim vnesite naziv projekta!'),(381,1,91,'project','project_add_error2','Kratko ime lahko vsebuje le črke brez šumnikov, številke (razen na začetku) ter \"_\"!'),(382,1,91,'project','project_add_error3','Prosim, izberite naročnika!'),(383,1,91,'project','project_add_error4','Prosim, dodajte vsaj 1 raziskavo!'),(384,1,91,'project','project_title','Naziv'),(385,1,91,'project','project_title_short','Kratki nazi'),(386,1,91,'project','project_use_research','Uporabi raziskave'),(387,1,91,'project','project_add_research','Dodaj raziskavo'),(388,1,91,'project','project_title_proj','Naziv projekta'),(389,1,91,'project','project_foot_text','Tekst noge grafa'),(390,1,91,'project','project_width','Širina'),(391,1,91,'project','project_time','Aktiviraj časovno komponento'),(392,1,91,'project','project_questions','Vprašanja v projektu'),(393,1,91,'project','project_apperance','Možne oblike prikaza'),(394,1,91,'project','usrName','Ime'),(395,1,91,'project','usrCli','Naročnik'),(396,1,91,'project','usralertCross1','Tega grafa ni mogoče prikazati brez križanja!'),(397,1,91,'project','usralertCross2','Tega grafa ni mogoče prikazati pri križanju!'),(398,1,91,'project','project_grapfSettings','Oblikovanje območja grafikona'),(399,1,91,'project','project_grapgOptins_tab','Možnosti grafa'),(400,1,91,'project','project_grapgOptins_drop','Predloge nastavitev'),(401,1,91,'project','project_grapgOptins_butto','Ustvari novo'),(402,1,91,'project','project_grapgOptins_new','Ime predloge'),(403,1,91,'project','project_grapgOptins_time','Časovna komponenta'),(404,1,91,'project','project_grapgOptins_heigh','Višina grafa (px)'),(405,1,91,'project','project_grapgOptins_paddi','Odmik grafa levo (px)'),(406,1,91,'project','project_grapgOptins_decPl','Št. decimalnih mest proc.'),(407,1,91,'project','project_grapgOptins_color','Barve od temne proti svetli'),(408,1,91,'project','project_grapgOptins_label','Vklop/izklop label na X-osi'),(409,1,91,'project','project_grapgOptins_Line','Vklop/izklop horizontalnih črt'),(410,1,91,'project','project_grapgOptins_LineA','Oblika črt'),(411,1,91,'project','project_grapgOptins_LineB','Debelina črt (px)'),(412,1,91,'project','project_grapgOptins_LineC','Barva črt'),(413,1,91,'project','project_grapgOptins_legen','Vklop/izklop legende'),(414,1,91,'project','project_grapgOptins_endDa','Vrsta podatka na koncu'),(415,1,91,'project','project_grapgOptins_numer','Numerus'),(416,1,91,'project','project_grapgOptins_proc','Procent'),(417,1,91,'project','project_grapgOptins_words','Št. besed v legendi pite'),(418,1,91,'project','project_grapgOptins_bar','Nastavitve stolpičnega grafa'),(419,1,91,'project','project_grapgOptins_barAl','Postavitev'),(420,1,91,'project','project_grapgOptins_colum','Naraščanje/padanje stolpcev'),(421,1,91,'project','project_grapgOptins_mapSe','Možnosti zemljevida'),(422,1,91,'project','project_grapgOptins_map','Nastavitve za mape'),(423,1,91,'project','project_grapgOptins_mapSl','Korak drsnikov'),(424,1,91,'project','project_grapgOptins_mapDa','Vrsta podatkov'),(425,1,91,'project','project_grapgOptins_mapTr','Prosojnost terena (%)'),(426,1,91,'project','project_grapgOptins_mapPa','Odmik mape levo (px)'),(427,1,91,'project','project_grapgOptins_mapTe','Prikaz terena'),(428,1,91,'project','project_grapgOptins_mapAu','Avtomatska izbira pod-sloja'),(429,1,91,'project','project_grapgOptins_advan','Dodatne možnosti'),(430,1,91,'project','project_grapgOptins_imgBc','Slika ozadja'),(431,1,91,'project','project_grapgOptins_geoCo','Georeferenčne koordinate'),(432,1,91,'project','project_grapgOptins_limit','Meja spodaj'),(433,1,91,'project','project_grapgOptins_mapFo','Nastavitve noge mape'),(434,1,91,'project','project_grapgOptins_pieCh','Nastavitve tortnega grafa'),(435,1,91,'project','project_grapgOptins_pieSi','Velikost pite (radius)'),(436,1,91,'project','project_grapgOptins_pieSe','Pokaži nastavitve za labele pite'),(437,1,91,'project','project_grapgOptins_pieOn','Vklop/izklop label pite'),(438,1,91,'project','project_grapgOptins_pieDa','Vrsta podatkov v labelah'),(439,1,91,'project','project_grapgOptins_pieLa','Pozicija label'),(440,1,91,'project','project_grapgOptins_Setti','Razveljavi nastavitve'),(441,1,91,'project','project_grapgOptins_dataS','Velikost podatkov (px)'),(442,1,91,'project','project_textOptins_tab','Možnosti besedila'),(443,1,91,'project','project_textOptins_qTitle','Nastavi vprašanje za naslov garafa'),(444,1,91,'project','project_textOptins_TitleS','Nastavitve naslova'),(445,1,91,'project','project_textOptins_TitleF','Pisava naslova'),(446,1,91,'project','project_textOptins_TitleC','Barva naslova'),(447,1,91,'project','project_textOptins_TitleA','Pozicija naslova'),(448,1,91,'project','project_textOptins_TitleW','Št. besed v naslovu'),(449,1,91,'project','project_textOptins_Xlabel','Nastavitve label X-osi'),(450,1,91,'project','project_textOptins_Ylabel','Nastavitve label Y-osi'),(451,1,91,'project','project_textOptins_legend','Nastavitve legende'),(452,1,91,'project','project_textOptins_fontSi','Velikost pisave legende'),(453,1,91,'project','project_textOptins_font','Pisava label legende'),(454,1,91,'project','project_textOptins_color','Barva label legende'),(455,1,91,'project','project_textOptins_bold','Odebeljen tekst label legende'),(456,1,91,'project','project_textOptins_align','Poravnava legende'),(457,1,91,'project','project_textOptins_alignR','Desno'),(458,1,91,'project','project_textOptins_alignL','Levo'),(459,1,91,'project','project_textOptins_alignM','Na sredino'),(460,1,91,'project','project_textOptins_alignV','Vertikalna poravnava legende'),(461,1,91,'project','project_textOptins_layout','Postavitev legende'),(462,1,91,'project','project_textOptins_paddin','Odmik legende'),(463,1,91,'project','project_advanceOptions_ta','Dodatne nastavitve'),(464,1,91,'project','project_advanceOptions_to','Nastavitve tooltipa'),(465,1,91,'project','project_advanceOptions_fo','Nastavitve noge grafa'),(466,1,91,'project','project_advanceOptions_im','Nastavitve slike grafa'),(467,1,91,'project','project_Options_body','Prikaz telo'),(468,1,91,'widgeti','widgeti','Widgeti'),(469,1,91,'widgeti','widgeti_title','Naziv widgeta'),(470,1,91,'widgeti','widgeti_project','Projekt'),(471,1,91,'widgeti','widgeti_code','Koda'),(472,1,91,'widgeti','widgeti_published','Objavljen'),(473,1,91,'widgeti','widgeti_publish','Objavi'),(474,1,91,'widgeti','widgeti_del_widet','Izbriši widget'),(475,1,91,'clients','months','mesecev'),(476,1,91,'clients','month','mesec'),(477,1,91,'clients','years','let'),(478,1,91,'clients','clients','Naročniki'),(479,1,91,'clients','name','Naziv'),(480,1,91,'clients','subscription_exp','Naročnina poteče'),(481,1,91,'clients','all_usr','Uporabnikov'),(482,1,91,'clients','new_client','Nov naročnik'),(483,1,91,'clients','name_full','Polni naziv'),(484,1,91,'clients','subscription','Naročnina'),(485,1,91,'clients','subscription_date','Datum naročila'),(486,1,91,'clients','subscription_period','Obdobje zakupa'),(487,1,91,'clients','subscription_periodExpp','Iztek obdobja zakupa'),(488,1,91,'clients','subscription_periodExp','Obdobje se izteče'),(489,1,91,'clients','subscription_periodExt','Podaljšaj zakup za'),(490,1,91,'clients','subscription_ExtAftr','čez'),(491,1,91,'clients','subscription_ExtDay','dni'),(492,1,91,'clients','subscription_periodExtBut','Podaljšaj'),(493,1,91,'clients','subscription_defSet','Privzete nastavitve widgetov'),(494,1,91,'clients','subscription_ww','Širina widgeta'),(495,1,91,'clients','subscription_width','Širina'),(496,1,91,'clients','subscription_alertClientN','Prosim, vnesite ime naročnika!'),(497,1,91,'clients','client_editPro','Projekti'),(498,1,91,'clients','client_editProCli','Projekti tega naročnika'),(499,1,91,'clients','client_editProAdd','Dodaj projekt'),(500,1,91,'clients','client_editTab','Osnovno'),(501,1,91,'clients','client_Change','Spremeni vse že narejene widgete'),(502,1,91,'clients','client_ChangeIfDef','Spremeni že narejene widgete, če so bili nastavljeni na privzet'),(503,1,91,'clients','client_DelClient','Izbriši'),(504,1,91,'clients','client_DelClientAlert1','Izbris naročnika'),(505,1,91,'clients','client_DelClientAlert2','Ali ste prepričani, da želite izbrisati naročnika'),(506,1,91,'users','name','Ime in priimek'),(507,1,91,'users','usr_client','Naročnik'),(508,1,91,'users','profile_drop2','Naročnik'),(509,1,91,'users','permission_profile','Profil pravic'),(510,1,91,'users','new_user','Nov uporabnik'),(511,1,91,'users','users','Uporabniki'),(512,1,91,'users','users_of_client','Uporabniki tega naročnika:'),(513,1,91,'users','all_users','Vsi uporabniki'),(514,1,91,'users','user','Uporabnik'),(515,1,91,'users','email','E-mail'),(516,1,91,'users','password','Geslo'),(517,1,91,'users','repeat_password','Ponovi geslo'),(518,1,91,'users','permissions','Pravice'),(519,1,91,'users','save_as_new_profile','Shrani kot nov profil'),(520,1,91,'default','upload','Naloži'),(521,1,91,'default','choose','Izberi ...'),(522,1,91,'default','cancel','Prekliči'),(523,1,91,'default','save','Shrani'),(524,1,91,'default','discard','Zavrzi'),(525,1,91,'default','delete','Izbriši'),(526,1,91,'default','ok','V redu'),(527,1,91,'users','custom','Po meri'),(528,1,91,'users','profile','Profil'),(529,1,91,'default','profile_drop1','Administrator'),(530,1,91,'default','editor','Urednik'),(1186,1,91,'permission','display_settings','Prikaz gumba za nastavitve (graf, tabela)'),(1185,1,46,'permission','display_settings','Display settings button (graph, table)'),(1184,1,91,'permission','edit_user','Urejanje uporabnikov'),(1183,1,46,'permission','edit_user','Editing users'),(1182,1,91,'permission','add_user','Dodajanje uporabnikov'),(1181,1,46,'permission','add_user','Adding users'),(537,1,91,'users','profile_name','Ime profila'),(538,1,91,'users','delete_profile','Izbriši profil'),(539,1,91,'users','update','Posodobi'),(540,1,91,'users','urs_alertName1','Prosim, vnesite ime uporabnika!'),(541,1,91,'users','urs_alertName2','Prosim, vnesite ime in priimek uporabnika, ločeno s presledkom!'),(542,1,91,'users','urs_alertEmail1','Prosim, vnesite e-naslov uporabnika!'),(543,1,91,'users','urs_alertEmail2','Vpisani elektronski naslov ni veljavne oblike!'),(544,1,91,'users','urs_alertPass1','Prosim, vnesite geslo!'),(545,1,91,'users','urs_alertPass2','Prosim, vpišite geslo dodatno!'),(546,1,91,'users','urs_alertPass3','Gesli se ne ujemata!'),(547,1,91,'users','urs_alertProf','Prosim izberite profil pravic!'),(1180,1,91,'permission','edit_client','Urejanje klientov'),(549,2,91,'login','loginEma','Uporabniško ime ali E-naslov'),(550,2,91,'login','loginPass','Geslo'),(551,2,91,'login','loginFPass','Ste pozabili geslo?'),(552,2,91,'login','loginGoButtn','Prijava'),(553,2,91,'login','loginSendButtn','Pošlji'),(554,2,91,'login','loginSendButtnAlrt','Ta uporabnik ne obstaja'),(555,2,91,'dashboard','tab1','Dashboard'),(556,2,91,'dashboard','tab3','Projekti'),(557,2,91,'dashboard','tab4','Widgeti'),(558,2,91,'dashboard','logout','Odjava'),(559,2,91,'default','close','Zapri'),(560,2,91,'project','project','Projekti'),(561,2,91,'project','include_recearch','Vključenih raziskav'),(1326,1,46,'project','project_color','Color'),(563,2,91,'project','usrName','Ime'),(564,2,91,'project','usrCli','Naročnik'),(565,2,91,'project','usrChooseQ','Prosimo, izberite vprašanje'),(566,2,91,'project','usrResTime','Čas raziskave'),(567,2,91,'project','usrResCross','Brez križanja'),(568,2,91,'project','usrResTotal','SKUPAJ'),(569,2,91,'default','research_preview_export','Izvozi'),(570,2,91,'project','usralertCross1','Tega grafa ni mogoče prikazati brez križanja!'),(571,2,91,'project','usralertCross2','Tega grafa ni mogoče prikazati pri križanju!'),(572,2,91,'project','proj_num','Število'),(573,2,91,'project','proj_proc','Odstotek'),(574,2,91,'default','research_preview_export_i','Slika'),(575,2,91,'default','research_preview_export_w','Widget'),(576,2,91,'widgeti','widgeti','Widgeti'),(577,2,91,'widgeti','widgeti_title','Naziv widgeta'),(578,2,91,'widgeti','widgeti_project','Projekt'),(579,2,91,'widgeti','widgeti_code','Koda'),(580,2,91,'widgeti','widgeti_published','Objavljen'),(581,2,91,'widgeti','widgeti_publish','Objavi'),(582,2,91,'widgeti','widgeti_del_widet','Izbriši widget'),(583,1,46,'research','cancel','Cancel'),(584,1,46,'research','research_exist','Research with that name already exist!'),(585,1,46,'research','ok','Ok'),(586,1,46,'research','research_import_successfu','Research has been successfully imported!'),(587,1,46,'project','project_new','New project'),(588,1,46,'project','project_add_error5','Selected short name is already taken!'),(589,1,46,'project','upload_new_data','Upload new data'),(590,1,91,'project','upload_new_data','Naloži nove podatke'),(591,1,91,'project','project_preview','Predogled'),(592,1,46,'project','project_preview','Preview'),(593,1,91,'project','project_edit','Urejevalnik'),(594,1,46,'project','project_edit','Editor'),(595,1,91,'project','research_time','Čas raziskave'),(596,1,46,'project','research_time','Time of research'),(597,1,46,'project','project_cross','Crossing with:'),(598,1,91,'project','project_cross','Križanje mogoče z'),(599,1,91,'project','project_comment','Komentar'),(600,1,46,'project','project_comment','Comment'),(601,1,91,'project','project_event','Dogodki'),(602,1,46,'project','project_event','Events'),(603,1,46,'project','project_event_add','Add event'),(604,1,91,'project','project_event_add','Dodaj dogodek'),(605,1,91,'project','project_edit_settings','Urejanje projekta'),(606,1,46,'project','project_edit_settings','Edit project'),(607,1,91,'project','save','Shrani'),(608,1,46,'project','save','Save'),(609,1,46,'project','cancel','Cancel'),(610,1,91,'project','cancel','Prekliči'),(611,1,91,'project','missings','Missingi'),(612,1,46,'project','missings','Missings'),(613,1,91,'project','miss_mean_value','Miss s.v.'),(614,1,46,'project','miss_mean_value','Miss m.v.'),(615,1,91,'project','project_edit_settings_hi','Skrij odg'),(616,1,46,'project','project_edit_settings_hi','Hide answ'),(617,1,46,'project','project_edit_settings_q','Question'),(618,1,91,'project','project_edit_settings_q','Vprašanje'),(619,1,91,'project','project_edit_settings_ti','Naslov'),(620,1,46,'project','project_edit_settings_ti','Title'),(621,1,46,'project','project_edit_settings_as','ANSWERS'),(622,1,91,'project','project_edit_settings_as','ODGOVORI'),(623,1,46,'project','project_edit_settings_aA','Add answer'),(624,1,91,'project','project_edit_settings_aA','Dodaj odgovor'),(625,1,46,'project','project_edit_settings_aD','Delete answer'),(626,1,91,'project','project_edit_settings_aD','Odstrani odgovor'),(627,1,46,'project','project_preview_total','TOTAL'),(628,1,91,'project','project_preview_total','SKUPAJ'),(629,1,46,'project','project_preview_cross','Without crossing'),(630,1,91,'project','project_preview_cross','Brez križanja'),(631,1,91,'project','project_cross2','Križanje z'),(632,1,46,'project','project_cross2','Crossing with'),(633,1,46,'project','project_preview_advance1','Table settings'),(634,1,91,'project','project_preview_advance1','Nastavitve za tabelo'),(635,1,46,'project','project_preview_use','Use'),(636,1,91,'project','project_preview_use','Uporabi'),(637,1,46,'project','close','Close'),(638,2,91,'project','close','Zapri'),(639,1,46,'project','save_as_draft','Save as draft'),(640,1,91,'project','save_as_draft','Shrani kot osnutek'),(641,1,46,'project','save_for_client','Save for client'),(642,1,91,'project','save_for_client','Shrani za naročnika'),(643,1,46,'project','delete','Delete'),(644,1,91,'project','delete','Izbriši'),(645,1,91,'project','project_preview_export','Izvozi'),(646,1,46,'project','project_preview_export','Export'),(647,1,46,'research','research_edit_settings_le','LEGEND'),(648,1,91,'research','research_edit_settings_le','LEGENDA'),(649,1,46,'research','research_edit_settings_al','Add legend'),(650,1,91,'research','research_edit_settings_al','Dodaj legendo'),(651,1,46,'research','research_edit_settings_dl','Delete legend'),(652,1,91,'research','research_edit_settings_dl','Odstrani legendo'),(653,1,46,'research','research_calc_weights','Calculate weights'),(654,1,91,'research','research_calc_weights','Izračunaj uteži'),(655,1,46,'users','user_delete','Delete'),(656,1,91,'users','user_delete','Izbriši'),(657,1,46,'users','client','Client'),(658,1,91,'users','client','Naročnik'),(659,1,46,'project','new_template_name_label','Template name'),(660,1,91,'project','new_template_name_label','Ime predloge'),(661,1,46,'project','template_allredy_exists_w','Predloga z takšnim imenom že obstaja. Če jo želite prepisati, kliknite ponovno na gumb \"Shrani\"'),(662,1,91,'project','template_allredy_exists_w','Template with this name already exists. If you wish to override it, click on \"Save\" button'),(663,1,46,'project','graph_right_offset_label','Graph right offset (px)'),(664,1,91,'project','graph_right_offset_label','Odmik grafa desno (px)'),(665,1,46,'project','graph_bottom_offset_label','Graph bottom offset (px)'),(666,1,91,'project','graph_bottom_offset_label','Odmik grafa spodaj (px)'),(667,1,46,'project','graph_top_offset_label','Graph top offset (px)'),(668,1,91,'project','graph_top_offset_label','Odmik grafa zgoraj (px)'),(669,1,46,'project','label_left_offset_label','Label left edge offset (px)'),(670,1,91,'project','label_left_offset_label','Odmik label od levega roba (px)'),(671,1,46,'project','label_break_cb_label','Automatic legend label breaking'),(672,1,91,'project','label_break_cb_label','Avtomatsko lomljenje label legende'),(673,1,46,'project','pie_legend_data_type_none','None'),(674,1,91,'project','pie_legend_data_type_none','Brez'),(675,1,46,'project','pie_legend_data_type_nume','Numerus'),(676,1,91,'project','pie_legend_data_type_nume','Numeric'),(677,1,46,'project','pie_legend_data_type_perc','Procent'),(678,1,91,'project','pie_legend_data_type_perc','Percent'),(679,1,46,'project','pie_legend_label_num','Number of words in pie legend'),(680,1,91,'project','pie_legend_label_num','Št. besed v legendi pite'),(681,1,46,'project','col_turn_Xlabels_on_off','Turn X-axis labels on/off'),(682,1,91,'project','col_turn_Xlabels_on_off','Vklop/izklop label na X-osi'),(683,1,46,'project','col_Xlabels_number_of_wor','Number of words on X-axis labels'),(684,1,91,'project','col_Xlabels_number_of_wor','Št. besed v labelah na X-osi'),(685,1,46,'project','col_number_of_words_on_la','Number of words on label line'),(686,1,91,'project','col_number_of_words_on_la','Št. besed v vrstici labele'),(687,1,46,'project','col_Xlabel_rotation_angle','X-axis label rotation angle'),(688,1,91,'project','col_Xlabel_rotation_angle','Rotacija label na X-osi'),(689,1,46,'project','col_legend_on_off','Legend on/off'),(690,1,91,'project','col_legend_on_off','Vklop/izklop legende'),(691,1,46,'project','col_legend_num_of_words','Number of words in legend'),(692,1,91,'project','col_legend_num_of_words','Št. besed v labelah legende'),(693,1,46,'project','col_legend_automatic_labe','Automatic legend label breaking'),(694,1,91,'project','col_legend_automatic_labe','Avtomatsko lomljenje label legende'),(695,1,46,'project','col_Yaxis_on_off','Y-axis on/off'),(696,1,91,'project','col_Yaxis_on_off','Vklop/izklop Y-osi'),(697,1,46,'project','default_label','Privzeto'),(698,1,91,'project','default_label','Default'),(699,1,46,'project','col_number_steps','Number of steps'),(700,1,91,'project','col_number_steps','Število korakov'),(701,1,46,'project','upper_boundary','Upper boundary'),(702,1,91,'project','upper_boundary','Zgornja meja'),(703,1,46,'project','col_on_off_hor_lines','Horizontal lines on/off'),(704,1,91,'project','col_on_off_hor_lines','Vklop/izklop horizontalnih črt'),(705,1,46,'project','col_on_off_ver_lines','Vertical lines on/off'),(706,1,91,'project','col_on_off_ver_lines','Vklop/izklop vertikalnih črt'),(707,1,46,'project','col_line_shape','Lines shape'),(708,1,91,'project','col_line_shape','Oblika črt'),(709,1,46,'project','col_line_shape_full','Full'),(710,1,91,'project','col_line_shape_full','Polna'),(711,1,46,'project','col_line_shape_dot','Dot'),(712,1,91,'project','col_line_shape_dot','Pika'),(713,1,46,'project','col_line_shape_dash','Dash'),(714,1,91,'project','col_line_shape_dash','Črta'),(715,1,46,'project','col_line_shape_slashdot','Dash-Dot'),(716,1,91,'project','col_line_shape_slashdot','Črta-Pika'),(717,1,46,'project','col_line_with','Line width (px)'),(718,1,91,'project','col_line_with','Debelina črt (px)'),(719,1,46,'project','col_line_color','Line color'),(720,1,91,'project','col_line_color','Barva črt'),(721,1,46,'project','col_graph_settings','Column graph settings'),(722,1,91,'project','col_graph_settings','Nastavitve stolpičnega grafa'),(723,1,46,'project','col_layout','Layout'),(724,1,91,'project','col_layout','Postavitev'),(725,1,46,'project','col_layout_hor','Horizontal'),(726,1,91,'project','col_layout_hor','Horizontalna'),(727,1,46,'project','col_layout_ver','Vertical'),(728,1,91,'project','col_layout_ver','Vertikalna'),(729,1,46,'project','col_rise_fall','Column rise/fall'),(730,1,91,'project','col_rise_fall','Naraščanje/padanje stolpcev'),(731,1,46,'project','col_order_without','Without'),(732,1,91,'project','col_order_without','Brez'),(733,1,46,'project','col_order_asc','Ascending'),(734,1,91,'project','col_order_asc','Naraščajoče'),(735,1,46,'project','col_order_desc','Descending'),(736,1,91,'project','col_order_desc','Padajoče'),(737,1,46,'project','col_sort_by_label','Order by'),(738,1,91,'project','col_sort_by_label','Sortiranje po'),(739,1,46,'project','col_width','Column width (px)'),(740,1,91,'project','col_width','Širina stolpcev (px)'),(741,1,46,'project','col_tick_position','Column tick position'),(742,1,91,'project','col_tick_position','Pozicija kazalca med stolpci'),(743,1,46,'project','col_tick_pos_between','Between column'),(744,1,91,'project','col_tick_pos_between','Med stolpcema'),(745,1,46,'project','col_tick_pos_under','Under column'),(746,1,91,'project','col_tick_pos_under','Pod stolpcem'),(747,1,46,'project','col_label_position','Label position'),(748,1,91,'project','col_label_position','Poravnava label'),(749,1,46,'project','col_label_pos_right','Right'),(750,1,91,'project','col_label_pos_right','Desno'),(751,1,46,'project','col_label_pos_left','Left'),(752,1,91,'project','col_label_pos_left','Levo'),(753,1,46,'project','col_label_pos_center','Center'),(754,1,91,'project','col_label_pos_center','Na sredini'),(755,1,46,'project','col_label_offset','Label offset from X-axis (px)'),(756,1,91,'project','col_label_offset','Odmik label od X-osi (px)'),(757,1,46,'project','col_label_ill_offset','Illegal label offest on corners of X-axis'),(758,1,91,'project','col_label_ill_offset','Nedovoljeno odstopanje label na vogalih X-osi'),(759,1,46,'project','col_show_data_opt','Show info on each column'),(760,1,91,'project','col_show_data_opt','Pokaži nastavitve za podatek na stolpcu'),(761,1,46,'project','col_on_off_col_data','Show/hide column data'),(762,1,91,'project','col_on_off_col_data','Vklop/izklop podatka na stolpcu'),(763,1,46,'project','col_on_off_sum_lab','Show/hide sum labels'),(764,1,91,'project','col_on_off_sum_lab','Vklop/izklop label seštevka'),(765,1,46,'project','col_data_type','Graph data type'),(766,1,91,'project','col_data_type','Vrsta podatka na grafu'),(767,1,46,'project','col_data_type_num','Numeric'),(768,1,91,'project','col_data_type_num','Numerusi'),(769,1,46,'project','col_data_type_perc','Percent'),(770,1,91,'project','col_data_type_perc','Procent'),(771,1,46,'project','col_cross_use_label','From crossing use % of'),(772,1,91,'project','col_cross_use_label','Iz križanj uporabi %'),(773,1,46,'project','col_cross_use_col','Column'),(774,1,91,'project','col_cross_use_col','Stolpec'),(775,1,46,'project','col_cross_use_row','Row'),(776,1,91,'project','col_cross_use_row','Vrsta'),(777,1,46,'project','col_data_pos','Column data position'),(778,1,91,'project','col_data_pos','Pozicija podatka na stolpcu'),(779,1,46,'project','col_data_pos_out','Oustide column'),(780,1,91,'project','col_data_pos_out','Zunaj stolpca'),(781,1,46,'project','col_data_pos_in','Inside column'),(782,1,91,'project','col_data_pos_in','Znotraj stolpca'),(783,1,46,'project','col_data_color','Column data color'),(784,1,91,'project','col_data_color','Barva podatka grafa'),(785,1,46,'project','col_data_size','Column data size (px)'),(786,1,91,'project','col_data_size','Velikost podatkov (px)'),(787,1,46,'project','col_data_offset','Column data offset'),(788,1,91,'project','col_data_offset','Odmik podatka na stolpcu'),(789,1,46,'project','col_data_rotation','Data rotation'),(790,1,91,'project','col_data_rotation','Rotacija podatka'),(791,1,46,'project','col_data_rotation_angle','Angle'),(792,1,91,'project','col_data_rotation_angle','Kot'),(793,1,46,'project','mix_line_setting_lab','Line settings'),(794,1,91,'project','mix_line_setting_lab','Nastavitve črt'),(795,1,46,'project','mix_line_width','Line width (px)'),(796,1,91,'project','mix_line_width','Debelina črt(e) (px)'),(797,1,46,'project','mix_marker_radius','Marker radius (px)'),(798,1,91,'project','mix_marker_radius','Radius markerjev (px)'),(799,1,46,'project','mix_marker_shape_label','Marker shape'),(800,1,91,'project','mix_marker_shape_label','Oblika markerja'),(801,1,46,'project','mix_marker_shape_circle','Circle'),(802,1,91,'project','mix_marker_shape_circle','Korg'),(803,1,46,'project','mix_marker_shape_square','Square'),(804,1,91,'project','mix_marker_shape_square','Kvadrat'),(805,1,46,'project','mix_marker_shape_diam','Diamond'),(806,1,91,'project','mix_marker_shape_diam','Diamant'),(807,1,46,'project','mix_marker_shape_trian','Trangle'),(808,1,91,'project','mix_marker_shape_trian','Trikotnik'),(809,1,46,'project','mix_marker_shape_trian2','Rotated triangle'),(810,1,91,'project','mix_marker_shape_trian2','Rotiran trikotnik'),(811,1,46,'project','line_sett_label','Line graph settings'),(812,1,91,'project','line_sett_label','Nastavitve črtnega grafa'),(813,1,46,'project','line_choose_type','Choose presentation type'),(814,1,91,'project','line_choose_type','Izbira tipa prikaza'),(815,1,46,'project','line_pres_type_lab','Type'),(816,1,91,'project','line_pres_type_lab','Tip'),(817,1,46,'project','line_data_asc_desc','Ascending/descendig data'),(818,1,91,'project','line_data_asc_desc','Naraščanje/padanje podatkov'),(819,1,46,'project','mix_marker_shape_mix','Mixed'),(820,1,91,'project','mix_marker_shape_mix','Mešano'),(821,1,46,'project','line_label_position','Label position'),(822,1,91,'project','line_label_position','Pozicija label med točkami'),(823,1,46,'project','line_label_pos_betw','Between points'),(824,1,91,'project','line_label_pos_betw','Med točkama'),(825,1,46,'project','line_label_pos_under','Under the point'),(826,1,91,'project','line_label_pos_under','Pod točko'),(827,1,46,'project','line_label_pos_left','Left'),(828,1,91,'project','line_label_pos_left','Levo'),(829,1,46,'project','line_label_pos_center','Center'),(830,1,91,'project','line_label_pos_center','Na sredini'),(831,1,46,'project','line_show_data_opt','Show line data options'),(832,1,91,'project','line_show_data_opt','Pokaži nastavitve za podatek na črti'),(833,1,46,'project','line_on_off_col_data','Show/hide line data'),(834,1,91,'project','line_on_off_col_data','Vklop/izklop podatka na črti'),(835,1,46,'project','line_data_offset','Line data offset'),(836,1,91,'project','line_data_offset','Odmik podatka na črti'),(837,1,46,'project','cancle','Cancle'),(838,1,91,'project','cancle','Prekliči'),(839,1,46,'project','pie_sett_label','Pie chart settings'),(840,1,91,'project','pie_sett_label','Nastavitve tortnega grafa'),(841,1,46,'project','pie_radius','Pie radius'),(842,1,91,'project','pie_radius','Velikost pite (radius)'),(843,1,46,'project','pie_show_lab_sett','Show pie labels settings'),(844,1,91,'project','pie_show_lab_sett','Pokaži nastavitve za labele pite'),(845,1,46,'project','pie_lab_on_off','Show/hide pie labels'),(846,1,91,'project','pie_lab_on_off','Vklop/izklop label pite'),(847,1,46,'project','pie_lab_data_lab','Labls only'),(848,1,91,'project','pie_lab_data_lab','Samo labele'),(849,1,46,'project','pie_lab_data_perc','Percents'),(850,1,91,'project','pie_lab_data_perc','Procenti'),(851,1,46,'project','pie_lab_data_num','Numeric'),(852,1,91,'project','pie_lab_data_num','Numerusi'),(853,1,46,'project','pie_lab_data_labs','Labels'),(854,1,91,'project','pie_lab_data_labs','Labele'),(855,1,46,'project','pie_label_pos','Label postition'),(856,1,91,'project','pie_label_pos','Pozicija label'),(857,1,46,'project','pie_label_num_words','Number of words in labels'),(858,1,91,'project','pie_label_num_words','Št. besed v labelah pite'),(859,1,46,'project','pie_label_color','Label color'),(860,1,91,'project','pie_label_color','Barva label'),(861,1,46,'project','pie_inner_radius','Inner circle radius'),(862,1,91,'project','pie_inner_radius','Velikost notranjega kroga (radius)'),(863,1,46,'project','pie_outer_radius','Outer circle radius'),(864,1,91,'project','pie_outer_radius','Velikost zunanjega kroga (radius)'),(865,1,46,'project','pie_inner_lab_opt','Inner circle label options'),(866,1,91,'project','pie_inner_lab_opt','Pokaži nastavitve notranjih label pite'),(867,1,46,'project','pie_inner_lab_num','Number of words in inner labels'),(868,1,91,'project','pie_inner_lab_num','Št. besed v notranjih labelah'),(869,1,46,'project','pie_inner_lab_col','Inner labels color'),(870,1,91,'project','pie_inner_lab_col','Barva notranjih label'),(871,1,46,'project','pie_inner_lab_siz','Inner data size (px)'),(872,1,91,'project','pie_inner_lab_siz','Velikost notranjih podatkov (px)'),(873,1,46,'project','pie_inner_lab_on_off','Show/hide inner pie labels'),(874,1,91,'project','pie_inner_lab_on_off','Vklop/izklop notranjih label pite'),(875,1,46,'project','pie_outer_lab_opt','Show outer pie labels options'),(876,1,91,'project','pie_outer_lab_opt','Pokaži nastavitve zunanjih label pite'),(877,1,46,'project','pie_outer_lab_on_off','Show/hide outer pie labels'),(878,1,91,'project','pie_outer_lab_on_off','Vklop/izklop zunanjih label pite'),(879,1,46,'project','pie_label_pos_in','Inside circle'),(880,1,91,'project','pie_label_pos_in','Znotraj kroga'),(881,1,46,'project','pie_label_pos_out','Outside circle'),(882,1,91,'project','pie_label_pos_out','Zunaj kroga'),(883,1,46,'project','pie_outer_lab_num','Number of words in outer labels'),(884,1,91,'project','pie_outer_lab_num','Št. besed v zunanjih labelah'),(885,1,46,'project','pie_outer_lab_col','Color of outer labels'),(886,1,91,'project','pie_outer_lab_col','Barva zunanjih label'),(887,1,46,'project','pie_outer_data_size','Outer data size (px)'),(888,1,91,'project','pie_outer_data_size','Velikost zunanjih podatkov (px)'),(889,1,46,'project','reset_sesstings','Reset settings'),(890,1,91,'project','reset_sesstings','Razveljavi nastavitve'),(891,1,46,'project','title_set_size_label','Title font size'),(892,1,91,'project','title_set_size_label','Velikost pisave naslova'),(893,1,46,'project','title_align_label','Align title'),(894,1,91,'project','title_align_label','Poravnava naslova'),(895,1,46,'project','title_FontSize_label','Label font size'),(896,1,91,'project','title_FontSize_label','Velikost pisave label'),(897,1,46,'project','labels_font_label','Label font'),(898,1,91,'project','labels_font_label','Pisava label'),(899,1,46,'project','legend_allign_top','Top'),(900,1,91,'project','legend_allign_top','Na vrhu'),(901,1,46,'project','legend_allign_center','Center'),(902,1,91,'project','legend_allign_center','Na sredini'),(903,1,46,'project','legend_allign_bottom','Bottom'),(904,1,91,'project','legend_allign_bottom','Spodaj'),(905,1,46,'project','toolt_on_off','Show/hide tooltip'),(906,1,91,'project','toolt_on_off','Vklop/izklop tooltipa'),(907,1,46,'project','toolt_num','Numbers'),(908,1,91,'project','toolt_num','Numerusi'),(909,1,46,'project','toolt_perc','Percent'),(910,1,91,'project','toolt_perc','Procent'),(911,1,46,'project','toolt_col_perc','Column percent'),(912,1,91,'project','toolt_col_perc','Odstotek stolpca'),(913,1,46,'project','toolt_row_perc','Row percent'),(914,1,91,'project','toolt_row_perc','Odstotek vrstice'),(915,1,46,'project','foot_on_off','Show/hide footnote'),(916,1,91,'project','foot_on_off','Vklop/izklop noge grafa'),(917,1,46,'project','foot_color','Footnote color'),(918,1,91,'project','foot_color','Barva noge'),(919,1,46,'project','foot_font_size','Footnote font size'),(920,1,91,'project','foot_font_size','Velikost pisave noge'),(921,1,46,'project','foot_font','Footnote font'),(922,1,91,'project','foot_font','Pisava noge'),(923,1,46,'project','foot_align','Footnote align'),(924,1,91,'project','foot_align','Poravnava noge'),(925,1,46,'project','foot_offset_bottom','Bottom offset'),(926,1,91,'project','foot_offset_bottom','Odmik od sp. roba'),(929,1,46,'project','chart_use_image','Use image as chart background'),(930,1,91,'project','chart_use_image','Slika za podlogo grafa'),(931,1,46,'project','chart_image_url','Image URL'),(932,1,91,'project','chart_image_url','URL slike'),(933,1,46,'project','chart_image_pos','Position'),(934,1,91,'project','chart_image_pos','Pozicija'),(935,1,46,'project','project_height','Height'),(936,1,91,'project','project_height','Višina'),(937,1,46,'project','chart_series_sett','Chart series settings'),(938,1,91,'project','chart_series_sett','Nastavljanje tipa serij podatkov'),(939,1,46,'project','options_dialog_title','Chart area settings'),(940,1,91,'project','options_dialog_title','Oblikovanje območja grafikona'),(941,1,46,'project','opt_dialog_use_btn','Apply'),(942,1,91,'project','opt_dialog_use_btn','Uporabi'),(943,1,46,'project','opt_dialog_cncl_btn','Close'),(944,1,91,'project','opt_dialog_cncl_btn','Zapri'),(947,1,46,'project','table_show_data_lbl','Show data'),(948,1,91,'project','table_show_data_lbl','Prikaz podatkov'),(949,1,46,'project','table_show_column','column'),(950,1,91,'project','table_show_column','stolpec'),(951,1,46,'project','table_show_row','row'),(952,1,91,'project','table_show_row','vrsta'),(953,1,46,'project','table_for_label','for'),(954,1,91,'project','table_for_label','za'),(955,1,46,'project','map_schoose_tmpl','Choose...'),(956,1,91,'project','map_schoose_tmpl','Izberi...'),(957,1,46,'project','map_new_template','New template'),(958,1,91,'project','map_new_template','Nova predloga'),(959,1,46,'project','map_save_tpl_btn','Save'),(960,1,91,'project','map_save_tpl_btn','Shrani'),(961,1,46,'project','map_add_level','Add level'),(962,1,91,'project','map_add_level','Dodaj nivo'),(963,1,46,'project','map_rem_level','Remove level'),(964,1,91,'project','map_rem_level','Odstrani nivo'),(965,1,46,'project','map_min_lvl_val','Minimal level value'),(966,1,91,'project','map_min_lvl_val','Najmanjša vrednost nivojev'),(967,1,46,'project','map_max_lvl_val','Maximal level value'),(968,1,91,'project','map_max_lvl_val','Največja vrednost nivojev'),(969,1,46,'project','map_reset_levels','Reset levels'),(970,1,91,'project','map_reset_levels','Ponastavi nivoje'),(971,1,46,'project','map_transparency','Terrain transparency'),(972,1,91,'project','map_transparency','Prosojnost terena'),(973,1,46,'project','map_offset_left','Map offset left'),(974,1,91,'project','map_offset_left','Odmik mape levo'),(975,1,46,'project','map_offset_right','Map offset right'),(976,1,91,'project','map_offset_right','Odmik mape desno'),(977,1,46,'project','map_offset_bottom','Map offset bottom'),(978,1,91,'project','map_offset_bottom','Odmik mape spodaj'),(979,1,46,'project','map_offset_up','Map offset up'),(980,1,91,'project','map_offset_up','Odmik mape zgoraj'),(981,1,46,'project','map_show_terrain','Show terrain'),(982,1,91,'project','map_show_terrain','Prikaz terena'),(983,1,46,'project','map_auto_under_lay','Automatically choose underlay'),(984,1,91,'project','map_auto_under_lay','Avtomatska izbira pod-sloja'),(985,1,46,'project','map_limit_left','Border left'),(986,1,91,'project','map_limit_left','Meja levo'),(987,1,46,'project','map_limit_up','Border top'),(988,1,91,'project','map_limit_up','Meja zgoraj'),(989,1,46,'project','map_limit_right','Border right'),(990,1,91,'project','map_limit_right','Meja desno'),(991,1,46,'project','foot_position','Footer position (top/bottom)'),(992,1,91,'project','foot_position','Pozicija noge(zgoraj/spodaj)'),(993,1,46,'project','foot_pos_top','Top'),(994,1,91,'project','foot_pos_top','Zgoraj'),(995,1,46,'project','foot_pos_bottom','Bottom'),(996,1,91,'project','foot_pos_bottom','Spodaj'),(997,1,46,'project','foot_position_2','Footer position (inside/outside)'),(998,1,91,'project','foot_position_2','Pozicija noge(znotraj/zunaj)'),(999,1,46,'project','foot_pos_in','Inside'),(1000,1,91,'project','foot_pos_in','Znotraj'),(1001,1,46,'project','foot_pos_out','Outside'),(1002,1,91,'project','foot_pos_out','Zunaj'),(1003,1,46,'project','no_project_aval','No projects avaliable!'),(1004,1,91,'project','no_project_aval','Ni projektov!'),(1005,1,46,'research','res_preview_export','Export'),(1006,1,91,'research','res_preview_export','Izvozi'),(1007,1,46,'research','res_preview_total','TOTAL'),(1008,1,91,'research','res_preview_total','SKUPAJ'),(1009,1,46,'project','no_users_aval','No users avaliable!'),(1010,1,91,'project','no_users_aval','Ni Uporabnikov!'),(1011,1,46,'project','remove_proj_q','Delete'),(1012,1,91,'project','remove_proj_q','Odstrani'),(1013,1,46,'project','project_total_lab','Total'),(1014,1,91,'project','project_total_lab','Skupaj'),(1015,1,46,'project','project_units_lab','units'),(1016,1,91,'project','project_units_lab','enote'),(1017,1,46,'project','project_shnumber_lab','num.'),(1018,1,91,'project','project_shnumber_lab','št.'),(1019,1,46,'project','project_map_lbl1','Map of regions in Slovenia'),(1020,1,91,'project','project_map_lbl1','Prikaz regij v Sloveniji'),(1021,1,46,'project','project_map_lbl2','Map of Slovenian municipalities'),(1022,1,91,'project','project_map_lbl2','Prikaz občin v Sloveniji'),(1023,1,46,'project','project_map_lbl3','Map of Slovenian constituencies'),(1024,1,91,'project','project_map_lbl3','Prikaz volilnih enot v Sloveniji'),(1025,1,46,'project','project_map_lbl4','Map of Slovenian electoral districts'),(1026,1,91,'project','project_map_lbl4','Prikaz volilnih okrajev v Sloveniji'),(1027,1,46,'project','project_reset_lbl','RESET'),(1028,1,91,'project','project_reset_lbl','PONASTAVI'),(1029,1,46,'project','project_q_base','Base'),(1030,1,91,'project','project_q_base','Osnovna os'),(1031,1,46,'project','project_q_col','Column'),(1032,1,91,'project','project_q_col','Stolpec'),(1033,1,46,'project','project_q_col_add','Add column'),(1034,1,91,'project','project_q_col_add','Dodaj stolpec'),(1035,1,46,'research','res_appearance','Possible appearances'),(1036,1,91,'research','res_appearance','Možne oblike prikaza'),(1037,1,46,'research','res_base_label','Base'),(1038,1,91,'research','res_base_label','Osnova os'),(1039,1,46,'research','res_col_label','Column'),(1040,1,91,'research','res_col_label','Stolpec'),(1041,1,46,'research','res_col_add_label','Add column'),(1042,1,91,'research','res_col_add_label','Dodaj stolpec'),(1043,1,46,'research','res_cross_label','Crossing possible with'),(1044,1,91,'research','res_cross_label','Križanje mogoče z'),(1045,1,46,'research','res_comm_label','Comment'),(1046,1,91,'research','res_comm_label','Komentar'),(1047,1,46,'research','res_events_label','Events'),(1048,1,91,'research','res_events_label','Dogodki'),(1049,1,46,'research','res_event_add_label','Add event'),(1050,1,91,'research','res_event_add_label','Dodaj dogodek'),(1051,1,46,'research','res_map_legend','Legend'),(1052,1,91,'research','res_map_legend','Legenda'),(1053,1,46,'project','proj_map_legend','Legend'),(1054,1,91,'project','proj_map_legend','Legenda'),(1055,1,46,'project','proj_map_legend_from','from'),(1056,1,91,'project','proj_map_legend_from','od'),(1057,1,46,'project','proj_map_legend_to','to'),(1058,1,91,'project','proj_map_legend_to','do'),(1059,1,46,'project','proj_map_legend_more','more than'),(1060,1,91,'project','proj_map_legend_more','več kot'),(1061,1,46,'widgeti','widgeti_reset','Reset'),(1062,1,91,'widgeti','widgeti_reset','Ponastavi'),(1063,1,46,'widgeti','widgeti_edit_proj','Edit project'),(1064,1,91,'widgeti','widgeti_edit_proj','Urejaj projekt'),(1065,1,46,'project','proj_add_data_lbl','Add new data'),(1066,1,91,'project','proj_add_data_lbl','Dodaj nove podatke'),(1067,1,46,'project','proj_spss_file_lbl','SPSS file'),(1068,1,91,'project','proj_spss_file_lbl','SPSS datoteka'),(1069,1,46,'widgeti','widget_author','Author'),(1070,1,91,'widgeti','widget_author','Avtor'),(1071,1,46,'widgeti','widget_tab_noData','No data avaliable'),(1072,1,91,'widgeti','widget_tab_noData','Nobenih podatkov ni na voljo'),(1073,1,46,'widgeti','widget_tab_show1','Showing from _START_ to _END_ of _TOTAL_'),(1074,1,91,'widgeti','widget_tab_show1','Prikazujem _START_ - _END_ od _TOTAL_'),(1075,1,46,'widgeti','widget_tab_show2','Showing 0 of 0 records'),(1076,1,91,'widgeti','widget_tab_show2','Prikazujem 0 od 0 zapisov'),(1077,1,46,'widgeti','widget_tab_filter','filtered from _MAX_ records'),(1078,1,91,'widgeti','widget_tab_filter','filtrirano od _MAX_ vseh zapisov'),(1079,1,46,'widgeti','widget_tab_menu','Show _MENU_ records'),(1080,1,91,'widgeti','widget_tab_menu','Prikaži _MENU_ zapisov'),(1081,1,46,'widgeti','widget_tab_loading','Loading'),(1082,1,91,'widgeti','widget_tab_loading','Nalagam'),(1083,1,46,'widgeti','widget_tab_working','Working'),(1084,1,91,'widgeti','widget_tab_working','Obdelujem'),(1085,1,46,'widgeti','widget_tab_search','Search'),(1086,1,91,'widgeti','widget_tab_search','Išči'),(1087,1,46,'widgeti','widget_tab_noMatch','No matching records'),(1088,1,91,'widgeti','widget_tab_noMatch','Nobeden zapis ne ustreza'),(1089,1,46,'widgeti','widget_tab_first','First'),(1090,1,91,'widgeti','widget_tab_first','Prvi'),(1091,1,46,'widgeti','widget_tab_last','Last'),(1092,1,91,'widgeti','widget_tab_last','Zadnji'),(1093,1,46,'widgeti','widget_tab_next','Next'),(1094,1,91,'widgeti','widget_tab_next','Nasl.'),(1095,1,46,'widgeti','widget_tab_prev','Prev.'),(1096,1,91,'widgeti','widget_tab_prev','Pred.'),(1097,1,46,'widgeti','widget_tab_asc','torn on for ascendig sort'),(1098,1,91,'widgeti','widget_tab_asc','vključite za naraščujoči sort'),(1099,1,46,'widgeti','widget_tab_desc','torn on for descending sort'),(1100,1,91,'widgeti','widget_tab_desc','vključite za padajoči sort'),(1101,1,46,'project','proj_select','Select'),(1102,1,91,'project','proj_select','Izberi'),(1103,1,46,'users','urs_alertName3','Please, enter e-mail!'),(1104,1,91,'users','urs_alertName3','Prosim, vnesite e-mail!'),(1105,1,46,'users','urs_alertName4','Entered e-mail adress is allready used by '),(1106,1,91,'users','urs_alertName4','Vpisani elektronski naslov že obstaja! Uporablja ga'),(1107,1,46,'users','urs_alertName5','Please, select client!'),(1108,1,91,'users','urs_alertName5','Prosim, izberite naročnika!'),(1109,1,46,'users','urs_alertName6','Administrator cannot have a client!'),(1110,1,91,'users','urs_alertName6','Administrator ne more imeti naročnika!'),(1111,1,46,'users','urs_alertName7','Please, enter password!'),(1112,1,91,'users','urs_alertName7','Prosim, vnesite geslo!'),(1113,1,46,'users','urs_alertName8','Please, enter password repeat!'),(1114,1,91,'users','urs_alertName8','Prosim, vnesite ponovljeno geslo!'),(1115,1,46,'users','urs_alertName9','Passwords do not match!'),(1116,1,91,'users','urs_alertName9','Gesli se ne ujemata!'),(1117,1,46,'users','urs_alertName10','Please select a profile, or create a new one!'),(1118,1,91,'users','urs_alertName10','Prosim izberite profil pravic ali ustvarite novega!'),(1119,1,46,'users','urs_alertName11','Please enter user name!'),(1120,1,91,'users','urs_alertName11','Prosim vnesi ime uporabnika!'),(1121,1,46,'users','urs_alertName12','Please enter user email!'),(1122,1,91,'users','urs_alertName12','Prosim vnesite e-mail uporabnika!'),(1123,1,46,'users','urs_alertName13','For selected profile, you have to choose a client!'),(1124,1,91,'users','urs_alertName13','Za izbrani profil pravic morate izbrati naročnika!'),(1125,1,46,'users','urs_alertName14','Administrators cannot have assigned clients! Choose a different profile or remove the client'),(1126,1,91,'users','urs_alertName14','Administratorji ne morejo imeti naročnika! Izberite drug profil pravic ali odstranite naročnika.'),(1127,1,46,'users','urs_alertName15','Please choose a profile!'),(1128,1,91,'users','urs_alertName15','Prosim izberite profil pravic!'),(1129,1,46,'users','urs_alertName16','Passwords do not match!'),(1130,1,91,'users','urs_alertName16','Gesli se ne ujemata!'),(1131,1,46,'users','urs_alertName17','Enter user password!'),(1132,1,91,'users','urs_alertName17','Vnesite geslo uporabnika!'),(1133,1,46,'widgeti','widgeti_delete','Delete'),(1134,1,91,'widgeti','widgeti_delete','Izbriši'),(1135,1,46,'widgets','widget_delete_msg','Do you wish to delete widget '),(1136,1,91,'widgets','widget_delete_msg','Želite odstraniti widget '),(1137,1,46,'users','user_exists','Profile that you defined allready exists!'),(1138,1,91,'users','user_exists','Profil, ki ste ga definirali, že obstaja v bazi!'),(1139,1,46,'users','profile_with_name','Profile with name'),(1140,1,91,'users','profile_with_name','Profil z imenom'),(1141,1,46,'users','allready_exists','allready exists! enter a new name!'),(1142,1,91,'users','allready_exists','že obstaja! Vnesite drugo ime!'),(1143,1,46,'users','has_been_saved','has been saved!'),(1144,1,91,'users','has_been_saved','je bil shranjen!'),(1145,1,46,'users','select_to_delete','Please select profile that you wish to delete!'),(1146,1,91,'users','select_to_delete','Prosim izberite profil, ki ga želite izbrisati!'),(1147,1,46,'users','succ_deleted','Profile has been successfully deleted!'),(1148,1,91,'users','succ_deleted','Profil je bil uspešno izbrisan!'),(1149,1,46,'users','wish_to_del','Profile that you wish to delete, is used by'),(1150,1,91,'users','wish_to_del','Profil, ki ga želite izbrisati uporablja'),(1151,1,46,'users','users_2','users!'),(1152,1,91,'users','users_2','uporabnikov!'),(1179,1,46,'permission','edit_client','Editing clients'),(1178,1,91,'permission','add_client','Dodajanje klientov'),(1177,1,46,'permission','add_client','Adding clients'),(1176,1,91,'permission','edit_research','Urejanje raziskav'),(1175,1,46,'permission','edit_research','Editing researches'),(1174,1,91,'permission','add_research','Dodajanje raziskav'),(1173,1,46,'permission','add_research','Adding researches'),(1172,1,91,'permission','edit_project','Urejanje projektov'),(1171,1,46,'permission','edit_project','Editing projects'),(1170,1,91,'permission','add_project','Dodajanje projektov'),(1169,1,46,'permission','add_project','Adding projects'),(1194,1,91,'users','user_name_label','Naziv'),(1195,1,46,'users','non_defined_profile','Enter the profile name'),(1196,1,91,'users','non_defined_profile','Vnesite ime profila'),(1197,1,46,'users','save_profile_btn','Save profile'),(1198,1,91,'users','save_profile_btn','Shrani profil'),(1199,1,46,'users','delete_profile_q','Do you really wish to delete this profile?'),(1200,1,91,'users','delete_profile_q','Ali res želite izbrisati profil?'),(1203,1,46,'default','alert_msg','Alert'),(1204,1,91,'default','alert_msg','Opozorilo'),(1205,1,46,'default','delete_profile_msg','Do you wish to delete this profile?'),(1206,1,91,'default','delete_profile_msg','Želite izbrisati ta profil?'),(1207,1,46,'default','delete_btn','Delete'),(1208,1,91,'default','delete_btn','Izbriši'),(1209,1,46,'default','cancel_btn','Cancel'),(1210,1,91,'default','cancel_btn','Prekliči'),(1211,1,46,'users','cancel_profile_btn','Cancel'),(1212,1,91,'users','cancel_profile_btn','Prekliči'),(1213,1,46,'permission','export_to_widget','Exporting to widget'),(1214,1,91,'permission','export_to_widget','Izvoz v widget'),(1215,1,46,'permission','delete_widget','Deleting widgets'),(1216,1,91,'permission','delete_widget','Odstranjevanje widgetov'),(1217,1,46,'users','no_client','None'),(1218,1,91,'users','no_client','Brez'),(1219,1,46,'users','delete_title','Delete user'),(1220,1,91,'users','delete_title','Izbris uporabnika'),(1221,1,46,'users','delete_desc','Do you want to delete user'),(1222,1,91,'users','delete_desc','Ali ste prepričani, da želite izbrisati uporabnika'),(1223,1,46,'users','delete_btn','Delete'),(1224,1,46,'users','delete_usr_title','Delete user'),(1225,1,91,'users','delete_usr_title','Izbris uporabnika'),(1226,1,46,'users','delete_usr_desc','Do you want to delete user'),(1227,1,91,'users','delete_usr_desc','Ali ste prepričani, da želite izbrisati uporabnika'),(1228,1,46,'users','delete_usr_btn','Delete'),(1229,1,91,'users','delete_usr_btn','Izbriši'),(1230,1,46,'users','cancel_usr_btn','Cancel'),(1231,1,91,'users','cancel_usr_btn','Prekliči'),(1232,1,46,'default','add_btn','Add'),(1233,1,91,'default','add_btn','Dodaj'),(1234,1,46,'users','urs_alertName18','Please, fill the datefield!'),(1235,1,91,'users','urs_alertName18','Prosim, vnesite datum!'),(1236,1,46,'users','urs_alertName19','Please, enter the client name!'),(1237,1,91,'users','urs_alertName19','Prosim, vnesite ime klienta!'),(1238,1,46,'clients','delete_cli_title','Delete client'),(1239,1,91,'clients','delete_cli_title','Izbris naročnika'),(1240,1,46,'clients','delete_cli_desc','Do dou wish to delete client'),(1241,1,91,'clients','delete_cli_desc','Želite izbrisati naročnika'),(1242,1,46,'clients','delete_cli_btn1','Delete'),(1243,1,91,'clients','delete_cli_btn1','Izbriši'),(1244,1,46,'clients','delete_cli_btn2','Cancel'),(1245,1,91,'clients','delete_cli_btn2','Prekliči'),(1246,1,46,'clients','cli_title','Name'),(1247,1,91,'clients','cli_title','Naziv'),(1248,1,46,'clients','subscription_col','Widget color'),(1249,1,91,'clients','subscription_col','Barva widgetov'),(1250,1,46,'widgets','del_alert_msg','Alert'),(1251,1,91,'widgets','del_alert_msg','Opozorilo'),(1252,1,46,'widgets','del_btn_confirm','Delete'),(1253,1,91,'widgets','del_btn_confirm','Izbriši'),(1254,1,46,'widgets','del_btn_cancel','Cancel'),(1255,1,91,'widgets','del_btn_cancel','Prekliči'),(1256,1,46,'project','add_proj_alert1','Please, enter project title!'),(1257,1,91,'project','add_proj_alert1','Prosim, vnesite naziv projekta!'),(1258,1,46,'project','add_proj_alert2','Please, enter project short name!'),(1259,1,91,'project','add_proj_alert2','Prosim, vnesite  kratek naziv projekta!'),(1260,1,46,'project','add_proj_alert3','Please, select client!'),(1261,1,91,'project','add_proj_alert3','Prosim, izberite klienta!'),(1262,1,46,'project','res_title','Research'),(1263,1,91,'project','res_title','Raziskava'),(1264,1,46,'research','import_res','Import from'),(1265,1,91,'research','import_res','Uvozi z'),(1266,1,46,'research','upload_res','Upload'),(1267,1,91,'research','upload_res','Naloži'),(1268,1,46,'research','new_res','New research'),(1269,1,91,'research','new_res','Nova raziskava'),(1270,1,46,'research','res_upload_title','Title'),(1271,1,91,'research','res_upload_title','Naziv'),(1272,1,46,'research','res_upload_short','Short title'),(1273,1,91,'research','res_upload_short','Kratek naziv'),(1274,1,46,'research','res_upload_file','file'),(1275,1,91,'research','res_upload_file','datoteka'),(1276,1,46,'research','select_project','Select project'),(1277,1,91,'research','select_project','Izberi projekt'),(1278,1,46,'research','research_save_btn','Save'),(1279,1,91,'research','research_save_btn','Shrani'),(1280,1,46,'research','research_cancel_btn','Cancel'),(1281,1,91,'research','research_cancel_btn','Prekliči'),(1282,1,46,'users','profile_ok_btn','Ok'),(1283,1,91,'users','profile_ok_btn','V redu'),(1284,1,46,'users','profile_allready_ex','Profile with selected rights allready exists!'),(1285,1,91,'users','profile_allready_ex','Profil z enakimi pravicami že obstaja!'),(1286,1,46,'research','back_btn','Back'),(1287,1,91,'research','back_btn','Nazaj'),(1288,1,46,'research','discart_btn','Discart'),(1289,1,91,'research','discart_btn','Zavrzi'),(1290,1,46,'project','answers_label','Answers'),(1291,1,91,'project','answers_label','Odgovori'),(1292,1,46,'project','add','Add'),(1293,1,91,'project','add','Dodaj'),(1294,1,46,'project','project_answer_add','Add answer'),(1295,1,91,'project','project_answer_add','Dodaj odgovor'),(1296,1,46,'project','project_questTab','Questions'),(1297,1,91,'project','project_questTab','Vprašanja'),(1298,1,46,'project','project_otherTab','Other'),(1299,1,91,'project','project_otherTab','Ostalo'),(1300,1,46,'project','placeholder_date','Event date'),(1301,1,91,'project','placeholder_date','Datum dogodka'),(1302,1,46,'project','placeholder_text','Description'),(1303,1,91,'project','placeholder_text','Opis'),(1304,1,46,'project','yes','Yes'),(1305,1,91,'project','yes','Da'),(1306,1,46,'project','no','No'),(1307,1,91,'project','no','Ne'),(1308,1,46,'project','discart','Do you wish to discart changes?'),(1309,1,91,'project','discart','Želite preklicati spremembe?'),(1310,1,46,'project','save_for_client_di','Do you wish to save for client?'),(1311,1,91,'project','save_for_client_di','Želite shraniti za naročnika?'),(1312,1,46,'project','save_as_draft_di','Do you wish to save as draft?'),(1313,1,91,'project','save_as_draft_di','Želite shraniti kot osnutek?'),(1314,1,46,'project','delete_proj_di','Do you wish to delete project?'),(1315,1,91,'project','delete_proj_di','Želite izbrisati projekt?'),(1316,1,46,'clients','ok','Ok'),(1317,1,91,'clients','ok','V redu'),(1318,1,46,'clients','client_users','Client users exist'),(1319,1,91,'clients','client_users','Obstajajo uporabniki naročnika'),(1320,1,46,'clients','client','Client'),(1321,1,91,'clients','client','Naročnika'),(1322,1,46,'clients','client_users_desc','cannot be deleted, because there are users that are bind to it. Please delete users from clients first!'),(1323,1,91,'clients','client_users_desc','ni mogoče izbrisati, ker obstajajo uporabniki, ki so vezani nanj! Najprej odstranite uporabnike iz naročnikov!'),(1324,1,46,'project','default_sett','Default settings'),(1325,1,91,'project','default_sett','Privzete nastavitve'),(1330,1,46,'default','chart_err_1','This chart cannot be shown with crossing!'),(1328,1,91,'research','cancel','Prekliči'),(1329,1,91,'research','ok','V redu'),(1331,1,91,'default','chart_err_1','Tega grafa ni mogoče prikazati pri križanju!'),(1332,1,46,'default','chart_err_2','This chart cannot be shown without crossing!'),(1333,1,91,'default','chart_err_2','Tega grafa ni mogoče prikazati brez križanja!'),(1334,1,46,'default','chart_err_3','Pie charts are not supported in scale questions!'),(1335,1,91,'default','chart_err_3','Tortni diagrami niso podprti pri scale vprašanjih!'),(1336,1,46,'default','chart_err_4','To use this chart, time component has to be turned on. You can turn it on in chart settings.'),(1337,1,91,'default','chart_err_4','Pri tem grafu mora biti izbrana časovna komponenta. Izberite jo v oknu za nastavitve grafa.'),(1338,1,46,'default','export_succ','Widget successfully exported!'),(1339,1,91,'default','export_succ','Widget uspešno izvožen!'),(1340,1,46,'users','input_err_msg','Data input error!'),(1341,1,91,'users','input_err_msg','Napaka pri vnosu podatkov!'),(1342,1,46,'clients','client_err_longname','Please, enter clients full name!'),(1343,1,91,'clients','client_err_longname','Prosim, vnesite polni naziv naročnika!'),(1344,1,46,'users','usr_profile_alert1','Profile is assigned to some user or a group of them.'),(1345,1,91,'users','usr_profile_alert1','Profil je dodeljen uporabnikom.'),(1346,1,46,'users','num_of_users','users. First change profiles of these users.'),(1347,1,91,'users','num_of_users','uporabnikov. Najprej spremenite profil uporabnikov.'),(1348,1,46,'users','no_profile_selected','No profile selected.'),(1349,1,91,'users','no_profile_selected','Ni izbranega profila.'),(1350,1,46,'users','select_profile_msg','Please select a prfile, that you wish to delete.'),(1351,1,91,'users','select_profile_msg','Prosim izberite profil pravic, ki ga želite izbrisati'),(1352,1,46,'default','language','Language'),(1353,1,91,'default','language','Jezik'),(1354,1,46,'users','new_password','New password'),(1355,1,91,'users','new_password','Novo geslo'),(1356,1,46,'research','res_import_err1','Please, enter research title!'),(1357,1,91,'research','res_import_err1','Prosim, vnesite naziv raziskave!'),(1358,1,46,'research','res_import_err2','Short name can contain only letters, numbers(except at the begining) and underscores!'),(1359,1,91,'research','res_import_err2','Kratko ime lahko vsebuje le črke brez šumnikov, številke(razen na začetku) ter podčrtaje!'),(1360,1,46,'research','res_import_err3','Select SPSS file!'),(1361,1,91,'research','res_import_err3','Izberite SPSS datoteko!'),(1362,1,46,'research','res_import_err4','Typed short name is allready taken!'),(1363,1,91,'research','res_import_err4','Izbrano kratko ime je žal že zasedeno!'),(1364,1,46,'research','res_import_err5','Please, enter the research short name!'),(1365,1,91,'research','res_import_err5','Prosim, vnesite kratek naziv raziskave!'),(1366,1,46,'login','login_err1','Login unsuccessful!'),(1367,1,91,'login','login_err1','Prijava neuspešna!'),(1368,1,46,'login','login_err2','Please try again'),(1369,1,91,'login','login_err2','Poskusite znova'),(1370,1,46,'login','forgotenPass_text','Trust us your email and we will shortly send you a new password.'),(1371,1,91,'login','forgotenPass_text','Zaupajte nam vaš email naslov in novo geslo boste v kratkem prejeli nanj.'),(1372,1,46,'login','forgotenPass_btn','Send'),(1373,1,91,'login','forgotenPass_btn','Pošlji'),(1374,1,46,'login','pass_reset_err1','Error: Email could not be sent.'),(1375,1,91,'login','pass_reset_err1','Napaka: Emaila ni bilo mogoče poslati.'),(1376,1,46,'login','pass_reset_err2','Error: Exceeded the number of trials. Try again in 15 minutes.'),(1377,1,91,'login','pass_reset_err2','Napaka: Preseženo število poizkusov. Poskusite znova čez 15 min.'),(1378,1,46,'login','pass_reset_err3','User with this email does not exist.'),(1379,1,91,'login','pass_reset_err3','Uporabnik z tem emailom ne obstaja.'),(1380,1,46,'login','pass_reset_ok','Email has been sent to the provided address.'),(1381,1,91,'login','pass_reset_ok','Email je bil poslan na podan naslov.'),(1382,1,46,'login','email_subject','New password request'),(1383,1,91,'login','email_subject','Zahteva za novo geslo'),(1384,1,46,'login','email_body','You have requested password reset on <b>Statview</b> portal.<br /><br />To execute this action, click on the following link:'),(1385,1,91,'login','email_body','Zahtevali ste ponovno generiranje uporabniškega gesla na portalu <b>Statview</b><br /><br />Za spremembo gesla obiščite naslednji naslov:'),(1386,1,46,'login','email_altbody','You have requested password reset on Statview portal. To execute this action, click on the following link:'),(1387,1,91,'login','email_altbody','Zahtevali ste ponovno generiranje uporabniškega gesla na portalu <b>Statview</b><br /><br />Za spremembo gesla obiščite naslednji naslov:'),(1388,1,46,'login','reset_pass','Reset password'),(1389,1,91,'login','reset_pass','Ponastavi geslo'),(1390,1,46,'login','email_not_provided','No email given.'),(1391,1,91,'login','email_not_provided','Email ni bil posredovan.'),(1392,1,46,'users','username','Username'),(1393,1,91,'users','username','Uporabniško ime'),(1394,1,46,'users','urs_alertName20','Please, enter username'),(1395,1,91,'users','urs_alertName20','Prosim, vnesite uporabniško ime'),(1396,1,46,'users','urs_alertName21','Given username is allready taken'),(1397,1,91,'users','urs_alertName21','Navedeno uporabniško ime je že zasedeno'),(1398,1,46,'users','urs_alertName22','Email is not in correct form'),(1399,1,91,'users','urs_alertName22','Email ni prave oblike'),(1400,1,46,'login','loginPass_repeat','Repeat password'),(1401,1,91,'login','loginPass_repeat','Ponovi geslo'),(1402,1,46,'login','password_reset','Password reset'),(1403,1,91,'login','password_reset','Ponastavitev gesla'),(1404,1,46,'login','forgotten_password','Forgotten password'),(1405,1,91,'login','forgotten_password','Pozabljeno geslo'),(1406,1,46,'login','login','Log in'),(1407,1,91,'login','login','Prijava'),(1408,1,46,'login','pass_reset_succ','Password successfully changed.'),(1409,1,91,'login','pass_reset_succ','Geslo uspešno spremenjeno.'),(1410,1,46,'login','pass_reset_err4','This request has expired.'),(1411,1,91,'login','pass_reset_err4','Zahteva za spremembo gesla je potekla.'),(1412,1,46,'login','pass_reset_err5','User does not exist.'),(1413,1,91,'login','pass_reset_err5','Uporabnik ne obstaja.'),(1414,1,46,'login','pass_reset_err6','Password change error.'),(1415,1,91,'login','pass_reset_err6','Napaka pri spremembi gesla.'),(1416,1,46,'login','into_system','into system.'),(1417,1,91,'login','into_system','v sistem.'),(1418,1,46,'login','mail_admin','administrator'),(1419,1,91,'login','mail_admin','skrbnik'),(1420,1,46,'users','show_permissions','Show permissions'),(1421,1,91,'users','show_permissions','Prikaži pravice'),(1422,1,46,'users','hide_permissions','Hide permissions'),(1423,1,91,'users','hide_permissions','Skrij pravice'),(1424,1,46,'users','same_profile_exists','Profile with the same name allready exists'),(1425,1,91,'users','same_profile_exists','Profil z podanim imenom že obstaja'),(1426,1,46,'clients','same_client_exists','Client with this title allredy exists.'),(1427,1,91,'clients','same_client_exists','Klient z tem nazivom že obstaja.'),(1428,1,46,'clients','urs_alertName23','Date is not in right format (d.m.yyyy).'),(1429,1,91,'clients','urs_alertName23','Datum ni v pravi obliki (d.m.llll).'),(1430,1,46,'project','project_eventsTab','Events'),(1431,1,91,'project','project_eventsTab','Dogodki'),(1432,1,46,'project','proj_missingTitleErr','Please, enter project title.'),(1433,1,91,'project','proj_missingTitleErr','Prosim, vnesi naziv projekta.'),(1434,1,46,'dashboard','unnamed_proj_name','Unnamed'),(1435,1,91,'dashboard','unnamed_proj_name','Neimenovan'),(1436,1,46,'widgets','unnamed_widget','Unnamed'),(1437,1,91,'widgets','unnamed_widget','Neimenovan'),(1461,1,91,'dashboard','dash_menu_preview','Predogled'),(1460,1,46,'dashboard','dash_menu_preview','Preview'),(1459,1,91,'dashboard','dash_menu_rename','Preimenuj'),(1458,1,46,'dashboard','dash_menu_rename','Rename'),(1457,1,91,'dashboard','dash_menu_save_as','Shrani kot novo'),(1456,1,46,'dashboard','dash_menu_save_as','Save as new'),(1455,1,91,'dashboard','dash_menu_save','Shrani'),(1454,1,46,'dashboard','dash_menu_save','Save'),(1453,1,91,'dashboard','dash_menu_new','Nov'),(1452,1,46,'dashboard','dash_menu_new','New'),(1462,1,46,'dashboard','dash_menu_export','Export'),(1463,1,91,'dashboard','dash_menu_export','Izvozi'),(1464,1,46,'dashboard','dash_menu_delete','Delete'),(1465,1,91,'dashboard','dash_menu_delete','Izbriši'),(1466,1,46,'dashboard','dash_title_new','New dashboard'),(1467,1,91,'dashboard','dash_title_new','Nov dashboard'),(1468,1,46,'dashboard','dash_select','Select dashboard...'),(1469,1,91,'dashboard','dash_select','Izberi dashboard...'),(1473,1,91,'dashboard','dash_width','Širina'),(1472,1,46,'dashboard','dash_width','Width'),(1474,1,46,'dashboard','dash_height','Height'),(1475,1,91,'dashboard','dash_height','Višina'),(1476,1,46,'dashboard','dash_acc_title1','Widgets'),(1477,1,91,'dashboard','dash_acc_title1','Widgeti'),(1478,1,46,'dashboard','dash_acc_title2','Labels'),(1479,1,91,'dashboard','dash_acc_title2','Napisi'),(1480,1,46,'dashboard','dash_acc_title3','Settings'),(1481,1,91,'dashboard','dash_acc_title3','Nastavitve'),(1482,1,46,'dashboard','dash_label_1','Label to drag'),(1483,1,91,'dashboard','dash_label_1','Napis'),(1497,1,91,'dashboard','dash_sett_auto_fit','Samodejna prilagoditev velikosti območja'),(1496,1,46,'dashboard','dash_sett_auto_fit','Auto fit canvas size'),(1495,1,91,'dashboard','dash_sett_size','Velikost območja'),(1494,1,46,'dashboard','dash_sett_size','Canvas size'),(1493,1,91,'dashboard','dash_sett_color','Barva ozadja'),(1492,1,46,'dashboard','dash_sett_color','Background color'),(1498,1,46,'dashboard','dash_sett_auto','Auto fit'),(1499,1,91,'dashboard','dash_sett_auto','Samodejno obreži'),(1500,1,46,'dashboard','dash_sett_apply','Apply'),(1501,1,91,'dashboard','dash_sett_apply','Uporabi'),(1502,1,46,'dashboard','dash_sett_reset','Reset'),(1503,1,91,'dashboard','dash_sett_reset','Ponastavi'),(1504,1,46,'dashboard','dash_d1_title','Edit label html'),(1505,1,91,'dashboard','dash_d1_title','Urejanje html napisa'),(1506,1,46,'dashboard','dash_d1_placeh','Paste label html here'),(1507,1,91,'dashboard','dash_d1_placeh','Prilepite html napisa tukaj'),(1508,1,46,'dashboard','dash_d2_title','Edit widget'),(1509,1,91,'dashboard','dash_d2_title','Nastavitve widgeta'),(1510,1,46,'dashboard','dash_d2_size','Size'),(1511,1,91,'dashboard','dash_d2_size','Velikost'),(1512,1,46,'dashboard','dash_d2_overflow','Show overflow'),(1513,1,91,'dashboard','dash_d2_overflow','Prikaži scroller'),(1514,1,46,'dashboard','dash_d3_title','Edit label'),(1515,1,91,'dashboard','dash_d3_title','Nastavitve napisa'),(1516,1,46,'dashboard','dash_d5_title','Save dashboard?'),(1517,1,91,'dashboard','dash_d5_title','Shrani dashboard?'),(1518,1,46,'dashboard','dash_d5_content','Dashboard that you\'re working on has not been saved yet. Do you wish to save it?'),(1519,1,91,'dashboard','dash_d5_content','Dashboard še ni bil shranjen. Ga želite shraniti?'),(1520,1,46,'dashboard','dash_d6_title','Delete dashboard'),(1521,1,91,'dashboard','dash_d6_title','Izbriši dashboard'),(1522,1,46,'dashboard','dash_d4_name','Name:'),(1523,1,91,'dashboard','dash_d4_name','Ime:'),(1524,1,46,'dashboard','dash_btn_cancel','Cancel'),(1525,1,91,'dashboard','dash_btn_cancel','Prekliči'),(1526,1,46,'dashboard','dash_btn_yes','Yes'),(1527,1,91,'dashboard','dash_btn_yes','Da'),(1528,1,46,'dashboard','dash_btn_no','No'),(1529,1,91,'dashboard','dash_btn_no','Ne'),(1530,1,46,'dashboard','dash_msg_saved','Saved'),(1531,1,91,'dashboard','dash_msg_saved','Shranjeno'),(1532,1,46,'dashboard','dash_d6_question','Do you want to delete'),(1533,1,91,'dashboard','dash_d6_question','Želite izbrisati'),(1534,1,46,'dashboard','dash_prev_title','Dashboard preview'),(1535,1,91,'dashboard','dash_prev_title','Predogled dashboarda'),(1536,1,46,'dashboard','dash_rename_title','Rename dashboard'),(1537,1,91,'dashboard','dash_rename_title','Preimenovanje dashboarda'),(1538,1,46,'dashboard','dash_saveas_title','Save dashboard as'),(1539,1,91,'dashboard','dash_saveas_title','Shrani dashboard kot'),(1540,1,46,'dashboard','dash_save_title','Save dashboard'),(1541,1,91,'dashboard','dash_save_title','Shrani dashboard'),(1542,1,46,'dashboard','dash_name_err1','Name is required!'),(1543,1,91,'dashboard','dash_name_err1','Ime je obvezno!'),(1544,1,46,'dashboard','dash_name_err2','Provided name is too long!<br />200 letters maximal.'),(1545,1,91,'dashboard','dash_name_err2','Podano ime je predolgo!<br>Maksimalna dolžina 200 črk.'),(1546,1,46,'dashboard','dash_name_err3','No special characters allowed!<br />Only letters, numbers and underlines.'),(1547,1,91,'dashboard','dash_name_err3','Posebni znaki niso dovoljeni!<br>Samo črke, številke in podčrtaji.'),(1548,1,46,'dashboard','dash_name_err4','Name is allready taken!'),(1549,1,91,'dashboard','dash_name_err4','Podano je že zasedeno.'),(1550,1,91,'project','std_dev','Standardni odklon'),(1551,1,46,'project','std_dev','Standard deviation'),(1552,1,91,'project','variation','Varianca'),(1553,1,46,'project','variation','Variation'),(1554,1,46,'project','project_date','Date'),(1555,1,91,'project','project_date','Datum'),(1556,1,46,'project','custom_color_scheme','Custom color scheme'),(1557,1,91,'project','custom_color_scheme','Prilagojena barvna shema'),(1558,1,46,'project','color','Color'),(1559,1,91,'project','color','Barva');
/*!40000 ALTER TABLE `_languagePack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_languagePack1`
--

DROP TABLE IF EXISTS `_languagePack1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_languagePack1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_programme` tinyint(4) NOT NULL,
  `id_language` mediumint(9) NOT NULL,
  `sub_page` varchar(25) CHARACTER SET utf8 NOT NULL,
  `translate_key` varchar(25) CHARACTER SET utf8 NOT NULL,
  `translate_text` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_select` (`id_programme`,`id_language`,`sub_page`,`translate_key`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_languagePack1`
--

LOCK TABLES `_languagePack1` WRITE;
/*!40000 ALTER TABLE `_languagePack1` DISABLE KEYS */;
INSERT INTO `_languagePack1` VALUES (1,1,91,'dashboard','tab1','Dashboard'),(2,1,91,'dashboard','tab2','Raziskave'),(3,1,91,'dashboard','tab3','Naročniki in projekti'),(4,1,91,'dashboard','tab4','Uporabniki'),(5,1,91,'dashboard','logout','Odjava'),(6,2,91,'head','logout','Odjava'),(7,1,91,'users','client','Naročnik'),(8,1,91,'users','name','Ime in priimek'),(9,1,91,'users','permission_profile','Profil pravic'),(10,1,91,'users','new_user','Nov uporabnik'),(11,1,91,'users','users','Uporabniki'),(12,1,91,'users','users_of_client','Uporabniki tega naročnika:'),(13,1,91,'users','all_users','Vsi uporabniki'),(14,1,91,'users','user','Uporabnik'),(15,1,91,'users','email','E-mail'),(16,1,91,'users','password','Geslo'),(17,1,91,'users','repeat_password','Ponovi geslo'),(18,1,91,'users','permissions','Pravice'),(19,1,91,'users','save_as_new_profile','Shrani kot nov profil'),(24,1,91,'default','choose','Izberi ...'),(22,1,91,'default','cancel','Prekliči'),(23,1,91,'default','save','Shrani'),(25,1,91,'users','custom','Po meri'),(26,1,91,'users','profile','Profil'),(27,1,91,'default','admin','Administrator'),(28,1,91,'default','editor','Urednik'),(29,1,91,'permission','rule_assignment','Sme dodeljevati pravice'),(30,1,91,'permission','changing_of_display_form','Sme določati obliko prikaza'),(31,1,91,'permission','changing_display_width','Sme spreminjati širino prikaza'),(32,1,91,'permission','allow_crossing_over','Sme določati križanje'),(33,1,91,'permission','changing_color_scheme','Sme spreminjati barvno shemo'),(34,1,91,'permission','export_from_website','Sme izvažati iz spletne strani'),(35,1,91,'users','profile_name','Ime profila'),(36,1,91,'users','delete_profile','Izbriši profil'),(37,1,91,'users','update','Posodobi'),(38,1,91,'clients','months','mesecev'),(39,1,91,'clients','month','mesec'),(40,1,91,'clients','years','let'),(41,1,91,'permission','display_settings','Sme določati nastavitve tabel, grafov in map');
/*!40000 ALTER TABLE `_languagePack1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_languagePackProgramm`
--

DROP TABLE IF EXISTS `_languagePackProgramm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_languagePackProgramm` (
  `id_programme` tinyint(3) NOT NULL AUTO_INCREMENT,
  `text` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id_programme` (`id_programme`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_languagePackProgramm`
--

LOCK TABLES `_languagePackProgramm` WRITE;
/*!40000 ALTER TABLE `_languagePackProgramm` DISABLE KEYS */;
INSERT INTO `_languagePackProgramm` VALUES (1,'administrator'),(2,'client');
/*!40000 ALTER TABLE `_languagePackProgramm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_layer_interconnection`
--

DROP TABLE IF EXISTS `_layer_interconnection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_layer_interconnection` (
  `category` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `parent_name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `child_id` int(11) NOT NULL,
  `child_name` varchar(40) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_layer_interconnection`
--

LOCK TABLES `_layer_interconnection` WRITE;
/*!40000 ALTER TABLE `_layer_interconnection` DISABLE KEYS */;
INSERT INTO `_layer_interconnection` VALUES (1,1,'Pomurska',2,'Beltinci'),(1,1,'Pomurska',10,'Tišina'),(1,1,'Pomurska',15,'Črenšovci'),(1,1,'Pomurska',29,'Gornja Radgona'),(1,1,'Pomurska',31,'Gornji Petrovci'),(1,1,'Pomurska',33,'Šalovci'),(1,1,'Pomurska',47,'Kobilje'),(1,1,'Pomurska',56,'Kuzma'),(1,1,'Pomurska',59,'Lendava/Lendva'),(1,1,'Pomurska',63,'Ljutomer'),(1,1,'Pomurska',78,'Moravske Toplice'),(1,1,'Pomurska',80,'Murska Sobota'),(1,1,'Pomurska',86,'Odranci'),(1,1,'Pomurska',97,'Puconci'),(1,1,'Pomurska',100,'Radenci'),(1,1,'Pomurska',105,'Rogašovci'),(1,1,'Pomurska',116,'Sveti Jurij ob Ščavnici'),(1,1,'Pomurska',132,'Turnišče'),(1,1,'Pomurska',152,'Cankova'),(1,1,'Pomurska',156,'Dobrovnik/Dobronak'),(1,1,'Pomurska',158,'Grad'),(1,1,'Pomurska',161,'Hodoš/Hodos'),(1,1,'Pomurska',166,'Križevci'),(1,1,'Pomurska',176,'Razkrižje'),(1,1,'Pomurska',187,'Velika Polana'),(1,1,'Pomurska',188,'Veržej'),(1,1,'Pomurska',195,'Apače'),(1,2,'Podravska',18,'Destrnik'),(1,2,'Podravska',24,'Dornava'),(1,2,'Podravska',26,'Duplek'),(1,2,'Podravska',28,'Gorišnica'),(1,2,'Podravska',42,'Juršinci'),(1,2,'Podravska',45,'Kidričevo'),(1,2,'Podravska',55,'Kungota'),(1,2,'Podravska',58,'Lenart'),(1,2,'Podravska',69,'Majšperk'),(1,2,'Podravska',70,'Maribor'),(1,2,'Podravska',87,'Ormož'),(1,2,'Podravska',89,'Pesnica'),(1,2,'Podravska',96,'Ptuj'),(1,2,'Podravska',98,'Rače - Fram'),(1,2,'Podravska',108,'Ruše'),(1,2,'Podravska',113,'Slovenska Bistrica'),(1,2,'Podravska',115,'Starše'),(1,2,'Podravska',118,'Šentilj'),(1,2,'Podravska',135,'Videm'),(1,2,'Podravska',143,'Zavrč'),(1,2,'Podravska',148,'Benedikt'),(1,2,'Podravska',153,'Cerkvenjak'),(1,2,'Podravska',159,'Hajdina'),(1,2,'Podravska',160,'Hoče - Slivnica'),(1,2,'Podravska',167,'Lovrenc na Pohorju'),(1,2,'Podravska',168,'Markovci'),(1,2,'Podravska',169,'Miklavž na Dravskem polju'),(1,2,'Podravska',171,'Oplotnica'),(1,2,'Podravska',172,'Podlehnik'),(1,2,'Podravska',178,'Selnica ob Dravi'),(1,2,'Podravska',181,'Sveta Ana'),(1,2,'Podravska',182,'Sveti Andraž v Slov. goricah'),(1,2,'Podravska',185,'Trnovska vas'),(1,2,'Podravska',191,'Žetale'),(1,2,'Podravska',196,'Cirkulane'),(1,2,'Podravska',198,'Makole'),(1,2,'Podravska',200,'Poljčane'),(1,2,'Podravska',202,'Središče ob Dravi'),(1,2,'Podravska',204,'Sveta Trojica v Slov. goricah'),(1,2,'Podravska',205,'Sveti Tomaž'),(1,2,'Podravska',210,'Sveti Jurij v Slov. goricah'),(1,3,'Koroška',16,'Črna na Koroškem'),(1,3,'Koroška',25,'Dravograd'),(1,3,'Koroška',74,'Mežica'),(1,3,'Koroška',76,'Mislinja'),(1,3,'Koroška',81,'Muta'),(1,3,'Koroška',93,'Podvelka'),(1,3,'Koroška',101,'Radlje ob Dravi'),(1,3,'Koroška',103,'Ravne na Koroškem'),(1,3,'Koroška',112,'Slovenj Gradec'),(1,3,'Koroška',141,'Vuzenica'),(1,3,'Koroška',175,'Prevalje'),(1,3,'Koroška',177,'Ribnica na Pohorju'),(1,4,'Savinjska',11,'Celje'),(1,4,'Savinjska',30,'Gornji Grad'),(1,4,'Savinjska',51,'Kozje'),(1,4,'Savinjska',57,'Laško'),(1,4,'Savinjska',62,'Ljubno'),(1,4,'Savinjska',67,'Luče'),(1,4,'Savinjska',79,'Mozirje'),(1,4,'Savinjska',83,'Nazarje'),(1,4,'Savinjska',92,'Podčetrtek'),(1,4,'Savinjska',99,'Radeče'),(1,4,'Savinjska',106,'Rogaška Slatina'),(1,4,'Savinjska',107,'Rogatec'),(1,4,'Savinjska',114,'Slovenske Konjice'),(1,4,'Savinjska',120,'Šentjur '),(1,4,'Savinjska',124,'Šmarje pri Jelšah'),(1,4,'Savinjska',125,'Šmartno ob Paki'),(1,4,'Savinjska',126,'Šoštanj'),(1,4,'Savinjska',127,'Štore'),(1,4,'Savinjska',133,'Velenje'),(1,4,'Savinjska',137,'Vitanje'),(1,4,'Savinjska',139,'Vojnik'),(1,4,'Savinjska',144,'Zreče'),(1,4,'Savinjska',149,'Bistrica ob Sotli'),(1,4,'Savinjska',151,'Braslovče'),(1,4,'Savinjska',154,'Dobje'),(1,4,'Savinjska',155,'Dobrna'),(1,4,'Savinjska',173,'Polzela'),(1,4,'Savinjska',174,'Prebold'),(1,4,'Savinjska',180,'Solčava'),(1,4,'Savinjska',184,'Tabor'),(1,4,'Savinjska',189,'Vransko'),(1,4,'Savinjska',190,'Žalec'),(1,4,'Savinjska',209,'Rečica ob Savinji'),(1,5,'Zasavska',34,'Hrastnik'),(1,5,'Zasavska',129,'Trbovlje'),(1,5,'Zasavska',142,'Zagorje ob Savi'),(1,6,'Spodnjeposavska',9,'Brežice'),(1,6,'Spodnjeposavska',54,'Krško'),(1,6,'Spodnjeposavska',110,'Sevnica'),(1,6,'Spodnjeposavska',197,'Kostanjevica na Krki'),(1,7,'Jugovzhodna Slovenija',17,'Črnomelj'),(1,7,'Jugovzhodna Slovenija',48,'Kočevje'),(1,7,'Jugovzhodna Slovenija',66,'Loški Potok'),(1,7,'Jugovzhodna Slovenija',73,'Metlika'),(1,7,'Jugovzhodna Slovenija',85,'Novo mesto'),(1,7,'Jugovzhodna Slovenija',88,'Osilnica'),(1,7,'Jugovzhodna Slovenija',104,'Ribnica'),(1,7,'Jugovzhodna Slovenija',109,'Semič'),(1,7,'Jugovzhodna Slovenija',119,'Šentjernej'),(1,7,'Jugovzhodna Slovenija',121,'Škocjan'),(1,7,'Jugovzhodna Slovenija',130,'Trebnje'),(1,7,'Jugovzhodna Slovenija',157,'Dolenjske Toplice'),(1,7,'Jugovzhodna Slovenija',165,'Kostel'),(1,7,'Jugovzhodna Slovenija',170,'Mirna Peč'),(1,7,'Jugovzhodna Slovenija',179,'Sodražica'),(1,7,'Jugovzhodna Slovenija',193,'Žužemberk'),(1,7,'Jugovzhodna Slovenija',199,'Mokronog - Trebelno'),(1,7,'Jugovzhodna Slovenija',203,'Straža'),(1,7,'Jugovzhodna Slovenija',206,'Šmarješke Toplice'),(1,7,'Jugovzhodna Slovenija',211,'Šentrupert'),(1,7,'Jugovzhodna Slovenija',212,'Mirna'),(1,8,'Osrednjeslovenska',5,'Borovnica'),(1,8,'Osrednjeslovenska',8,'Brezovica'),(1,8,'Osrednjeslovenska',20,'Dobrepolje'),(1,8,'Osrednjeslovenska',21,'Dobrova - Polhov Gradec'),(1,8,'Osrednjeslovenska',22,'Dol pri Ljubljani'),(1,8,'Osrednjeslovenska',23,'Domžale'),(1,8,'Osrednjeslovenska',32,'Grosuplje'),(1,8,'Osrednjeslovenska',37,'Ig'),(1,8,'Osrednjeslovenska',39,'Ivančna Gorica'),(1,8,'Osrednjeslovenska',43,'Kamnik'),(1,8,'Osrednjeslovenska',60,'Litija'),(1,8,'Osrednjeslovenska',61,'Ljubljana'),(1,8,'Osrednjeslovenska',64,'Logatec'),(1,8,'Osrednjeslovenska',68,'Lukovica'),(1,8,'Osrednjeslovenska',71,'Medvode'),(1,8,'Osrednjeslovenska',72,'Mengeš'),(1,8,'Osrednjeslovenska',77,'Moravče'),(1,8,'Osrednjeslovenska',123,'Škofljica'),(1,8,'Osrednjeslovenska',134,'Velike Lašče'),(1,8,'Osrednjeslovenska',138,'Vodice'),(1,8,'Osrednjeslovenska',140,'Vrhnika'),(1,8,'Osrednjeslovenska',162,'Horjul'),(1,8,'Osrednjeslovenska',164,'Komenda'),(1,8,'Osrednjeslovenska',186,'Trzin'),(1,8,'Osrednjeslovenska',194,'Šmartno pri Litiji'),(1,8,'Osrednjeslovenska',208,'Log - Dragomer'),(1,9,'Gorenjska',3,'Bled'),(1,9,'Gorenjska',4,'Bohinj'),(1,9,'Gorenjska',12,'Cerklje na Gorenjskem'),(1,9,'Gorenjska',27,'Gorenja vas - Poljane'),(1,9,'Gorenjska',41,'Jesenice'),(1,9,'Gorenjska',52,'Kranj'),(1,9,'Gorenjska',53,'Kranjska Gora'),(1,9,'Gorenjska',82,'Naklo'),(1,9,'Gorenjska',95,'Preddvor'),(1,9,'Gorenjska',102,'Radovljica'),(1,9,'Gorenjska',117,'Šenčur'),(1,9,'Gorenjska',122,'Škofja Loka'),(1,9,'Gorenjska',131,'Tržič'),(1,9,'Gorenjska',146,'Železniki'),(1,9,'Gorenjska',147,'Žiri'),(1,9,'Gorenjska',163,'Jezersko'),(1,9,'Gorenjska',192,'Žirovnica'),(1,9,'Gorenjska',207,'Gorje'),(1,10,'Notranjsko-kraška',13,'Cerknica'),(1,10,'Notranjsko-kraška',38,'Ilirska Bistrica'),(1,10,'Notranjsko-kraška',65,'Loška dolina'),(1,10,'Notranjsko-kraška',91,'Pivka'),(1,10,'Notranjsko-kraška',94,'Postojna'),(1,10,'Notranjsko-kraška',150,'Bloke'),(1,11,'Goriška',1,'Ajdovščina'),(1,11,'Goriška',6,'Bovec'),(1,11,'Goriška',7,'Brda'),(1,11,'Goriška',14,'Cerkno'),(1,11,'Goriška',36,'Idrija'),(1,11,'Goriška',44,'Kanal'),(1,11,'Goriška',46,'Kobarid'),(1,11,'Goriška',75,'Miren - Kostanjevica'),(1,11,'Goriška',84,'Nova Gorica'),(1,11,'Goriška',128,'Tolmin'),(1,11,'Goriška',136,'Vipava'),(1,11,'Goriška',183,'Šempeter - Vrtojba'),(1,11,'Goriška',201,'Renče - Vogrsko'),(1,12,'Obalno-kraška',19,'Divača'),(1,12,'Obalno-kraška',35,'Hrpelje - Kozina'),(1,12,'Obalno-kraška',40,'Izola/Isola'),(1,12,'Obalno-kraška',49,'Komen'),(1,12,'Obalno-kraška',50,'Koper/Capodistria'),(1,12,'Obalno-kraška',90,'Piran/Pirano'),(1,12,'Obalno-kraška',111,'Sežana'),(2,6,'Novo mesto',6007,'Sevnica'),(2,6,'Novo mesto',6006,'Krško'),(2,6,'Novo mesto',6005,'Brežice'),(2,6,'Novo mesto',6004,'Trebnje'),(2,6,'Novo mesto',6003,'Novo mesto II'),(2,6,'Novo mesto',6002,'Novo mesto I'),(2,6,'Novo mesto',6001,'Črnomelj'),(2,5,'Celje',5011,'Radlje ob Dravi'),(2,5,'Celje',5010,'Ravne na Koroškem'),(2,5,'Celje',5009,'Slovenj Gradec'),(2,5,'Celje',5008,'Velenje II'),(2,5,'Celje',5007,'Velenje I'),(2,5,'Celje',5006,'Mozirje'),(2,5,'Celje',5005,'Žalec II'),(2,5,'Celje',5004,'Žalec I'),(2,5,'Celje',5003,'Celje II'),(2,5,'Celje',5002,'Celje I'),(2,5,'Celje',5001,'Šentjur pri Celju'),(2,4,'Ljubljana Bežigrad',4011,'Domžale II'),(2,4,'Ljubljana Bežigrad',4010,'Domžale I'),(2,4,'Ljubljana Bežigrad',4009,'Ljubljana Bežigrad II'),(2,4,'Ljubljana Bežigrad',4008,'Ljubljana Bežigrad I'),(2,4,'Ljubljana Bežigrad',4007,'Ljubljana Moste - Polje III'),(2,4,'Ljubljana Bežigrad',4006,'Ljubljana Moste - Polje II'),(2,4,'Ljubljana Bežigrad',4005,'Ljubljana Moste - Polje I'),(2,4,'Ljubljana Bežigrad',4004,'Litija'),(2,4,'Ljubljana Bežigrad',4003,'Grosuplje'),(2,4,'Ljubljana Bežigrad',4002,'Ribnica'),(2,4,'Ljubljana Bežigrad',4001,'Kočevje'),(2,3,'Ljubljana Center',3011,'Ljubljana Šiška IV'),(2,3,'Ljubljana Center',3010,'Ljubljana Šiška III'),(2,3,'Ljubljana Center',3009,'Ljubljana Šiška II'),(2,3,'Ljubljana Center',3008,'Ljubljana Šiška I'),(2,3,'Ljubljana Center',3007,'Ljubljana Center'),(2,3,'Ljubljana Center',3006,'Ljubljana Vič - Rudnik IV'),(2,3,'Ljubljana Center',3005,'Ljubljana Vič - Rudnik III'),(2,3,'Ljubljana Center',3004,'Ljubljana Vič - Rudnik II'),(2,3,'Ljubljana Center',3003,'Ljubljana Vič - Rudnik I'),(2,3,'Ljubljana Center',3002,'Vrhnika'),(2,3,'Ljubljana Center',3001,'Logatec'),(2,2,'Postojna',2011,'Ajdovščina'),(2,2,'Postojna',2010,'Nova Gorica II'),(2,2,'Postojna',2009,'Nova Gorica I'),(2,2,'Postojna',2008,'Postojna'),(2,2,'Postojna',2007,'Ilirska Bistrica'),(2,2,'Postojna',2006,'Sežana'),(2,2,'Postojna',2005,'Koper II'),(2,2,'Postojna',2004,'Koper I'),(2,2,'Postojna',2003,'Izola'),(2,2,'Postojna',2002,'Piran'),(2,2,'Postojna',2001,'Tolmin'),(2,1,'Kranj',1011,'Idrija'),(2,1,'Kranj',1010,'Kamnik'),(2,1,'Kranj',1009,'Škofja Loka II'),(2,1,'Kranj',1008,'Škofja Loka I'),(2,1,'Kranj',1007,'Tržič'),(2,1,'Kranj',1006,'Kranj III'),(2,1,'Kranj',1005,'Kranj II'),(2,1,'Kranj',1004,'Kranj I'),(2,1,'Kranj',1003,'Radovljica II'),(2,1,'Kranj',1002,'Radovljica I'),(2,1,'Kranj',1001,'Jesenice'),(2,6,'Novo mesto',6008,'Laško'),(2,6,'Novo mesto',6009,'Hrastnik'),(2,6,'Novo mesto',6010,'Trbovlje'),(2,6,'Novo mesto',6011,'Zagorje ob Savi'),(2,7,'Maribor',7001,'Šmarje pri Jelšah'),(2,7,'Maribor',7002,'Slovenska Bistrica'),(2,7,'Maribor',7003,'Slovenske Konjice'),(2,7,'Maribor',7004,'Ruše'),(2,7,'Maribor',7005,'Maribor I'),(2,7,'Maribor',7006,'Maribor II'),(2,7,'Maribor',7007,'Maribor III'),(2,7,'Maribor',7008,'Maribor IV'),(2,7,'Maribor',7009,'Maribor V'),(2,7,'Maribor',7010,'Maribor VI'),(2,7,'Maribor',7011,'Maribor VII'),(2,8,'Ptuj',8001,'Lendava'),(2,8,'Ptuj',8002,'Ormož'),(2,8,'Ptuj',8003,'Ljutomer'),(2,8,'Ptuj',8004,'Murska Sobota I'),(2,8,'Ptuj',8005,'Murska Sobota II'),(2,8,'Ptuj',8006,'Gornja Radgona'),(2,8,'Ptuj',8007,'Lenart'),(2,8,'Ptuj',8008,'Pesnica'),(2,8,'Ptuj',8009,'Ptuj I'),(2,8,'Ptuj',8010,'Ptuj II'),(2,8,'Ptuj',8011,'Ptuj III');
/*!40000 ALTER TABLE `_layer_interconnection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_map_option_templates`
--

DROP TABLE IF EXISTS `_map_option_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_map_option_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `options` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_map_option_templates`
--

LOCK TABLES `_map_option_templates` WRITE;
/*!40000 ALTER TABLE `_map_option_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `_map_option_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_map_options`
--

DROP TABLE IF EXISTS `_map_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_map_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_question` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `id_project` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `id_answer` tinyint(11) NOT NULL,
  `type` tinyint(11) NOT NULL,
  `sub_type` int(11) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_map_options`
--

LOCK TABLES `_map_options` WRITE;
/*!40000 ALTER TABLE `_map_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `_map_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_password_reset`
--

DROP TABLE IF EXISTS `_password_reset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_password_reset` (
  `pk_id_password_reset` int(11) NOT NULL AUTO_INCREMENT,
  `added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ip_address` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`pk_id_password_reset`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_password_reset`
--

LOCK TABLES `_password_reset` WRITE;
/*!40000 ALTER TABLE `_password_reset` DISABLE KEYS */;
/*!40000 ALTER TABLE `_password_reset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_permission_profiles`
--

DROP TABLE IF EXISTS `_permission_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_permission_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shortName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `profileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL COMMENT '0 - disabled; 1 - enabled ',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_permission_profiles`
--

LOCK TABLES `_permission_profiles` WRITE;
/*!40000 ALTER TABLE `_permission_profiles` DISABLE KEYS */;
INSERT INTO `_permission_profiles` VALUES (1,'admin','Administrator',1);
/*!40000 ALTER TABLE `_permission_profiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_permissions`
--

DROP TABLE IF EXISTS `_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shortName` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT 'translate_key in language table',
  `enabled` tinyint(1) NOT NULL COMMENT '0 - disabled; 1 - enabled ',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_permissions`
--

LOCK TABLES `_permissions` WRITE;
/*!40000 ALTER TABLE `_permissions` DISABLE KEYS */;
INSERT INTO `_permissions` VALUES (1,'add_project',1),(2,'edit_project',1),(3,'add_research',1),(4,'edit_research',1),(5,'add_client',1),(6,'edit_client',1),(7,'add_user',1),(8,'edit_user',1),(9,'display_settings',1),(10,'export_to_widget',1),(11,'delete_widget',1);
/*!40000 ALTER TABLE `_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_permissions_by_p_profiles`
--

DROP TABLE IF EXISTS `_permissions_by_p_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_permissions_by_p_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idProfile` int(11) NOT NULL,
  `idPermission` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_permissions_by_p_profiles`
--

LOCK TABLES `_permissions_by_p_profiles` WRITE;
/*!40000 ALTER TABLE `_permissions_by_p_profiles` DISABLE KEYS */;
INSERT INTO `_permissions_by_p_profiles` VALUES (1,1,1),(2,1,2),(3,1,3),(4,1,4),(5,1,5),(6,1,6),(7,1,7),(8,1,8),(9,1,9),(10,1,10),(11,1,11);
/*!40000 ALTER TABLE `_permissions_by_p_profiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_projects`
--

DROP TABLE IF EXISTS `_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_projects` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `projectName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `longName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `footerText` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lastChangeTime` int(11) unsigned DEFAULT NULL,
  `createDate` datetime NOT NULL,
  `weighted` tinyint(1) NOT NULL DEFAULT '0',
  `isTimed` tinyint(1) NOT NULL DEFAULT '0',
  `created_ux` int(11) unsigned NOT NULL,
  `modified_ux` int(11) unsigned NOT NULL,
  `showWidth` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'check separate table',
  `colorShema` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'check separate table',
  `weightVar` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `ready` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `client` (`projectName`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_projects`
--

LOCK TABLES `_projects` WRITE;
/*!40000 ALTER TABLE `_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_projectsShowTypes`
--

DROP TABLE IF EXISTS `_projectsShowTypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_projectsShowTypes` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_project` int(5) NOT NULL,
  `name_question` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `pie` tinyint(1) NOT NULL,
  `bar` tinyint(1) NOT NULL,
  `line` tinyint(1) NOT NULL,
  `tabl` tinyint(1) NOT NULL,
  `pie1` tinyint(1) NOT NULL,
  `bar1` tinyint(1) NOT NULL,
  `line1` tinyint(1) NOT NULL,
  `tabl1` tinyint(1) NOT NULL,
  `pie2` tinyint(1) NOT NULL,
  `bar2` tinyint(1) NOT NULL,
  `line2` tinyint(1) NOT NULL,
  `tabl2` tinyint(1) NOT NULL,
  `pie3` tinyint(1) NOT NULL,
  `bar3` tinyint(1) NOT NULL,
  `line3` tinyint(1) NOT NULL,
  `tabl3` tinyint(1) NOT NULL,
  `pie4` tinyint(1) NOT NULL,
  `bar4` tinyint(1) NOT NULL,
  `line4` tinyint(1) NOT NULL,
  `tabl4` tinyint(1) NOT NULL,
  `pie5` tinyint(1) NOT NULL,
  `bar5` tinyint(1) NOT NULL,
  `line5` tinyint(1) NOT NULL,
  `tabl5` tinyint(1) NOT NULL,
  `map` tinyint(1) NOT NULL,
  `map1` tinyint(1) NOT NULL,
  `map2` tinyint(1) NOT NULL,
  `map3` tinyint(1) NOT NULL,
  `map4` tinyint(1) NOT NULL,
  `map5` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_research` (`id_project`,`name_question`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_projectsShowTypes`
--

LOCK TABLES `_projectsShowTypes` WRITE;
/*!40000 ALTER TABLE `_projectsShowTypes` DISABLE KEYS */;
/*!40000 ALTER TABLE `_projectsShowTypes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_projects_by_research`
--

DROP TABLE IF EXISTS `_projects_by_research`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_projects_by_research` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_project` int(5) DEFAULT NULL,
  `id_research` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_project` (`id_project`,`id_research`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_projects_by_research`
--

LOCK TABLES `_projects_by_research` WRITE;
/*!40000 ALTER TABLE `_projects_by_research` DISABLE KEYS */;
/*!40000 ALTER TABLE `_projects_by_research` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_research`
--

DROP TABLE IF EXISTS `_research`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_research` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `long_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `weighted` tinyint(1) NOT NULL DEFAULT '0',
  `created_ux` int(11) unsigned NOT NULL,
  `modified_ux` int(11) unsigned NOT NULL,
  `showWidth` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'check separate table',
  `colorShema` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'check separate table',
  `weight_factors` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weightVar` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `created_idUser` int(5) NOT NULL,
  `modified_idUser` int(5) NOT NULL,
  `warpit_project_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `deeted` (`deleted`),
  KEY `warpit_project_id` (`warpit_project_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_research`
--

LOCK TABLES `_research` WRITE;
/*!40000 ALTER TABLE `_research` DISABLE KEYS */;
/*!40000 ALTER TABLE `_research` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_researchShowTypes`
--

DROP TABLE IF EXISTS `_researchShowTypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_researchShowTypes` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_research` int(5) NOT NULL,
  `name_question` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `pie` tinyint(1) NOT NULL,
  `bar` tinyint(1) NOT NULL,
  `line` tinyint(1) NOT NULL,
  `tabl` tinyint(1) NOT NULL,
  `pie1` tinyint(1) NOT NULL,
  `bar1` tinyint(1) NOT NULL,
  `line1` tinyint(1) NOT NULL,
  `tabl1` tinyint(1) NOT NULL,
  `pie2` tinyint(1) NOT NULL,
  `bar2` tinyint(1) NOT NULL,
  `line2` tinyint(1) NOT NULL,
  `tabl2` tinyint(1) NOT NULL,
  `pie3` tinyint(1) NOT NULL,
  `bar3` tinyint(1) NOT NULL,
  `line3` tinyint(1) NOT NULL,
  `tabl3` tinyint(1) NOT NULL,
  `pie4` tinyint(1) NOT NULL,
  `bar4` tinyint(1) NOT NULL,
  `line4` tinyint(1) NOT NULL,
  `tabl4` tinyint(1) NOT NULL,
  `pie5` tinyint(1) NOT NULL,
  `bar5` tinyint(1) NOT NULL,
  `line5` tinyint(1) NOT NULL,
  `tabl5` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_research` (`id_research`,`name_question`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_researchShowTypes`
--

LOCK TABLES `_researchShowTypes` WRITE;
/*!40000 ALTER TABLE `_researchShowTypes` DISABLE KEYS */;
/*!40000 ALTER TABLE `_researchShowTypes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_session_variable`
--

DROP TABLE IF EXISTS `_session_variable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_session_variable` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `id_session` int(6) NOT NULL,
  `variable_value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_id` (`id_session`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_session_variable`
--

LOCK TABLES `_session_variable` WRITE;
/*!40000 ALTER TABLE `_session_variable` DISABLE KEYS */;
INSERT INTO `_session_variable` VALUES (1,1,'UserInfo|a:10:{s:2:\"id\";s:1:\"2\";s:5:\"group\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:9:\"Firstname\";s:13:\"Administrator\";s:7:\"Surname\";s:0:\"\";s:5:\"email\";s:5:\"admin\";s:8:\"language\";s:2:\"46\";s:12:\"country_code\";s:3:\"USA\";s:9:\"LastLogin\";s:19:\"2016-02-11 14:48:20\";s:9:\"user_type\";s:1:\"1\";}UserProfileName|s:13:\"Administrator\";UserPermissions|a:11:{i:0;s:11:\"add_project\";i:1;s:12:\"edit_project\";i:2;s:12:\"add_research\";i:3;s:13:\"edit_research\";i:4;s:10:\"add_client\";i:5;s:11:\"edit_client\";i:6;s:8:\"add_user\";i:7;s:9:\"edit_user\";i:8;s:16:\"display_settings\";i:9;s:16:\"export_to_widget\";i:10;s:13:\"delete_widget\";}'),(2,2,'UserInfo|a:10:{s:2:\"id\";s:1:\"2\";s:5:\"group\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:9:\"Firstname\";s:13:\"Administrator\";s:7:\"Surname\";s:0:\"\";s:5:\"email\";s:5:\"admin\";s:8:\"language\";s:2:\"46\";s:12:\"country_code\";s:3:\"USA\";s:9:\"LastLogin\";s:19:\"2016-02-12 06:46:52\";s:9:\"user_type\";s:1:\"1\";}UserProfileName|s:13:\"Administrator\";UserPermissions|a:11:{i:0;s:11:\"add_project\";i:1;s:12:\"edit_project\";i:2;s:12:\"add_research\";i:3;s:13:\"edit_research\";i:4;s:10:\"add_client\";i:5;s:11:\"edit_client\";i:6;s:8:\"add_user\";i:7;s:9:\"edit_user\";i:8;s:16:\"display_settings\";i:9;s:16:\"export_to_widget\";i:10;s:13:\"delete_widget\";}'),(3,0,'UserInfo|a:10:{s:2:\"id\";s:1:\"2\";s:5:\"group\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:9:\"Firstname\";s:13:\"Administrator\";s:7:\"Surname\";s:0:\"\";s:5:\"email\";s:5:\"admin\";s:8:\"language\";s:2:\"46\";s:12:\"country_code\";s:3:\"USA\";s:9:\"LastLogin\";s:19:\"2016-02-12 07:11:10\";s:9:\"user_type\";s:1:\"1\";}UserProfileName|s:13:\"Administrator\";UserPermissions|a:11:{i:0;s:11:\"add_project\";i:1;s:12:\"edit_project\";i:2;s:12:\"add_research\";i:3;s:13:\"edit_research\";i:4;s:10:\"add_client\";i:5;s:11:\"edit_client\";i:6;s:8:\"add_user\";i:7;s:9:\"edit_user\";i:8;s:16:\"display_settings\";i:9;s:16:\"export_to_widget\";i:10;s:13:\"delete_widget\";}'),(4,33,'UserInfo|a:10:{s:2:\"id\";s:1:\"2\";s:5:\"group\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:9:\"Firstname\";s:13:\"Administrator\";s:7:\"Surname\";s:0:\"\";s:5:\"email\";s:5:\"admin\";s:8:\"language\";s:2:\"46\";s:12:\"country_code\";s:3:\"USA\";s:9:\"LastLogin\";s:19:\"2016-02-12 07:13:16\";s:9:\"user_type\";s:1:\"1\";}UserProfileName|s:13:\"Administrator\";UserPermissions|a:11:{i:0;s:11:\"add_project\";i:1;s:12:\"edit_project\";i:2;s:12:\"add_research\";i:3;s:13:\"edit_research\";i:4;s:10:\"add_client\";i:5;s:11:\"edit_client\";i:6;s:8:\"add_user\";i:7;s:9:\"edit_user\";i:8;s:16:\"display_settings\";i:9;s:16:\"export_to_widget\";i:10;s:13:\"delete_widget\";}'),(5,34,'UserInfo|a:10:{s:2:\"id\";s:1:\"2\";s:5:\"group\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:9:\"Firstname\";s:13:\"Administrator\";s:7:\"Surname\";s:0:\"\";s:5:\"email\";s:5:\"admin\";s:8:\"language\";s:2:\"46\";s:12:\"country_code\";s:3:\"USA\";s:9:\"LastLogin\";s:19:\"2016-02-12 07:16:08\";s:9:\"user_type\";s:1:\"1\";}UserProfileName|s:13:\"Administrator\";UserPermissions|a:11:{i:0;s:11:\"add_project\";i:1;s:12:\"edit_project\";i:2;s:12:\"add_research\";i:3;s:13:\"edit_research\";i:4;s:10:\"add_client\";i:5;s:11:\"edit_client\";i:6;s:8:\"add_user\";i:7;s:9:\"edit_user\";i:8;s:16:\"display_settings\";i:9;s:16:\"export_to_widget\";i:10;s:13:\"delete_widget\";}'),(6,35,'UserInfo|a:10:{s:2:\"id\";s:1:\"2\";s:5:\"group\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:9:\"Firstname\";s:13:\"Administrator\";s:7:\"Surname\";s:0:\"\";s:5:\"email\";s:5:\"admin\";s:8:\"language\";s:2:\"46\";s:12:\"country_code\";s:3:\"USA\";s:9:\"LastLogin\";s:19:\"2016-02-12 07:16:54\";s:9:\"user_type\";s:1:\"1\";}UserProfileName|s:13:\"Administrator\";UserPermissions|a:11:{i:0;s:11:\"add_project\";i:1;s:12:\"edit_project\";i:2;s:12:\"add_research\";i:3;s:13:\"edit_research\";i:4;s:10:\"add_client\";i:5;s:11:\"edit_client\";i:6;s:8:\"add_user\";i:7;s:9:\"edit_user\";i:8;s:16:\"display_settings\";i:9;s:16:\"export_to_widget\";i:10;s:13:\"delete_widget\";}'),(7,36,'UserInfo|a:10:{s:2:\"id\";s:1:\"2\";s:5:\"group\";s:1:\"1\";s:8:\"username\";s:5:\"admin\";s:9:\"Firstname\";s:13:\"Administrator\";s:7:\"Surname\";s:0:\"\";s:5:\"email\";s:5:\"admin\";s:8:\"language\";s:2:\"46\";s:12:\"country_code\";s:3:\"USA\";s:9:\"LastLogin\";s:19:\"2016-02-12 07:19:40\";s:9:\"user_type\";s:1:\"1\";}UserProfileName|s:13:\"Administrator\";UserPermissions|a:11:{i:0;s:11:\"add_project\";i:1;s:12:\"edit_project\";i:2;s:12:\"add_research\";i:3;s:13:\"edit_research\";i:4;s:10:\"add_client\";i:5;s:11:\"edit_client\";i:6;s:8:\"add_user\";i:7;s:9:\"edit_user\";i:8;s:16:\"display_settings\";i:9;s:16:\"export_to_widget\";i:10;s:13:\"delete_widget\";}');
/*!40000 ALTER TABLE `_session_variable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_sliderLabels`
--

DROP TABLE IF EXISTS `_sliderLabels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_sliderLabels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_project` int(11) DEFAULT NULL,
  `questField` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `labelText` text COLLATE utf8_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_sliderLabels`
--

LOCK TABLES `_sliderLabels` WRITE;
/*!40000 ALTER TABLE `_sliderLabels` DISABLE KEYS */;
/*!40000 ALTER TABLE `_sliderLabels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_slider_options`
--

DROP TABLE IF EXISTS `_slider_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_slider_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_question` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `id_project` int(11) NOT NULL,
  `res_ids` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_slider_options`
--

LOCK TABLES `_slider_options` WRITE;
/*!40000 ALTER TABLE `_slider_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `_slider_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_slider_ranged_options`
--

DROP TABLE IF EXISTS `_slider_ranged_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_slider_ranged_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_question` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `id_project` int(11) NOT NULL,
  `res_id_min` text COLLATE utf8_unicode_ci NOT NULL,
  `res_id_max` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_slider_ranged_options`
--

LOCK TABLES `_slider_ranged_options` WRITE;
/*!40000 ALTER TABLE `_slider_ranged_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `_slider_ranged_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_table_options`
--

DROP TABLE IF EXISTS `_table_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_table_options` (
  `pk_id_table_options` int(11) NOT NULL AUTO_INCREMENT,
  `id_project` int(11) NOT NULL,
  `id_question` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `id_cross` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `options` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`pk_id_table_options`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_table_options`
--

LOCK TABLES `_table_options` WRITE;
/*!40000 ALTER TABLE `_table_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `_table_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_user`
--

DROP TABLE IF EXISTS `_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_user` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `group` tinyint(1) DEFAULT NULL COMMENT '1=admin,2=client',
  `username` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `Firstname` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `Surname` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `language` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=169 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_user`
--

LOCK TABLES `_user` WRITE;
/*!40000 ALTER TABLE `_user` DISABLE KEYS */;
INSERT INTO `_user` VALUES (2,1,'admin','98bfe7780b3044eba8560c4a35455a18','Administrator','','admin',46);
/*!40000 ALTER TABLE `_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_user_session`
--

DROP TABLE IF EXISTS `_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_user_session` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `id_ascii_session` char(36) COLLATE utf8_unicode_ci NOT NULL,
  `logged_in` tinyint(1) NOT NULL DEFAULT '0',
  `id_user` int(4) NOT NULL DEFAULT '0',
  `user_type` tinyint(4) NOT NULL,
  `last_impression` datetime NOT NULL,
  `created` datetime NOT NULL,
  `logout` datetime NOT NULL,
  `user_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ascii_session_id` (`id_ascii_session`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_user_session`
--

LOCK TABLES `_user_session` WRITE;
/*!40000 ALTER TABLE `_user_session` DISABLE KEYS */;
INSERT INTO `_user_session` VALUES (1,'i6vhrqfnbs8j58nuh40tfjc201',1,2,1,'2016-02-12 07:11:10','2016-02-11 14:48:20','2016-02-12 07:11:10',''),(2,'ho4nm0k9ve56gigrqhcdvcp6o1',1,2,1,'2016-02-12 07:10:36','2016-02-12 06:46:52','0000-00-00 00:00:00',''),(3,'ka7ib6ak5b9ufshpvuar1i4r70',1,2,1,'2016-02-12 07:11:11','2016-02-12 07:11:10','2016-02-12 07:11:11',''),(4,'qp1nc555rlaoh2qk95g7qj8ju4',1,2,1,'2016-02-12 07:11:11','2016-02-12 07:11:11','2016-02-12 07:11:11',''),(5,'9tf5fsvnh7kqqf42la2b0vanu0',1,2,1,'2016-02-12 07:11:12','2016-02-12 07:11:12','2016-02-12 07:11:12',''),(6,'sehpjs2uk05ahroao1c96fmfh6',1,2,1,'2016-02-12 07:11:12','2016-02-12 07:11:12','2016-02-12 07:11:12',''),(7,'dih538l3tca13nnhdgi429ipf3',1,2,1,'2016-02-12 07:11:13','2016-02-12 07:11:13','2016-02-12 07:11:13',''),(8,'uu36uc2gr2co9ffc2168sf7605',1,2,1,'2016-02-12 07:11:13','2016-02-12 07:11:13','2016-02-12 07:11:13',''),(9,'4cvtubmnkc1bc7anon0qlcbmh3',1,2,1,'2016-02-12 07:11:14','2016-02-12 07:11:14','2016-02-12 07:11:14',''),(10,'mocgu39bn45prjhkjsns8beui5',1,2,1,'2016-02-12 07:11:15','2016-02-12 07:11:14','2016-02-12 07:11:15',''),(11,'kgcldik7fqrno3u50e8hga35g7',1,2,1,'2016-02-12 07:11:15','2016-02-12 07:11:15','2016-02-12 07:11:15',''),(12,'glq12o6j94vn0p3grjsdh1vkh0',1,2,1,'2016-02-12 07:11:16','2016-02-12 07:11:15','2016-02-12 07:11:16',''),(13,'pv8qmdoauc3rpof0vf98iv6rj6',1,2,1,'2016-02-12 07:11:16','2016-02-12 07:11:16','2016-02-12 07:11:16',''),(14,'0cgj74flms157vjasl94od1bi2',1,2,1,'2016-02-12 07:11:17','2016-02-12 07:11:16','2016-02-12 07:11:17',''),(15,'e2ilq1h350c2nk2tvrnnklco76',1,2,1,'2016-02-12 07:11:17','2016-02-12 07:11:17','2016-02-12 07:11:17',''),(16,'44uf7pdqq9cl52qqo1icf1o973',1,2,1,'2016-02-12 07:11:18','2016-02-12 07:11:17','2016-02-12 07:11:18',''),(17,'d5f8hupkqpst2496gb3tsd8tq6',1,2,1,'2016-02-12 07:11:18','2016-02-12 07:11:18','2016-02-12 07:11:18',''),(18,'i6i8ktdgj0bvjerfegdbq1jpi4',1,2,1,'2016-02-12 07:11:19','2016-02-12 07:11:18','2016-02-12 07:11:19',''),(19,'vfp002t61vfl4i298k89ljlse5',1,2,1,'2016-02-12 07:11:19','2016-02-12 07:11:19','2016-02-12 07:11:19',''),(20,'b3q89b2ppep6rai0kqf1bjepp4',1,2,1,'2016-02-12 07:11:20','2016-02-12 07:11:19','2016-02-12 07:11:20',''),(21,'f5irt2kf4ujvvuqit7d0vsqrm2',1,2,1,'2016-02-12 07:11:20','2016-02-12 07:11:20','2016-02-12 07:11:20',''),(22,'jnb4l719njqp2lf3bjte0q5ba4',1,2,1,'2016-02-12 07:11:21','2016-02-12 07:11:20','2016-02-12 07:11:21',''),(23,'oo3gsn382f610sugmj3igm4qm7',1,2,1,'2016-02-12 07:11:21','2016-02-12 07:11:21','2016-02-12 07:11:21',''),(24,'6ojb92g2isbr3mb9mp9agp32t4',1,2,1,'2016-02-12 07:11:22','2016-02-12 07:11:21','2016-02-12 07:11:22',''),(25,'ujc14eifsphfe4amcnqa7gspm4',1,2,1,'2016-02-12 07:11:22','2016-02-12 07:11:22','2016-02-12 07:11:22',''),(26,'1ltolilcejdtakht6vbltv2fi3',1,2,1,'2016-02-12 07:11:23','2016-02-12 07:11:22','2016-02-12 07:11:23',''),(27,'emsoo72eusu3624qh9vh5qoua1',1,2,1,'2016-02-12 07:11:23','2016-02-12 07:11:23','2016-02-12 07:11:23',''),(28,'50tf0ktbe7dpp0admr97kh1kn3',1,2,1,'2016-02-12 07:11:24','2016-02-12 07:11:23','2016-02-12 07:11:24',''),(29,'c1oj520ej3ptta9r2v0l1ojpq3',1,2,1,'2016-02-12 07:11:25','2016-02-12 07:11:24','2016-02-12 07:11:25',''),(30,'66e0vs7inoin4rrqlmkdsfn9s7',1,2,1,'2016-02-12 07:11:25','2016-02-12 07:11:25','2016-02-12 07:11:25',''),(31,'lhoc6b7a8sbrfusl4q75m4nt50',1,2,1,'2016-02-12 07:11:26','2016-02-12 07:11:25','2016-02-12 07:11:26',''),(32,'hsagn0c2i675n5ioa7ra7m8df4',1,2,1,'2016-02-12 07:11:26','2016-02-12 07:11:26','2016-02-12 07:11:26',''),(33,'h5dldqs1h74lg2ae4me88ju6q5',1,2,1,'2016-02-12 07:15:25','2016-02-12 07:11:27','0000-00-00 00:00:00',''),(34,'6kdsd66gj86kk5801adso5tqd7',1,2,1,'2016-02-12 07:16:10','2016-02-12 07:16:08','0000-00-00 00:00:00',''),(35,'po7o26lruolng8rbmtkbbc52f0',1,2,1,'2016-02-12 07:18:27','2016-02-12 07:16:54','0000-00-00 00:00:00',''),(36,'ods8aun9380ckf7i0ffv1lo9n0',1,2,1,'2016-02-12 07:25:47','2016-02-12 07:19:40','0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_users_by_clients`
--

DROP TABLE IF EXISTS `_users_by_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_users_by_clients` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `id_user` int(8) DEFAULT NULL,
  `id_client` int(8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`id_user`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_users_by_clients`
--

LOCK TABLES `_users_by_clients` WRITE;
/*!40000 ALTER TABLE `_users_by_clients` DISABLE KEYS */;
INSERT INTO `_users_by_clients` VALUES (1,168,0);
/*!40000 ALTER TABLE `_users_by_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_warpit_statveiw`
--

DROP TABLE IF EXISTS `_warpit_statveiw`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_warpit_statveiw` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_warpitProject` int(5) DEFAULT NULL,
  `id_statviewResearch` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_warpitProject` (`id_warpitProject`),
  UNIQUE KEY `id_statviewResearch` (`id_statviewResearch`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_warpit_statveiw`
--

LOCK TABLES `_warpit_statveiw` WRITE;
/*!40000 ALTER TABLE `_warpit_statveiw` DISABLE KEYS */;
/*!40000 ALTER TABLE `_warpit_statveiw` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_weight_layers`
--

DROP TABLE IF EXISTS `_weight_layers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_weight_layers` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `id_project` int(5) unsigned NOT NULL DEFAULT '0',
  `layer_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `layer_vars` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `layer_weight` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `position` int(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_weight_layers`
--

LOCK TABLES `_weight_layers` WRITE;
/*!40000 ALTER TABLE `_weight_layers` DISABLE KEYS */;
INSERT INTO `_weight_layers` VALUES (2,7,'','q1','weight',16),(3,9,'spol','Pol','weight',16),(4,9,'nekaj','Pol','weight',16),(5,30,'Default','q3','weight',16),(6,31,'Novi','q3','weight',16),(7,32,'Novi','q3','weight',16),(8,32,'Novi','q3','unweight',16),(9,32,'Novi','q3','weight',16),(10,32,'Lorem Ipsum Generator Logo GENERATOR HTML SNIPPETS','q2','weight',16),(11,32,'vv','q3','weight',16),(12,32,'zz','q2','weight',16),(13,32,'gg','q3','weight',16),(14,16,'Novi','q1x','weight',16),(15,16,'fb','q4_1,q4_2,q4_3,q4_4,q4_5','weight',16),(16,23,'default','q3_1_1,q3_1_2,q3_2_1,q3_2_2','weight',16);
/*!40000 ALTER TABLE `_weight_layers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_weight_layers_definitions`
--

DROP TABLE IF EXISTS `_weight_layers_definitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_weight_layers_definitions` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `id_layer` smallint(5) unsigned NOT NULL DEFAULT '0',
  `lab_definition` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_weight_layers_definitions`
--

LOCK TABLES `_weight_layers_definitions` WRITE;
/*!40000 ALTER TABLE `_weight_layers_definitions` DISABLE KEYS */;
INSERT INTO `_weight_layers_definitions` VALUES (2,2,'2=>100'),(3,3,''),(4,4,''),(5,5,''),(6,6,''),(7,7,'1=>Lorem][2=>Lorem'),(8,8,''),(9,9,''),(10,10,''),(11,11,''),(12,12,''),(13,13,''),(14,14,''),(15,15,''),(16,16,'');
/*!40000 ALTER TABLE `_weight_layers_definitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_weight_options`
--

DROP TABLE IF EXISTS `_weight_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_weight_options` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `id_user` int(5) NOT NULL DEFAULT '0',
  `user_type` int(5) NOT NULL DEFAULT '0',
  `id_project` int(5) NOT NULL DEFAULT '0',
  `row_weights` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `col_weights` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_weights` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lock_wuser` tinyint(1) NOT NULL DEFAULT '0',
  `break_vars` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_weight_options`
--

LOCK TABLES `_weight_options` WRITE;
/*!40000 ALTER TABLE `_weight_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `_weight_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_widget`
--

DROP TABLE IF EXISTS `_widget`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_widget` (
  `widgetId` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `questionId` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `projectId` int(11) NOT NULL,
  `id_answer` tinyint(11) NOT NULL DEFAULT '0',
  `id_kriz` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `date` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`widgetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_widget`
--

LOCK TABLES `_widget` WRITE;
/*!40000 ALTER TABLE `_widget` DISABLE KEYS */;
/*!40000 ALTER TABLE `_widget` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_widget_view_log`
--

DROP TABLE IF EXISTS `_widget_view_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_widget_view_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_id` int(11) NOT NULL,
  `question_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `project_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `sub_type` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='log ogledov posameznih komponent widgetov ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_widget_view_log`
--

LOCK TABLES `_widget_view_log` WRITE;
/*!40000 ALTER TABLE `_widget_view_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `_widget_view_log` ENABLE KEYS */;
UNLOCK TABLES;
