<?php
include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");

class PasswordValidator
{
    private $password;
    private $isValid;
    private $errors;

    private $minLength;
    private $includeNumber;
    private	$includeSpecialChar;
    private	$includeLetter;
    private	$includeUpperLetter;
    private	$includeLowerLetter;

    public function __construct($password, $autoValidate = false)
    {
        $this->password = $password;
        $this->isValid = true;

        $passwordOptions = configLoader::loadConfig("password_options");
        $this->minLength = $passwordOptions["min_length"];
    		$this->includeNumber = $passwordOptions["include_number"];
    		$this->includeSpecialChar = $passwordOptions["include_special_char"];
    		$this->includeLetter = $passwordOptions["include_letter"];
    		$this->includeUpperLetter = $passwordOptions["include_letter_upper"];
    		$this->includeLowerLetter = $passwordOptions["include_letter_lower"];

        if($autoValidate)
        {
            $this->Validate();
        }
    }

    public function Validate()
    {
        $this->ValidateMinLength();
        $this->ValidateHasNumber();
        $this->ValidateHasSpecialCharacter();
        $this->ValidateHasLetter();
        $this->ValidateHasUpperCaseLetter();
        $this->ValidateHasLowerCaseLetter();
    }

    private function ValidateMinLength()
    {
        if($this->minLength && (strlen($this->password) < $this->minLength) )
		{
            $this->isValid = false;
			$this->errors[] = "Password must have at least {$this->minLength} characters.";
		}
    }

    private function ValidateHasNumber()
    {
        if($this->includeNumber && !(preg_match('/\d/', $this->password)) )
		{
            $this->isValid = false;
			$this->errors[] = "Password needs at least 1 number.";
		}
    }

    private function ValidateHasSpecialCharacter()
    {
        if($this->includeSpecialChar && !(preg_match('/\W/', $this->password)) )
		{
            $this->isValid = false;
			$this->errors[] ="Password must have at least 1 special character.";
		}
    }

    private function ValidateHasLetter()
    {
        if($this->includeLetter && !(preg_match('/[a-zA-Z]/', $this->password)) )
		{
            $this->isValid = false;
			$this->errors[] = "Password must have at least 1 letter.";
		}
    }

    private function ValidateHasUpperCaseLetter()
    {
        if($this->includeUpperLetter && !(preg_match('/[A-Z]/', $this->password)) )
		{
            $this->isValid = false;
			$this->errors[] = "Password must have at least 1 uppper case letter.";
		}
    }

    private function ValidateHasLowerCaseLetter()
    {
        if($this->includeLowerLetter && !(preg_match('/[a-z]/', $this->password)) )
		{
            $this->isValid = false;
			$this->errors[] = "Password must have at least 1 lower case letter.";
		}
    }

    public function IsValid()
    {
        return $this->isValid;
    }

    public function GetErrors()
    {
        return $this->errors;
    }
}
?>
