	
	function DragColumnsScroll(cmpId) {
		let vars = {};
		vars[cmpId] = {};
		vars[cmpId]['mousedown'] = false;
		vars[cmpId]['enableHandler'] = false;
		vars[cmpId]['targetElement'] = 'div#'+cmpId+' div.x-grid3-scroller';
		
		$('div#'+cmpId+' div.x-grid3-header').mousedown(function(e) {
			vars[cmpId]['mousedown'] = true;
			vars[cmpId]['timer'] = window.setInterval(function() {
				vars[cmpId]['enableHandler'] = true;
			}, 250);
		}).mouseup(function(e) {
			vars[cmpId]['mousedown'] = false;
			clearInterval(vars[cmpId]['timer']);
			//console.log(vars);
		});
		
		$('div#'+cmpId+' div.x-grid3-header').mousemove(function(e) {
			
			if(vars[cmpId]['enableHandler']) {
				vars[cmpId]['scrollEl'] = $(this).next(vars[cmpId]['targetElement']);
				
				if(vars[cmpId]['mousedown'] && vars[cmpId]['scrollEl'].length) {
					
					vars[cmpId]['borderLeft'] = vars[cmpId]['scrollEl'].offset().left;
					vars[cmpId]['borderRight'] = vars[cmpId]['scrollEl'].offset().left + vars[cmpId]['scrollEl'].width();
					vars[cmpId]['x'] = e.clientX;
					vars[cmpId]['scrollToPos'] = vars[cmpId]['scrollEl'].scrollLeft();
					
					if(vars[cmpId]['x'] > (vars[cmpId]['borderRight'] - 100)) {
						vars[cmpId]['scrollToPos'] += 100;
					} else if(vars[cmpId]['x'] < vars[cmpId]['borderLeft'] + 100) {
						vars[cmpId]['scrollToPos'] -= 100;
					}
					
					vars[cmpId]['scrollEl'].animate({ scrollLeft: vars[cmpId]['scrollToPos'] }, {
						duration: 250
					});
				}
				vars[cmpId]['enableHandler'] = false;
			}
		});
	}