<?php
set_time_limit(1000);
$sessionHandling = 1;

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT . "init.php");

include_once(PATH_TO_ROOT . "_liveUpdate/class.capiMachine.php");

$userIdParam = intval($_GET['user_id']);
$logId = intval($_POST['logId']);

$capiMachine = new capiMachine($db);
$capiMachine->SetCapiServerOptions(configLoader::loadConfig('capi-server'));

$capiMachine->GetMachine($_POST['client-machine-id'], $userIdParam);

capiMachine::writeLog("************* UPLOAD ******************\n\r");
capiMachine::writeLog("Macine ID - [" . $_POST['client-machine-id'] . "] is active: " . $capiMachine->isActive() . " and allow to upload data: " . $capiMachine->GetMachineInfo('allow_upload') . "\n\r");
$returnData = array();

if ($capiMachine->isActive() && intval($capiMachine->GetMachineInfo('allow_upload')) == 1) {
    $time = time();
    $seqNum = 0;
    do {
        $upload_file = "capi-data-" . date("mdY-his") . "-" . time() . "_" . $seqNum . ".xml";
        $seqNum++;

    } while (file_exists(WARPIT_LIVEUPDATE_ZIPVERSION . "/upload/" . $upload_file));
    capiMachine::writeLog("Filename: " . $upload_file . "\n\r");

    $fp = fopen(WARPIT_LIVEUPDATE_ZIPVERSION . "/upload/" . $upload_file, "w");
    fwrite($fp, $_POST['PostData']);
    fclose($fp);

//		echo $_POST['PostData']."<br>";


    $oXML = new SimpleXMLElement("<xml>" . $_POST['PostData'] . "</xml>");
//    var_dump($oXML);


    //  $oXML = new SimpleXMLElement("<xml>".file_get_contents(WARPIT_WEBPROJECTS. 'LiveUpdate/test/inputData.xml')."</xml>");
    $UploadedProjects = array();
    //print "tukaj2";
    $insertedIds = array();
    $newIdsMap = [];
    $oldIds = array();
    foreach ($oXML->record as $rec) {
        $sqlf = array();
        $clientId = null;
        $user_id = null;
        //echo $rec->database."<br>";

        if ($rec->id_project) $UploadedProjects[intval($rec->id_project)] = intval($rec->id_project);

        if ($rec->table == "_capi_interviewer_visits") $rec->table = "_Capi_interviewer_visits";

        foreach (explode(",", $rec->listFields) as $f) {
            if ($f == 'id') {
                $id = $rec->fields->$f;
                //20161017 Tanis: we need to save current id for old records checking
                $clientId = $id->__toString();
            } elseif ($f == 'id_clien') {
                $sqlf[] = $f . " = '" . $id . "'";
            } else if ($f === 'id_structure') {
                $structureId = $rec->fields->$f * (-1);
                $sqlf[] = "$f = $structureId";
            } //20161017 Tanis: also we will need user id
            else if ($f == 'user_id') {
                $user_id = $rec->fields->$f;
                $sqlf[] = $f . " = '" . addslashes(strval(htmlspecialchars_decode($rec->fields->$f))) . "'";
            } //20161017 Tanis: END
            else {
                $sqlf[] = $f . " = '" . addslashes(strval(htmlspecialchars_decode($rec->fields->$f))) . "'";
            }
            //else $sqlf[] = $f." = '".$rec->fields->$f."'";


        }

        //20161017 Tanis: We check if this record have already been transfered to the server
        // If it is true we set old record as test one
        if ($clientId && strpos($rec->table, '_structure') !== false) {
            $table = $dbConfig[strval($rec->database)] . "." . $rec->table->__toString();
            $user_id = $user_id->__toString();

            if (!$oldIds[$table][$user_id]) $oldIds[$table][$user_id] = array();

            $oldId = $db->get($rec->table, 'user_id =' . $user_id . ' AND user_type = 4 AND status = 1 AND status_rec = 1 AND id_clien = ' . $clientId, 'id', $dbConfig[strval($rec->database)]);

            if ($oldId) {
                foreach ($oldId as $myid) {
                    $oldIds[$table][$user_id][] = $myid;
                }
            }
        }
        //20161017 Tanis: END

        $sql = "INSERT IGNORE INTO " . $dbConfig[strval($rec->database)] . "." . $rec->table . "  SET " . implode(",", $sqlf);


        try {
            $currentTable = $rec->table->__toString();
            $db->SQLexecute($sql);
            $newId = $db->GetLastInsertId();


            if (strpos($currentTable, '_structure') !== false) {
                $newIdsMap[$currentTable][] = [
                    'oldId' => $id->__toString(),
                    'newId' => $newId,
                    'userId' => $user_id,
                ];
            }

            $insertedIds[$rec->database->__toString()][$rec->table->__toString()]['ids'][] = $id->__toString();


        } catch (Exception $e) {
            $insertedIds[$rec->database->__toString()][$rec->table->__toString()]['msg'] = "Server: error when I try to insert data in " . $dbConfig[strval($rec->database)] . "." . $rec->table;
            $returnData['success'] = false;
            $returnData['insertedIds'] = $insertedIds;
            echo json_encode($returnData);
            exit;
        }
    }
    //20161017 Tanis: here we update old recoreds
    if (count($oldIds)) {
        foreach ($oldIds as $tableName => $user) {
            foreach ($user as $user_id => $ids) {
                if (count($ids)) {

                    $sql = "UPDATE " . $tableName . " SET status_rec = 2 WHERE id IN (" . implode(',', $ids) . ")";
                    $db->SQLexecute($sql);

                    //20170511 Bojan Orter - I added deleting from quotaCalc table for duplications
                    $projectName = substr($tableName, 0, strpos($tableName, '_structure'));
                    $expTableName = explode('.', $projectName . "___quotaCalc");
                    $dbName = $expTableName[0];
                    $tableName = $expTableName[1];

                    if ($db->tableExists($tableName)) {
                        $sql = "DELETE FROM $dbName.$tableName WHERE id IN (" . implode(',', $ids) . ")";
                        $db->SQLexecute($sql);
                    }
                    //END Bojan Orter
                }
            }
        }
    }
    //20161017 Tanis: END

    /*
     * 20180523 Tanis
     * Updating id_structure in ___EngineLog table.
     * For more info see: https://gitlab.solve-x.net/warpit/warpit/issues/172
     *
     */

    if (count($newIdsMap) > 0) {
        foreach ($newIdsMap as $table => $recordsForUpdate) {
            list($currentTable) = explode('_structure', $table);
            $engineLogTable = $currentTable . '___EngineLog';

            foreach ($recordsForUpdate as $structureIdsMap) {

                $oldId = $structureIdsMap['oldId'];
                $newId = $structureIdsMap['newId'];
                $userId = $structureIdsMap['userId'];

                $oldId = $oldId * (-1);

                $sql = "UPDATE " . DB_WARPIT_WEBCATI_BASE . "." . $engineLogTable . "
                        SET id_structure = {$newId } 
                        WHERE id_user = {$userId}
                        AND user_type = 4
                        AND id_structure = {$oldId}";

                $db->SQLexecute($sql);
            }


        }
    }

    capiMachine::writeLog("uploaded projects: " . print_r($UploadedProjects, true) . PHP_EOL);


    // Update quotas

    if ($UploadedProjects) {

        $db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
        foreach ($UploadedProjects as $idProject) {
            //$idProject = 3;
            $sql = " SELECT proj_name FROM _Projects WHERE id = " . $idProject;
            $res = $db->SQLexecute($sql);
            $zad = $db->fetchAssoc($res);
            $projectName = $zad['proj_name'];

            $sql = "SHOW TABLES LIKE '" . $projectName . "___quotaCalc'";
            $res = $db->SQLexecute($sql);
            if ($db->NumRows($res)) {
                $sql = "DESCRIBE " . $projectName . "___quotaCalc ";
                $res = $db->SQLexecute($sql);

                $fields_quota = array();
                $fields_structure = array();
                // getting structure of Quota table to know what to read from structure
                while ($zad = $db->fetchAssoc($res)) {

                    // we need to make 2 arrays because some of field are different named in structure as in quota table
                    // so we have 2 arrays, One to read from structure table $fields_structure and one for inserting into quota table $fields_quota
                    $fields_quota[$zad['Field']] = $zad['Field'];
                    if ($zad['Field'] == "QT_user_id") $zad['Field'] = "user_id";
                    if ($zad['Field'] == "QT_user_type") $zad['Field'] = "user_type";
                    $fields_structure[$zad['Field']] = $zad['Field'];
                }

                $sql = "INSERT IGNORE INTO " . $projectName . "___quotaCalc (" . implode(",", $fields_quota) . ")
								SELECT " . implode(",", $fields_structure) . " FROM " . $projectName . "_structure
										WHERE user_id = '" . $userIdParam . "' AND status = 1 AND status_rec = 1 ";
                //echo $sql;
                try {
                    $db->SQLexecute($sql);
                } catch (Exception $e) {
                    $returnData['success'] = false;
                    $returnData['msg'] = "Server: can't recalculate quotas on project: " . $projectName;
                    $returnData['SQL'] = $sql;
                    $returnData['insertedIds'] = $insertedIds;
                    echo json_encode($returnData);
                    exit;
                }

            }
        }

    }

    if ($UploadedProjects) {
        $uploadProjectsLog = [];

        $projects = $db->get(
            '_Projects',
            'id IN(' . implode(',', $UploadedProjects) .')',
            'id, proj_name',
            DB_WARPIT_WEBCATI_BASE
        );

        foreach($projects as $project) {
            list($projectId, $projectName) = array_values($project);

            $structureTable = "{$projectName}_structure";
            $inserted = count($insertedIds['table_warpit_webcati_base'][$structureTable]['ids']);

            $uploadProjectsLog[] = "($projectId, $inserted, $logId)";
        }

        $insertSql = "INSERT INTO `" . DB_WARPIT_LIVEUPDATE ."` . `_LiveUpdateUploadedRecords`";
        $insertSql .= "(project_id, number_of_inserted_records, log_id) VALUES";
        $insertSql .= implode(',', $uploadProjectsLog);

        $db->SQLexecute($insertSql);

    }

    $returnData['success'] = true;
    $returnData['msg'] = "Server: Successfully saved data!";
    $returnData['insertedIds'] = $insertedIds;
    echo json_encode($returnData);
    capiMachine::writeLog("Upload done. \n\r");
    capiMachine::writeLog('Retruned data:' . print_r($returnData, true) . "\n\r");
} else {
    $returnData['success'] = false;
    $returnData['msg'] = "Server: Client doesn't have permissions for upload";

    echo json_encode($returnData);
    capiMachine::writeLog("NO UPLOAD because of restrictions.\n\r");
}

capiMachine::writeLog("************* END UPLOAD ******************\n\r");
?>
