<?php

namespace Steps;

use \ActionData;
use \db;

class PrepareLocalRecords extends AbstractStep
{
    private $db;

    private $newLine = "\n";

    private $space = "\t";

    private $recordsData = [];

    private $actionData = null;

    public function __construct(\DataContainers\ActionData $actionData, \DataContainers\CurrentVersion $versions, db $db)
    {
        $this->db = $db;
        $this->actionData = $actionData;
        $this->versions = $versions;
    }

    public function execute()
    {
        $id_user = config('user_id');
        $record = '';
        $currentProject = $this->projects->current();

        while ($currentProject) {

            $recordData = $this->prepareProjectData($currentProject, $id_user);

            $record .= $recordData;

            $currentProject = $this->projects->next();
        }

        foreach ($this->recordsData as $table => $recDat) {
            $ids = array_column($recDat, 'id_record');

            $data = array('recordsCnt' => count($recDat));
            $this->actionData->addRecordsForUpload($table, $ids);

            list($projectName) = explode('_structure', $table);
            list($databse, $projectName) = explode('.', $projectName);
            $data['projectName'] = $projectName;
            if ($this->isProject($table))
                $this->clientStatus->dataExists($data);
            else
                $this->clientStatus->dataAboutVisits($data);

        }

        $this->actionData->addXml($record);
    }

    public function addRecord($data)
    {
        $this->clientStatus->addRecord($data);
        $this->recordsData[$data['table']][] = $data;
    }

    protected function isProject($tableName)
    {
        return $tableName != DB_WARPIT_WEBCATI_BASE . "._Capi_interviewer_visits";
    }

    protected function prepareProjectData($currentProject, $id_user)
    {
        $sql = "SELECT id,proj_name FROM " . DB_WARPIT_WEBCATI_BASE . "._Projects WHERE id = " . $currentProject;

        $res = $this->db->SQLexecute($sql);
        $zad = $this->db->fetchAssoc($res);
        $projectName = $zad['proj_name'];
       $record = '';

        // visits
        $sql = "SELECT * FROM " . DB_WARPIT_WEBCATI_BASE . "._Capi_interviewer_visits
                WHERE user_id = " . $id_user . " AND ( flag_cli IS NULL OR flag_cli != 1 ) AND id_project = " . $currentProject;

        $res = $this->db->SQLexecute($sql);

        $tb = DB_WARPIT_WEBCATI_BASE . "._Capi_interviewer_visits";

        while ($zad = $this->db->fetchAssoc($res)) {
            //    $this->clientRequest->addRecord($tb, $zad['id'], $projectName);
            $this->addRecord(array('table' => $tb, 'id_record' => $zad['id'], 'project_name' => $projectName));

            $this->uploadUpdateDefine[$tb][] = $zad['id'];
            $list = array();

            $record .= "<record>" . $this->newLine;
            $record .= $this->space . "<database>table_warpit_webcati_base</database>" . $this->newLine;
            $record .= $this->space . "<table>_capi_interviewer_visits</table>" . $this->newLine;
            $record .= $this->space . "<fields>" . $this->newLine;
            foreach ($zad as $key => $val) {
                $record .= $this->space . $this->space . "<" . $key . ">" . $val . "</" . $key . ">" . $this->newLine;
                $list[] = $key;
            }
            $record .= $this->space . "</fields>" . $this->newLine;
            $record .= $this->space . "<listFields>" . implode(",", $list) . "</listFields>" . $this->newLine;
            $record .= "</record>" . $this->newLine;
        }


        /* -------------------------------------------------------------
           ----             PROJECTS								                ----
           -------------------------------------------------------------*/

        $tb = DB_WARPIT_WEBCATI_BASE . "." . $projectName . "_structure";

        $sql = "SELECT * FROM " . $tb . "
                WHERE  user_id = " . $id_user . " AND ( flag_cli IS NULL OR flag_cli != 1 ) ";

        try {
            $res = $this->db->SQLexecute($sql);

        } catch (\Exception $e) {
            $this->clientStatus->reportMissingTable(array('table' => $tb, 'projectName' => $projectName));
            return [$record, ''];
        }

        $this->uploadUpdateDefine[$tb] = array();

        while ($zad_record = $this->db->fetchAssoc($res)) {

            $this->addRecord(array('table' => $tb, 'id_record' => $zad_record['id'], 'project_name' => $projectName));

            $list = array();

            $this->uploadUpdateDefine[$tb][] = $zad_record['id'];

            $record .= "<record>" . $this->newLine;
            $record .= $this->space . "<database>table_warpit_webcati_base</database>" . $this->newLine;
            $record .= $this->space . "<table>" . $projectName . "_structure</table>" . $this->newLine;
            $record .= $this->space . "<id_project>" . $currentProject . "</id_project>" . $this->newLine;

            $record .= $this->space . "<fields>" . $this->newLine;
            foreach ($zad_record as $key => $val) {
                if (is_null($val) && $key != "id_clien") continue;
                $record .= $this->space . $this->space . "<" . $key . ">" . htmlspecialchars($val) . "</" . $key . ">" . $this->newLine;
                $list[] = $key;
            }
            $record .= $this->space . "</fields>" . $this->newLine;
            $record .= $this->space . "<listFields>" . implode(",", $list) . "</listFields>" . $this->newLine;
            $record .= "</record>" . $this->newLine;


          }

        /* -------------------------------------------------------------
           ----             PROJECTS ENGINE LOG								                ----
           -------------------------------------------------------------*/
        $allowUpload = filter_var(config('upload_engine_log'), FILTER_VALIDATE_BOOLEAN);

        if ($allowUpload === true) {

            $tb = DB_WARPIT_WEBCATI_BASE . "." . $projectName . "___EngineLog";
            $structureTable = DB_WARPIT_WEBCATI_BASE . "." . $projectName . "_structure";

            $sql = "SELECT el.* FROM {$tb} as el
                  LEFT JOIN $structureTable as s
                  ON el.id_structure = s.id
                  WHERE user_id = " . $id_user . "  AND (s.flag_cli is null or s.flag_cli != 1)";

            try {
                $res = $this->db->SQLexecute($sql);

            } catch (\Exception $e) {
                $this->clientStatus->reportMissingTable(array('table' => $tb, 'projectName' => $projectName));
                return $record;
            }

            $this->uploadUpdateDefine[$tb] = array();

            while ($zad_record = $this->db->fetchAssoc($res)) {

                $this->addRecord(array('table' => $tb, 'id_record' => $zad_record['id'], 'project_name' => $projectName));
                $list = array();

                $record .= "<record>" . $this->newLine;
                $record .= $this->space . "<database>table_warpit_webcati_base</database>" . $this->newLine;
                $record .= $this->space . "<table>" . $projectName . "___EngineLog</table>" . $this->newLine;
                $record .= $this->space . "<id_project>" . $currentProject . "</id_project>" . $this->newLine;

                $record .= $this->space . "<fields>" . $this->newLine;
                foreach ($zad_record as $key => $val) {
                    if (is_null($val) && $key != "id_clien") continue;
                    $record .= $this->space . $this->space . "<" . $key . ">" . htmlspecialchars($val) . "</" . $key . ">" . $this->newLine;
                    $list[] = $key;
                }
                $record .= $this->space . "</fields>" . $this->newLine;
                $record .= $this->space . "<listFields>" . implode(",", $list) . "</listFields>" . $this->newLine;
                $record .= "</record>" . $this->newLine;

            }
        }

        return $record;
    }
}
