<?php

function configExists()
{
    $fileName = PATH_TO_ROOT . '_config/dbConfig.php';

    return file_exists($fileName);
}

function container()
{
    static $container = null;

    if ($container === null)
        require __DIR__ . '/../framework/config.php';

    return $container;
}

function make($className)
{
    $container = container();
    return $container->make($className);
}

function hashPassword($string)
{
    return password_hash($string, PASSWORD_DEFAULT, ['cost' => 10]);
}


/**
 * Generate a random string, using a cryptographically secure
 * pseudorandom number generator (random_int)
 *
 * For PHP 7, random_int is a PHP core function
 * For PHP 5.x, depends on https://github.com/paragonie/random_compat
 *
 * @param int $length      How many characters do we want?
 * @param string $keyspace A string of all possible characters
 *                         to select from
 * @return string
 */
function randomString($length, $keyspace = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ')
{
    $pieces = [];
    $max = mb_strlen($keyspace, '8bit') - 1;
    for ($i = 0; $i < $length; ++$i) {
        $pieces []= $keyspace[random_int(0, $max)];
    }
    return implode('', $pieces);
}

function view($fileName, $context, $designPath = '')
{
    if($designPath === ''){
        $designPath = WARPIT_WEBPROJECTS . '/twig';
    }

    $loader = new Twig_Loader_Filesystem($designPath);
    $twig = new Twig_Environment($loader, [
        'cache' => false, // production: __DIR__ . '/storage/views/cache'
    ]);


    $template = $twig->loadTemplate($fileName);
    return $template->render($context);

}


/**
 * Append string if not exists.
 *
 * @param $string string you want to add suffix to
 * @param $suffix suffix
 * @return string string with appended suffix
 */
function appendIfNotExists($string, $suffix)
{
    //we remove suffix if already exists in string
    $string = str_replace($suffix, '', $string);

    return "$string$suffix";
}
