<?php

namespace Warpit\Services;

use Warpit\Repositories\WarpitInstallRepository;
use SolveX\Support\Dotenv;

class WarpitInstallService
{
    public function __construct(WarpitInstallRepository $warpitInstallRepository)
    {
        $this->warpitInstallRepository = $warpitInstallRepository;
    }

    public function setDatabase(\db $db)
    {
        $this->warpitInstallRepository->setDatabase($db);
    }

    public function mainDatabaseExists($prefix)
    {
        return $this->warpitInstallRepository->mainDatabaseExists($prefix);
    }

    public function databasesExists($prefix)
    {
        return $this->warpitInstallRepository->databasesExists($prefix);
    }

    public function createConfig($user, $password, $warpitMainDatabase, $host)
    {
          $sampleFilename = PATH_TO_ROOT . '_config/dbConfig.sample.php';
          $fileName = PATH_TO_ROOT . '_config/dbConfig.php';

          $tags = ['[!MYSQL_USER]', '[!MYSQL_PASSWORD]', '[!MAIN_WARPIT_DATABASE]', '[!MYSQL_HOST]'];
          $values = [$user, $password, $warpitMainDatabase, $host];

          $configContent = file_get_contents($sampleFilename);
          $configContent = str_replace($tags, $values, $configContent);

          file_put_contents($fileName, $configContent);
    }

    public function configExists()
    {
          $fileName = PATH_TO_ROOT . '_config/dbConfig.php';
          return is_file($fileName);
    }

    public function createMainDatabase($mysqlUser, $mysqlPass, $mysqlHost, $databases)
    {
        $database = array_shift($databases);

        list($dbName, $dbDump) = $database;

        $this
            ->warpitInstallRepository
            ->createDatabase($dbName);

        if ($dbDump === false) {
            return;
        }
        $this
            ->warpitInstallRepository
            ->importDatabase($dbDump, $dbName, $mysqlUser, $mysqlPass, $mysqlHost);
    }

    public function createDatabase($mysqlUser, $mysqlPass, $mysqlHost, $databases)
    {
        array_shift($databases);

        foreach ($databases as $database) {
            list($dbName, $dbDump) = $database;

            $this
              ->warpitInstallRepository
              ->createDatabase($dbName);

            if ($dbDump === false) {
                continue;
            }
            $this
              ->warpitInstallRepository
              ->importDatabase($dbDump, $dbName, $mysqlUser, $mysqlPass, $mysqlHost);
        }
    }

    public function createTemporaryDesign($webProjectsAbsolute, $depth, $webProjectsWww)
    {
        $designPath = $depth . $webProjectsWww;

        $temp = tempnam($webProjectsAbsolute. 'tmp_base.sql', 'temp');
        $content = file_get_contents(PATH_TO_ROOT .'db/database/Warpit_Webcati_base.sql');
        file_put_contents($temp, str_replace('[!web_projects_folder]', $designPath, $content));
        return $temp;
    }

    //TODO remove $env add real variables
    public function databaseConfiguration($env)
    {
        $liveUpdateFolder = $env['WEBPROJECTS_FOLDER'] . 'LiveUpdate/' ;
        $wwwBase = $env['PROTOCOL'] . "://{\$_SERVER['HTTP_HOST']}";

        if(strlen($env['WWW_PORT'])  > 0){
            $wwwBase .= ":" . $env['WWW_PORT'];
        }

        $webProjectsWww = mysql_real_escape_string($wwwBase .$env['WEBPROJECTS_WWW']);
        $warpitWww      = mysql_real_escape_string($wwwBase . $env['WARPIT_WWW']);
        $redirectWww    = $warpitWww .'webuserspool/_redirect/';
        $databases      = $env['databases'];
        $this
        ->warpitInstallRepository
        ->updateDatabaseConfig(
          'table_warpit_main',
          $databases['warpit'][0],
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
            'table_warpit_statview',
            $databases['warpitStatviewe'][0],
            $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
            'table_warpit_webcati',
            $databases['warpitWebcati'][0],
            $databases['warpit'][0]
        )
        ->updateDatabaseConfig(
            'table_warpit_webcati_base',
            $databases['warpitWebcatiBase'][0],
            $databases['warpit'][0]
        )
        ->updateDatabaseConfig(
          'table_warpit_liveupdate',
          $databases['warpitWebcatiLiveUpdate'][0],
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
          'table_warpit_webrecode',
          $databases['warpitWebrecode'][0],
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
          'table_warpit_webhelp',
          $databases['warpitWebhelp'][0],
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
          'table_warpit_userspool',
          $databases['warpitWebuserspool'][0],
          $databases['warpit'][0]
          )

        ->updateDatabaseConfig(
          'warpit_absolute',
          getcwd() . '/',
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
            'warpit_webprojects',
            $env['WEBPROJECTS_FOLDER'],
            $databases['warpit'][0]
            )
        ->updateDatabaseConfig(
          'redirectModul_www',
          $redirectWww,
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
          'warpit_webprojects_www',
          rtrim($webProjectsWww, '/'),
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
          'warpit_www',
          $warpitWww,
          $databases['warpit'][0]
          )
        ->updateDatabaseConfig(
          'live_update_zip_files',
          $liveUpdateFolder,
          $databases['warpit'][0]
          )
        ;

        if(strlen($env['IMPORT_METHOD']) > 0){
            $this->warpitInstallRepository->updateDatabaseConfig(
              'method',
              $env['IMPORT_METHOD'],
              $databases['warpit'][0],
              'import_option'
            );
        }
    }

    public function unzipDesignFiles($web_projects_folder)
    {
        $zip = new \ZipArchive;
        if ($zip->open(PATH_TO_ROOT . 'install/designFiles.zip') === true) {
            $zip->extractTo($web_projects_folder);
            $zip->close();
        } else {
            return false;
        }

        return true;
    }

    public function filesExists($webProjects)
    {
        $liveUpdateDir = $webProjects.'LiveUpdate/';
        $tmpDir          = $liveUpdateDir .'tmp/';
        $uploadDir     = $liveUpdateDir .'upload/';
        $extractDir     = $webProjects .'WEB/';

        return is_dir($liveUpdateDir) === true &&
                is_dir($tmpDir) === true &&
                is_dir($uploadDir) === true &&
                is_dir($extractDir) === true;
    }

    public function createLiveUpdateFiles($webProjects)
    {
        $liveUpdateDir = $webProjects.'LiveUpdate/';
        $tmpDir        = $liveUpdateDir .'tmp/';
        $uploadDir     = $liveUpdateDir .'upload/';

        if(is_dir($liveUpdateDir) === false){
            mkdir($liveUpdateDir);
        }
        if(is_dir($tmpDir) === false){
            mkdir($tmpDir);
        }
        if(is_dir($uploadDir) === false){
            mkdir($uploadDir);
        }

        return $liveUpdateDir;
    }

    public function addCrontabEntry()
    {
        $newCron = '* * * * * cd ' . getcwd() .' && php cli warpit:run-scheduler >> /dev/null 2>&1';

        $output = shell_exec('crontab -l');
        file_put_contents('/tmp/crontab.txt', $output.$newCron.PHP_EOL);
        exec('crontab /tmp/crontab.txt');
        exec('rm /tmp/crontab.txt');
    }

    public function crontabEntryExists()
    {
        $cron = '* * * * * cd ' . getcwd() .' && php cli warpit:run-scheduler >> /dev/null 2>&1';

        $output = shell_exec('crontab -l');
        return strpos($output, $cron) !== false;
    }

    
    public function loadConfig()
    {
        $env = (new Dotenv(__DIR__ . '/../../', '.install'))->load();

        $env['WARPIT_WWW'] = rtrim($env['WARPIT_WWW'], '/') . '/';
        $env['DESIGN_DEPTH'] = rtrim($env['DESIGN_DEPTH'], '/');
        $env['WEBPROJECTS_WWW'] = rtrim($env['WEBPROJECTS_WWW'], '/') . '/';
        $env['WEBPROJECTS_FOLDER'] = rtrim($env['WEBPROJECTS_FOLDER'], '/') . '/';

        $env['WARPIT_WWW'] = '/' . ltrim($env['WARPIT_WWW'], '/');
        $env['WEBPROJECTS_WWW'] = '/' . ltrim($env['WEBPROJECTS_WWW'], '/');
        $env['WEBPROJECTS_FOLDER'] = '/' . ltrim($env['WEBPROJECTS_FOLDER'], '/');
        $env['DESIGN_DEPTH'] = ltrim($env['DESIGN_DEPTH'], '/');

        $env['databases'] = $this->generateDatabaseNames(
            $env['MAIN_DATABASE'],
            $env['WEBPROJECTS_FOLDER'],
            $env['DESIGN_DEPTH'],
            $env['WEBPROJECTS_WWW']
        );

        return $env;
    }

    protected function generateDatabaseNames($mainDatabase, $webProjectsAbsoulte, $designDepth, $webProjectsWww)
    {
        return [
            'warpit' => [
                $mainDatabase,
                PATH_TO_ROOT . 'db/database/Warpit.sql'
            ],
            'warpitWebcati' => [
                $mainDatabase . '_Webcati',
                PATH_TO_ROOT . 'db/database/Warpit_Webcati.sql'
            ],
            'warpitWebcatiBase' => [
                $mainDatabase . "_Webcati_base",
                $this
                    ->createTemporaryDesign(
                        $webProjectsAbsoulte,
                        $designDepth,
                        $webProjectsWww
                    ),
            ],
            'warpitWebcatiLiveUpdate' => [
                $mainDatabase . "_Webcati_liveupdate",
                PATH_TO_ROOT . 'db/database/Warpit_Webcati_liveupdate.sql'
            ],
            'warpitWebrecode' => [
                $mainDatabase . "_Webrecode",
                false
            ],
            'warpitWebuserspool' => [
                $mainDatabase . "_Webuserspool",
                PATH_TO_ROOT . 'db/database/Warpit_Webuserspool.sql'
            ],
            'warpitStatviewe' => [
                $mainDatabase . "_Statview",
                PATH_TO_ROOT . 'db/database/Warpit_Statview.sql'
            ],
            'warpitWebhelp' => [
                $mainDatabase . "_Webhelp",
                PATH_TO_ROOT . 'db/database/Warpit_Webhelp.sql'
            ],
        ];
    }
}
