<?php

namespace Warpit\Services;

use Warpit\Repositories\RecreateStructureRepository;

class RecreateStructureService
{
    protected $recreateStructureRepository = null;

    public function __construct(RecreateStructureRepository $recreateStructureRepository)
    {
        $this->recreateStructureRepository = $recreateStructureRepository;
    }

    public function recreateStructure($engineLogTable, $structureTable)
    {
        $engineLog = $this->recreateStructureRepository->showEngineLog($engineLogTable);
        $data = [];
        foreach ($engineLog as $key => $line) {
            if (!isset($line->eventLogger) || empty($line->eventLogger)) {
                continue;
            }

            $id = $line->id_structure;
            if (!isset($data[$id])) {
                $data[$id] = [];
            }

            $json = json_decode($line->eventLogger, true);
            foreach ($json as $key => $value) {
                if (isset($value['objName'])) {
                    preg_match_all("/\[([^\]]*)\]/", $value['objName'], $matches);
                    if (!empty($matches[1])) {
                        $data[$id][$matches[1][0]] = $value['objValue'];
                    }
                    $data[$id]['id'] = $id;
                }
            }
        }

        foreach ($data as $key => $value) {
            $this->recreateStructureRepository->createStructureValue($structureTable, $value);
        }

    }
}
