<?php

namespace Warpit\Console\Job;

use Warpit\Console\Interfaces\JobInterface;
use Warpit\Services\CleanBlacklistService;

use Log;


/**
 * Class SendMailJob
 * @package Warpit\Console\Job
 *
 * Sometimes we have same person imported into multiple warpit projects. They say that they don't want to be called for
 * this project anymore so we put them to the black list. After some time we remove them from it.
 */
class CleanBlacklistJob implements JobInterface
{
    protected $cleanBlacklistService = null;

    public function __construct(CleanBlacklistService $cleanBlacklistService)
    {
        $this->cleanBlacklistService = $cleanBlacklistService;
    }

    public function run()
    {
        $this->cleanBlacklistService->clean();
    }
}
